/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.editor.KotlinMultilineStringEnterHandler;
import org.jetbrains.kotlin.idea.refactoring.DataContextUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016JF\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J2\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "()V", "isInBrace", "", "wasInMultilineString", "whiteSpaceAfterCaret", "", "postProcessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "preprocessEnter", "caretOffset", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "offset", "hostPosition", "Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$HostPosition;", "Companion", "kotlin.idea"})
public final class KotlinMultilineStringEnterHandler
extends EnterHandlerDelegateAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean wasInMultilineString;
    @NotNull
    private String whiteSpaceAfterCaret = "";
    private boolean isInBrace;
    private static final char DEFAULT_TRIM_MARGIN_CHAR = '|';
    @NotNull
    private static final String TRIM_INDENT_CALL = "trimIndent";
    @NotNull
    private static final String TRIM_MARGIN_CALL = "trimMargin";
    @NotNull
    private static final String MULTILINE_QUOTE = "\"\"\"";

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        int offset2 = ((Number)caretOffset.get()).intValue();
        if (!(editor2 instanceof EditorWindow)) {
            return this.preprocessEnter(file2, editor2, offset2, originalHandler, dataContext);
        }
        Companion.HostPosition hostPosition = KotlinMultilineStringEnterHandler.Companion.getHostPosition(dataContext);
        if (hostPosition == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Companion.HostPosition hostPosition2 = hostPosition;
        return this.preprocessEnter(hostPosition2, originalHandler, dataContext);
    }

    private final EnterHandlerDelegate.Result preprocessEnter(Companion.HostPosition hostPosition, EditorActionHandler originalHandler, DataContext dataContext) {
        PsiFile file2 = hostPosition.component1();
        Editor editor2 = hostPosition.component2();
        int offset2 = hostPosition.component3();
        return this.preprocessEnter(file2, editor2, offset2, originalHandler, dataContext);
    }

    /*
     * WARNING - void declaration
     */
    private final EnterHandlerDelegate.Result preprocessEnter(PsiFile file2, Editor editor2, int offset2, EditorActionHandler originalHandler, DataContext dataContext) {
        block6: {
            String string2;
            String text2;
            Document document;
            block5: {
                void $this$takeWhile$iv;
                if (!(file2 instanceof KtFile)) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                document = editor2.getDocument();
                text2 = document.getText();
                if (offset2 == 0 || offset2 >= text2.length()) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                PsiElement element3 = file2.findElementAt(offset2);
                if (!Companion.inMultilineString(element3, offset2)) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                this.wasInMultilineString = true;
                String string3 = text2.substring(offset2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                String string4 = string3;
                KotlinMultilineStringEnterHandler kotlinMultilineStringEnterHandler = this;
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char ch = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (ch == ' ' || ch == '\t') continue;
                    void var13_16 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string5 = var13_16.substring(n2, index$iv);
                    string2 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    break block5;
                }
                string2 = $this$takeWhile$iv;
            }
            kotlinMultilineStringEnterHandler.whiteSpaceAfterCaret = string2;
            document.deleteString(offset2, offset2 + this.whiteSpaceAfterCaret.length());
            char ch1 = text2.charAt(offset2 - 1);
            char ch2 = text2.charAt(offset2);
            boolean bl = this.isInBrace = ch1 == '(' && ch2 == ')' || ch1 == '{' && ch2 == '}' || ch1 == '>' && ch2 == '<';
            if (!this.isInBrace || !CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
                return EnterHandlerDelegate.Result.Continue;
            }
            EditorActionHandler editorActionHandler = originalHandler;
            if (editorActionHandler == null) break block6;
            editorActionHandler.execute(editor2, editor2.getCaretModel().getCurrentCaret(), dataContext);
        }
        return EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    @NotNull
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull DataContext dataContext) {
        if (!(editor2 instanceof EditorWindow)) {
            return this.postProcessEnter(file2, editor2);
        }
        Companion.HostPosition hostPosition = KotlinMultilineStringEnterHandler.Companion.getHostPosition(dataContext);
        if (hostPosition == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Companion.HostPosition hostPosition2 = hostPosition;
        return this.postProcessEnter(hostPosition2.getFile(), hostPosition2.getEditor());
    }

    private final EnterHandlerDelegate.Result postProcessEnter(PsiFile file2, Editor editor2) {
        Character c;
        if (!(file2 instanceof KtFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!this.wasInMultilineString) {
            return EnterHandlerDelegate.Result.Continue;
        }
        this.wasInMultilineString = false;
        Project project = ((KtFile)file2).getProject();
        Document document = editor2.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        CaretModel caretModel = editor2.getCaretModel();
        int offset2 = caretModel.getOffset();
        PsiElement psiElement2 = file2.findElementAt(offset2);
        if (psiElement2 == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement element3 = psiElement2;
        KtStringTemplateExpression ktStringTemplateExpression = Companion.findString(element3, offset2);
        if (ktStringTemplateExpression == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        KtStringTemplateExpression literal = ktStringTemplateExpression;
        boolean hasTrimIndentCallInChain = Companion.hasTrimIndentCallInChain(literal);
        if (hasTrimIndentCallInChain) {
            c = null;
        } else {
            c = Companion.getMarginCharFromTrimMarginCallsInChain(literal);
            if (c == null) {
                c = org.jetbrains.kotlin.idea.editor.KotlinMultilineStringEnterHandler$Companion.getMarginCharFromLiteral$default(Companion, literal, '\u0000', 2, null);
            }
        }
        Character marginChar = c;
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(file2, document, offset2, literal, this, hasTrimIndentCallInChain, marginChar, caretModel){
            final /* synthetic */ PsiFile $file$inlined;
            final /* synthetic */ Document $document$inlined;
            final /* synthetic */ int $offset$inlined;
            final /* synthetic */ KtStringTemplateExpression $literal$inlined;
            final /* synthetic */ KotlinMultilineStringEnterHandler this$0;
            final /* synthetic */ boolean $hasTrimIndentCallInChain$inlined;
            final /* synthetic */ Character $marginChar$inlined;
            final /* synthetic */ CaretModel $caretModel$inlined;
            {
                this.$file$inlined = psiFile2;
                this.$document$inlined = document;
                this.$offset$inlined = n;
                this.$literal$inlined = ktStringTemplateExpression;
                this.this$0 = kotlinMultilineStringEnterHandler;
                this.$hasTrimIndentCallInChain$inlined = bl;
                this.$marginChar$inlined = c;
                this.$caretModel$inlined = caretModel;
            }

            /*
             * Unable to fully structure code
             */
            public final T compute() {
                block23: {
                    block21: {
                        block24: {
                            block20: {
                                block22: {
                                    $i$a$-runWriteAction-KotlinMultilineStringEnterHandler$postProcessEnter$1 = false;
                                    settings = new Companion.MultilineSettings(this.$file$inlined);
                                    caretMarker = this.$document$inlined.createRangeMarker(this.$offset$inlined, this.$offset$inlined);
                                    caretMarker.setGreedyToRight(true);
                                    prevLineNumber = this.$document$inlined.getLineNumber(this.$offset$inlined) - 1;
                                    v0 = var5_5 = prevLineNumber >= 0;
                                    if (_Assertions.ENABLED && !var5_5) {
                                        var6_7 = "Assertion failed";
                                        throw new AssertionError((Object)var6_7);
                                    }
                                    prevLine = KotlinMultilineStringEnterHandler.Companion.getLineByNumber(prevLineNumber, this.$document$inlined);
                                    currentLine = KotlinMultilineStringEnterHandler.Companion.getLineByNumber(prevLineNumber + 1, this.$document$inlined);
                                    nextLine = this.$document$inlined.getLineCount() > prevLineNumber + 2 ? KotlinMultilineStringEnterHandler.Companion.getLineByNumber(prevLineNumber + 2, this.$document$inlined) : "";
                                    wasSingleLine = StringsKt.indexOf$default((CharSequence)this.$literal$inlined.getText(), (String)"\n", (int)0, (boolean)false, (int)6, null) == StringsKt.lastIndexOf$default((CharSequence)this.$literal$inlined.getText(), (String)"\n", (int)0, (boolean)false, (int)6, null);
                                    var9_11 = new String[]{"\n"};
                                    lines = StringsKt.split$default((CharSequence)this.$literal$inlined.getText(), (String[])var9_11, (boolean)false, (int)0, (int)6, null);
                                    literalOffset = this.$literal$inlined.getTextRange().getStartOffset();
                                    if (!wasSingleLine && (lines.size() != 3 || !KotlinMultilineStringEnterHandler.access$isInBrace$p(this.this$0))) break block22;
                                    v1 = shouldUseTrimIndent = this.$hasTrimIndentCallInChain$inlined != false || this.$marginChar$inlined == null && Intrinsics.areEqual((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first((List)lines))).toString(), (Object)"\"\"\"") != false;
                                    newMarginChar = shouldUseTrimIndent != false ? null : Character.valueOf(this.$marginChar$inlined != null ? this.$marginChar$inlined.charValue() : '|');
                                    KotlinMultilineStringEnterHandler.Companion.insertTrimCall(this.$document$inlined, this.$literal$inlined, shouldUseTrimIndent != false ? null : newMarginChar);
                                    prevIndent = settings.indentLength(prevLine);
                                    indentSize = prevIndent + settings.getMarginIndent();
                                    KotlinMultilineStringEnterHandler.Companion.forceIndent(KotlinMultilineStringEnterHandler.access$postProcessEnter$lambda$4$caretOffset(caretMarker), indentSize, newMarginChar, this.$document$inlined, settings);
                                    v2 = this.$literal$inlined.getText().substring(this.$offset$inlined - literalOffset);
                                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"this as java.lang.String).substring(startIndex)");
                                    isInLineEnd = Intrinsics.areEqual((Object)v2, (Object)"\"\"\"");
                                    if (isInLineEnd) {
                                        caretMarker.setGreedyToRight(false);
                                        KotlinMultilineStringEnterHandler.Companion.insertNewLine(KotlinMultilineStringEnterHandler.access$postProcessEnter$lambda$4$caretOffset(caretMarker), prevIndent, this.$document$inlined, settings);
                                        caretMarker.setGreedyToRight(true);
                                    }
                                    if (KotlinMultilineStringEnterHandler.access$isInBrace$p(this.this$0)) {
                                        KotlinMultilineStringEnterHandler.Companion.forceIndent(KotlinMultilineStringEnterHandler.access$postProcessEnter$lambda$4$caretOffset(caretMarker) + 1, indentSize, newMarginChar, this.$document$inlined, settings);
                                    }
                                    break block23;
                                }
                                isPrevLineFirst = this.$document$inlined.getLineNumber(literalOffset) == prevLineNumber;
                                if (isPrevLineFirst) {
                                    v3 = ((String)CollectionsKt.first((List)lines)).substring(3);
                                    v4 = v3;
                                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"this as java.lang.String).substring(startIndex)");
                                } else {
                                    v4 = prevLine;
                                }
                                indentInPreviousLine = KotlinMultilineStringEnterHandler.Companion.prefixLength(v4, (Function1<? super Character, Boolean>)((Function1)postProcessEnter.1.indentInPreviousLine.1.INSTANCE));
                                if (isPrevLineFirst) {
                                    v5 = ((String)CollectionsKt.first((List)lines)).substring(indentInPreviousLine + 3);
                                    v6 = v5;
                                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"this as java.lang.String).substring(startIndex)");
                                } else {
                                    v7 = prevLine.substring(indentInPreviousLine);
                                    v6 = v7;
                                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"this as java.lang.String).substring(startIndex)");
                                }
                                prefixStripped = v6;
                                $this$filterNot$iv = lines.subList(1, lines.size());
                                $i$f$filterNot = false;
                                var17_27 = $this$filterNot$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterNotTo = false;
                                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                                    it = (String)element$iv$iv;
                                    $i$a$-filterNot-KotlinMultilineStringEnterHandler$postProcessEnter$1$nonBlankNotFirstLines$1 = false;
                                    if (StringsKt.isBlank((CharSequence)it) != false || Intrinsics.areEqual((Object)StringsKt.trimStart((CharSequence)it).toString(), (Object)"\"\"\"") != false) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                nonBlankNotFirstLines = (List)destination$iv$iv;
                                if (this.$marginChar$inlined == null || StringsKt.startsWith$default((CharSequence)prefixStripped, (char)this.$marginChar$inlined.charValue(), (boolean)false, (int)2, null) || !(((Collection)nonBlankNotFirstLines).isEmpty() == false)) ** GOTO lbl-1000
                                $this$none$iv = nonBlankNotFirstLines;
                                $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    v8 = true;
                                } else {
                                    for (E element$iv : $this$none$iv) {
                                        it = (String)element$iv;
                                        $i$a$-none-KotlinMultilineStringEnterHandler$postProcessEnter$1$marginCharToInsert$1 = false;
                                        if (!StringsKt.startsWith$default((CharSequence)StringsKt.trimStart((CharSequence)it).toString(), (char)this.$marginChar$inlined.charValue(), (boolean)false, (int)2, null)) continue;
                                        v8 = false;
                                        break block20;
                                    }
                                    v8 = true;
                                }
                            }
                            if (v8) {
                                v9 = null;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v9 = marginCharToInsert = this.$marginChar$inlined;
                            }
                            if (marginCharToInsert == null) break block24;
                            if (StringsKt.startsWith$default((CharSequence)StringsKt.trimStart((CharSequence)currentLine).toString(), (char)marginCharToInsert.charValue(), (boolean)false, (int)2, null)) break block23;
                        }
                        indentLength = KotlinMultilineStringEnterHandler.access$isInBrace$p(this.this$0) != false ? settings.indentLength(nextLine) : (isPrevLineFirst == false ? settings.indentLength(prevLine) : settings.indentLength(prevLine) + settings.getMarginIndent());
                        KotlinMultilineStringEnterHandler.Companion.forceIndent(KotlinMultilineStringEnterHandler.access$postProcessEnter$lambda$4$caretOffset(caretMarker), indentLength, marginCharToInsert, this.$document$inlined, settings);
                        if (marginCharToInsert != null && StringsKt.startsWith$default((CharSequence)prefixStripped, (char)marginCharToInsert.charValue(), (boolean)false, (int)2, null)) {
                            v10 = prefixStripped.substring(1);
                            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"this as java.lang.String).substring(startIndex)");
                            destination$iv$iv = v10;
                            $i$f$takeWhile = false;
                            var21_38 = $this$takeWhile$iv.length();
                            for (index$iv = 0; index$iv < var21_38; ++index$iv) {
                                it = $this$takeWhile$iv.charAt(index$iv);
                                $i$a$-takeWhile-KotlinMultilineStringEnterHandler$postProcessEnter$1$wsAfterMargin$1 = false;
                                if (it == ' ' || it == '\t') continue;
                                var22_41 = $this$takeWhile$iv;
                                var23_42 = 0;
                                v11 = var22_41.substring(var23_42, index$iv);
                                v12 = v11;
                                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                break block21;
                            }
                            v12 = $this$takeWhile$iv;
                        } else {
                            v12 = "";
                        }
                    }
                    wsAfterMargin = v12;
                    this.$document$inlined.insertString(KotlinMultilineStringEnterHandler.access$postProcessEnter$lambda$4$caretOffset(caretMarker), (CharSequence)wsAfterMargin);
                    if (KotlinMultilineStringEnterHandler.access$isInBrace$p(this.this$0)) {
                        nextLineOffset = this.$document$inlined.getLineStartOffset(prevLineNumber + 2);
                        KotlinMultilineStringEnterHandler.Companion.forceIndent(nextLineOffset, 0, null, this.$document$inlined, settings);
                        v13 = marginCharToInsert;
                        if (v13 == null || (v13 = v13.toString()) == null) {
                            v13 = "";
                        }
                        this.$document$inlined.insertString(nextLineOffset, (CharSequence)((String)v13 + wsAfterMargin));
                        KotlinMultilineStringEnterHandler.Companion.forceIndent(nextLineOffset, indentLength, null, this.$document$inlined, settings);
                    }
                }
                this.$document$inlined.insertString(KotlinMultilineStringEnterHandler.access$postProcessEnter$lambda$4$caretOffset(caretMarker), (CharSequence)KotlinMultilineStringEnterHandler.access$getWhiteSpaceAfterCaret$p(this.this$0));
                this.$caretModel$inlined.moveToOffset(KotlinMultilineStringEnterHandler.access$postProcessEnter$lambda$4$caretOffset(caretMarker));
                caretMarker.dispose();
                return (T)Unit.INSTANCE;
            }
        });
        return EnterHandlerDelegate.Result.Stop;
    }

    private static final int postProcessEnter$lambda$4$caretOffset(RangeMarker caretMarker) {
        return caretMarker.getEndOffset();
    }

    public static final /* synthetic */ boolean access$isInBrace$p(KotlinMultilineStringEnterHandler $this) {
        return $this.isInBrace;
    }

    public static final /* synthetic */ int access$postProcessEnter$lambda$4$caretOffset(RangeMarker caretMarker) {
        return KotlinMultilineStringEnterHandler.postProcessEnter$lambda$4$caretOffset(caretMarker);
    }

    public static final /* synthetic */ String access$getWhiteSpaceAfterCaret$p(KotlinMultilineStringEnterHandler $this) {
        return $this.whiteSpaceAfterCaret;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u000212B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ5\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\nH\u0002J\u001f\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0002\u0010#J\u0015\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\n\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\nJ\u0018\u0010(\u001a\u00020'2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J%\u0010+\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010-J\u001e\u0010.\u001a\u00020\u000e*\u00020\u00062\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020'00R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion;", "", "()V", "DEFAULT_TRIM_MARGIN_CHAR", "", "MULTILINE_QUOTE", "", "TRIM_INDENT_CALL", "TRIM_MARGIN_CALL", "findString", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "element", "Lcom/intellij/psi/PsiElement;", "offset", "", "forceIndent", "", "indent", "marginChar", "document", "Lcom/intellij/openapi/editor/Document;", "settings", "Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$MultilineSettings;", "(IILjava/lang/Character;Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$MultilineSettings;)V", "getHostPosition", "Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$HostPosition;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getLineByNumber", "number", "getLiteralCalls", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "str", "getMarginCharFromLiteral", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;C)Ljava/lang/Character;", "getMarginCharFromTrimMarginCallsInChain", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;)Ljava/lang/Character;", "hasTrimIndentCallInChain", "", "inMultilineString", "insertNewLine", "nlOffset", "insertTrimCall", "literal", "(Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;Ljava/lang/Character;)V", "prefixLength", "f", "Lkotlin/Function1;", "HostPosition", "MultilineSettings", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KtStringTemplateExpression findString(@Nullable PsiElement element3, int offset2) {
            Object v0;
            block6: {
                if (!(element3 instanceof LeafPsiElement)) {
                    return null;
                }
                IElementType iElementType = ((LeafPsiElement)element3).getElementType();
                if (!Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.REGULAR_STRING_PART)) {
                    if ((Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.CLOSING_QUOTE) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.SHORT_TEMPLATE_ENTRY_START)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) {
                        if (((LeafPsiElement)element3).getStartOffset() != offset2) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                Sequence $this$firstIsInstanceOrNull$iv = PsiUtilsKt.getParents((PsiElement)element3);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof KtStringTemplateExpression)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            return v0;
        }

        public final boolean inMultilineString(@Nullable PsiElement element3, int offset2) {
            KtStringTemplateExpression ktStringTemplateExpression = this.findString(element3, offset2);
            return !(ktStringTemplateExpression != null ? KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)ktStringTemplateExpression) : true);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Character getMarginCharFromLiteral(@NotNull KtStringTemplateExpression str, char marginChar) {
            void $this$filterTo$iv$iv;
            List lines = StringsKt.lines((CharSequence)str.getText());
            if (lines.size() <= 2) {
                return null;
            }
            Iterable $this$filter$iv = lines.subList(1, lines.size() - 1);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.isBlank((CharSequence)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List middleNonBlank = (List)destination$iv$iv;
            if (!((Collection)middleNonBlank).isEmpty()) {
                boolean bl;
                block7: {
                    Iterable $this$all$iv = middleNonBlank;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (StringsKt.startsWith$default((CharSequence)((Object)StringsKt.trimStart((CharSequence)it)).toString(), (char)marginChar, (boolean)false, (int)2, null)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return Character.valueOf(marginChar);
                }
            }
            return null;
        }

        public static /* synthetic */ Character getMarginCharFromLiteral$default(Companion companion, KtStringTemplateExpression ktStringTemplateExpression, char c, int n, Object object) {
            if ((n & 2) != 0) {
                c = (char)124;
            }
            return companion.getMarginCharFromLiteral(ktStringTemplateExpression, c);
        }

        private final Sequence<KtCallExpression> getLiteralCalls(KtStringTemplateExpression str) {
            Ref.ObjectRef previous = new Ref.ObjectRef();
            previous.element = str;
            return SequencesKt.mapNotNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParents((PsiElement)((PsiElement)str)), (Function1)((Function1)new Function1<PsiElement, Boolean>((Ref.ObjectRef<PsiElement>)previous){
                final /* synthetic */ Ref.ObjectRef<PsiElement> $previous;
                {
                    this.$previous = $previous;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiElement parent2) {
                    boolean bl;
                    if (parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)parent2).getReceiverExpression(), (Object)this.$previous.element)) {
                        this.$previous.element = parent2;
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }
            })), (Function1)getLiteralCalls.2.INSTANCE);
        }

        @Nullable
        public final Character getMarginCharFromTrimMarginCallsInChain(@NotNull KtStringTemplateExpression str) {
            Object v1;
            block6: {
                Sequence<KtCallExpression> $this$firstOrNull$iv = this.getLiteralCalls(str);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtCallExpression call = (KtCallExpression)element$iv;
                    boolean bl = false;
                    KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((KtCallElement)call));
                    if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)KotlinMultilineStringEnterHandler.TRIM_MARGIN_CALL)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            KtCallExpression ktCallExpression = v1;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression literalCall = ktCallExpression;
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.getOrNull((List)literalCall.getValueArguments(), (int)0);
            if (ktValueArgument == null) {
                return Character.valueOf('|');
            }
            KtValueArgument firstArgument2 = ktValueArgument;
            Iterator iterator = firstArgument2.getArgumentExpression();
            KtStringTemplateExpression ktStringTemplateExpression = iterator instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)iterator : null;
            if (ktStringTemplateExpression == null) {
                return Character.valueOf('|');
            }
            KtStringTemplateExpression argumentExpression = ktStringTemplateExpression;
            Object object = ArraysKt.singleOrNull((Object[])argumentExpression.getEntries());
            KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = object instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)object : null;
            if (ktLiteralStringTemplateEntry == null) {
                return Character.valueOf('|');
            }
            KtLiteralStringTemplateEntry entry = ktLiteralStringTemplateEntry;
            Object object2 = entry.getText();
            if (object2 == null || (object2 = StringsKt.singleOrNull((CharSequence)((CharSequence)object2))) == null) {
                object2 = Character.valueOf('|');
            }
            return object2;
        }

        public final boolean hasTrimIndentCallInChain(@NotNull KtStringTemplateExpression str) {
            boolean bl;
            block1: {
                Sequence<KtCallExpression> $this$any$iv = this.getLiteralCalls(str);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    KtCallExpression call = (KtCallExpression)element$iv;
                    boolean bl2 = false;
                    KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((KtCallElement)call));
                    if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)KotlinMultilineStringEnterHandler.TRIM_INDENT_CALL)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final String getLineByNumber(int number2, @NotNull Document document) {
            return document.getText(new TextRange(document.getLineStartOffset(number2), document.getLineEndOffset(number2)));
        }

        public final void insertNewLine(int nlOffset, int indent, @NotNull Document document, @NotNull MultilineSettings settings2) {
            document.insertString(nlOffset, (CharSequence)"\n");
            this.forceIndent(nlOffset + 1, indent, null, document, settings2);
        }

        public final void forceIndent(int offset2, int indent, @Nullable Character marginChar, @NotNull Document document, @NotNull MultilineSettings settings2) {
            String string2;
            int lineStart;
            block2: {
                String line;
                int lineNumber = document.getLineNumber(offset2);
                lineStart = document.getLineStartOffset(lineNumber);
                String $this$takeWhile$iv = line = this.getLineByNumber(lineNumber, document);
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char c = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (c == ' ' || c == '\t') continue;
                    String string3 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string4 = string3.substring(n2, index$iv);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    break block2;
                }
                string2 = $this$takeWhile$iv;
            }
            String wsPrefix = string2;
            int n = lineStart + wsPrefix.length();
            String string5 = settings2.getSmartSpaces(indent);
            Object object = marginChar;
            if (object == null || (object = ((Character)object).toString()) == null) {
                object = "";
            }
            document.replaceString(lineStart, n, (CharSequence)(string5 + (String)object));
        }

        /*
         * WARNING - void declaration
         */
        public final int prefixLength(@NotNull String $this$prefixLength, @NotNull Function1<? super Character, Boolean> f2) {
            String string2;
            block1: {
                void var3_3;
                String $this$takeWhile$iv = $this$prefixLength;
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    if (((Boolean)f2.invoke((Object)Character.valueOf($this$takeWhile$iv.charAt(index$iv)))).booleanValue()) continue;
                    String string3 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string4 = string3.substring(n2, index$iv);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    break block1;
                }
                string2 = var3_3;
            }
            return ((CharSequence)string2).length();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void insertTrimCall(@NotNull Document document, @NotNull KtStringTemplateExpression literal, @Nullable Character marginChar) {
            if (this.hasTrimIndentCallInChain(literal)) return;
            if (this.getMarginCharFromTrimMarginCallsInChain(literal) != null) {
                return;
            }
            Sequence $this$any$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)literal));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                boolean bl;
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (it instanceof KtAnnotationEntry) return;
                KtProperty ktProperty = it instanceof KtProperty ? (KtProperty)it : null;
                if (ktProperty != null) {
                    if (ktProperty.hasModifier(KtTokens.CONST_KEYWORD)) {
                        return;
                    }
                    bl = false;
                } else {
                    bl = false;
                }
                if (bl) {
                    return;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return;
            }
            boolean bl = false;
            if (bl) {
                return;
            }
            if (marginChar == null) {
                document.insertString(literal.getTextRange().getEndOffset(), (CharSequence)".trimIndent()");
                return;
            } else {
                char c = '|';
                document.insertString(literal.getTextRange().getEndOffset(), (CharSequence)(marginChar.charValue() == c ? ".trimMargin()" : ".trimMargin(\"" + marginChar + "\")"));
            }
        }

        private final HostPosition getHostPosition(DataContext dataContext) {
            Editor editor2 = DataContextUtilsKt.getHostEditor(dataContext);
            EditorEx editorEx = editor2 instanceof EditorEx ? (EditorEx)editor2 : null;
            if (editorEx == null) {
                return null;
            }
            EditorEx editor3 = editorEx;
            Project project = DataContextUtilsKt.getProject(dataContext);
            VirtualFile virtualFile = editor3.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile(virtualFile2, project);
            if (psiFile2 == null) {
                return null;
            }
            PsiFile psiFile3 = psiFile2;
            return new HostPosition(psiFile3, (Editor)editor3, editor3.getCaretModel().getOffset());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0011R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$MultilineSettings;", "", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "kotlinIndentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "Lorg/jetbrains/annotations/NotNull;", "marginIndent", "", "getMarginIndent", "()I", "regularIndent", "tabSize", "useTabs", "", "getSmartSpaces", "", "count", "indentLength", "line", "kotlin.idea"})
        public static final class MultilineSettings {
            @NotNull
            private final CommonCodeStyleSettings.IndentOptions kotlinIndentOptions;
            private final boolean useTabs;
            private final int tabSize;
            private final int regularIndent;
            private final int marginIndent;

            public MultilineSettings(@NotNull PsiFile file2) {
                this.kotlinIndentOptions = CodeStyle.getIndentOptions((PsiFile)file2);
                this.useTabs = this.kotlinIndentOptions.USE_TAB_CHARACTER;
                this.tabSize = this.kotlinIndentOptions.TAB_SIZE;
                this.marginIndent = this.regularIndent = this.kotlinIndentOptions.INDENT_SIZE;
            }

            public final int getMarginIndent() {
                return this.marginIndent;
            }

            @NotNull
            public final String getSmartSpaces(int count) {
                return this.useTabs ? StringUtil.repeat((String)"\t", (int)(count / this.tabSize)) + StringUtil.repeat((String)" ", (int)(count % this.tabSize)) : StringUtil.repeat((String)" ", (int)count);
            }

            public final int indentLength(@NotNull String line) {
                int n;
                if (this.useTabs) {
                    int tabsCount2 = Companion.prefixLength(line, (Function1<? super Character, Boolean>)((Function1)indentLength.tabsCount.1.INSTANCE));
                    String string2 = line.substring(tabsCount2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    n = tabsCount2 * this.tabSize + Companion.prefixLength(string2, (Function1<? super Character, Boolean>)((Function1)indentLength.1.INSTANCE));
                } else {
                    n = Companion.prefixLength(line, (Function1<? super Character, Boolean>)((Function1)indentLength.2.INSTANCE));
                }
                return n;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$HostPosition;", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;I)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getFile", "()Lcom/intellij/psi/PsiFile;", "getOffset", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "kotlin.idea"})
        private static final class HostPosition {
            @NotNull
            private final PsiFile file;
            @NotNull
            private final Editor editor;
            private final int offset;

            public HostPosition(@NotNull PsiFile file2, @NotNull Editor editor2, int offset2) {
                this.file = file2;
                this.editor = editor2;
                this.offset = offset2;
            }

            @NotNull
            public final PsiFile getFile() {
                return this.file;
            }

            @NotNull
            public final Editor getEditor() {
                return this.editor;
            }

            public final int getOffset() {
                return this.offset;
            }

            @NotNull
            public final PsiFile component1() {
                return this.file;
            }

            @NotNull
            public final Editor component2() {
                return this.editor;
            }

            public final int component3() {
                return this.offset;
            }

            @NotNull
            public final HostPosition copy(@NotNull PsiFile file2, @NotNull Editor editor2, int offset2) {
                return new HostPosition(file2, editor2, offset2);
            }

            public static /* synthetic */ HostPosition copy$default(HostPosition hostPosition, PsiFile psiFile2, Editor editor2, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    psiFile2 = hostPosition.file;
                }
                if ((n2 & 2) != 0) {
                    editor2 = hostPosition.editor;
                }
                if ((n2 & 4) != 0) {
                    n = hostPosition.offset;
                }
                return hostPosition.copy(psiFile2, editor2, n);
            }

            @NotNull
            public String toString() {
                return "HostPosition(file=" + this.file + ", editor=" + this.editor + ", offset=" + this.offset + ")";
            }

            public int hashCode() {
                int result2 = this.file.hashCode();
                result2 = result2 * 31 + this.editor.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.offset);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof HostPosition)) {
                    return false;
                }
                HostPosition hostPosition = (HostPosition)other;
                if (!Intrinsics.areEqual((Object)this.file, (Object)hostPosition.file)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.editor, (Object)hostPosition.editor)) {
                    return false;
                }
                return this.offset == hostPosition.offset;
            }
        }
    }
}

