/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.editor.EntryChunk;
import org.jetbrains.kotlin.idea.editor.KotlinLiteralCopyPasteProcessor;
import org.jetbrains.kotlin.idea.editor.KotlinLiteralCopyPasteProcessorKt;
import org.jetbrains.kotlin.idea.editor.LiteralChunk;
import org.jetbrains.kotlin.idea.editor.NewLineChunk;
import org.jetbrains.kotlin.idea.editor.TemplateChunk;
import org.jetbrains.kotlin.idea.editor.TemplateTokenSequence;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004H\u0016J2\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePreProcessor;", "()V", "preprocessOnCopy", "", "file", "Lcom/intellij/psi/PsiFile;", "startOffsets", "", "endOffsets", "text", "preprocessOnPaste", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rawText", "Lcom/intellij/openapi/editor/RawText;", "kotlin.idea"})
public final class KotlinLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(@NotNull PsiFile file2, @NotNull int[] startOffsets, @NotNull int[] endOffsets, @NotNull String text2) {
        if (!(file2 instanceof KtFile)) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean changed2 = false;
        String fileText = ((KtFile)file2).getText();
        int deducedBlockSelectionWidth = KotlinLiteralCopyPasteProcessorKt.access$deduceBlockSelectionWidth(startOffsets, endOffsets, text2);
        int n = startOffsets.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 > 0) {
                buffer.append('\n');
            }
            TextRange fileRange = new TextRange(startOffsets[i2], endOffsets[i2]);
            int givenTextOffset = fileRange.getStartOffset();
            while (givenTextOffset < fileRange.getEndOffset()) {
                TextRange inter;
                PsiElement tpEntry;
                PsiElement element3 = file2.findElementAt(givenTextOffset);
                if (element3 == null) {
                    String string2 = fileText.substring(givenTextOffset, fileRange.getEndOffset() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    buffer.append(string2);
                    break;
                }
                IElementType elTp = element3.getNode().getElementType();
                if (Intrinsics.areEqual((Object)elTp, (Object)KtTokens.ESCAPE_SEQUENCE) && fileRange.contains(FixersUtilKt.getRange(element3))) {
                    TextRange textRange = KotlinLiteralCopyPasteProcessorKt.access$getTemplateContentRange(element3);
                    boolean bl = textRange != null ? textRange.contains(fileRange) : false;
                    if (bl) {
                        PsiElement psiElement2 = element3.getParent();
                        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry");
                        tpEntry = (KtEscapeStringTemplateEntry)psiElement2;
                        changed2 = true;
                        buffer.append(tpEntry.getUnescapedValue());
                        givenTextOffset = PsiUtilsKt.getEndOffset((PsiElement)element3);
                        continue;
                    }
                }
                if (Intrinsics.areEqual((Object)elTp, (Object)KtTokens.SHORT_TEMPLATE_ENTRY_START) || Intrinsics.areEqual((Object)elTp, (Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) {
                    TextRange inter2;
                    tpEntry = element3.getParent();
                    Intrinsics.checkNotNull((Object)fileRange.intersection(FixersUtilKt.getRange(tpEntry)));
                    String string3 = fileText.substring(inter2.getStartOffset(), inter2.getEndOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    buffer.append(string3);
                    givenTextOffset = inter2.getEndOffset();
                    continue;
                }
                Intrinsics.checkNotNull((Object)fileRange.intersection(FixersUtilKt.getRange(element3)));
                String string4 = fileText.substring(inter.getStartOffset(), inter.getEndOffset());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                buffer.append(string4);
                givenTextOffset = inter.getEndOffset();
            }
            int blockSelectionPadding = deducedBlockSelectionWidth - fileRange.getLength();
            for (int j = 0; j < blockSelectionPadding; ++j) {
                buffer.append(' ');
            }
        }
        return changed2 ? buffer.toString() : null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public String preprocessOnPaste(@NotNull Project project, @NotNull PsiFile file2, @NotNull Editor editor2, @NotNull String text2, @Nullable RawText rawText) {
        StringBuilder stringBuilder;
        String string2;
        String string3;
        TemplateTokenSequence templateTokenSequence;
        block24: {
            boolean bl;
            Object object;
            block18: {
                CharSequence $this$all$iv;
                block23: {
                    Object object2;
                    Iterator iterator;
                    boolean endsInLineBreak;
                    String lineBreak;
                    StringBuilder res;
                    block20: {
                        block21: {
                            block22: {
                                KtQualifiedExpression ktQualifiedExpression;
                                KtStringTemplateExpression beginTp;
                                PsiElement begin;
                                block19: {
                                    if (!(file2 instanceof KtFile)) {
                                        return text2;
                                    }
                                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
                                    SelectionModel selectionModel = editor2.getSelectionModel();
                                    PsiElement psiElement2 = file2.findElementAt(selectionModel.getSelectionStart());
                                    if (psiElement2 == null) {
                                        return text2;
                                    }
                                    begin = psiElement2;
                                    KtStringTemplateExpression ktStringTemplateExpression = KotlinLiteralCopyPasteProcessorKt.access$getTemplateIfAtLiteral(file2, selectionModel.getSelectionStart(), begin);
                                    if (ktStringTemplateExpression == null) {
                                        return text2;
                                    }
                                    beginTp = ktStringTemplateExpression;
                                    KtStringTemplateExpression ktStringTemplateExpression2 = KotlinLiteralCopyPasteProcessorKt.getTemplateIfAtLiteral$default(file2, selectionModel.getSelectionEnd(), null, 2, null);
                                    if (ktStringTemplateExpression2 == null) {
                                        return text2;
                                    }
                                    KtStringTemplateExpression endTp = ktStringTemplateExpression2;
                                    if (KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)beginTp) != KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)endTp)) {
                                        return text2;
                                    }
                                    templateTokenSequence = new TemplateTokenSequence(text2);
                                    if (!KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)beginTp)) break block19;
                                    res = new StringBuilder();
                                    lineBreak = "\\n\"+\n \"";
                                    endsInLineBreak = false;
                                    Sequence $this$forEach$iv = templateTokenSequence;
                                    boolean $i$f$forEach = false;
                                    iterator = $this$forEach$iv.iterator();
                                    break block20;
                                }
                                PsiElement psiElement3 = beginTp.getFirstChild();
                                if (!Intrinsics.areEqual((Object)(psiElement3 != null ? psiElement3.getText() : null), (Object)"\"\"\"") || !Intrinsics.areEqual((ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)beginTp))) != null && (ktQualifiedExpression = UtilsKt.getCallExpression(ktQualifiedExpression)) != null && (ktQualifiedExpression = ktQualifiedExpression.getCalleeExpression()) != null ? ktQualifiedExpression.getText() : null, (Object)"trimIndent")) break block21;
                                TemplateChunk templateChunk2 = (TemplateChunk)SequencesKt.firstOrNull((Sequence)templateTokenSequence);
                                templateChunk2 = (TemplateChunk)SequencesKt.lastOrNull((Sequence)templateTokenSequence);
                                if (!Intrinsics.areEqual((Object)(templateChunk != null ? KotlinLiteralCopyPasteProcessor.preprocessOnPaste$indent(templateChunk) : null), (Object)(templateChunk2 != null ? KotlinLiteralCopyPasteProcessor.preprocessOnPaste$indent(templateChunk2) : null))) break block21;
                                Object object3 = begin.getParent();
                                if (object3 == null || (object3 = object3.getPrevSibling()) == null || (object3 = object3.getText()) == null) break block22;
                                Object object4 = object = object3;
                                boolean bl2 = false;
                                $this$all$iv = (CharSequence)object4;
                                boolean $i$f$all = false;
                                break block23;
                            }
                            string3 = null;
                            break block24;
                        }
                        string3 = null;
                        break block24;
                    }
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        TemplateChunk it = (TemplateChunk)e;
                        boolean bl3 = false;
                        TemplateChunk templateChunk = it;
                        if (templateChunk instanceof LiteralChunk) {
                            StringUtil.escapeStringCharacters((int)((LiteralChunk)it).getText().length(), (String)((LiteralChunk)it).getText(), (String)"$\"", (StringBuilder)res);
                        } else if (templateChunk instanceof EntryChunk) {
                            res.append(((EntryChunk)it).getText());
                        } else if (templateChunk instanceof NewLineChunk) {
                            res.append(lineBreak);
                        }
                        endsInLineBreak = it instanceof NewLineChunk;
                    }
                    if (endsInLineBreak) {
                        object2 = StringsKt.removeSuffix((CharSequence)res, (CharSequence)lineBreak) + "\\n";
                        return object2;
                    }
                    object2 = res.toString();
                    return object2;
                }
                for (int j = 0; j < $this$all$iv.length(); ++j) {
                    char element$iv;
                    char c = element$iv = $this$all$iv.charAt(j);
                    boolean bl4 = false;
                    if (c == ' ' || c == '\t') continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
            string3 = string2 = bl ? object : null;
        }
        if (string3 == null) {
            string2 = "";
        }
        String indent = string2;
        StringBuilder $this$preprocessOnPaste_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Regex tripleQuoteRe = new Regex("[\"]{3,}");
        String string4 = "";
        Iterator<TemplateChunk> iterator = templateTokenSequence.iterator();
        while (true) {
            void var16_24;
            if (!iterator.hasNext()) {
                String string5 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
                return string5;
            }
            TemplateChunk chunk = iterator.next();
            TemplateChunk templateChunk = chunk;
            if (templateChunk instanceof LiteralChunk) {
                String escapedDollar = StringsKt.replace$default((String)((LiteralChunk)chunk).getText(), (String)"$", (String)"${'$'}", (boolean)false, (int)4, null);
                boolean bl5 = false;
                String replaced2 = tripleQuoteRe.replace((CharSequence)escapedDollar, (Function1)preprocessOnPaste.2.replaced.1.1.INSTANCE);
                $this$preprocessOnPaste_u24lambda_u245.append((String)var16_24 + replaced2);
                String string6 = "";
                continue;
            }
            if (templateChunk instanceof EntryChunk) {
                $this$preprocessOnPaste_u24lambda_u245.append((String)var16_24 + ((EntryChunk)chunk).getText());
                String string7 = "";
                continue;
            }
            if (!(templateChunk instanceof NewLineChunk)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)$this$preprocessOnPaste_u24lambda_u245.append('\n'), (String)"append('\\n')");
            String string8 = indent;
        }
    }

    private static final String preprocessOnPaste$indent(TemplateChunk $this$preprocessOnPaste_u24indent) {
        Object object;
        block1: {
            TemplateChunk templateChunk = $this$preprocessOnPaste_u24indent;
            String $this$takeWhile$iv = templateChunk instanceof LiteralChunk ? ((LiteralChunk)$this$preprocessOnPaste_u24indent).getText() : (templateChunk instanceof EntryChunk ? ((EntryChunk)$this$preprocessOnPaste_u24indent).getText() : "");
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                object = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                break block1;
            }
            object = templateChunk;
        }
        return object;
    }
}

