/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0014JF\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinEnterAfterUnmatchedBraceHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler;", "()V", "getRBraceForLambda", "", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "(Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;)Ljava/lang/Integer;", "getRBraceOffset", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffset", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "isDeclarationInitializer", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
public final class KotlinEnterAfterUnmatchedBraceHandler
extends EnterAfterUnmatchedBraceHandler {
    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        int caretOffset = ((Number)caretOffsetRef.get()).intValue() - 1;
        PsiElement element3 = file2.findElementAt(caretOffset);
        PsiElement psiElement2 = element3;
        if (Intrinsics.areEqual((Object)(psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null), (Object)KtTokens.LBRACE)) {
            return super.preprocessEnter(file2, editor2, caretOffsetRef, caretAdvance, dataContext, originalHandler);
        }
        if (!(element3 instanceof PsiWhiteSpace)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement prevElement = KotlinPsiUtils.getElementAtOffsetIgnoreWhitespaceAfter(file2, caretOffset);
        if (prevElement != null && Intrinsics.areEqual((Object)prevElement.getNode().getElementType(), (Object)KtTokens.LBRACE)) {
            return super.preprocessEnter(file2, editor2, new Ref((Object)(PsiUtilsKt.getStartOffset((PsiElement)prevElement) + 1)), caretAdvance, dataContext, originalHandler);
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    protected int getRBraceOffset(@NotNull PsiFile file2, @NotNull Editor editor2, int caretOffset) {
        Integer endOffset2;
        Integer n;
        PsiElement parent2;
        PsiElement nextSibling;
        PsiElement element3;
        PsiElement psiElement2 = element3 = file2.findElementAt(caretOffset - 1);
        Object object = nextSibling = psiElement2 != null ? psiElement2.getNextSibling() : null;
        if (nextSibling instanceof PsiWhiteSpace && ((PsiWhiteSpace)nextSibling).textContains('\n')) {
            return super.getRBraceOffset(file2, editor2, caretOffset);
        }
        PsiElement psiElement3 = element3;
        Object object2 = parent2 = psiElement3 != null ? psiElement3.getParent() : null;
        if (parent2 instanceof KtFunctionLiteral) {
            n = this.getRBraceForLambda((KtFunctionLiteral)parent2);
        } else if (parent2 instanceof KtWhenExpression) {
            if (this.isDeclarationInitializer((KtExpression)parent2)) {
                Object[] objectArray = (Object[])CollectionsKt.firstOrNull((List)((KtWhenExpression)parent2).getEntries());
                KtWhenCondition ktWhenCondition = objectArray != null && (objectArray = objectArray.getConditions()) != null ? (KtWhenCondition)ArraysKt.firstOrNull((Object[])objectArray) : null;
                KtWhenConditionWithExpression ktWhenConditionWithExpression = ktWhenCondition instanceof KtWhenConditionWithExpression ? (KtWhenConditionWithExpression)ktWhenCondition : null;
                n = ktWhenConditionWithExpression != null ? Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktWhenConditionWithExpression))) : null;
            } else {
                n = null;
            }
        } else {
            n = null;
        }
        Integer n2 = endOffset2 = n;
        return n2 != null ? n2.intValue() : super.getRBraceOffset(file2, editor2, caretOffset);
    }

    private final Integer getRBraceForLambda(KtFunctionLiteral functionLiteral) {
        PsiElement firstVisibleChild;
        PsiElement psiElement2 = functionLiteral.getParent();
        KtLambdaExpression ktLambdaExpression2 = psiElement2 instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement2 : null;
        if (ktLambdaExpression2 == null || (ktLambdaExpression2 = ktLambdaExpression2.getBodyExpression()) == null) {
            return null;
        }
        KtLambdaExpression bodyExpression = ktLambdaExpression2;
        PsiElement psiElement3 = bodyExpression.getFirstChild();
        PsiElement psiElement4 = firstVisibleChild = psiElement3 != null ? PsiUtilsKt.getNextSiblingIgnoringWhitespace((PsiElement)psiElement3, (boolean)true) : null;
        return psiElement4 != null ? Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)psiElement4)) : null;
    }

    private final boolean isDeclarationInitializer(KtExpression $this$isDeclarationInitializer) {
        PsiElement psiElement2 = $this$isDeclarationInitializer.getParent();
        KtDeclarationWithInitializer ktDeclarationWithInitializer = psiElement2 instanceof KtDeclarationWithInitializer ? (KtDeclarationWithInitializer)psiElement2 : null;
        return Intrinsics.areEqual((Object)(ktDeclarationWithInitializer != null ? ktDeclarationWithInitializer.getInitializer() : null), (Object)$this$isDeclarationInitializer);
    }
}

