/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.PositionManager;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTargetFilterer;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTargetFiltererAdapterKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.LineMatchingMethodVisitor;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J0\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\rH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00030\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTargetFiltererAdapter;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/LineMatchingMethodVisitor;", "lines", "Lkotlin/ranges/ClosedRange;", "", "location", "Lcom/sun/jdi/Location;", "positionManager", "Lcom/intellij/debugger/PositionManager;", "targetFilterer", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTargetFilterer;", "(Lkotlin/ranges/ClosedRange;Lcom/sun/jdi/Location;Lcom/intellij/debugger/PositionManager;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTargetFilterer;)V", "inInline", "", "inlineFunctionVariablesAndBorders", "", "Lkotlin/Pair;", "Lcom/sun/jdi/LocalVariable;", "reportOpcode", "", "opcode", "visitMethodInsn", "owner", "", "name", "descriptor", "isInterface", "kotlin.jvm-debugger.core-fe10"})
public final class KotlinSmartStepTargetFiltererAdapter
extends LineMatchingMethodVisitor {
    @NotNull
    private final Location location;
    @NotNull
    private final PositionManager positionManager;
    @NotNull
    private final KotlinSmartStepTargetFilterer targetFilterer;
    @NotNull
    private final List<Pair<LocalVariable, ClosedRange<Location>>> inlineFunctionVariablesAndBorders;
    private boolean inInline;

    public KotlinSmartStepTargetFiltererAdapter(@NotNull ClosedRange<Integer> lines, @NotNull Location location2, @NotNull PositionManager positionManager, @NotNull KotlinSmartStepTargetFilterer targetFilterer) {
        super(lines);
        Map<LocalVariable, ClosedRange<Location>> map2;
        this.location = location2;
        this.positionManager = positionManager;
        this.targetFilterer = targetFilterer;
        Method method = SafeUtilKt.safeMethod(this.location);
        List list2 = method != null && (map2 = DebuggerUtil.getInlineFunctionAndArgumentVariablesToBordersMap(method)) != null ? MapsKt.toList(map2) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        this.inlineFunctionVariablesAndBorders = list2;
    }

    @Override
    public void reportOpcode(int opcode) {
        Object v1;
        block5: {
            if (!this.getLineEverMatched()) {
                return;
            }
            Iterable $this$firstOrNull$iv = this.inlineFunctionVariablesAndBorders;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                IntRange intRange = KotlinSmartStepTargetFiltererAdapterKt.access$toLineNumberRange((ClosedRange)it.getSecond());
                int n = intRange.getFirst();
                int n2 = intRange.getLast();
                int n3 = this.getCurrentLine();
                boolean bl2 = n <= n3 ? n3 <= n2 : false;
                if (!bl2) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        Pair inlineCall = v1;
        if (inlineCall == null) {
            this.inInline = false;
            return;
        }
        if (!this.inInline) {
            KtNamedFunction calledInlineFunction;
            String name2 = ((LocalVariable)inlineCall.getFirst()).name();
            if (StringsKt.startsWith$default((String)name2, (String)"$i$f$", (boolean)false, (int)2, null) && (calledInlineFunction = KotlinSmartStepTargetFiltererAdapterKt.access$getCalledInlineFunction(this.positionManager, this.location, this.getCurrentLine())) != null) {
                this.targetFilterer.visitInlineFunction(calledInlineFunction);
            }
            this.inInline = true;
        }
    }

    @Override
    public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String descriptor2, boolean isInterface2) {
        if (this.getLineMatches()) {
            this.targetFilterer.visitOrdinaryFunction(owner, name2, descriptor2);
        }
    }
}

