/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTargetFiltererKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nJ,\u0010\u0018\u001a\u00020\u0019*\u00020\u00042\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J,\u0010\u001b\u001a\u00020\u0019*\u00020\u00042\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTargetFilterer;", "", "targets", "", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodSmartStepTarget;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "(Ljava/util/List;Lcom/intellij/debugger/engine/DebugProcessImpl;)V", "functionCounter", "", "", "", "targetWasVisited", "", "getUnvisitedTargets", "reset", "", "visitInlineFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitOrdinaryFunction", "owner", "name", "signature", "matches", "", "currentCount", "shouldBeVisited", "kotlin.jvm-debugger.core-fe10"})
public final class KotlinSmartStepTargetFilterer {
    @NotNull
    private final List<KotlinMethodSmartStepTarget> targets;
    @NotNull
    private final DebugProcessImpl debugProcess;
    @NotNull
    private final Map<String, Integer> functionCounter;
    @NotNull
    private final boolean[] targetWasVisited;

    public KotlinSmartStepTargetFilterer(@NotNull List<KotlinMethodSmartStepTarget> targets, @NotNull DebugProcessImpl debugProcess) {
        this.targets = targets;
        this.debugProcess = debugProcess;
        this.functionCounter = new LinkedHashMap();
        int n = 0;
        int n2 = this.targets.size();
        boolean[] blArray = new boolean[n2];
        KotlinSmartStepTargetFilterer kotlinSmartStepTargetFilterer = this;
        while (n < n2) {
            int n3 = n++;
            blArray[n3] = false;
        }
        kotlinSmartStepTargetFilterer.targetWasVisited = blArray;
    }

    public final void visitInlineFunction(@NotNull KtNamedFunction function2) {
        int matchedSteppingTargetIndex;
        block4: {
            int n;
            DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)function2);
            if (declarationDescriptor == null) {
                return;
            }
            DeclarationDescriptor descriptor2 = declarationDescriptor;
            String label2 = KotlinMethodSmartStepTarget.Companion.calcLabel(descriptor2);
            int currentCount = KotlinSmartStepTargetFiltererKt.access$increment(this.functionCounter, label2) - 1;
            List<KotlinMethodSmartStepTarget> $this$indexOfFirst$iv = this.targets;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<KotlinMethodSmartStepTarget> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                KotlinMethodSmartStepTarget item$iv;
                KotlinMethodSmartStepTarget it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getDeclaration() == function2 && it.getOrdinal() == currentCount) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = matchedSteppingTargetIndex = -1;
        }
        if (matchedSteppingTargetIndex < 0) {
            return;
        }
        this.targetWasVisited[matchedSteppingTargetIndex] = true;
    }

    public final void visitOrdinaryFunction(@NotNull String owner, @NotNull String name2, @NotNull String signature2) {
        int currentCount = KotlinSmartStepTargetFiltererKt.access$increment(this.functionCounter, owner + "." + name2 + signature2) - 1;
        Iterator<KotlinMethodSmartStepTarget> iterator = this.targets.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i2 = n++;
            KotlinMethodSmartStepTarget target2 = iterator.next();
            if (!this.shouldBeVisited(target2, owner, name2, signature2, currentCount)) continue;
            this.targetWasVisited[i2] = true;
            break;
        }
    }

    private final boolean shouldBeVisited(KotlinMethodSmartStepTarget $this$shouldBeVisited, String owner, String name2, String signature2, int currentCount) {
        String actualName = DebuggerUtils.INSTANCE.trimIfMangledInBytecode(name2, $this$shouldBeVisited.getMethodInfo().isNameMangledInBytecode());
        if ($this$shouldBeVisited.getMethodInfo().isInlineClassMember()) {
            return this.matches($this$shouldBeVisited, owner, actualName, KotlinSmartStepTargetFiltererKt.access$getSignatureWithoutFirstArgument(signature2), currentCount);
        }
        return this.matches($this$shouldBeVisited, owner, actualName, signature2, currentCount);
    }

    private final boolean matches(KotlinMethodSmartStepTarget $this$matches, String owner, String name2, String signature2, int currentCount) {
        if (Intrinsics.areEqual((Object)$this$matches.getMethodInfo().getName(), (Object)name2) && $this$matches.getOrdinal() == currentCount) {
            KtDeclaration ktDeclaration = $this$matches.getDeclaration();
            if (ktDeclaration == null || (ktDeclaration = KotlinSmartStepTargetFiltererKt.access$getLightClassMethod(ktDeclaration)) == null) {
                return false;
            }
            KtDeclaration lightClassMethod = ktDeclaration;
            return KotlinSmartStepTargetFiltererKt.access$matches((PsiMethod)lightClassMethod, owner, name2, signature2, this.debugProcess);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KotlinMethodSmartStepTarget> getUnvisitedTargets() {
        void $this$filterIndexedTo$iv$iv;
        Iterable $this$filterIndexed$iv = this.targets;
        boolean $i$f$filterIndexed = false;
        Iterable iterable = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            KotlinMethodSmartStepTarget cfr_ignored_0 = (KotlinMethodSmartStepTarget)element$iv$iv;
            int i2 = index$iv$iv;
            boolean bl2 = false;
            if (!(!this.targetWasVisited[i2])) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void reset() {
        Arrays.fill(this.targetWasVisited, false);
        this.functionCounter.clear();
    }
}

