/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaMethodFilterKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTargetKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u001b\u001a\u00020\u0013*\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaMethodFilter;", "Lcom/intellij/debugger/engine/BreakpointStepMethodFilter;", "lambda", "Lorg/jetbrains/kotlin/psi/KtFunction;", "callingExpressionLines", "Lcom/intellij/util/Range;", "", "lambdaInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lcom/intellij/util/Range;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;)V", "firstStatementPosition", "Lcom/intellij/debugger/SourcePosition;", "lambdaPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "lastStatementLine", "getBreakpointPosition", "getCallingExpressionLines", "getLastStatementLine", "isTargetLambdaName", "", "name", "", "locationMatches", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "matchesExpression", "bodyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.jvm-debugger.core-fe10"})
public final class KotlinLambdaMethodFilter
implements BreakpointStepMethodFilter {
    @Nullable
    private final Range<Integer> callingExpressionLines;
    @NotNull
    private final KotlinLambdaInfo lambdaInfo;
    @NotNull
    private final SmartPsiElementPointer<KtFunction> lambdaPtr;
    @Nullable
    private final SourcePosition firstStatementPosition;
    private final int lastStatementLine;

    public KotlinLambdaMethodFilter(@NotNull KtFunction lambda2, @Nullable Range<Integer> callingExpressionLines, @NotNull KotlinLambdaInfo lambdaInfo) {
        this.callingExpressionLines = callingExpressionLines;
        this.lambdaInfo = lambdaInfo;
        this.lambdaPtr = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)lambda2));
        Pair<SourcePosition, SourcePosition> pair = KotlinLambdaMethodFilterKt.findFirstAndLastStatementPositions((KtDeclarationWithBody)lambda2);
        SourcePosition firstPosition = (SourcePosition)pair.component1();
        SourcePosition lastPosition = (SourcePosition)pair.component2();
        this.firstStatementPosition = firstPosition;
        SourcePosition sourcePosition = lastPosition;
        this.lastStatementLine = sourcePosition != null ? sourcePosition.getLine() : -1;
    }

    @Nullable
    public SourcePosition getBreakpointPosition() {
        return this.firstStatementPosition;
    }

    public int getLastStatementLine() {
        return this.lastStatementLine;
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location2) {
        KtFunction ktFunction = KotlinMethodSmartStepTargetKt.getElementInReadAction(this.lambdaPtr);
        if (ktFunction == null) {
            return true;
        }
        KtFunction lambda2 = ktFunction;
        if (this.lambdaInfo.isInline()) {
            return DebuggerUtil.isInsideInlineArgument(lambda2, location2, process2);
        }
        Method method = SafeUtilKt.safeMethod(location2);
        if (method == null) {
            return true;
        }
        Method method2 = method;
        if (method2.isBridge()) {
            return false;
        }
        String string2 = method2.name();
        if (string2 == null) {
            return false;
        }
        String methodName2 = string2;
        return this.isTargetLambdaName(methodName2) && this.matchesExpression(location2, process2, lambda2.getBodyExpression());
    }

    private final boolean matchesExpression(Location $this$matchesExpression, DebugProcessImpl process2, KtExpression bodyExpression) {
        SourcePosition sourcePosition = process2.getPositionManager().getSourcePosition($this$matchesExpression);
        if (sourcePosition == null) {
            return true;
        }
        SourcePosition sourcePosition2 = sourcePosition;
        boolean $i$f$runReadAction = false;
        KtBlockExpression ktBlockExpression = (KtBlockExpression)ApplicationManager.getApplication().runReadAction(new Computable(sourcePosition2){
            final /* synthetic */ SourcePosition $sourcePosition$inlined;
            {
                this.$sourcePosition$inlined = sourcePosition;
            }

            /*
             * WARNING - void declaration
             */
            public final T compute() {
                void $this$parentOfType$iv;
                boolean bl = false;
                PsiElement psiElement2 = this.$sourcePosition$inlined.getElementAt();
                boolean withSelf$iv = true;
                boolean $i$f$parentOfType = false;
                return (T)((KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtBlockExpression.class, (boolean)false));
            }
        });
        if (ktBlockExpression == null) {
            return true;
        }
        KtBlockExpression blockAt = ktBlockExpression;
        return blockAt == bodyExpression;
    }

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.lambdaInfo.isInline() ? new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)) : this.callingExpressionLines;
    }

    public final boolean isTargetLambdaName(@NotNull String name2) {
        String actualName = DebuggerUtils.INSTANCE.trimIfMangledInBytecode(name2, this.lambdaInfo.isNameMangledInBytecode());
        if (this.lambdaInfo.isSuspend()) {
            return Intrinsics.areEqual((Object)actualName, (Object)"invokeSuspend");
        }
        return Intrinsics.areEqual((Object)actualName, (Object)this.lambdaInfo.getMethodName()) || DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(actualName);
    }
}

