/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.debugger.ui.breakpoints.SteppingBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodFilter;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\u0018H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilter;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "callingExpressionLines", "Lcom/intellij/util/Range;", "", "lambdaInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;", "lambdaFilter", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaMethodFilter;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lcom/intellij/util/Range;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaMethodFilter;)V", "visitedLocations", "createBreakpoint", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter$KotlinLambdaInstanceBreakpoint;", "context", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "locationMatches", "", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "onReached", "hint", "Lcom/intellij/debugger/engine/RequestHint;", "getLambdaMethod", "Lcom/sun/jdi/Method;", "Lcom/sun/jdi/ReferenceType;", "getLambdaReference", "Lcom/sun/jdi/ObjectReference;", "KotlinLambdaInstanceBreakpoint", "kotlin.jvm-debugger.core-fe10"})
public final class KotlinLambdaAsyncMethodFilter
extends KotlinMethodFilter {
    @NotNull
    private final KotlinLambdaInfo lambdaInfo;
    @NotNull
    private final KotlinLambdaMethodFilter lambdaFilter;
    private int visitedLocations;

    public KotlinLambdaAsyncMethodFilter(@Nullable KtDeclaration declaration2, @Nullable Range<Integer> callingExpressionLines, @NotNull KotlinLambdaInfo lambdaInfo, @NotNull KotlinLambdaMethodFilter lambdaFilter) {
        super(declaration2, callingExpressionLines, lambdaInfo.getCallerMethodInfo());
        this.lambdaInfo = lambdaInfo;
        this.lambdaFilter = lambdaFilter;
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @Nullable Location location2, @Nullable StackFrameProxyImpl frameProxy) {
        if (frameProxy == null || !super.locationMatches(process2, location2, frameProxy)) {
            return false;
        }
        int n = this.visitedLocations;
        this.visitedLocations = n + 1;
        ObjectReference objectReference = this.getLambdaReference(frameProxy);
        if (objectReference == null) {
            return false;
        }
        ObjectReference lambdaReference = objectReference;
        Method method = this.getLambdaMethod(lambdaReference.referenceType());
        if (method == null) {
            return false;
        }
        Method lambdaMethod = method;
        Location locationInLambda = (Location)CollectionsKt.firstOrNull(SafeUtilKt.safeAllLineLocations(lambdaMethod));
        if (locationInLambda == null) {
            return this.visitedLocations == this.lambdaInfo.getCallerMethodOrdinal();
        }
        return this.lambdaFilter.locationMatches(process2, locationInLambda);
    }

    private final Method getLambdaMethod(ReferenceType $this$getLambdaMethod) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$getLambdaMethod.methods();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!(it.isPublic() && !it.isBridge())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public int onReached(@NotNull SuspendContextImpl context2, @Nullable RequestHint hint) {
        try {
            KotlinLambdaInstanceBreakpoint breakpoint2 = this.createBreakpoint(context2);
            if (breakpoint2 != null) {
                DebugProcessImpl.prepareAndSetSteppingBreakpoint((SuspendContextImpl)context2, (SteppingBreakpoint)((SteppingBreakpoint)breakpoint2), (RequestHint)hint, (boolean)true);
                return -100;
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return 0;
    }

    private final KotlinLambdaInstanceBreakpoint createBreakpoint(SuspendContextImpl context2) {
        Object object = context2.getFrameProxy();
        if (object == null || (object = this.getLambdaReference((StackFrameProxyImpl)object)) == null) {
            return null;
        }
        Object lambdaReference = object;
        SourcePosition sourcePosition = this.lambdaFilter.getBreakpointPosition();
        if (sourcePosition == null) {
            return null;
        }
        SourcePosition position = sourcePosition;
        return new KotlinLambdaInstanceBreakpoint(context2.getDebugProcess().getProject(), position, lambdaReference.uniqueID(), this.lambdaFilter);
    }

    private final ObjectReference getLambdaReference(StackFrameProxyImpl $this$getLambdaReference) {
        Object object = CollectionsKt.getOrNull((List)$this$getLambdaReference.getArgumentValues(), (int)this.lambdaInfo.getParameterIndex());
        return object instanceof ObjectReference ? (ObjectReference)object : null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter$KotlinLambdaInstanceBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/StepIntoBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "pos", "Lcom/intellij/debugger/SourcePosition;", "lambdaId", "", "lambdaFilter", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaMethodFilter;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/debugger/SourcePosition;JLorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaMethodFilter;)V", "evaluateCondition", "", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "event", "Lcom/sun/jdi/event/LocatableEvent;", "kotlin.jvm-debugger.core-fe10"})
    private static final class KotlinLambdaInstanceBreakpoint
    extends StepIntoBreakpoint {
        private final long lambdaId;
        @NotNull
        private final KotlinLambdaMethodFilter lambdaFilter;

        public KotlinLambdaInstanceBreakpoint(@NotNull Project project, @NotNull SourcePosition pos, long lambdaId, @NotNull KotlinLambdaMethodFilter lambdaFilter) {
            super(project, pos, (BreakpointStepMethodFilter)lambdaFilter);
            this.lambdaId = lambdaId;
            this.lambdaFilter = lambdaFilter;
        }

        public boolean evaluateCondition(@NotNull EvaluationContextImpl context2, @NotNull LocatableEvent event) {
            if (!super.evaluateCondition(context2, event)) {
                return false;
            }
            ThreadReferenceProxyImpl threadReferenceProxyImpl = context2.getSuspendContext().getThread();
            if (threadReferenceProxyImpl == null) {
                return false;
            }
            ThreadReferenceProxyImpl thread = threadReferenceProxyImpl;
            Object object = SafeUtilKt.safeMethod(event.location());
            if (object == null || (object = object.name()) == null) {
                return false;
            }
            Object methodName2 = object;
            if (!this.lambdaFilter.isTargetLambdaName((String)methodName2)) {
                return false;
            }
            int frameIndex = DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName((String)methodName2) ? 1 : 0;
            ObjectReference lambdaReference = SafeUtilKt.safeThisObject(thread.frame(frameIndex));
            return lambdaReference != null && lambdaReference.uniqueID() == this.lambdaId;
        }
    }
}

