/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.trace.impl.interpret;

import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.sequence.trace.impl.interpret.InterpreterUtil;
import org.jetbrains.kotlin.idea.debugger.sequence.trace.impl.interpret.ValuesOrder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J0\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\u0013\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/trace/impl/interpret/FilterTraceInterpreter;", "Lcom/intellij/debugger/streams/trace/CallTraceInterpreter;", "predicateValueToAccept", "", "(Z)V", "extractPredicateValues", "", "", "filteringMap", "Lcom/sun/jdi/Value;", "resolve", "Lcom/intellij/debugger/streams/trace/TraceInfo;", "call", "Lcom/intellij/debugger/streams/wrapper/StreamCall;", "value", "resolveValuesAfter", "Lcom/intellij/debugger/streams/trace/TraceElement;", "before", "resolveValuesBefore", "map", "kotlin.jvm-debugger.sequence"})
public final class FilterTraceInterpreter
implements CallTraceInterpreter {
    private final boolean predicateValueToAccept;

    public FilterTraceInterpreter(boolean predicateValueToAccept) {
        this.predicateValueToAccept = predicateValueToAccept;
    }

    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call, @NotNull Value value2) {
        if (!(value2 instanceof ArrayReference)) {
            throw new UnexpectedValueTypeException("array reference excepted, but actual: " + value2.type().name());
        }
        Map<Integer, TraceElement> before2 = this.resolveValuesBefore(((ArrayReference)value2).getValue(0));
        Value filteringMap = ((ArrayReference)value2).getValue(1);
        Map<Integer, TraceElement> after = this.resolveValuesAfter(before2, filteringMap);
        return new ValuesOrder(call, before2, after);
    }

    private final Map<Integer, TraceElement> resolveValuesBefore(Value map2) {
        InterpreterUtil.MapRepresentation mapRepresentation = InterpreterUtil.INSTANCE.extractMap(map2);
        ArrayReference keys = mapRepresentation.component1();
        ArrayReference objects = mapRepresentation.component2();
        List result2 = new ArrayList();
        int n = keys.length();
        for (int i2 = 0; i2 < n; ++i2) {
            Value time = keys.getValue(i2);
            Value value2 = objects.getValue(i2);
            if (!(time instanceof IntegerValue)) {
                throw new UnexpectedValueTypeException("time should be represented by integer value");
            }
            result2.add(new TraceElementImpl(((IntegerValue)time).value(), value2));
        }
        return InterpreterUtil.INSTANCE.createIndexByTime(result2);
    }

    private final Map<Integer, TraceElement> resolveValuesAfter(Map<Integer, ? extends TraceElement> before2, Value filteringMap) {
        Map<Integer, Boolean> predicateValues = this.extractPredicateValues(filteringMap);
        LinkedHashMap result2 = new LinkedHashMap();
        for (Map.Entry<Integer, ? extends TraceElement> entry : before2.entrySet()) {
            int beforeTime = ((Number)entry.getKey()).intValue();
            TraceElement element3 = entry.getValue();
            Boolean predicateValue = predicateValues.get(beforeTime);
            if (!Intrinsics.areEqual((Object)predicateValue, (Object)this.predicateValueToAccept)) continue;
            ((Map)result2).put(beforeTime + 1, new TraceElementImpl(beforeTime + 1, element3.getValue()));
        }
        return result2;
    }

    private final Map<Integer, Boolean> extractPredicateValues(Value filteringMap) {
        InterpreterUtil.MapRepresentation mapRepresentation = InterpreterUtil.INSTANCE.extractMap(filteringMap);
        ArrayReference keys = mapRepresentation.component1();
        ArrayReference values2 = mapRepresentation.component2();
        Map result2 = new LinkedHashMap();
        int n = keys.length();
        for (int i2 = 0; i2 < n; ++i2) {
            Value time = keys.getValue(i2);
            Value value2 = values2.getValue(i2);
            if (!(time instanceof IntegerValue)) {
                throw new UnexpectedValueTypeException("time should be represented by integer value");
            }
            if (!(value2 instanceof BooleanValue)) {
                throw new UnexpectedValueTypeException("predicate value should be represented by boolean value");
            }
            result2.put(((IntegerValue)time).value(), ((BooleanValue)value2).value());
        }
        return result2;
    }
}

