/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.Location;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.DebuggerFieldPropertyDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationError;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationStatus;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameterAnalyzer;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameterInfo;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelPropertyDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.OnceUsedChecker;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitorKt;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001b\u001a\u00020\u001cJ\"\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0019J\u0018\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020$2\u0006\u0010 \u001a\u00020%H\u0002J\u0012\u0010,\u001a\u00020$2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020*H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u00192\u0006\u0010.\u001a\u00020\u0018H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00192\u0006\u0010.\u001a\u00020\u0018H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u000204H\u0002J$\u00105\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020*2\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010(H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020*H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010\u00192\u0006\u0010;\u001a\u00020<H\u0002J\u001a\u0010=\u001a\u0004\u0018\u00010\u00192\u0006\u0010.\u001a\u00020\u00182\u0006\u0010 \u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020@H\u0002J\u0015\u0010A\u001a\u00020$*\u00020%2\u0006\u0010B\u001a\u00020%H\u0082\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterAnalyzer;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "evaluationStatus", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;)V", "containingPrimaryConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "getContainingPrimaryConstructor", "()Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "containingPrimaryConstructor$delegate", "Lkotlin/Lazy;", "crossingBounds", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Dumb;", "onceUsedChecker", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/OnceUsedChecker;", "parameters", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Smart;", "Lkotlin/collections/LinkedHashMap;", "analyze", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterInfo;", "checkBounds", "", "descriptor", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "parameter", "doesCrossInlineBounds", "", "Lcom/intellij/psi/PsiElement;", "declaration", "getLabel", "", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isAssignmentLValue", "isCodeFragmentDeclaration", "isContainingPrimaryConstructorParameter", "target", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isFakeFunctionForJavaContext", "processCoroutineContextCall", "processDebugLabel", "processDispatchReceiver", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "processExtensionReceiver", "receiverType", "Lorg/jetbrains/kotlin/types/KotlinType;", "label", "processFakeJavaCodeReceiver", "processReceiver", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "processSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "processSyntheticFieldVariable", "Lorg/jetbrains/kotlin/descriptors/impl/SyntheticFieldDescriptor;", "isInside", "parent", "kotlin.jvm-debugger.evaluation"})
public final class CodeFragmentParameterAnalyzer {
    @NotNull
    private final ExecutionContext context;
    @NotNull
    private final KtCodeFragment codeFragment;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final EvaluationStatus evaluationStatus;
    @NotNull
    private final LinkedHashMap<DeclarationDescriptor, CodeFragmentParameter.Smart> parameters;
    @NotNull
    private final Set<CodeFragmentParameter.Dumb> crossingBounds;
    @NotNull
    private final OnceUsedChecker onceUsedChecker;
    @NotNull
    private final Lazy containingPrimaryConstructor$delegate;

    public CodeFragmentParameterAnalyzer(@NotNull ExecutionContext context2, @NotNull KtCodeFragment codeFragment, @NotNull BindingContext bindingContext2, @NotNull EvaluationStatus evaluationStatus) {
        this.context = context2;
        this.codeFragment = codeFragment;
        this.bindingContext = bindingContext2;
        this.evaluationStatus = evaluationStatus;
        this.parameters = new LinkedHashMap();
        this.crossingBounds = new LinkedHashSet();
        this.onceUsedChecker = new OnceUsedChecker(CodeFragmentParameterAnalyzer.class);
        this.containingPrimaryConstructor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ConstructorDescriptor>(this){
            final /* synthetic */ CodeFragmentParameterAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ConstructorDescriptor invoke() {
                PsiElement psiElement2;
                block7: {
                    block6: {
                        void $this$getParentOfType$iv;
                        Comparable<Location> comparable;
                        block5: {
                            block4: {
                                Comparable<Location> comparable2 = SafeUtilKt.safeLocation((StackFrameProxy)CodeFragmentParameterAnalyzer.access$getContext$p(this.this$0).getFrameProxy());
                                if (comparable2 == null || (comparable2 = SafeUtilKt.safeMethod((Location)comparable2)) == null) break block4;
                                Comparable<Location> it = comparable = comparable2;
                                boolean bl = false;
                                comparable2 = it.isConstructor() ? comparable : null;
                                if (comparable2 != null) break block5;
                            }
                            return null;
                        }
                        psiElement2 = CodeFragmentParameterAnalyzer.access$getCodeFragment$p(this.this$0).getContext();
                        if (psiElement2 == null) break block6;
                        comparable = psiElement2;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfType = false;
                        psiElement2 = (KtPrimaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtPrimaryConstructor.class, (boolean)strict$iv);
                        if (psiElement2 != null) break block7;
                    }
                    return null;
                }
                PsiElement constructor2 = psiElement2;
                return (ConstructorDescriptor)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.CONSTRUCTOR, (Object)constructor2);
            }
        }));
    }

    private final ConstructorDescriptor getContainingPrimaryConstructor() {
        Lazy lazy = this.containingPrimaryConstructor$delegate;
        return (ConstructorDescriptor)lazy.getValue();
    }

    @NotNull
    public final CodeFragmentParameterInfo analyze() {
        this.onceUsedChecker.trigger();
        this.codeFragment.accept((KtVisitor)new KtTreeVisitor<Unit>(this){
            final /* synthetic */ CodeFragmentParameterAnalyzer this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public Void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @Nullable Unit data2) {
                ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression2), (BindingContext)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0));
                if (resolvedCall2 == null) {
                    return null;
                }
                ResolvedCall resolvedCall3 = resolvedCall2;
                this.processResolvedCall(resolvedCall3, expression2);
                return null;
            }

            private final void processResolvedCall(ResolvedCall<?> resolvedCall2, KtSimpleNameExpression expression2) {
                CodeFragmentParameter.Smart parameter2;
                ReceiverValue dispatchReceiver;
                ReceiverParameterDescriptor extensionParameter;
                CallableDescriptor descriptor2;
                if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                    this.processResolvedCall(((VariableAsFunctionResolvedCall)resolvedCall2).getFunctionCall(), expression2);
                    this.processResolvedCall(((VariableAsFunctionResolvedCall)resolvedCall2).getVariableCall(), expression2);
                    return;
                }
                analyze.1 var3_3 = this;
                CodeFragmentParameterAnalyzer codeFragmentParameterAnalyzer = this.this$0;
                analyze.1 $this$processResolvedCall_u24lambda_u240 = var3_3;
                boolean bl = false;
                CallableDescriptor callableDescriptor = descriptor2 = resolvedCall2.getResultingDescriptor();
                DeclarationDescriptor declarationDescriptor = callableDescriptor != null ? callableDescriptor.getContainingDeclaration() : null;
                ClassDescriptor containingClass = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
                CallableDescriptor callableDescriptor2 = descriptor2;
                Object object = extensionParameter = callableDescriptor2 != null ? callableDescriptor2.getExtensionReceiverParameter() : null;
                if (descriptor2 != null && !(descriptor2 instanceof DebuggerFieldPropertyDescriptor) && extensionParameter != null && containingClass != null && containingClass.getKind() != ClassKind.OBJECT) {
                    CodeFragmentParameter.Smart parameter3 = CodeFragmentParameterAnalyzer.access$processDispatchReceiver(codeFragmentParameterAnalyzer, containingClass);
                    codeFragmentParameterAnalyzer.checkBounds((DeclarationDescriptor)descriptor2, (KtExpression)expression2, parameter3);
                }
                boolean $i$f$runReadAction = false;
                if (((Boolean)ApplicationManager.getApplication().runReadAction(new Computable(expression2){
                    final /* synthetic */ KtSimpleNameExpression $expression$inlined;
                    {
                        this.$expression$inlined = ktSimpleNameExpression;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)Boolean.valueOf(KtPsiUtilKt.isDotSelector((KtExpression)((KtExpression)this.$expression$inlined)));
                    }
                })).booleanValue()) {
                    CallableDescriptor descriptor3 = resolvedCall2.getResultingDescriptor();
                    CodeFragmentParameter.Smart parameter4 = CodeFragmentParameterAnalyzer.access$processCoroutineContextCall(this.this$0, (DeclarationDescriptor)resolvedCall2.getResultingDescriptor());
                    if (parameter4 != null) {
                        this.this$0.checkBounds((DeclarationDescriptor)descriptor3, (KtExpression)expression2, parameter4);
                    }
                    return;
                }
                if (CodeFragmentParameterAnalyzer.access$isCodeFragmentDeclaration(this.this$0, (DeclarationDescriptor)resolvedCall2.getResultingDescriptor())) {
                    return;
                }
                boolean processed = false;
                ReceiverValue extensionReceiver = resolvedCall2.getExtensionReceiver();
                if (extensionReceiver instanceof ImplicitReceiver) {
                    DeclarationDescriptor descriptor4 = ((ImplicitReceiver)extensionReceiver).getDeclarationDescriptor();
                    CodeFragmentParameter.Smart parameter5 = CodeFragmentParameterAnalyzer.access$processReceiver(this.this$0, (ImplicitReceiver)extensionReceiver);
                    this.this$0.checkBounds(descriptor4, (KtExpression)expression2, parameter5);
                    processed = true;
                }
                if ((dispatchReceiver = resolvedCall2.getDispatchReceiver()) instanceof ImplicitReceiver) {
                    DeclarationDescriptor descriptor5 = ((ImplicitReceiver)dispatchReceiver).getDeclarationDescriptor();
                    parameter2 = CodeFragmentParameterAnalyzer.access$processReceiver(this.this$0, (ImplicitReceiver)dispatchReceiver);
                    if (parameter2 != null) {
                        this.this$0.checkBounds(descriptor5, (KtExpression)expression2, parameter2);
                        processed = true;
                    }
                }
                if (!processed && resolvedCall2.getResultingDescriptor() instanceof SyntheticFieldDescriptor) {
                    CallableDescriptor callableDescriptor3 = resolvedCall2.getResultingDescriptor();
                    Intrinsics.checkNotNull((Object)callableDescriptor3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor");
                    SyntheticFieldDescriptor descriptor6 = (SyntheticFieldDescriptor)callableDescriptor3;
                    parameter2 = CodeFragmentParameterAnalyzer.access$processSyntheticFieldVariable(this.this$0, descriptor6);
                    this.this$0.checkBounds((DeclarationDescriptor)descriptor6, (KtExpression)expression2, parameter2);
                    processed = true;
                }
                if (!processed) {
                    CallableDescriptor descriptor7 = resolvedCall2.getResultingDescriptor();
                    parameter2 = this.processDescriptor((DeclarationDescriptor)descriptor7, expression2);
                    this.this$0.checkBounds((DeclarationDescriptor)descriptor7, (KtExpression)expression2, parameter2);
                }
            }

            private final CodeFragmentParameter.Smart processDescriptor(DeclarationDescriptor descriptor2, KtSimpleNameExpression expression2) {
                CodeFragmentParameter.Smart smart = CodeFragmentParameterAnalyzer.access$processDebugLabel(this.this$0, descriptor2);
                if (smart == null && (smart = CodeFragmentParameterAnalyzer.access$processCoroutineContextCall(this.this$0, descriptor2)) == null) {
                    smart = CodeFragmentParameterAnalyzer.access$processSimpleNameExpression(this.this$0, descriptor2, expression2);
                }
                return smart;
            }

            @Nullable
            public Void visitThisExpression(@NotNull KtThisExpression expression2, @Nullable Unit data2) {
                CodeFragmentParameter.Smart parameter2;
                boolean $i$f$runReadAction = false;
                KtReferenceExpression instanceReference = (KtReferenceExpression)ApplicationManager.getApplication().runReadAction(new Computable(expression2){
                    final /* synthetic */ KtThisExpression $expression$inlined;
                    {
                        this.$expression$inlined = ktThisExpression;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)this.$expression$inlined.getInstanceReference();
                    }
                });
                DeclarationDescriptor target2 = (DeclarationDescriptor)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)instanceReference);
                if (CodeFragmentParameterAnalyzer.access$isCodeFragmentDeclaration(this.this$0, target2)) {
                    return null;
                }
                DeclarationDescriptor declarationDescriptor = target2;
                if (declarationDescriptor instanceof ClassDescriptor) {
                    v0 = CodeFragmentParameterAnalyzer.access$processDispatchReceiver(this.this$0, (ClassDescriptor)target2);
                } else if (declarationDescriptor instanceof CallableDescriptor) {
                    KotlinType type2;
                    KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)expression2);
                    KotlinType kotlinType = type2 = kotlinTypeInfo != null ? kotlinTypeInfo.getType() : null;
                    if (kotlinType != null) {
                        KotlinType kotlinType2 = kotlinType;
                        CodeFragmentParameterAnalyzer codeFragmentParameterAnalyzer = this.this$0;
                        KotlinType it = kotlinType2;
                        boolean bl = false;
                        v0 = CodeFragmentParameterAnalyzer.access$processExtensionReceiver(codeFragmentParameterAnalyzer, (CallableDescriptor)target2, type2, expression2.getLabelName());
                    } else {
                        v0 = null;
                    }
                } else {
                    v0 = parameter2 = null;
                }
                if (parameter2 != null) {
                    this.this$0.checkBounds(target2, (KtExpression)expression2, parameter2);
                }
                return null;
            }

            @Nullable
            public Void visitSuperExpression(@NotNull KtSuperExpression expression2, @Nullable Unit data2) {
                block2: {
                    KotlinType kotlinType = (KotlinType)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, (Object)expression2);
                    if (kotlinType == null) {
                        return null;
                    }
                    KotlinType type2 = kotlinType;
                    ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                    ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                    if (classDescriptor == null) {
                        return null;
                    }
                    ClassDescriptor descriptor2 = classDescriptor;
                    Map $this$getOrPut$iv = CodeFragmentParameterAnalyzer.access$getParameters$p(this.this$0);
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(descriptor2);
                    if (value$iv != null) break block2;
                    boolean bl = false;
                    String name2 = descriptor2.getName().asString();
                    CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DISPATCH_RECEIVER, "", "super@" + name2), type2, (DeclarationDescriptor)descriptor2, false, 8, null);
                    $this$getOrPut$iv.put(descriptor2, answer$iv);
                }
                return null;
            }

            @Nullable
            public Void visitCallExpression(@NotNull KtCallExpression expression2, @Nullable Unit data2) {
                CallableDescriptor descriptor2;
                ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression2), (BindingContext)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0));
                if (resolvedCall2 != null && (descriptor2 = resolvedCall2.getResultingDescriptor()) instanceof ConstructorDescriptor && KotlinBuiltIns.isNothing((KotlinType)((ConstructorDescriptor)descriptor2).getReturnType())) {
                    throw EvaluateExceptionUtil.createEvaluateException((String)KotlinDebuggerEvaluationBundle.message("error.nothing.initialization", new Object[0]));
                }
                return (Void)super.visitCallExpression(expression2, (Object)data2);
            }
        }, (Object)Unit.INSTANCE);
        return new CodeFragmentParameterInfo(CollectionsKt.toList((Iterable)this.parameters.values()), this.crossingBounds);
    }

    private final CodeFragmentParameter.Smart processReceiver(ImplicitReceiver receiver2) {
        if (this.isCodeFragmentDeclaration(receiver2.getDeclarationDescriptor())) {
            return null;
        }
        ImplicitReceiver implicitReceiver = receiver2;
        return implicitReceiver instanceof ImplicitClassReceiver ? this.processDispatchReceiver(((ImplicitClassReceiver)receiver2).getClassDescriptor()) : (implicitReceiver instanceof ExtensionReceiver ? this.processExtensionReceiver(((ExtensionReceiver)receiver2).getDeclarationDescriptor(), ((ExtensionReceiver)receiver2).getType(), null) : null);
    }

    private final CodeFragmentParameter.Smart processDispatchReceiver(ClassDescriptor descriptor2) {
        Object object;
        if (descriptor2.getKind() == ClassKind.OBJECT || this.getContainingPrimaryConstructor() != null) {
            return null;
        }
        SimpleType type2 = descriptor2.getDefaultType();
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            Name name2 = descriptor2.getName();
            String debugLabel = name2.isSpecial() ? "" : "@" + name2.asString();
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DISPATCH_RECEIVER, "", "this" + debugLabel), (KotlinType)type2, (DeclarationDescriptor)descriptor2, false, 8, null);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final CodeFragmentParameter.Smart processExtensionReceiver(CallableDescriptor descriptor2, KotlinType receiverType2, String label2) {
        Object object;
        if (this.isFakeFunctionForJavaContext(descriptor2)) {
            return this.processFakeJavaCodeReceiver(descriptor2);
        }
        String string2 = label2;
        if (string2 == null && (string2 = this.getLabel(descriptor2)) == null) {
            return null;
        }
        String actualLabel = string2;
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.EXTENSION_RECEIVER, actualLabel, "this@" + actualLabel), receiverType2, (DeclarationDescriptor)receiverParameter, false, 8, null);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final String getLabel(CallableDescriptor callableDescriptor) {
        Name name2;
        String string2;
        PsiElement source = PsiSourceElementKt.getPsi((SourceElement)callableDescriptor.getSource());
        if (source instanceof KtFunctionLiteral && (string2 = CodegenUtilKt.getCallLabelForLambdaArgument((KtFunctionLiteral)((KtFunctionLiteral)source), (BindingContext)this.bindingContext)) != null) {
            String it = string2;
            boolean bl = false;
            return it;
        }
        Name it = name2 = callableDescriptor.getName();
        boolean bl = false;
        Object object = !it.isSpecial() ? name2 : null;
        return object != null ? object.asString() : null;
    }

    private final boolean isFakeFunctionForJavaContext(CallableDescriptor descriptor2) {
        return descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getName().asString(), (Object)"_java_locals_debug_fun_") && this.codeFragment.getCopyableUserData(KtCodeFragment.Companion.getFAKE_CONTEXT_FOR_JAVA_FILE()) != null;
    }

    private final CodeFragmentParameter.Smart processFakeJavaCodeReceiver(CallableDescriptor descriptor2) {
        Object object;
        CallableDescriptor callableDescriptor;
        CallableDescriptor callableDescriptor2;
        CallableDescriptor it = callableDescriptor2 = descriptor2;
        boolean bl = false;
        Object object2 = callableDescriptor = descriptor2 instanceof FunctionDescriptor ? callableDescriptor2 : null;
        if (callableDescriptor == null || (callableDescriptor2 = callableDescriptor.getExtensionReceiverParameter()) == null) {
            return null;
        }
        CallableDescriptor receiverParameter = callableDescriptor2;
        String label2 = "_java_locals_debug_fun_";
        KotlinType type2 = receiverParameter.getType();
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl2 = false;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FAKE_JAVA_OUTER_CLASS, label2, "this"), type2, (DeclarationDescriptor)receiverParameter, false, 8, null);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final CodeFragmentParameter.Smart processSyntheticFieldVariable(SyntheticFieldDescriptor descriptor2) {
        Object object;
        PropertyDescriptor propertyDescriptor = descriptor2.getPropertyDescriptor();
        String fieldName = propertyDescriptor.getName().asString();
        KotlinType type2 = propertyDescriptor.getType();
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FIELD_VAR, fieldName, "field"), type2, (DeclarationDescriptor)descriptor2, false, 8, null);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final CodeFragmentParameter.Smart processSimpleNameExpression(DeclarationDescriptor target2, KtSimpleNameExpression expression2) {
        CodeFragmentParameter.Smart smart;
        boolean isPrimaryConstructorParameter;
        if (target2 instanceof ValueParameterDescriptor && ((ValueParameterDescriptor)target2).isCrossinline()) {
            this.evaluationStatus.error(EvaluationError.CrossInlineLambda);
            throw EvaluateExceptionUtil.createEvaluateException((String)KotlinDebuggerEvaluationBundle.message("error.crossinline.lambda.evaluation", new Object[0]));
        }
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = target2 instanceof DeclarationDescriptorWithVisibility ? (DeclarationDescriptorWithVisibility)target2 : null;
        boolean isLocalTarget = Intrinsics.areEqual((Object)(declarationDescriptorWithVisibility != null ? declarationDescriptorWithVisibility.getVisibility() : null), (Object)DescriptorVisibilities.LOCAL);
        boolean bl = isPrimaryConstructorParameter = !isLocalTarget && target2 instanceof PropertyDescriptor && this.isContainingPrimaryConstructorParameter((PropertyDescriptor)target2);
        if (!isLocalTarget && !isPrimaryConstructorParameter) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = target2;
        if (declarationDescriptor instanceof SimpleFunctionDescriptor) {
            Object object;
            KotlinType kotlinType = FunctionsTypingVisitorKt.createFunctionType$default((SimpleFunctionDescriptor)((SimpleFunctionDescriptor)target2), (KotlinBuiltIns)DescriptorUtilsKt.getBuiltIns((DeclarationDescriptor)target2), (boolean)((SimpleFunctionDescriptor)target2).isSuspend(), (boolean)false, (int)4, null);
            if (kotlinType == null) {
                return null;
            }
            KotlinType type2 = kotlinType;
            Map $this$getOrPut$iv = this.parameters;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(target2);
            if (value$iv == null) {
                boolean bl2 = false;
                CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.LOCAL_FUNCTION, ((SimpleFunctionDescriptor)target2).getName().asString(), null, 4, null), type2, (DeclarationDescriptor)((SimpleFunctionDescriptor)target2).getOriginal(), false, 8, null);
                $this$getOrPut$iv.put(target2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            smart = (CodeFragmentParameter.Smart)object;
        } else if (declarationDescriptor instanceof ValueDescriptor) {
            Object object;
            boolean bl3;
            KtExpression unwrappedExpression;
            KtExpression ktExpression = unwrappedExpression = KtPsiUtil.deparenthesize((KtExpression)((KtExpression)expression2));
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl4 = false;
                bl3 = this.isAssignmentLValue((PsiElement)it);
            } else {
                bl3 = false;
            }
            boolean isLValue = bl3;
            Map $this$getOrPut$iv = this.parameters;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(target2);
            if (value$iv == null) {
                boolean bl5 = false;
                CodeFragmentParameter.Kind kind2 = target2 instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)target2).isDelegated() ? CodeFragmentParameter.Kind.DELEGATED : CodeFragmentParameter.Kind.ORDINARY;
                CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(kind2, ((ValueDescriptor)target2).getName().asString(), null, 4, null), ((ValueDescriptor)target2).getType(), target2, isLValue);
                $this$getOrPut$iv.put(target2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            smart = (CodeFragmentParameter.Smart)object;
        } else {
            smart = null;
        }
        return smart;
    }

    private final boolean isAssignmentLValue(PsiElement expression2) {
        Object object;
        block3: {
            block2: {
                KtBinaryExpression ktBinaryExpression;
                PsiElement psiElement2 = expression2.getParent();
                object = psiElement2 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement2 : null;
                if (object == null) break block2;
                KtBinaryExpression it = ktBinaryExpression = object;
                boolean bl = false;
                object = KtPsiUtil.isAssignment((PsiElement)((PsiElement)it)) ? ktBinaryExpression : null;
                if (object != null) break block3;
            }
            return false;
        }
        KtBinaryExpression assignmentExpression = object;
        return Intrinsics.areEqual((Object)assignmentExpression.getLeft(), (Object)expression2);
    }

    private final boolean isContainingPrimaryConstructorParameter(PropertyDescriptor target2) {
        ConstructorDescriptor constructorDescriptor = this.getContainingPrimaryConstructor();
        if (constructorDescriptor == null) {
            return false;
        }
        ConstructorDescriptor primaryConstructor = constructorDescriptor;
        for (ValueParameterDescriptor parameter2 : primaryConstructor.getValueParameters()) {
            PropertyDescriptor property2 = (PropertyDescriptor)this.bindingContext.get((ReadOnlySlice)BindingContext.VALUE_PARAMETER_AS_PROPERTY, (Object)parameter2);
            if (!Intrinsics.areEqual((Object)target2, (Object)property2)) continue;
            return true;
        }
        return false;
    }

    private final CodeFragmentParameter.Smart processCoroutineContextCall(DeclarationDescriptor target2) {
        if (target2 instanceof PropertyDescriptor && Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)target2), (Object)CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_FQ_NAME())) {
            Object object;
            Map $this$getOrPut$iv = this.parameters;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(target2);
            if (value$iv == null) {
                boolean bl = false;
                CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.COROUTINE_CONTEXT, "", null, 4, null), ((PropertyDescriptor)target2).getType(), target2, false, 8, null);
                $this$getOrPut$iv.put(target2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (CodeFragmentParameter.Smart)object;
        }
        return null;
    }

    private final CodeFragmentParameter.Smart processDebugLabel(DeclarationDescriptor target2) {
        Object object;
        DebugLabelPropertyDescriptor debugLabelPropertyDescriptor = target2 instanceof DebugLabelPropertyDescriptor ? (DebugLabelPropertyDescriptor)target2 : null;
        if (debugLabelPropertyDescriptor == null) {
            return null;
        }
        DebugLabelPropertyDescriptor debugLabelPropertyDescriptor2 = debugLabelPropertyDescriptor;
        String labelName2 = debugLabelPropertyDescriptor2.getLabelName();
        String debugString = debugLabelPropertyDescriptor2.getName().asString();
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(target2);
        if (value$iv == null) {
            boolean bl = false;
            KotlinType type2 = debugLabelPropertyDescriptor2.getType();
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DEBUG_LABEL, labelName2, debugString), type2, (DeclarationDescriptor)debugLabelPropertyDescriptor2, false, 8, null);
            $this$getOrPut$iv.put(target2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    public final void checkBounds(@Nullable DeclarationDescriptor descriptor2, @NotNull KtExpression expression2, @Nullable CodeFragmentParameter.Smart parameter2) {
        if (parameter2 == null || !(descriptor2 instanceof DeclarationDescriptorWithSource)) {
            return;
        }
        PsiElement targetPsi = PsiSourceElementKt.getPsi((SourceElement)((DeclarationDescriptorWithSource)descriptor2).getSource());
        if (targetPsi != null && this.doesCrossInlineBounds((PsiElement)expression2, targetPsi)) {
            ((Collection)this.crossingBounds).add(parameter2.getDumb());
        }
    }

    private final boolean doesCrossInlineBounds(PsiElement expression2, PsiElement declaration2) {
        Object object;
        PsiElement declarationParent;
        block7: {
            block6: {
                PsiElement psiElement2;
                PsiElement psiElement3 = declaration2.getParent();
                if (psiElement3 == null) {
                    return false;
                }
                declarationParent = psiElement3;
                object = expression2.getParent();
                if (object == null) break block6;
                PsiElement it = psiElement2 = object;
                boolean bl = false;
                object = this.isInside(it, declarationParent) ? psiElement2 : null;
                if (object != null) break block7;
            }
            return false;
        }
        PsiElement currentParent = object;
        while (currentParent != null && !Intrinsics.areEqual((Object)currentParent, (Object)declarationParent)) {
            SimpleFunctionDescriptor functionDescriptor2;
            if (currentParent instanceof KtFunction && (functionDescriptor2 = (SimpleFunctionDescriptor)this.bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)currentParent)) != null && !functionDescriptor2.isInline()) {
                return true;
            }
            currentParent = currentParent instanceof KtCodeFragment ? ((KtCodeFragment)currentParent).getContext() : currentParent.getParent();
        }
        return false;
    }

    private final boolean isCodeFragmentDeclaration(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ValueParameterDescriptor && this.isCodeFragmentDeclaration((DeclarationDescriptor)((ValueParameterDescriptor)descriptor2).getContainingDeclaration())) {
            return true;
        }
        if (!(descriptor2 instanceof DeclarationDescriptorWithSource)) {
            return false;
        }
        PsiElement psiElement2 = PsiSourceElementKt.getPsi((SourceElement)((DeclarationDescriptorWithSource)descriptor2).getSource());
        return (psiElement2 != null ? psiElement2.getContainingFile() : null) instanceof KtCodeFragment;
    }

    private final boolean isInside(PsiElement $this$isInside, PsiElement parent2) {
        while (!PsiUtilsKt.isAncestor$default((PsiElement)parent2, (PsiElement)$this$isInside, (boolean)false, (int)2, null)) {
            PsiFile psiFile2 = $this$isInside.getContainingFile();
            KtCodeFragment ktCodeFragment = psiFile2 instanceof KtCodeFragment ? (KtCodeFragment)psiFile2 : null;
            if (ktCodeFragment == null || (ktCodeFragment = ktCodeFragment.getContext()) == null) {
                return false;
            }
            KtCodeFragment context2 = ktCodeFragment;
            CodeFragmentParameterAnalyzer codeFragmentParameterAnalyzer = this_;
            psiFile2 = parent2;
            CodeFragmentParameterAnalyzer this_ = codeFragmentParameterAnalyzer;
            $this$isInside = context2;
            parent2 = psiFile2;
        }
        return true;
    }

    public static final /* synthetic */ BindingContext access$getBindingContext$p(CodeFragmentParameterAnalyzer $this) {
        return $this.bindingContext;
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processCoroutineContextCall(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target2) {
        return $this.processCoroutineContextCall(target2);
    }

    public static final /* synthetic */ boolean access$isCodeFragmentDeclaration(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor descriptor2) {
        return $this.isCodeFragmentDeclaration(descriptor2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processReceiver(CodeFragmentParameterAnalyzer $this, ImplicitReceiver receiver2) {
        return $this.processReceiver(receiver2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processSyntheticFieldVariable(CodeFragmentParameterAnalyzer $this, SyntheticFieldDescriptor descriptor2) {
        return $this.processSyntheticFieldVariable(descriptor2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processDebugLabel(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target2) {
        return $this.processDebugLabel(target2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processSimpleNameExpression(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target2, KtSimpleNameExpression expression2) {
        return $this.processSimpleNameExpression(target2, expression2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processDispatchReceiver(CodeFragmentParameterAnalyzer $this, ClassDescriptor descriptor2) {
        return $this.processDispatchReceiver(descriptor2);
    }

    public static final /* synthetic */ LinkedHashMap access$getParameters$p(CodeFragmentParameterAnalyzer $this) {
        return $this.parameters;
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processExtensionReceiver(CodeFragmentParameterAnalyzer $this, CallableDescriptor descriptor2, KotlinType receiverType2, String label2) {
        return $this.processExtensionReceiver(descriptor2, receiverType2, label2);
    }

    public static final /* synthetic */ ExecutionContext access$getContext$p(CodeFragmentParameterAnalyzer $this) {
        return $this.context;
    }

    public static final /* synthetic */ KtCodeFragment access$getCodeFragment$p(CodeFragmentParameterAnalyzer $this) {
        return $this.codeFragment;
    }
}

