/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.classLoading;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.AndroidOClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoadKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.OrdinaryClassLoadingAdapter;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\bf\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH&J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter;", "", "isApplicable", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "info", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter$Companion$ClassInfoForEvaluator;", "loadClasses", "Lcom/sun/jdi/ClassLoaderReference;", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "mirrorOfByteArray", "Lcom/sun/jdi/ArrayReference;", "bytes", "", "Companion", "kotlin.jvm-debugger.evaluation"})
public interface ClassLoadingAdapter {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoadingAdapter$Companion.$$INSTANCE;

    public boolean isApplicable(@NotNull ExecutionContext var1, @NotNull Companion.ClassInfoForEvaluator var2);

    @NotNull
    public ClassLoaderReference loadClasses(@NotNull ExecutionContext var1, @NotNull Collection<ClassToLoad> var2);

    @NotNull
    default public ArrayReference mirrorOfByteArray(@NotNull byte[] bytes2, @NotNull ExecutionContext context2) {
        int chunkSize;
        ClassLoaderReference classLoader2 = context2.getClassLoader();
        ReferenceType referenceType = context2.findClass("byte[]", classLoader2);
        Intrinsics.checkNotNull((Object)referenceType, (String)"null cannot be cast to non-null type com.sun.jdi.ArrayType");
        ArrayType arrayClass = (ArrayType)referenceType;
        ArrayReference reference2 = context2.newInstance(arrayClass, bytes2.length);
        context2.keepReference(reference2);
        ArrayList mirrors = new ArrayList(bytes2.length);
        for (byte by : bytes2) {
            ((Collection)mirrors).add(context2.getVm().mirrorOf(by));
        }
        for (int loaded = 0; loaded < mirrors.size(); loaded += chunkSize) {
            chunkSize = Math.min(4096, mirrors.size() - loaded);
            reference2.setValues(loaded, mirrors, loaded, chunkSize);
        }
        return reference2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter$Companion;", "", "()V", "ADAPTERS", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter;", "CHUNK_SIZE", "", "analyzeClass", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter$Companion$ClassInfoForEvaluator;", "classToLoad", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "info", "loadClasses", "Lcom/sun/jdi/ClassLoaderReference;", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "classes", "", "ClassInfoForEvaluator", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final int CHUNK_SIZE = 4096;
        @NotNull
        private static final List<ClassLoadingAdapter> ADAPTERS;

        private Companion() {
        }

        @Nullable
        public final ClassLoaderReference loadClasses(@NotNull ExecutionContext context2, @NotNull Collection<ClassToLoad> classes2) {
            Object v0;
            block4: {
                Iterable $this$firstOrNull$iv = classes2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ClassToLoad it = (ClassToLoad)element$iv;
                    boolean bl = false;
                    if (!it.isMainClass()) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            ClassToLoad classToLoad = v0;
            if (classToLoad == null) {
                return null;
            }
            ClassToLoad mainClass = classToLoad;
            ClassInfoForEvaluator info2 = new ClassInfoForEvaluator(false, false, classes2.size() > 1, 3, null);
            if (!info2.getContainsAdditionalClasses()) {
                info2 = this.analyzeClass(mainClass, info2);
            }
            for (ClassLoadingAdapter adapter : ADAPTERS) {
                if (!adapter.isApplicable(context2, info2)) continue;
                return adapter.loadClasses(context2, classes2);
            }
            return null;
        }

        private final ClassInfoForEvaluator analyzeClass(ClassToLoad classToLoad, ClassInfoForEvaluator info2) {
            ClassNode classNode = new ClassNode();
            ClassNode $this$analyzeClass_u24lambda_u241 = classNode;
            boolean bl = false;
            new ClassReader(classToLoad.getBytes()).accept((ClassVisitor)$this$analyzeClass_u24lambda_u241, 0);
            ClassNode classNode2 = classNode;
            for (MethodNode method : classNode2.methods) {
                if ((method.access & 0x20) == 0) continue;
                return ClassInfoForEvaluator.copy$default(info2, false, true, false, 5, null);
            }
            Iterable $this$single$iv = classNode2.methods;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                MethodNode it = (MethodNode)element$iv;
                boolean bl2 = false;
                if (!ClassToLoadKt.isEvaluationEntryPoint(it)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            MethodNode methodToRun = single$iv;
            HashSet<Label> visitedLabels = new HashSet<Label>();
            InsnList insnList = methodToRun.instructions;
            if (insnList == null || (insnList = insnList.getFirst()) == null) {
                return info2;
            }
            InsnList firstInsn = insnList;
            return org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoadingAdapter$Companion.analyzeClass$analyzeInsn(visitedLabels, classToLoad, (AbstractInsnNode)firstInsn, info2);
        }

        private static final ClassInfoForEvaluator analyzeClass$analyzeInsn(HashSet<Label> visitedLabels, ClassToLoad $classToLoad, AbstractInsnNode insn, ClassInfoForEvaluator info2) {
            while (true) {
                AbstractInsnNode nextInsn;
                AbstractInsnNode abstractInsnNode;
                if ((abstractInsnNode = insn) instanceof LabelNode) {
                    ((Collection)visitedLabels).add(((LabelNode)insn).getLabel());
                } else if (abstractInsnNode instanceof JumpInsnNode) {
                    if (visitedLabels.contains(((JumpInsnNode)insn).label.getLabel())) {
                        return ClassInfoForEvaluator.copy$default(info2, true, false, false, 6, null);
                    }
                } else {
                    if (abstractInsnNode instanceof TableSwitchInsnNode ? true : abstractInsnNode instanceof LookupSwitchInsnNode) {
                        return ClassInfoForEvaluator.copy$default(info2, false, true, false, 5, null);
                    }
                    if (abstractInsnNode instanceof InsnNode ? ((InsnNode)insn).getOpcode() == 194 || ((InsnNode)insn).getOpcode() == 195 : abstractInsnNode instanceof MethodInsnNode && ((MethodInsnNode)insn).getOpcode() == 184 && Intrinsics.areEqual((Object)((MethodInsnNode)insn).owner, (Object)$classToLoad.getClassName())) {
                        return ClassInfoForEvaluator.copy$default(info2, false, true, false, 5, null);
                    }
                }
                if (insn.getNext() == null) {
                    return info2;
                }
                ClassInfoForEvaluator classInfoForEvaluator = info2;
                insn = nextInsn;
                info2 = classInfoForEvaluator;
            }
        }

        static {
            $$INSTANCE = new Companion();
            Object[] objectArray = new ClassLoadingAdapter[]{new AndroidOClassLoadingAdapter(), new OrdinaryClassLoadingAdapter()};
            ADAPTERS = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter$Companion$ClassInfoForEvaluator;", "", "containsLoops", "", "containsCodeUnsupportedInEval4J", "containsAdditionalClasses", "(ZZZ)V", "getContainsAdditionalClasses", "()Z", "getContainsCodeUnsupportedInEval4J", "getContainsLoops", "isCompilingEvaluatorPreferred", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "kotlin.jvm-debugger.evaluation"})
        public static final class ClassInfoForEvaluator {
            private final boolean containsLoops;
            private final boolean containsCodeUnsupportedInEval4J;
            private final boolean containsAdditionalClasses;

            public ClassInfoForEvaluator(boolean containsLoops, boolean containsCodeUnsupportedInEval4J, boolean containsAdditionalClasses) {
                this.containsLoops = containsLoops;
                this.containsCodeUnsupportedInEval4J = containsCodeUnsupportedInEval4J;
                this.containsAdditionalClasses = containsAdditionalClasses;
            }

            public /* synthetic */ ClassInfoForEvaluator(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    bl2 = false;
                }
                if ((n & 4) != 0) {
                    bl3 = false;
                }
                this(bl, bl2, bl3);
            }

            public final boolean getContainsLoops() {
                return this.containsLoops;
            }

            public final boolean getContainsCodeUnsupportedInEval4J() {
                return this.containsCodeUnsupportedInEval4J;
            }

            public final boolean getContainsAdditionalClasses() {
                return this.containsAdditionalClasses;
            }

            public final boolean isCompilingEvaluatorPreferred() {
                return this.containsLoops || this.containsCodeUnsupportedInEval4J || this.containsAdditionalClasses;
            }

            public final boolean component1() {
                return this.containsLoops;
            }

            public final boolean component2() {
                return this.containsCodeUnsupportedInEval4J;
            }

            public final boolean component3() {
                return this.containsAdditionalClasses;
            }

            @NotNull
            public final ClassInfoForEvaluator copy(boolean containsLoops, boolean containsCodeUnsupportedInEval4J, boolean containsAdditionalClasses) {
                return new ClassInfoForEvaluator(containsLoops, containsCodeUnsupportedInEval4J, containsAdditionalClasses);
            }

            public static /* synthetic */ ClassInfoForEvaluator copy$default(ClassInfoForEvaluator classInfoForEvaluator, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = classInfoForEvaluator.containsLoops;
                }
                if ((n & 2) != 0) {
                    bl2 = classInfoForEvaluator.containsCodeUnsupportedInEval4J;
                }
                if ((n & 4) != 0) {
                    bl3 = classInfoForEvaluator.containsAdditionalClasses;
                }
                return classInfoForEvaluator.copy(bl, bl2, bl3);
            }

            @NotNull
            public String toString() {
                return "ClassInfoForEvaluator(containsLoops=" + this.containsLoops + ", containsCodeUnsupportedInEval4J=" + this.containsCodeUnsupportedInEval4J + ", containsAdditionalClasses=" + this.containsAdditionalClasses + ")";
            }

            public int hashCode() {
                int n;
                int result2;
                int n2 = this.containsLoops ? 1 : 0;
                if (n2 != 0) {
                    n2 = result2 = 1;
                }
                if ((n = this.containsCodeUnsupportedInEval4J) != 0) {
                    n = 1;
                }
                result2 = result2 * 31 + n;
                int n3 = this.containsAdditionalClasses ? 1 : 0;
                if (n3 != 0) {
                    n3 = 1;
                }
                result2 = result2 * 31 + n3;
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ClassInfoForEvaluator)) {
                    return false;
                }
                ClassInfoForEvaluator classInfoForEvaluator = (ClassInfoForEvaluator)other;
                if (this.containsLoops != classInfoForEvaluator.containsLoops) {
                    return false;
                }
                if (this.containsCodeUnsupportedInEval4J != classInfoForEvaluator.containsCodeUnsupportedInEval4J) {
                    return false;
                }
                return this.containsAdditionalClasses == classInfoForEvaluator.containsAdditionalClasses;
            }

            public ClassInfoForEvaluator() {
                this(false, false, false, 7, null);
            }
        }
    }
}

