/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.classLoading;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.AndroidDexer;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0004J$\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0004\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/AbstractAndroidClassLoadingAdapter;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter;", "()V", "dex", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "tryLoadClass", "Lcom/sun/jdi/ReferenceType;", "fqName", "", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "wrapToByteBuffer", "Lcom/sun/jdi/ObjectReference;", "bytes", "Lcom/sun/jdi/ArrayReference;", "kotlin.jvm-debugger.evaluation"})
public abstract class AbstractAndroidClassLoadingAdapter
implements ClassLoadingAdapter {
    @Nullable
    protected final byte[] dex(@NotNull ExecutionContext context2, @NotNull Collection<ClassToLoad> classes2) {
        return ((AndroidDexer)CollectionsKt.single((List)AndroidDexer.Companion.getInstances(context2.getProject()))).dex(classes2);
    }

    @NotNull
    protected final ObjectReference wrapToByteBuffer(@NotNull ArrayReference bytes2, @NotNull ExecutionContext context2) {
        ClassLoaderReference classLoader2 = context2.getClassLoader();
        ReferenceType referenceType = context2.findClass("java.nio.ByteBuffer", classLoader2);
        Intrinsics.checkNotNull((Object)referenceType, (String)"null cannot be cast to non-null type com.sun.jdi.ClassType");
        ClassType byteBufferClass = (ClassType)referenceType;
        Method method = byteBufferClass.concreteMethodByName("wrap", "([B)Ljava/nio/ByteBuffer;");
        if (method == null) {
            throw new IllegalStateException("'wrap' method not found".toString());
        }
        Method wrapMethod = method;
        Value value2 = context2.invokeMethod(byteBufferClass, wrapMethod, (List<? extends Value>)CollectionsKt.listOf((Object)bytes2));
        Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
        return (ObjectReference)value2;
    }

    @Nullable
    protected final ReferenceType tryLoadClass(@NotNull ExecutionContext context2, @NotNull String fqName2, @Nullable ClassLoaderReference classLoader2) {
        ReferenceType referenceType;
        try {
            referenceType = context2.getDebugProcess().loadClass(context2.getEvaluationContext(), fqName2, classLoader2);
        }
        catch (Throwable e) {
            referenceType = null;
        }
        return referenceType;
    }
}

