/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinExpressionWrapper;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinSuspendFunctionWrapper$containsSuspendFunctionCall$lambda$3$;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0014\u0010\u0018\u001a\u00020\t*\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u0017\u001a\u00020\t*\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u0019\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0012\u0010\u001c\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u001d0\u001aH\u0002J\u001a\u0010\u001c\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u001d0\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinSuspendFunctionWrapper;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinExpressionWrapper;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "psiContext", "Lcom/intellij/psi/PsiElement;", "isCoroutineScopeAvailable", "", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;Lcom/intellij/psi/PsiElement;Z)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "coroutineContextKeyword", "", "checkIfKotlinxCoroutinesIsAvailable", "", "createWrappedExpressionText", "expressionText", "isApplicable", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "wrapInRunBlocking", "isCoroutineContextAvailable", "containsSuspendFunctionCall", "isCoroutineContextAvailableFromFunction", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isCoroutineContextAvailableFromLambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "kotlin.jvm-debugger.evaluation"})
public final class KotlinSuspendFunctionWrapper
implements KotlinExpressionWrapper {
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final ExecutionContext executionContext;
    @Nullable
    private final PsiElement psiContext;
    @NotNull
    private final String coroutineContextKeyword;

    public KotlinSuspendFunctionWrapper(@NotNull BindingContext bindingContext2, @NotNull ExecutionContext executionContext2, @Nullable PsiElement psiContext, boolean isCoroutineScopeAvailable) {
        this.bindingContext = bindingContext2;
        this.executionContext = executionContext2;
        this.psiContext = psiContext;
        this.coroutineContextKeyword = isCoroutineScopeAvailable ? CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_FQ_NAME().shortName().asString() : CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_FQ_NAME().asString();
    }

    @NotNull
    public final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @Override
    @NotNull
    public String createWrappedExpressionText(@NotNull String expressionText2) {
        this.checkIfKotlinxCoroutinesIsAvailable();
        boolean $i$f$runReadAction = false;
        boolean isCoroutineContextAvailable = (Boolean)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ KotlinSuspendFunctionWrapper this$0;
            {
                this.this$0 = kotlinSuspendFunctionWrapper;
            }

            public final T compute() {
                boolean bl = false;
                return (T)Boolean.valueOf(KotlinSuspendFunctionWrapper.access$isCoroutineContextAvailable(this.this$0, KotlinSuspendFunctionWrapper.access$getPsiContext$p(this.this$0)));
            }
        });
        return this.wrapInRunBlocking(expressionText2, isCoroutineContextAvailable);
    }

    @Override
    public boolean isApplicable(@NotNull KtExpression expression2) {
        return this.containsSuspendFunctionCall(expression2, this.bindingContext);
    }

    private final String wrapInRunBlocking(String expressionText2, boolean isCoroutineContextAvailable) {
        StringBuilder stringBuilder;
        StringBuilder $this$wrapInRunBlocking_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$wrapInRunBlocking_u24lambda_u241.append("kotlinx.coroutines.runBlocking");
        if (isCoroutineContextAvailable) {
            $this$wrapInRunBlocking_u24lambda_u241.append(StringsKt.trimIndent((String)("\n                     (\n                        @kotlin.OptIn(kotlin.ExperimentalStdlibApi::class)\n                        " + this.coroutineContextKeyword + ".minusKey(kotlinx.coroutines.CoroutineDispatcher)\n                    )\n                ")));
        }
        $this$wrapInRunBlocking_u24lambda_u241.append(" {\n\t");
        $this$wrapInRunBlocking_u24lambda_u241.append(expressionText2);
        $this$wrapInRunBlocking_u24lambda_u241.append("\n}");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private final boolean containsSuspendFunctionCall(KtExpression $this$containsSuspendFunctionCall, BindingContext bindingContext2) {
        boolean $i$f$runReadAction = false;
        return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable($this$containsSuspendFunctionCall, bindingContext2, this){
            final /* synthetic */ KtExpression $this_containsSuspendFunctionCall$inlined;
            final /* synthetic */ BindingContext $bindingContext$inlined;
            final /* synthetic */ KotlinSuspendFunctionWrapper this$0;
            {
                this.$this_containsSuspendFunctionCall$inlined = ktExpression;
                this.$bindingContext$inlined = bindingContext2;
                this.this$0 = kotlinSuspendFunctionWrapper;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final T compute() {
                boolean bl;
                boolean bl2;
                boolean bl3 = false;
                PsiElement $this$descendantsOfType_u24default$iv = (PsiElement)this.$this_containsSuspendFunctionCall$inlined;
                boolean childrenFirst$iv = false;
                boolean $i$f$descendantsOfType = false;
                Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.descendants$default((PsiElement)$this$descendantsOfType_u24default$iv, (boolean)childrenFirst$iv, null, (int)2, null);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)containsSuspendFunctionCall$lambda$3$$inlined$descendantsOfType$default$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence $this$any$iv = sequence2;
                boolean $i$f$any = false;
                Iterator iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) {
                        bl = false;
                        return (T)Boolean.valueOf(bl);
                    }
                    E element$iv = iterator.next();
                    KtCallExpression callExpression2 = (KtCallExpression)element$iv;
                    boolean bl4 = false;
                    ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)callExpression2), (BindingContext)this.$bindingContext$inlined);
                    if (resolvedCall2 != null && DescriptorUtilsKt.isSuspend((CallableDescriptor)resolvedCall2.getResultingDescriptor())) {
                        PsiElement $this$parentsOfType_u24default$iv = (PsiElement)callExpression2;
                        boolean withSelf$iv = true;
                        boolean $i$f$parentsOfType = false;
                        if (!KotlinSuspendFunctionWrapper.access$isCoroutineContextAvailableFromLambda(this.this$0, PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, KtLambdaExpression.class, (boolean)withSelf$iv), this.$bindingContext$inlined)) {
                            bl2 = true;
                            continue;
                        }
                    }
                    bl2 = false;
                } while (!bl2);
                bl = true;
                return (T)Boolean.valueOf(bl);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCoroutineContextAvailable(PsiElement $this$isCoroutineContextAvailable) {
        if ($this$isCoroutineContextAvailable == null) {
            return false;
        }
        PsiElement $this$parentsOfType_u24default$iv = $this$isCoroutineContextAvailable;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        if (this.isCoroutineContextAvailableFromFunction((Sequence<? extends KtNamedFunction>)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, KtNamedFunction.class, (boolean)withSelf$iv))) return true;
        $this$parentsOfType_u24default$iv = $this$isCoroutineContextAvailable;
        withSelf$iv = true;
        $i$f$parentsOfType = false;
        if (!this.isCoroutineContextAvailableFromLambda((Sequence<? extends KtLambdaExpression>)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, KtLambdaExpression.class, (boolean)withSelf$iv))) return false;
        return true;
    }

    private final boolean isCoroutineContextAvailableFromFunction(Sequence<? extends KtNamedFunction> $this$isCoroutineContextAvailableFromFunction) {
        for (KtNamedFunction item : $this$isCoroutineContextAvailableFromFunction) {
            CallableDescriptor descriptor2;
            DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)item);
            CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
            if (callableDescriptor == null || !DescriptorUtilsKt.isSuspend((CallableDescriptor)(descriptor2 = callableDescriptor))) continue;
            return true;
        }
        return false;
    }

    private final boolean isCoroutineContextAvailableFromLambda(Sequence<? extends KtLambdaExpression> $this$isCoroutineContextAvailableFromLambda, BindingContext bindingContext2) {
        for (KtLambdaExpression item : $this$isCoroutineContextAvailableFromLambda) {
            KotlinType type2;
            if (CallUtilKt.getType((KtExpression)((KtExpression)item), (BindingContext)bindingContext2) == null || !FunctionTypesKt.isSuspendFunctionType((KotlinType)type2)) continue;
            return true;
        }
        return false;
    }

    private final boolean isCoroutineContextAvailableFromLambda(Sequence<? extends KtLambdaExpression> $this$isCoroutineContextAvailableFromLambda) {
        boolean bl;
        if (SequencesKt.none($this$isCoroutineContextAvailableFromLambda)) {
            bl = false;
        } else {
            BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)SequencesKt.last($this$isCoroutineContextAvailableFromLambda), BodyResolveMode.PARTIAL);
            bl = this.isCoroutineContextAvailableFromLambda($this$isCoroutineContextAvailableFromLambda, bindingContext2);
        }
        return bl;
    }

    private final void checkIfKotlinxCoroutinesIsAvailable() {
        DebugProcessImpl debugProcess = this.executionContext.getDebugProcess();
        EvaluationContextImpl evaluationContext = this.executionContext.getEvaluationContext();
        try {
            debugProcess.findClass((EvaluationContext)evaluationContext, "kotlinx.coroutines.BuildersKt", evaluationContext.getClassLoader());
        }
        catch (EvaluateException ex) {
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.failed.to.wrap.suspend.function", new Object[0]));
            throw new KotlinNothingValueException();
        }
    }

    public static final /* synthetic */ boolean access$isCoroutineContextAvailable(KotlinSuspendFunctionWrapper $this, PsiElement $receiver) {
        return $this.isCoroutineContextAvailable($receiver);
    }

    public static final /* synthetic */ PsiElement access$getPsiContext$p(KotlinSuspendFunctionWrapper $this) {
        return $this.psiContext;
    }

    public static final /* synthetic */ boolean access$isCoroutineContextAvailableFromLambda(KotlinSuspendFunctionWrapper $this, Sequence $receiver, BindingContext bindingContext2) {
        return $this.isCoroutineContextAvailableFromLambda((Sequence<? extends KtLambdaExpression>)$receiver, bindingContext2);
    }
}

