/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.eval4j.AbnormalTermination;
import org.jetbrains.eval4j.AbstractValue;
import org.jetbrains.eval4j.Eval4JInterpretingException;
import org.jetbrains.eval4j.ExceptionThrown;
import org.jetbrains.eval4j.InterpreterLoopKt;
import org.jetbrains.eval4j.InterpreterResult;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValueReturned;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JDIEval;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.util.caching.ConcurrentFactoryCache;
import org.jetbrains.kotlin.idea.core.util.InlineAnalysisUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.KotlinDebuggerEvaluator;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationError;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationStatus;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationStatusKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.FragmentProjectFileDependencyCollectorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentEditor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentEditorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoadKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCodegenException;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompiler;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentData;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentDataKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelPropertyDescriptorProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.ClassLoadingResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.CompilingEvaluatorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.VariableFinder;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 >2\u00020\u0001:\u0002>?B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0019\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u001cH\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\u001e\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001f\u0010/\u001a\u0004\u0018\u00010,2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00100\u001a\u000201H\u0002\u00a2\u0006\u0002\u00102JQ\u00103\u001a\u0002H4\"\u0004\b\u0000\u001042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000b\u001a\u00020\f2\u001a\u00105\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u0012\u0004\u0012\u0002H406H\u0002\u00a2\u0006\u0002\u00107J\u0018\u00108\u001a\u00020,2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002J\f\u0010=\u001a\u00020(*\u00020.H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator;", "Lcom/intellij/debugger/engine/evaluation/expression/Evaluator;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lcom/intellij/debugger/SourcePosition;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "analyze", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$ErrorCheckingResult;", "status", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "calculateMainMethodCallArguments", "", "Lcom/sun/jdi/Value;", "variableFinder", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder;", "compiledData", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData;", "compileCodeFragment", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "doAnalyze", "evaluate", "", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "evaluateSafe", "evaluateWithCompilation", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "evaluateWithEval4J", "Lorg/jetbrains/eval4j/InterpreterResult;", "evaluateWithStatus", "getCompiledCodeFragment", "getModifier", "", "isCoroutineScopeAvailable", "", "frameProxy", "Lcom/intellij/debugger/engine/jdi/StackFrameProxy;", "reportErrorDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "reportErrorDiagnosticIfAny", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;Lorg/jetbrains/kotlin/resolve/BindingContext;)Lkotlin/Unit;", "runEvaluation", "T", "block", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData;Lcom/sun/jdi/ClassLoaderReference;Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "updateLocalVariableValue", "converter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter;", "ref", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$RefWrapper;", "isIllegalSuspendFunCallInCodeFragment", "Companion", "ErrorCheckingResult", "kotlin.jvm-debugger.evaluation"})
public final class KotlinEvaluator
implements Evaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtCodeFragment codeFragment;
    @Nullable
    private final SourcePosition sourcePosition;
    private static boolean LOG_COMPILATIONS;
    @NotNull
    private static final Set<DiagnosticFactory<?>> IGNORED_DIAGNOSTICS;
    @NotNull
    private static final List<Type> DEFAULT_METHOD_MARKERS;

    public KotlinEvaluator(@NotNull KtCodeFragment codeFragment, @Nullable SourcePosition sourcePosition) {
        this.codeFragment = codeFragment;
        this.sourcePosition = sourcePosition;
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object evaluate(@NotNull EvaluationContextImpl context2) {
        if (((CharSequence)this.codeFragment.getText()).length() == 0) {
            return context2.getDebugProcess().getVirtualMachineProxy().mirrorOfVoid();
        }
        EvaluationStatus status = new EvaluationStatus();
        KotlinDebuggerEvaluator.EvaluationType evaluationType = (KotlinDebuggerEvaluator.EvaluationType)((Object)this.codeFragment.getUserData(KotlinCodeFragmentFactory.Companion.getEVALUATION_TYPE()));
        if (evaluationType != null) {
            status.evaluationType(evaluationType);
        }
        boolean $i$f$runReadAction = false;
        EvaluationStatus.EvaluationContextLanguage language = (EvaluationStatus.EvaluationContextLanguage)((Object)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ KotlinEvaluator this$0;
            {
                this.this$0 = kotlinEvaluator2;
            }

            public final T compute() {
                EvaluationStatus.EvaluationContextLanguage evaluationContextLanguage;
                boolean bl = false;
                if (this.this$0.getCodeFragment().getCopyableUserData(KtCodeFragment.Companion.getFAKE_CONTEXT_FOR_JAVA_FILE()) != null) {
                    evaluationContextLanguage = EvaluationStatus.EvaluationContextLanguage.Java;
                } else {
                    PsiElement psiElement2 = this.this$0.getCodeFragment().getContext();
                    evaluationContextLanguage = Intrinsics.areEqual((Object)(psiElement2 != null ? psiElement2.getLanguage() : null), (Object)KotlinLanguage.INSTANCE) ? EvaluationStatus.EvaluationContextLanguage.Kotlin : EvaluationStatus.EvaluationContextLanguage.Other;
                }
                return (T)((Object)evaluationContextLanguage);
            }
        }));
        EvaluationStatusKt.contextLanguage(status, language);
        try {
            Object object = this.evaluateWithStatus(context2, status);
            return object;
        }
        finally {
            status.send();
        }
    }

    private final Object evaluateWithStatus(EvaluationContextImpl context2, EvaluationStatus status) {
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable(this, status){
            final /* synthetic */ KotlinEvaluator this$0;
            final /* synthetic */ EvaluationStatus $status$inlined;
            {
                this.this$0 = kotlinEvaluator2;
                this.$status$inlined = evaluationStatus;
            }

            public final T compute() {
                boolean bl = false;
                if (DumbService.getInstance((Project)this.this$0.getCodeFragment().getProject()).isDumb()) {
                    this.$status$inlined.error(EvaluationError.DumbMode);
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.dumb.mode", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                return (T)Unit.INSTANCE;
            }
        });
        if (!context2.getDebugProcess().isAttached()) {
            status.error(EvaluationError.DebuggerNotAttached);
            throw EvaluateExceptionUtil.PROCESS_EXITED;
        }
        StackFrameProxyImpl stackFrameProxyImpl = context2.getFrameProxy();
        if (stackFrameProxyImpl == null) {
            KotlinEvaluator $this$evaluateWithStatus_u24lambda_u242 = this;
            boolean bl = false;
            status.error(EvaluationError.NoFrameProxy);
            throw EvaluateExceptionUtil.NULL_STACK_FRAME;
        }
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        ThreadReferenceProxyImpl threadReferenceProxyImpl = context2.getSuspendContext().getThread();
        if (threadReferenceProxyImpl == null) {
            KotlinEvaluator $this$evaluateWithStatus_u24lambda_u243 = this;
            boolean bl = false;
            status.error(EvaluationError.ThreadNotAvailable);
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.thread.unavailable", new Object[0]));
            throw new KotlinNothingValueException();
        }
        ThreadReferenceProxyImpl operatingThread = threadReferenceProxyImpl;
        if (!operatingThread.isSuspended()) {
            status.error(EvaluationError.ThreadNotSuspended);
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.thread.not.suspended", new Object[0]));
            throw new KotlinNothingValueException();
        }
        try {
            ExecutionContext executionContext2 = new ExecutionContext(context2, frameProxy);
            return this.evaluateSafe(executionContext2, status);
        }
        catch (CodeFragmentCodegenException e) {
            status.error(EvaluationError.BackendException);
            KotlinEvaluatorBuilderKt.evaluationException(e.getReason());
            throw new KotlinNothingValueException();
        }
        catch (EvaluateException e) {
            EvaluationError error2 = e.getExceptionFromTargetVM() != null ? EvaluationError.ExceptionFromEvaluatedCode : EvaluationError.EvaluateException;
            status.error(error2);
            throw e;
        }
        catch (ProcessCanceledException e) {
            status.error(EvaluationError.ProcessCancelledException);
            KotlinEvaluatorBuilderKt.evaluationException(e);
            throw new KotlinNothingValueException();
        }
        catch (Eval4JInterpretingException e) {
            status.error(EvaluationError.InterpretingException);
            KotlinEvaluatorBuilderKt.evaluationException(e.getCause());
            throw new KotlinNothingValueException();
        }
        catch (Exception e) {
            boolean isSpecialException = KotlinEvaluatorBuilderKt.access$isSpecialException(e);
            if (isSpecialException) {
                status.error(EvaluationError.SpecialException);
                KotlinEvaluatorBuilderKt.evaluationException(e);
                throw new KotlinNothingValueException();
            }
            status.error(EvaluationError.GenericException);
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = KotlinDebuggerEvaluationBundle.message("error.exception.occurred", new Object[0]);
            }
            KotlinEvaluatorBuilderKt.access$reportError(this.codeFragment, this.sourcePosition, string2, e);
            String cause = e.getMessage() != null ? ": " + e.getMessage() : "";
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.evaluate", new Object[0]) + cause);
            throw new KotlinNothingValueException();
        }
    }

    private final Object evaluateSafe(ExecutionContext context2, EvaluationStatus status) {
        InterpreterResult interpreterResult;
        ClassLoaderReference classLoaderRef;
        CompiledCodeFragmentData compiledData = this.getCompiledCodeFragment(context2, status);
        ClassLoadingResult classLoadingResult = CompilingEvaluatorKt.loadClassesSafely(context2, (Collection<ClassToLoad>)compiledData.getClasses());
        ClassLoadingResult.Success success2 = classLoadingResult instanceof ClassLoadingResult.Success ? (ClassLoadingResult.Success)classLoadingResult : null;
        ClassLoaderReference classLoaderReference = classLoaderRef = success2 != null ? success2.getClassLoader() : null;
        if (classLoadingResult instanceof ClassLoadingResult.Failure) {
            EvaluationStatusKt.classLoadingFailed(status);
        }
        if (classLoaderRef != null) {
            try {
                EvaluationStatusKt.usedEvaluator(status, EvaluationStatus.EvaluatorType.Bytecode);
                return this.evaluateWithCompilation(context2, compiledData, classLoaderRef, status);
            }
            catch (Throwable e) {
                InterpreterResult interpreterResult2;
                EvaluationStatusKt.compilingEvaluatorFailed(status);
                KotlinEvaluatorBuilderKt.getLOG().warn("Compiling evaluator failed: " + e.getMessage(), e);
                EvaluationStatusKt.usedEvaluator(status, EvaluationStatus.EvaluatorType.Eval4j);
                interpreterResult = interpreterResult2 = this.evaluateWithEval4J(context2, compiledData, classLoaderRef, status);
            }
        } else {
            EvaluationStatusKt.usedEvaluator(status, EvaluationStatus.EvaluatorType.Eval4j);
            interpreterResult = this.evaluateWithEval4J(context2, compiledData, null, status);
        }
        InterpreterResult result2 = interpreterResult;
        return KotlinEvaluator.Companion.toJdiValue(result2, context2, status);
    }

    private final CompiledCodeFragmentData getCompiledCodeFragment(ExecutionContext context2, EvaluationStatus status) {
        StringBuilder stringBuilder;
        boolean $i$f$runReadAction = false;
        ConcurrentFactoryCache cache2 = (ConcurrentFactoryCache)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ KotlinEvaluator this$0;
            {
                this.this$0 = kotlinEvaluator2;
            }

            public final T compute() {
                ConcurrentFactoryCache concurrentFactoryCache;
                boolean bl = false;
                PsiElement psiElement2 = this.this$0.getCodeFragment().getContext();
                if (psiElement2 == null) {
                    concurrentFactoryCache = null;
                } else {
                    PsiElement contextElement = psiElement2;
                    concurrentFactoryCache = (ConcurrentFactoryCache)CachedValuesManager.getCachedValue((PsiElement)contextElement, (CachedValueProvider)getCompiledCodeFragment.cache.1.1.INSTANCE);
                }
                return (T)concurrentFactoryCache;
            }
        });
        if (cache2 == null) {
            return this.compileCodeFragment(context2, status);
        }
        StringBuilder $this$getCompiledCodeFragment_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$getCompiledCodeFragment_u24lambda_u245.append(this.codeFragment.importsToString());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        $this$getCompiledCodeFragment_u24lambda_u245.append(this.codeFragment.getText());
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String key = string2;
        return (CompiledCodeFragmentData)cache2.get(key, (Function1)new Function1<String, CompiledCodeFragmentData>(this, context2, status){
            final /* synthetic */ KotlinEvaluator this$0;
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ EvaluationStatus $status;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$status = $status;
                super(1);
            }

            public final CompiledCodeFragmentData invoke(String it) {
                return KotlinEvaluator.access$compileCodeFragment(this.this$0, this.$context, this.$status);
            }
        });
    }

    private final CompiledCodeFragmentData compileCodeFragment(ExecutionContext context2, EvaluationStatus status) {
        DebugProcessImpl debugProcess = context2.getDebugProcess();
        Ref.ObjectRef analysisResult2 = new Ref.ObjectRef();
        analysisResult2.element = this.analyze(this.codeFragment, status, debugProcess);
        boolean codeFragmentWasEdited = KotlinCodeFragmentEditorKt.withSuspendFunctionWrapper(KotlinCodeFragmentEditorKt.withToStringWrapper(new KotlinCodeFragmentEditor(this.codeFragment), ((ErrorCheckingResult)analysisResult2.element).getBindingContext()), ((ErrorCheckingResult)analysisResult2.element).getBindingContext(), context2, this.isCoroutineScopeAvailable((StackFrameProxy)context2.getFrameProxy())).editCodeFragment();
        if (codeFragmentWasEdited) {
            analysisResult2.element = this.analyze(this.codeFragment, status, debugProcess);
        }
        Diagnostic diagnostic = ((ErrorCheckingResult)analysisResult2.element).getIllegalSuspendFunCallDiagnostic();
        if (diagnostic != null) {
            Diagnostic it = diagnostic;
            boolean bl = false;
            this.reportErrorDiagnostic(it, status);
        }
        boolean $i$f$runReadAction = false;
        Pair pair = (Pair)ApplicationManager.getApplication().runReadAction(new Computable(this, analysisResult2, status){
            final /* synthetic */ KotlinEvaluator this$0;
            final /* synthetic */ Ref.ObjectRef $analysisResult$inlined;
            final /* synthetic */ EvaluationStatus $status$inlined;
            {
                this.this$0 = kotlinEvaluator2;
                this.$analysisResult$inlined = objectRef;
                this.$status$inlined = evaluationStatus;
            }

            public final T compute() {
                Pair pair;
                boolean bl = false;
                ResolutionFacade resolutionFacade = KotlinEvaluatorBuilderKt.getResolutionFacadeForCodeFragment(this.this$0.getCodeFragment());
                try {
                    List list2;
                    if (!CodeFragmentCompiler.Companion.useIRFragmentCompiler()) {
                        list2 = (List)InlineAnalysisUtilsKt.analyzeInlinedFunctions(resolutionFacade, (KtFile)this.this$0.getCodeFragment(), false, ((ErrorCheckingResult)this.$analysisResult$inlined.element).getBindingContext()).getSecond();
                    } else {
                        List list3;
                        List $this$compileCodeFragment_u24lambda_u248_u24lambda_u247 = list3 = CollectionsKt.toMutableList((Collection)FragmentProjectFileDependencyCollectorKt.gatherProjectFilesDependedOnByFragment(this.this$0.getCodeFragment(), ((ErrorCheckingResult)this.$analysisResult$inlined.element).getBindingContext()));
                        boolean bl2 = false;
                        KotlinEvaluator.access$compileCodeFragment$lambda$8$moveToLast($this$compileCodeFragment_u24lambda_u248_u24lambda_u247, this.this$0.getCodeFragment());
                        list2 = list3;
                    }
                    List filesToCompile = list2;
                    AnalysisResult analysis = ResolutionFacade.analyzeWithAllCompilerChecks$default(resolutionFacade, filesToCompile, null, 2, null);
                    pair = new Pair((Object)analysis.getBindingContext(), (Object)filesToCompile);
                }
                catch (IllegalArgumentException e) {
                    this.$status$inlined.error(EvaluationError.ErrorElementOccurred);
                    String string2 = e.getMessage();
                    if (string2 == null) {
                        string2 = e.toString();
                    }
                    KotlinEvaluatorBuilderKt.evaluationException(string2);
                    throw new KotlinNothingValueException();
                }
                return (T)pair;
            }
        });
        BindingContext bindingContext2 = (BindingContext)pair.component1();
        List filesToCompile = (List)pair.component2();
        ModuleDescriptor moduleDescriptor = ((ErrorCheckingResult)analysisResult2.element).getModuleDescriptor();
        CodeFragmentCompiler.CompilationResult result2 = new CodeFragmentCompiler(context2, status).compile(this.codeFragment, filesToCompile, bindingContext2, moduleDescriptor);
        if (LOG_COMPILATIONS) {
            KotlinEvaluatorBuilderKt.getLOG().debug("Compile bytecode for " + this.codeFragment.getText());
        }
        return KotlinEvaluatorBuilderKt.createCompiledDataDescriptor(result2);
    }

    private final boolean isCoroutineScopeAvailable(StackFrameProxy frameProxy) {
        return frameProxy instanceof CoroutineStackFrameProxyImpl ? ((CoroutineStackFrameProxyImpl)frameProxy).isCoroutineScopeAvailable() : false;
    }

    private final ErrorCheckingResult analyze(KtCodeFragment codeFragment, EvaluationStatus status, DebugProcessImpl debugProcess) {
        Result result2 = (Result)ReadAction.nonBlocking(() -> KotlinEvaluator.analyze$lambda$9(this, codeFragment, status, debugProcess)).executeSynchronously();
        Object object = result2.unbox-impl();
        ResultKt.throwOnFailure((Object)object);
        return (ErrorCheckingResult)object;
    }

    /*
     * WARNING - void declaration
     */
    private final ErrorCheckingResult doAnalyze(KtCodeFragment codeFragment, EvaluationStatus status, DebugProcessImpl debugProcess) {
        Object v1;
        BindingContext bindingContext2;
        ModuleDescriptor moduleDescriptor;
        List<KtCodeFragment> list2;
        block5: {
            void $this$firstOrNull$iv;
            try {
                AnalyzingUtils.checkForSyntacticErrors((PsiElement)((PsiElement)codeFragment));
            }
            catch (IllegalArgumentException e) {
                status.error(EvaluationError.ErrorElementOccurred);
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = e.toString();
                }
                KotlinEvaluatorBuilderKt.evaluationException(string2);
                throw new KotlinNothingValueException();
            }
            ResolutionFacade resolutionFacade = KotlinEvaluatorBuilderKt.getResolutionFacadeForCodeFragment(codeFragment);
            new DebugLabelPropertyDescriptorProvider(codeFragment, debugProcess).supplyDebugLabels();
            AnalysisResult analysisResult2 = ResolutionFacade.analyzeWithAllCompilerChecks$default(resolutionFacade, (KtElement)codeFragment, null, 2, null);
            if (analysisResult2.isError()) {
                status.error(EvaluationError.FrontendException);
                KotlinEvaluatorBuilderKt.evaluationException(analysisResult2.getError());
                throw new KotlinNothingValueException();
            }
            BindingContext bindingContext3 = analysisResult2.getBindingContext();
            this.reportErrorDiagnosticIfAny(status, bindingContext3);
            Iterable iterable = (Iterable)bindingContext3.getDiagnostics();
            list2 = Collections.singletonList(codeFragment);
            moduleDescriptor = analysisResult2.getModuleDescriptor();
            bindingContext2 = bindingContext3;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Diagnostic it = (Diagnostic)element$iv;
                boolean bl = false;
                if (!this.isIllegalSuspendFunCallInCodeFragment(it)) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        Object var16_17 = v1;
        Diagnostic diagnostic = var16_17;
        List<KtCodeFragment> list3 = list2;
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        BindingContext bindingContext4 = bindingContext2;
        return new ErrorCheckingResult(bindingContext4, moduleDescriptor2, list3, diagnostic);
    }

    /*
     * WARNING - void declaration
     */
    private final Unit reportErrorDiagnosticIfAny(EvaluationStatus status, BindingContext bindingContext2) {
        Unit unit2;
        Object v0;
        block4: {
            void $this$firstOrNull$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = (Iterable)bindingContext2.getDiagnostics();
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                Diagnostic it = (Diagnostic)element$iv$iv;
                boolean bl = false;
                if (!(!IGNORED_DIAGNOSTICS.contains(it.getFactory()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Diagnostic it = (Diagnostic)element$iv;
                boolean bl = false;
                if (!(it.getSeverity() == Severity.ERROR && Intrinsics.areEqual((Object)it.getPsiElement().getContainingFile(), (Object)this.codeFragment))) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        Diagnostic diagnostic = v0;
        if (diagnostic != null) {
            Diagnostic it = diagnostic;
            boolean bl = false;
            this.reportErrorDiagnostic(it, status);
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        return unit2;
    }

    private final void reportErrorDiagnostic(Diagnostic diagnostic, EvaluationStatus status) {
        status.error(EvaluationError.ErrorsInCode);
        KotlinEvaluatorBuilderKt.evaluationException(DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)diagnostic)));
        throw new KotlinNothingValueException();
    }

    private final boolean isIllegalSuspendFunCallInCodeFragment(Diagnostic $this$isIllegalSuspendFunCallInCodeFragment) {
        return $this$isIllegalSuspendFunCallInCodeFragment.getSeverity() == Severity.ERROR && Intrinsics.areEqual((Object)$this$isIllegalSuspendFunCallInCodeFragment.getPsiElement().getContainingFile(), (Object)this.codeFragment) && Intrinsics.areEqual((Object)$this$isIllegalSuspendFunCallInCodeFragment.getFactory(), (Object)Errors.ILLEGAL_SUSPEND_FUNCTION_CALL);
    }

    private final com.sun.jdi.Value evaluateWithCompilation(ExecutionContext context2, CompiledCodeFragmentData compiledData, ClassLoaderReference classLoader2, EvaluationStatus status) {
        return (com.sun.jdi.Value)this.runEvaluation(context2, compiledData, classLoader2, status, (Function1)new Function1<List<? extends com.sun.jdi.Value>, com.sun.jdi.Value>(context2, classLoader2){
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ ClassLoaderReference $classLoader;
            {
                this.$context = $context;
                this.$classLoader = $classLoader;
                super(1);
            }

            @Nullable
            public final com.sun.jdi.Value invoke(@NotNull List<? extends com.sun.jdi.Value> args) {
                ReferenceType referenceType = this.$context.findClass("Generated_for_debugger_class", this.$classLoader);
                ClassType classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
                if (classType == null) {
                    throw new IllegalStateException("Can not find class \"Generated_for_debugger_class\"".toString());
                }
                ClassType mainClassType = classType;
                Iterable $this$single$iv = mainClassType.methods();
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (T element$iv : $this$single$iv) {
                    Method it = (Method)element$iv;
                    boolean bl = false;
                    if (!ClassToLoadKt.isEvaluationEntryPoint(it.name())) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Method mainMethod = single$iv;
                com.sun.jdi.Value returnValue = this.$context.invokeMethod(mainClassType, mainMethod, args);
                return EvaluatorValueConverter.Companion.unref(returnValue);
            }
        });
    }

    private final InterpreterResult evaluateWithEval4J(ExecutionContext context2, CompiledCodeFragmentData compiledData, ClassLoaderReference classLoader2, EvaluationStatus status) {
        Object element$iv2;
        block2: {
            ClassNode classNode;
            byte[] mainClassBytecode = CompiledCodeFragmentDataKt.getMainClass(compiledData).getBytes();
            ClassNode $this$evaluateWithEval4J_u24lambda_u2414 = classNode = new ClassNode();
            boolean bl = false;
            new ClassReader(mainClassBytecode).accept((ClassVisitor)$this$evaluateWithEval4J_u24lambda_u2414, 0);
            ClassNode mainClassAsmNode = classNode;
            Iterable $this$first$iv = mainClassAsmNode.methods;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MethodNode it = (MethodNode)element$iv2;
                boolean bl2 = false;
                if (!ClassToLoadKt.isEvaluationEntryPoint(it)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        MethodNode mainMethod = (MethodNode)element$iv2;
        ClassLoaderReference classLoaderReference = classLoader2;
        if (classLoaderReference == null) {
            classLoaderReference = context2.getEvaluationContext().getClassLoader();
        }
        return (InterpreterResult)this.runEvaluation(context2, compiledData, classLoaderReference, status, (Function1)new Function1<List<? extends com.sun.jdi.Value>, InterpreterResult>(context2, mainMethod, classLoader2){
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ MethodNode $mainMethod;
            final /* synthetic */ ClassLoaderReference $classLoader;
            {
                this.$context = $context;
                this.$mainMethod = $mainMethod;
                this.$classLoader = $classLoader;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final InterpreterResult invoke(@NotNull List<? extends com.sun.jdi.Value> args) {
                Collection<Value> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object object;
                Object object2;
                VirtualMachine vm;
                block4: {
                    block3: {
                        vm = this.$context.getVm().getVirtualMachine();
                        object2 = this.$context.getSuspendContext().getThread();
                        if (object2 == null || (object2 = object2.getThreadReference()) == null) break block3;
                        Object it = object = object2;
                        boolean bl = false;
                        object2 = it.isSuspended() ? object : null;
                        if (object2 != null) break block4;
                    }
                    throw new IllegalStateException("Can not find a thread to run evaluation on".toString());
                }
                Object thread = object2;
                int n = this.$context.getInvokePolicy();
                JDIEval eval2 = new JDIEval(vm, this.$classLoader, (ThreadReference)thread, this.$context, n){
                    final /* synthetic */ ExecutionContext $context;
                    {
                        this.$context = $context;
                        super($vm, $classLoader, $thread, $super_call_param$1);
                    }

                    @Nullable
                    public com.sun.jdi.Value jdiInvokeStaticMethod(@NotNull ClassType type2, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int invokePolicy) {
                        return this.$context.invokeMethod(type2, method, args);
                    }

                    @Nullable
                    public com.sun.jdi.Value jdiInvokeStaticMethod(@NotNull InterfaceType type2, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int invokePolicy) {
                        return this.$context.invokeMethod(type2, method, args);
                    }

                    @Nullable
                    public com.sun.jdi.Value jdiInvokeMethod(@NotNull ObjectReference obj, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int policy) {
                        return this.$context.invokeMethod(obj, method, args, 2);
                    }
                };
                Iterable iterable = args;
                MethodNode methodNode = this.$mainMethod;
                MethodNode methodNode2 = this.$mainMethod;
                boolean $i$f$map = false;
                object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    com.sun.jdi.Value value2 = (com.sun.jdi.Value)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(JdiValuesKt.asValue((com.sun.jdi.Value)it));
                }
                collection = (List)destination$iv$iv;
                return InterpreterLoopKt.interpreterLoop$default(methodNode2, JdiValuesKt.makeInitialFrame(methodNode, (List<? extends Value>)collection), eval2, null, 8, null);
            }
        });
    }

    private final <T> T runEvaluation(ExecutionContext context2, CompiledCodeFragmentData compiledData, ClassLoaderReference classLoader2, EvaluationStatus status, Function1<? super List<? extends com.sun.jdi.Value>, ? extends T> block2) {
        Iterator<Type> $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = compiledData.getClasses();
        boolean $i$f$filter = false;
        void var8_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            ClassToLoad it = (ClassToLoad)element$iv$iv;
            boolean bl = false;
            if (!(!it.isMainClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Object element$iv = $this$filterTo$iv$iv.next();
            ClassToLoad it = (ClassToLoad)element$iv;
            boolean bl = false;
            context2.findClass(it.getClassName(), classLoader2);
        }
        for (Type parameterType : compiledData.getMainMethodSignature().getParameterTypes()) {
            context2.findClass(parameterType, classLoader2);
        }
        VariableFinder variableFinder = new VariableFinder(context2);
        List<com.sun.jdi.Value> args = this.calculateMainMethodCallArguments(variableFinder, compiledData, status);
        Object result2 = block2.invoke(args);
        for (VariableFinder.RefWrapper wrapper : variableFinder.getRefWrappers()) {
            this.updateLocalVariableValue(variableFinder.getEvaluatorValueConverter(), wrapper);
        }
        return (T)result2;
    }

    private final void updateLocalVariableValue(EvaluatorValueConverter converter, VariableFinder.RefWrapper ref) {
        StackFrameProxyImpl frameProxy = converter.getContext().getFrameProxy();
        com.sun.jdi.Value newValue = EvaluatorValueConverter.Companion.unref(ref.getWrapper());
        LocalVariableProxyImpl variable2 = SafeUtilKt.safeVisibleVariableByName(frameProxy, ref.getLocalVariableName());
        if (variable2 != null) {
            try {
                frameProxy.setValue(variable2, newValue);
            }
            catch (InvalidTypeException e) {
                com.sun.jdi.Value value2 = newValue;
                KotlinEvaluatorBuilderKt.getLOG().error("Cannot update local variable value: expected type " + variable2.getType() + ", actual type " + (value2 != null ? value2.type() : null), (Throwable)e);
            }
        } else if (frameProxy instanceof CoroutineStackFrameProxyImpl) {
            ((CoroutineStackFrameProxyImpl)frameProxy).updateSpilledVariableValue(ref.getLocalVariableName(), newValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<com.sun.jdi.Value> calculateMainMethodCallArguments(VariableFinder variableFinder, CompiledCodeFragmentData compiledData, EvaluationStatus status) {
        void $this$mapTo$iv$iv;
        List<Type> asmValueParameters = compiledData.getMainMethodSignature().getParameterTypes();
        List<CodeFragmentParameter.Dumb> valueParameters2 = compiledData.getParameters();
        if (!(asmValueParameters.size() == valueParameters2.size())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        List args = CollectionsKt.zip((Iterable)valueParameters2, (Iterable)asmValueParameters);
        Iterable $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Type asmType;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CodeFragmentParameter.Dumb parameter2 = (CodeFragmentParameter.Dumb)pair.component1();
            VariableFinder.Result result2 = variableFinder.find(parameter2, asmType = (Type)pair.component2());
            if (result2 == null) {
                String name2 = parameter2.getDebugString();
                StackFrameProxyImpl frameProxy = variableFinder.getContext().getFrameProxy();
                if (parameter2.getKind() == CodeFragmentParameter.Kind.COROUTINE_CONTEXT) {
                    status.error(EvaluationError.CoroutineContextUnavailable);
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.coroutine.context.unavailable", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                if (compiledData.getCrossingBounds().contains(parameter2)) {
                    status.error(EvaluationError.ParameterNotCaptured);
                    Object[] objectArray = new Object[]{name2};
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.not.captured", objectArray));
                    throw new KotlinNothingValueException();
                }
                if (parameter2.getKind() == CodeFragmentParameter.Kind.FIELD_VAR) {
                    status.error(EvaluationError.BackingFieldNotFound);
                    Object[] objectArray = new Object[]{parameter2.getName()};
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.find.backing.field", objectArray));
                    throw new KotlinNothingValueException();
                }
                if (parameter2.getKind() == CodeFragmentParameter.Kind.ORDINARY && KotlinEvaluator.calculateMainMethodCallArguments$lambda$19$isInsideDefaultInterfaceMethod(frameProxy)) {
                    status.error(EvaluationError.InsideDefaultMethod);
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.parameter.evaluation.default.methods", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                if (parameter2.getKind() == CodeFragmentParameter.Kind.ORDINARY && frameProxy instanceof CoroutineStackFrameProxyImpl) {
                    status.error(EvaluationError.OptimisedVariable);
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.variable.was.optimised", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                status.error(EvaluationError.CannotFindVariable);
                Object[] objectArray = new Object[]{name2, asmType.getClassName()};
                KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.find.variable", objectArray));
                throw new KotlinNothingValueException();
            }
            collection.add(result2.getValue());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Void getModifier() {
        return null;
    }

    private static final <T> void compileCodeFragment$lambda$8$moveToLast(List<T> $this$compileCodeFragment_u24lambda_u248_u24moveToLast, T element3) {
        $this$compileCodeFragment_u24lambda_u248_u24moveToLast.removeAll(CollectionsKt.listOf(element3));
        $this$compileCodeFragment_u24lambda_u248_u24moveToLast.add(element3);
    }

    private static final Result analyze$lambda$9(KotlinEvaluator this$0, KtCodeFragment $codeFragment, EvaluationStatus $status, DebugProcessImpl $debugProcess) {
        Object object;
        try {
            object = Result.constructor-impl((Object)this$0.doAnalyze($codeFragment, $status, $debugProcess));
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Exception ex) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)ex));
        }
        return Result.box-impl((Object)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean calculateMainMethodCallArguments$lambda$19$isInsideDefaultInterfaceMethod(StackFrameProxyImpl frameProxy) {
        Type it;
        Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
        Comparable<Location> comparable = location2;
        if (location2 == null) return false;
        if ((comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) {
            return false;
        }
        Comparable<Location> method = comparable;
        String desc2 = method.signature();
        if (!StringsKt.endsWith$default((String)method.name(), (String)"$default", (boolean)false, (int)2, null)) return false;
        Iterable $this$any$iv = DEFAULT_METHOD_MARKERS;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (Type)element$iv;
            boolean bl = false;
        } while (!StringsKt.contains$default((CharSequence)desc2, (CharSequence)("I" + it.getDescriptor() + ")"), (boolean)false, (int)2, null));
        return true;
    }

    public static final /* synthetic */ CompiledCodeFragmentData access$compileCodeFragment(KotlinEvaluator $this, ExecutionContext context2, EvaluationStatus status) {
        return $this.compileCodeFragment(context2, status);
    }

    public static final /* synthetic */ void access$compileCodeFragment$lambda$8$moveToLast(List $receiver, Object element3) {
        KotlinEvaluator.compileCodeFragment$lambda$8$moveToLast($receiver, element3);
    }

    static {
        Object[] objectArray = new DiagnosticFactoryWithPsiElement[]{(DiagnosticFactoryWithPsiElement)Errors.OPT_IN_USAGE_ERROR, (DiagnosticFactoryWithPsiElement)Errors.MISSING_DEPENDENCY_SUPERCLASS, (DiagnosticFactoryWithPsiElement)Errors.IR_WITH_UNSTABLE_ABI_COMPILED_CLASS, (DiagnosticFactoryWithPsiElement)Errors.FIR_COMPILED_CLASS, (DiagnosticFactoryWithPsiElement)Errors.ILLEGAL_SUSPEND_FUNCTION_CALL};
        IGNORED_DIAGNOSTICS = SetsKt.plus((Set)((Set)Errors.INVISIBLE_REFERENCE_DIAGNOSTICS), (Iterable)SetsKt.setOf((Object[])objectArray));
        objectArray = new Type[]{AsmTypes.OBJECT_TYPE, AsmTypes.DEFAULT_CONSTRUCTOR_MARKER};
        DEFAULT_METHOD_MARKERS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\nH\u00c6\u0003J9\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$ErrorCheckingResult;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "illegalSuspendFunCallDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/List;Lorg/jetbrains/kotlin/diagnostics/Diagnostic;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getFiles", "()Ljava/util/List;", "getIllegalSuspendFunCallDiagnostic", "()Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.jvm-debugger.evaluation"})
    private static final class ErrorCheckingResult {
        @NotNull
        private final BindingContext bindingContext;
        @NotNull
        private final ModuleDescriptor moduleDescriptor;
        @NotNull
        private final List<KtFile> files;
        @Nullable
        private final Diagnostic illegalSuspendFunCallDiagnostic;

        public ErrorCheckingResult(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends KtFile> files2, @Nullable Diagnostic illegalSuspendFunCallDiagnostic) {
            this.bindingContext = bindingContext2;
            this.moduleDescriptor = moduleDescriptor;
            this.files = files2;
            this.illegalSuspendFunCallDiagnostic = illegalSuspendFunCallDiagnostic;
        }

        @NotNull
        public final BindingContext getBindingContext() {
            return this.bindingContext;
        }

        @NotNull
        public final ModuleDescriptor getModuleDescriptor() {
            return this.moduleDescriptor;
        }

        @NotNull
        public final List<KtFile> getFiles() {
            return this.files;
        }

        @Nullable
        public final Diagnostic getIllegalSuspendFunCallDiagnostic() {
            return this.illegalSuspendFunCallDiagnostic;
        }

        @NotNull
        public final BindingContext component1() {
            return this.bindingContext;
        }

        @NotNull
        public final ModuleDescriptor component2() {
            return this.moduleDescriptor;
        }

        @NotNull
        public final List<KtFile> component3() {
            return this.files;
        }

        @Nullable
        public final Diagnostic component4() {
            return this.illegalSuspendFunCallDiagnostic;
        }

        @NotNull
        public final ErrorCheckingResult copy(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends KtFile> files2, @Nullable Diagnostic illegalSuspendFunCallDiagnostic) {
            return new ErrorCheckingResult(bindingContext2, moduleDescriptor, files2, illegalSuspendFunCallDiagnostic);
        }

        public static /* synthetic */ ErrorCheckingResult copy$default(ErrorCheckingResult errorCheckingResult, BindingContext bindingContext2, ModuleDescriptor moduleDescriptor, List list2, Diagnostic diagnostic, int n, Object object) {
            if ((n & 1) != 0) {
                bindingContext2 = errorCheckingResult.bindingContext;
            }
            if ((n & 2) != 0) {
                moduleDescriptor = errorCheckingResult.moduleDescriptor;
            }
            if ((n & 4) != 0) {
                list2 = errorCheckingResult.files;
            }
            if ((n & 8) != 0) {
                diagnostic = errorCheckingResult.illegalSuspendFunCallDiagnostic;
            }
            return errorCheckingResult.copy(bindingContext2, moduleDescriptor, list2, diagnostic);
        }

        @NotNull
        public String toString() {
            return "ErrorCheckingResult(bindingContext=" + this.bindingContext + ", moduleDescriptor=" + this.moduleDescriptor + ", files=" + this.files + ", illegalSuspendFunCallDiagnostic=" + this.illegalSuspendFunCallDiagnostic + ")";
        }

        public int hashCode() {
            int result2 = this.bindingContext.hashCode();
            result2 = result2 * 31 + this.moduleDescriptor.hashCode();
            result2 = result2 * 31 + ((Object)this.files).hashCode();
            result2 = result2 * 31 + (this.illegalSuspendFunCallDiagnostic == null ? 0 : this.illegalSuspendFunCallDiagnostic.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ErrorCheckingResult)) {
                return false;
            }
            ErrorCheckingResult errorCheckingResult = (ErrorCheckingResult)other;
            if (!Intrinsics.areEqual((Object)this.bindingContext, (Object)errorCheckingResult.bindingContext)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.moduleDescriptor, (Object)errorCheckingResult.moduleDescriptor)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.files, errorCheckingResult.files)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.illegalSuspendFunCallDiagnostic, (Object)errorCheckingResult.illegalSuspendFunCallDiagnostic);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u00020\r8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion;", "", "()V", "DEFAULT_METHOD_MARKERS", "", "Lorg/jetbrains/org/objectweb/asm/Type;", "kotlin.jvm.PlatformType", "IGNORED_DIAGNOSTICS", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "getIGNORED_DIAGNOSTICS$kotlin_jvm_debugger_evaluation", "()Ljava/util/Set;", "LOG_COMPILATIONS", "", "getLOG_COMPILATIONS", "()Z", "setLOG_COMPILATIONS", "(Z)V", "getValueIfSharedVar", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "value", "Lorg/jetbrains/eval4j/Value;", "toJdiValue", "Lcom/sun/jdi/Value;", "Lorg/jetbrains/eval4j/InterpreterResult;", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "status", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        @ApiStatus.Internal
        public final boolean getLOG_COMPILATIONS() {
            return LOG_COMPILATIONS;
        }

        public final void setLOG_COMPILATIONS(boolean bl) {
            LOG_COMPILATIONS = bl;
        }

        @NotNull
        public final Set<DiagnosticFactory<?>> getIGNORED_DIAGNOSTICS$kotlin_jvm_debugger_evaluation() {
            return IGNORED_DIAGNOSTICS;
        }

        private final com.sun.jdi.Value toJdiValue(InterpreterResult $this$toJdiValue, ExecutionContext context2, EvaluationStatus status) {
            InterpreterResult interpreterResult = $this$toJdiValue;
            if (!(interpreterResult instanceof ValueReturned)) {
                if (interpreterResult instanceof ExceptionThrown) {
                    switch (WhenMappings.$EnumSwitchMapping$0[((ExceptionThrown)$this$toJdiValue).getKind().ordinal()]) {
                        case 1: {
                            status.error(EvaluationError.ExceptionFromEvaluatedCode);
                            Object v = ((ExceptionThrown)$this$toJdiValue).getException().getValue();
                            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
                            KotlinEvaluatorBuilderKt.evaluationException(new InvocationException((ObjectReference)v));
                            throw new KotlinNothingValueException();
                        }
                        case 2: {
                            Object v = ((ExceptionThrown)$this$toJdiValue).getException().getValue();
                            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Throwable");
                            throw (Throwable)v;
                        }
                    }
                    status.error(EvaluationError.Eval4JUnknownException);
                    KotlinEvaluatorBuilderKt.evaluationException(((ExceptionThrown)$this$toJdiValue).getException().toString());
                    throw new KotlinNothingValueException();
                }
                if (interpreterResult instanceof AbnormalTermination) {
                    status.error(EvaluationError.Eval4JAbnormalTermination);
                    KotlinEvaluatorBuilderKt.evaluationException(((AbnormalTermination)$this$toJdiValue).getMessage());
                    throw new KotlinNothingValueException();
                }
                throw new IllegalStateException("Unknown result value produced by eval4j");
            }
            Value jdiValue = ((ValueReturned)$this$toJdiValue).getResult();
            VariableFinder.Result sharedVar = jdiValue instanceof AbstractValue ? this.getValueIfSharedVar(jdiValue) : null;
            Object object = sharedVar;
            if (object == null || (object = ((VariableFinder.Result)object).getValue()) == null) {
                object = JdiValuesKt.asJdiValue(jdiValue, context2.getVm().getVirtualMachine(), jdiValue.getAsmType());
            }
            return object;
        }

        private final VariableFinder.Result getValueIfSharedVar(Value value2) {
            Object object = ValuesKt.obj(value2, value2.getAsmType());
            ObjectReference objectReference = object instanceof ObjectReference ? (ObjectReference)object : null;
            if (objectReference == null) {
                return null;
            }
            ObjectReference obj = objectReference;
            return new VariableFinder.Result(EvaluatorValueConverter.Companion.unref(obj));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ExceptionThrown.ExceptionKind.values().length];
                try {
                    nArray[ExceptionThrown.ExceptionKind.FROM_EVALUATED_CODE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExceptionThrown.ExceptionKind.BROKEN_CODE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

