/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinExpressionWrapper;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentEditor;", "", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "expressionWrappers", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinExpressionWrapper;", "addWrapper", "wrapper", "editCodeFragment", "", "extractExpressionWithText", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "replaceExpression", "", "expression", "newExpressionText", "Companion", "kotlin.jvm-debugger.evaluation"})
public final class KotlinCodeFragmentEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtCodeFragment codeFragment;
    @NotNull
    private final List<KotlinExpressionWrapper> expressionWrappers;
    @NotNull
    private static final Logger LOG = Logger.getInstance(KotlinCodeFragmentEditor.class);

    public KotlinCodeFragmentEditor(@NotNull KtCodeFragment codeFragment) {
        this.codeFragment = codeFragment;
        this.expressionWrappers = new ArrayList();
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @NotNull
    public final KotlinCodeFragmentEditor addWrapper(@NotNull KotlinExpressionWrapper wrapper) {
        this.expressionWrappers.add(wrapper);
        return this;
    }

    public final boolean editCodeFragment() {
        Pair<KtExpression, String> pair = this.extractExpressionWithText();
        if (pair == null) {
            return false;
        }
        Pair<KtExpression, String> pair2 = pair;
        KtExpression expression2 = (KtExpression)pair2.component1();
        String expressionText2 = (String)pair2.component2();
        boolean expressionWasWrapped = false;
        String newExpressionText = expressionText2;
        for (KotlinExpressionWrapper wrapper : this.expressionWrappers) {
            if (!wrapper.isApplicable(expression2)) continue;
            expressionWasWrapped = true;
            newExpressionText = wrapper.createWrappedExpressionText(newExpressionText);
        }
        if (expressionWasWrapped) {
            this.replaceExpression(expression2, newExpressionText);
        }
        return expressionWasWrapped;
    }

    private final void replaceExpression(KtExpression expression2, String newExpressionText) {
        boolean $i$f$runReadAction = false;
        KtExpression newExpression2 = (KtExpression)ApplicationManager.getApplication().runReadAction(new Computable(expression2, newExpressionText){
            final /* synthetic */ KtExpression $expression$inlined;
            final /* synthetic */ String $newExpressionText$inlined;
            {
                this.$expression$inlined = ktExpression;
                this.$newExpressionText$inlined = string2;
            }

            public final T compute() {
                boolean bl = false;
                return (T)new KtPsiFactory(this.$expression$inlined.getProject(), false, 2, null).createExpression(this.$newExpressionText$inlined);
            }
        });
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(expression2, newExpression2){
            final /* synthetic */ KtExpression $expression;
            final /* synthetic */ KtExpression $newExpression;
            {
                this.$expression = $expression;
                this.$newExpression = $newExpression;
                super(0);
            }

            public final void invoke() {
                ApplicationUtilsKt.executeWriteCommand(this.$expression.getProject(), KotlinDebuggerEvaluationBundle.message("wrap.expression", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>(this.$expression, this.$newExpression){
                    final /* synthetic */ KtExpression $expression;
                    final /* synthetic */ KtExpression $newExpression;
                    {
                        this.$expression = $expression;
                        this.$newExpression = $newExpression;
                        super(0);
                    }

                    public final void invoke() {
                        this.$expression.replace((PsiElement)this.$newExpression);
                    }
                }));
            }
        }), (int)1, null);
    }

    private final Pair<KtExpression, String> extractExpressionWithText() {
        boolean $i$f$runReadAction = false;
        return (Pair)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ KotlinCodeFragmentEditor this$0;
            {
                this.this$0 = kotlinCodeFragmentEditor;
            }

            public final T compute() {
                KtExpression expression2;
                boolean bl = false;
                KtCodeFragment ktCodeFragment = this.this$0.getCodeFragment();
                if (ktCodeFragment instanceof KtExpressionCodeFragment) {
                    v0 = ((KtExpressionCodeFragment)this.this$0.getCodeFragment()).getContentElement();
                } else if (ktCodeFragment instanceof KtBlockCodeFragment) {
                    v0 = (KtExpression)CollectionsKt.lastOrNull((List)((KtBlockCodeFragment)this.this$0.getCodeFragment()).getContentElement().getStatements());
                } else {
                    KotlinCodeFragmentEditor.access$getLOG$cp().error("Invalid code fragment type: " + this.this$0.getClass());
                    v0 = expression2 = null;
                }
                return (T)(expression2 == null ? null : new Pair((Object)expression2, (Object)expression2.getText()));
            }
        });
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentEditor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

