/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.j2k.J2KUtilsKt;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0018\u00010\fR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u00060\fR\u00020\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo;", "", "project", "Lcom/intellij/openapi/project/Project;", "thisObject", "Lcom/sun/jdi/Value;", "variables", "", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "(Lcom/intellij/openapi/project/Project;Lcom/sun/jdi/Value;Ljava/util/Map;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo$Variable;", "getThisObject", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo$Variable;", "", "getVariables", "()Ljava/util/List;", "Companion", "Variable", "kotlin.jvm-debugger.evaluation"})
public final class FrameInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final Variable thisObject;
    @NotNull
    private final List<Variable> variables;
    @NotNull
    private static final String FAKE_JAVA_THIS_NAME = "$this$_java_locals_debug_fun_";

    /*
     * WARNING - void declaration
     */
    private FrameInfo(Project project, Value thisObject, Map<LocalVariableProxyImpl, ? extends Value> variables) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$thisObject_u24lambda_u240;
        this.project = project;
        FrameInfo frameInfo = this;
        FrameInfo frameInfo2 = this;
        boolean $i$a$-run-FrameInfo$thisObject$22 = false;
        frameInfo2.thisObject = thisObject == null ? null : (FrameInfo)$this$thisObject_u24lambda_u240.new Variable(FAKE_JAVA_THIS_NAME, thisObject.type().name(), thisObject);
        Map<LocalVariableProxyImpl, ? extends Value> map2 = variables;
        frameInfo2 = this;
        boolean $i$f$map = false;
        void $i$a$-run-FrameInfo$thisObject$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LocalVariableProxyImpl v = (LocalVariableProxyImpl)entry.getKey();
            Value value2 = (Value)entry.getValue();
            collection.add(new Variable(v.name(), v.typeName(), value2));
        }
        frameInfo2.variables = (List)destination$iv$iv;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Variable getThisObject() {
        return this.thisObject;
    }

    @NotNull
    public final List<Variable> getVariables() {
        return this.variables;
    }

    public /* synthetic */ FrameInfo(Project project, Value thisObject, Map variables, DefaultConstructorMarker $constructor_marker) {
        this(project, thisObject, variables);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo$Companion;", "", "()V", "FAKE_JAVA_THIS_NAME", "", "collectVariableValues", "", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "Lcom/sun/jdi/Value;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "createKotlinProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "project", "Lcom/intellij/openapi/project/Project;", "name", "typeName", "value", "from", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo;", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrameInfo from(@NotNull Project project, @Nullable StackFrameProxyImpl frameProxy) {
            if (frameProxy == null) {
                return new FrameInfo(project, null, MapsKt.emptyMap(), null);
            }
            Map<LocalVariableProxyImpl, Value> variableValues = this.collectVariableValues(frameProxy);
            ObjectReference objectReference = SafeUtilKt.safeThisObject(frameProxy);
            if (objectReference == null) {
                throw new AbsentInformationException();
            }
            ObjectReference thisObject = objectReference;
            return new FrameInfo(project, thisObject, variableValues, null);
        }

        private final Map<LocalVariableProxyImpl, Value> collectVariableValues(StackFrameProxyImpl frameProxy) {
            List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(frameProxy);
            HashMap values2 = new HashMap(variables.size());
            for (LocalVariableProxyImpl variable2 : variables) {
                Value value2;
                if (frameProxy.getValue(variable2) == null) continue;
                ((Map)values2).put(variable2, value2);
            }
            return values2;
        }

        private final KtProperty createKotlinProperty(Project project, String name2, String typeName, Value value2) {
            KtProperty ktProperty;
            block0: {
                String className = StringsKt.substringBefore$default((String)StringsKt.replace$default((String)typeName, (String)"$", (String)".", (boolean)false, (int)4, null), (String)"[]", null, (int)2, null);
                PsiClassType classType = PsiType.getTypeByName((String)className, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                String elementType = !(value2 instanceof PrimitiveValue) && classType.resolve() == null ? "java.lang.Object" : className;
                Object propertyType = value2 instanceof ArrayReference ? elementType + "[]" : elementType;
                PsiClassType psiType = PsiType.getTypeByName((String)propertyType, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                PsiField field2 = PsiElementFactory.getInstance((Project)project).createField(name2, (PsiType)psiType);
                KtNamedDeclaration ktNamedDeclaration = J2KUtilsKt.j2k$default((PsiMember)field2, null, 1, null);
                ktProperty = ktNamedDeclaration instanceof KtProperty ? (KtProperty)ktNamedDeclaration : null;
                KtProperty ktProperty2 = ktProperty;
                if (ktProperty2 == null || (ktProperty2 = ktProperty2.getModifierList()) == null) break block0;
                ktProperty2.delete();
            }
            return ktProperty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo$Variable;", "", "name", "", "typeName", "value", "Lcom/sun/jdi/Value;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo;Ljava/lang/String;Ljava/lang/String;Lcom/sun/jdi/Value;)V", "getName", "()Ljava/lang/String;", "getTypeName", "getValue", "()Lcom/sun/jdi/Value;", "asProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "kotlin.jvm-debugger.evaluation"})
    public final class Variable {
        @NotNull
        private final String name;
        @NotNull
        private final String typeName;
        @Nullable
        private final Value value;

        public Variable(@NotNull String name2, @Nullable String typeName, Value value2) {
            this.name = name2;
            this.typeName = typeName;
            this.value = value2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getTypeName() {
            return this.typeName;
        }

        @Nullable
        public final Value getValue() {
            return this.value;
        }

        @Nullable
        public final KtProperty asProperty() {
            if (!PsiNameHelper.getInstance((Project)FrameInfo.this.getProject()).isIdentifier(this.name)) {
                return null;
            }
            return Companion.createKotlinProperty(FrameInfo.this.getProject(), this.name, this.typeName, this.value);
        }
    }
}

