/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.dfaassist;

import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.debugger.engine.dfaassist.DebuggerDfaListener;
import com.intellij.debugger.engine.dfaassist.DfaAssistProvider;
import com.intellij.debugger.engine.dfaassist.DfaHint;
import com.intellij.debugger.engine.jdi.LocalVariableProxy;
import com.intellij.debugger.jdi.StackFrameProxyEx;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ThreeState;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculator;
import org.jetbrains.kotlin.idea.debugger.dfaassist.KotlinDfaAssistProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinAnchor;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinConstantConditionsInspection;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinProblem;
import org.jetbrains.kotlin.idea.inspections.dfa.KtClassDef;
import org.jetbrains.kotlin.idea.inspections.dfa.KtThisDescriptor;
import org.jetbrains.kotlin.idea.inspections.dfa.KtVariableDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/dfaassist/KotlinDfaAssistProvider;", "Lcom/intellij/debugger/engine/dfaassist/DfaAssistProvider;", "()V", "constraintFromJvmClassName", "Lcom/intellij/codeInspection/dataFlow/TypeConstraint;", "anchor", "Lcom/intellij/psi/PsiElement;", "jvmClassName", "", "createListener", "Lcom/intellij/debugger/engine/dfaassist/DebuggerDfaListener;", "getAnchor", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "getCodeBlock", "getJdiValueForDfaVariable", "Lcom/sun/jdi/Value;", "proxy", "Lcom/intellij/debugger/jdi/StackFrameProxyEx;", "dfaVar", "Lcom/intellij/codeInspection/dataFlow/value/DfaVariableValue;", "locationMatches", "", "location", "Lcom/sun/jdi/Location;", "postprocess", "value", "kotlin.jvm-debugger.evaluation"})
public final class KotlinDfaAssistProvider
implements DfaAssistProvider {
    public boolean locationMatches(@NotNull PsiElement element3, @NotNull Location location2) {
        String string2;
        String jdiClassName;
        block2: {
            jdiClassName = location2.method().declaringType().name();
            PsiFile file2 = element3.getContainingFile();
            if (!(file2 instanceof KtFile)) {
                return false;
            }
            Map<KtElement, String> classNames = ClassNameCalculator.INSTANCE.getClassNames((KtFile)file2);
            for (PsiElement e : PsiUtilsKt.getParentsWithSelf((PsiElement)element3)) {
                boolean bl = false;
                String string3 = classNames.get(e);
                if (string3 == null) continue;
                string2 = string3;
                break block2;
            }
            string2 = null;
        }
        String psiClassName = string2;
        return Intrinsics.areEqual(psiClassName, (Object)jdiClassName);
    }

    @Nullable
    public KtExpression getAnchor(@NotNull PsiElement element3) {
        PsiElement cur = element3;
        while (cur instanceof PsiWhiteSpace || cur instanceof PsiComment) {
            cur = cur.getNextSibling();
        }
        while (true) {
            PsiElement parent2;
            if ((parent2 = cur.getParent()) instanceof KtBlockExpression || parent2 instanceof KtFunction) {
                PsiElement psiElement2 = cur;
                return psiElement2 instanceof KtExpression ? (KtExpression)psiElement2 : null;
            }
            if (parent2 == null || cur.getStartOffsetInParent() > 0) {
                return null;
            }
            cur = parent2;
        }
    }

    @Nullable
    public KtExpression getCodeBlock(@NotNull PsiElement anchor) {
        if (!(anchor instanceof KtExpression)) {
            return null;
        }
        PsiElement parent2 = ((KtExpression)anchor).getParent();
        if (parent2 instanceof KtBlockExpression) {
            return (KtExpression)parent2;
        }
        if (parent2 instanceof KtFunction) {
            return (KtExpression)anchor;
        }
        return null;
    }

    @Nullable
    public Value getJdiValueForDfaVariable(@NotNull StackFrameProxyEx proxy, @NotNull DfaVariableValue dfaVar, @NotNull PsiElement anchor) {
        DfaVariableValue qualifier2 = dfaVar.getQualifier();
        PsiElement psiVariable = dfaVar.getPsiVariable();
        if (qualifier2 == null) {
            LocalVariableProxy variable2;
            VariableDescriptor descriptor2 = dfaVar.getDescriptor();
            if (descriptor2 instanceof KtThisDescriptor) {
                String jvmName;
                String signature2;
                DeclarationDescriptor declarationDescriptor = ((KtThisDescriptor)descriptor2).getDescriptor();
                if (declarationDescriptor instanceof FunctionDescriptor) {
                    String thisName = "$this$" + ((FunctionDescriptor)declarationDescriptor).getName();
                    LocalVariableProxy thisVar = proxy.visibleVariableByName(thisName);
                    if (thisVar != null) {
                        return this.postprocess(proxy.getVariableValue(thisVar));
                    }
                    return null;
                }
                ObjectReference thisObject = proxy.thisObject();
                if (thisObject != null && Intrinsics.areEqual((Object)(signature2 = Type.getType((String)thisObject.referenceType().signature()).getClassName()), (Object)(jvmName = KotlinPsiHeuristics.getJvmName(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)declarationDescriptor))))) {
                    return thisObject;
                }
                return null;
            }
            if (descriptor2 instanceof KtVariableDescriptor && psiVariable instanceof KtCallableDeclaration && (variable2 = proxy.visibleVariableByName(((KtNamedDeclaration)psiVariable).getName())) != null) {
                return this.postprocess(proxy.getVariableValue(variable2));
            }
        } else {
            ReferenceType type2;
            Field field2;
            Value jdiQualifier = this.getJdiValueForDfaVariable(proxy, qualifier2, anchor);
            if (jdiQualifier instanceof ObjectReference && psiVariable instanceof KtCallableDeclaration && (field2 = (type2 = ((ObjectReference)jdiQualifier).referenceType()).fieldByName(((KtCallableDeclaration)psiVariable).getName())) != null) {
                return this.postprocess(((ObjectReference)jdiQualifier).getValue(field2));
            }
        }
        return null;
    }

    private final Value postprocess(Value value2) {
        return DfaAssistProvider.wrap((Value)EvaluatorValueConverter.Companion.unref(value2));
    }

    @NotNull
    public DebuggerDfaListener createListener() {
        return new DebuggerDfaListener(){
            @NotNull
            private final HashMap<PsiElement, DfaHint> hints;
            {
                this.hints = new HashMap<K, V>();
            }

            @NotNull
            public final HashMap<PsiElement, DfaHint> getHints() {
                return this.hints;
            }

            public void beforePush(@NotNull DfaValue[] args, @NotNull DfaValue value2, @NotNull DfaAnchor anchor, @NotNull DfaMemoryState state) {
                KtElement ktElement;
                DfType dfType = state.getDfType(value2);
                DfaAnchor dfaAnchor = anchor;
                if (dfaAnchor instanceof KotlinAnchor.KotlinExpressionAnchor) {
                    if (!this.shouldTrackExpressionValue(((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression()) || KotlinConstantConditionsInspection.Companion.shouldSuppress(dfType, ((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression())) {
                        return;
                    }
                    ktElement = (KtElement)((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression();
                } else if (dfaAnchor instanceof KotlinAnchor.KotlinWhenConditionAnchor) {
                    ktElement = (KtElement)((KotlinAnchor.KotlinWhenConditionAnchor)anchor).getCondition();
                } else {
                    return;
                }
                KtElement psi2 = ktElement;
                DfaHint hint = DfaHint.ANY_VALUE;
                if (dfType == DfTypes.TRUE) {
                    hint = DfaHint.TRUE;
                } else if (dfType == DfTypes.FALSE) {
                    hint = DfaHint.FALSE;
                } else if (dfType == DfTypes.NULL) {
                    PsiElement parent2 = psi2.getParent();
                    if (parent2 instanceof KtPostfixExpression && Intrinsics.areEqual((Object)((KtPostfixExpression)parent2).getOperationToken(), (Object)KtTokens.EXCLEXCL)) {
                        hint = DfaHint.NPE;
                    } else if (parent2 instanceof KtBinaryExpressionWithTypeRHS && ((KtBinaryExpressionWithTypeRHS)parent2).getOperationReference().textMatches((CharSequence)"as")) {
                        KotlinType type2;
                        KtTypeReference typeReference2;
                        KtTypeReference ktTypeReference = typeReference2 = ((KtBinaryExpressionWithTypeRHS)parent2).getRight();
                        KotlinType kotlinType = type2 = ktTypeReference != null ? BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)ktTypeReference, (BindingContext)ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)typeReference2, BodyResolveMode.FULL)) : null;
                        if (type2 != null && !type2.isMarkedNullable()) {
                            hint = DfaHint.NPE;
                            psi2 = (KtElement)((KtBinaryExpressionWithTypeRHS)parent2).getOperationReference();
                        }
                    } else if (parent2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationToken(), (Object)KtTokens.ELVIS)) {
                        hint = DfaHint.NULL;
                    } else if (psi2 instanceof KtBinaryExpressionWithTypeRHS && ((KtBinaryExpressionWithTypeRHS)psi2).getOperationReference().textMatches((CharSequence)"as?")) {
                        hint = DfaHint.NULL;
                    }
                }
                this.hints.merge((PsiElement)psi2, hint, (arg_0, arg_1) -> createListener.1.beforePush$lambda$0(createListener.beforePush.1.INSTANCE, arg_0, arg_1));
            }

            public void onCondition(@NotNull UnsatisfiedConditionProblem problem, @NotNull DfaValue value2, @NotNull ThreeState failed, @NotNull DfaMemoryState state) {
                if (problem instanceof KotlinProblem.KotlinCastProblem) {
                    this.hints.merge((PsiElement)((KotlinProblem.KotlinCastProblem)problem).getCast().getOperationReference(), failed == ThreeState.YES ? DfaHint.CCE : DfaHint.NONE, (arg_0, arg_1) -> createListener.1.onCondition$lambda$1(createListener.onCondition.1.INSTANCE, arg_0, arg_1));
                }
            }

            private final boolean shouldTrackExpressionValue(KtExpression expr) {
                if (expr instanceof KtBinaryExpression) {
                    IElementType token = ((KtBinaryExpression)expr).getOperationToken();
                    if (Intrinsics.areEqual((Object)token, (Object)KtTokens.EQ)) {
                        return false;
                    }
                    if (Intrinsics.areEqual((Object)token, (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)token, (Object)KtTokens.OROR)) {
                        return false;
                    }
                }
                PsiElement parent2 = expr.getParent();
                while (parent2 instanceof KtParenthesizedExpression) {
                    parent2 = ((KtParenthesizedExpression)parent2).getParent();
                }
                PsiElement psiElement2 = parent2;
                KtPrefixExpression ktPrefixExpression = psiElement2 instanceof KtPrefixExpression ? (KtPrefixExpression)psiElement2 : null;
                return !Intrinsics.areEqual((Object)(ktPrefixExpression != null ? ktPrefixExpression.getOperationToken() : null), (Object)KtTokens.EXCL);
            }

            @NotNull
            public Map<PsiElement, DfaHint> computeHints() {
                this.hints.values().removeIf(arg_0 -> createListener.1.computeHints$lambda$2(createListener.computeHints.1.INSTANCE, arg_0));
                return this.hints;
            }

            private static final DfaHint beforePush$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                return (DfaHint)$tmp0.invoke(p0, p1);
            }

            private static final DfaHint onCondition$lambda$1(Function2 $tmp0, Object p0, Object p1) {
                return (DfaHint)$tmp0.invoke(p0, p1);
            }

            private static final boolean computeHints$lambda$2(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }

    @NotNull
    public TypeConstraint constraintFromJvmClassName(@NotNull PsiElement anchor, @NotNull String jvmClassName) {
        Intrinsics.checkNotNull((Object)anchor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
        TypeConstraints.ClassDef classDef2 = KtClassDef.Companion.fromJvmClassName((KtElement)anchor, jvmClassName);
        if (classDef2 == null) {
            return TypeConstraints.TOP;
        }
        TypeConstraints.ClassDef classDef3 = classDef2;
        return (TypeConstraint)TypeConstraints.exactClass((TypeConstraints.ClassDef)classDef3);
    }
}

