/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineDebugProbesProxy;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineFrameBuilder;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CreateContentParams;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CreateContentParamsProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.XDebugSessionListenerProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineSelectedNodeListener;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineView;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineViewDebugSessionListener;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineViewKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIcon;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIconPresentationRenderer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 42\u00020\u00012\u00020\u00022\u00020\u0003:\f456789:;<=>?B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00020$0#H\u0002J\b\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u001bH\u0016J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.H\u0002J\u000e\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u00020\u001bJ\u0006\u00103\u001a\u00020\u001bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/XDebugSessionListenerProvider;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CreateContentParamsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "javaDebugProcess", "Lcom/intellij/debugger/engine/JavaDebugProcess;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/debugger/engine/JavaDebugProcess;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "getAlarm", "()Lcom/intellij/util/SingleAlarm;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "Lorg/jetbrains/annotations/NotNull;", "mainPanel", "Ljavax/swing/JPanel;", "panel", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel;", "renderer", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIconPresentationRenderer;", "restorer", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRestorer;", "treeState", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState;", "applyRenderer", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "presentation", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;", "createContentParams", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CreateContentParams;", "createRenderer", "Lcom/intellij/ui/SimpleListCellRenderer;", "", "createToolbar", "Lcom/intellij/openapi/actionSystem/impl/ActionToolbarImpl;", "debugSessionListener", "Lcom/intellij/xdebugger/XDebugSessionListener;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "dispose", "installClickAndKeyListeners", "tree", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;", "renewRoot", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "resetRoot", "saveState", "Companion", "CoroutineContainer", "CoroutineFrameValue", "CoroutineGroupContainer", "CoroutineTopGroupContainer", "CreationFramesContainer", "EmptyNode", "ErrorNode", "FramesContainer", "InfoNode", "RendererContainer", "XCoroutinesRootNode", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineView
implements Disposable,
XDebugSessionListenerProvider,
CreateContentParamsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SingleAlarm alarm = new SingleAlarm(() -> CoroutineView.alarm$lambda$0(this), 100, (Disposable)this, null, null, 24, null);
    @NotNull
    private final DebugProcessImpl debugProcess;
    @NotNull
    private final SimpleColoredTextIconPresentationRenderer renderer;
    @NotNull
    private final JPanel mainPanel;
    @Nullable
    private XDebuggerTreeState treeState;
    @Nullable
    private XDebuggerTreeRestorer restorer;
    @NotNull
    private final XDebuggerTreePanel panel;
    private static final int VIEW_CLEAR_DELAY_MS = 100;
    @NotNull
    private static final String EMPTY_DISPATCHER_NAME = KotlinDebuggerCoroutinesBundle.message("coroutine.view.dispatcher.empty", new Object[0]);
    @NotNull
    private static final ReadOnlyProperty<Object, Logger> log$delegate = ProvidersKt.getLogger();

    public CoroutineView(@NotNull Project project, @NotNull JavaDebugProcess javaDebugProcess) {
        this.debugProcess = javaDebugProcess.getDebuggerSession().getProcess();
        this.renderer = new SimpleColoredTextIconPresentationRenderer();
        this.mainPanel = new JPanel(new BorderLayout());
        this.panel = new XDebuggerTreePanel(project, javaDebugProcess.getEditorsProvider(), (Disposable)this, null, "Kotlin.XDebugger.Actions", null);
        ComboBox combobox2 = new ComboBox();
        combobox2.setRenderer((ListCellRenderer)this.createRenderer());
        combobox2.addItem(null);
        ActionToolbarImpl toolbar2 = this.createToolbar();
        Wrapper threadsPanel = new Wrapper();
        threadsPanel.setBorder((Border)new CustomLineBorder(0, 0, 1, 0));
        threadsPanel.add((Component)toolbar2.getComponent(), (Object)"East");
        threadsPanel.add((Component)combobox2, (Object)"Center");
        this.mainPanel.add((Component)this.panel.getMainPanel(), "Center");
        this.installClickAndKeyListeners(this.panel.getTree());
    }

    @NotNull
    public final SingleAlarm getAlarm() {
        return this.alarm;
    }

    public final void saveState() {
        DebuggerUIUtil.invokeLater(() -> CoroutineView.saveState$lambda$1(this));
    }

    public final void resetRoot() {
        DebuggerUIUtil.invokeLater(() -> CoroutineView.resetRoot$lambda$2(this));
    }

    public final void renewRoot(@NotNull SuspendContextImpl suspendContext) {
        this.panel.getTree().setRoot((XDebuggerTreeNode)new XCoroutinesRootNode(suspendContext), false);
        if (this.treeState != null) {
            XDebuggerTreeRestorer xDebuggerTreeRestorer = this.restorer;
            if (xDebuggerTreeRestorer != null) {
                xDebuggerTreeRestorer.dispose();
            }
            XDebuggerTreeState xDebuggerTreeState = this.treeState;
            this.restorer = xDebuggerTreeState != null ? xDebuggerTreeState.restoreState(this.panel.getTree()) : null;
        }
    }

    public void dispose() {
        if (this.restorer != null) {
            XDebuggerTreeRestorer xDebuggerTreeRestorer = this.restorer;
            if (xDebuggerTreeRestorer != null) {
                xDebuggerTreeRestorer.dispose();
            }
            this.restorer = null;
        }
    }

    @Override
    @NotNull
    public XDebugSessionListener debugSessionListener(@NotNull XDebugSession session) {
        return new CoroutineViewDebugSessionListener(session, this);
    }

    @Override
    @NotNull
    public CreateContentParams createContentParams() {
        return new CreateContentParams("XCoroutineThreadsContent", this.mainPanel, KotlinDebuggerCoroutinesBundle.message("coroutine.view.title", new Object[0]), null, (JComponent)this.panel.getTree());
    }

    private final SimpleListCellRenderer<? super String> createRenderer() {
        return SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> CoroutineView.createRenderer$lambda$3(createRenderer.1.INSTANCE, arg_0, arg_1, arg_2));
    }

    private final ActionToolbarImpl createToolbar() {
        DefaultActionGroup framesGroup = new DefaultActionGroup();
        AnAction[] anActionArray = new AnAction[]{ActionManager.getInstance().getAction("XDebugger.Frames.TopToolbar")};
        framesGroup.addAll(anActionArray);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("DebuggerToolbar", (ActionGroup)framesGroup, true);
        Intrinsics.checkNotNull((Object)actionToolbar, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.impl.ActionToolbarImpl");
        ActionToolbarImpl toolbar2 = (ActionToolbarImpl)actionToolbar;
        toolbar2.setReservePlaceAutoPopupIcon(false);
        return toolbar2;
    }

    private final void applyRenderer(XValueNode node2, SimpleColoredTextIcon presentation) {
        node2.setPresentation(presentation.getIcon(), presentation.valuePresentation(), presentation.getHasChildren());
    }

    private final void installClickAndKeyListeners(XDebuggerTree tree2) {
        new CoroutineSelectedNodeListener(this.debugProcess, tree2).install();
    }

    private static final void alarm$lambda$0(CoroutineView this$0) {
        this$0.resetRoot();
    }

    private static final void saveState$lambda$1(CoroutineView this$0) {
        if (!(this$0.panel.getTree().getRoot() instanceof EmptyNode)) {
            this$0.treeState = XDebuggerTreeState.saveState((XDebuggerTree)this$0.panel.getTree());
        }
    }

    private static final void resetRoot$lambda$2(CoroutineView this$0) {
        this$0.panel.getTree().setRoot((XDebuggerTreeNode)this$0.new EmptyNode(), false);
    }

    private static final void createRenderer$lambda$3(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
        $tmp0.invoke((Object)p0, p1, (Object)p2);
    }

    public static final /* synthetic */ String access$getEMPTY_DISPATCHER_NAME$cp() {
        return EMPTY_DISPATCHER_NAME;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$Companion;", "", "()V", "EMPTY_DISPATCHER_NAME", "", "VIEW_CLEAR_DELAY_MS", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$EmptyNode;", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode;", "Lcom/intellij/xdebugger/frame/XValueContainer;", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;)V", "kotlin.jvm-debugger.coroutines"})
    public final class EmptyNode
    extends XValueContainerNode<XValueContainer> {
        public EmptyNode() {
            super(CoroutineView.this.panel.getTree(), null, true, new XValueContainer(){});
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$XCoroutinesRootNode;", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineTopGroupContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "kotlin.jvm-debugger.coroutines"})
    public final class XCoroutinesRootNode
    extends XValueContainerNode<CoroutineTopGroupContainer> {
        public XCoroutinesRootNode(SuspendContextImpl suspendContext) {
            super(CoroutineView.this.panel.getTree(), null, false, (XValueContainer)new CoroutineTopGroupContainer(suspendContext));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineTopGroupContainer;", "Lcom/intellij/xdebugger/frame/XValueContainer;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "getSuspendContext", "()Lcom/intellij/debugger/engine/SuspendContextImpl;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "kotlin.jvm-debugger.coroutines"})
    public final class CoroutineTopGroupContainer
    extends XValueContainer {
        @NotNull
        private final SuspendContextImpl suspendContext;

        public CoroutineTopGroupContainer(SuspendContextImpl suspendContext) {
            this.suspendContext = suspendContext;
        }

        @NotNull
        public final SuspendContextImpl getSuspendContext() {
            return this.suspendContext;
        }

        public void computeChildren(@NotNull XCompositeNode node2) {
            XValueChildrenList children2 = new XValueChildrenList();
            children2.add((XNamedValue)new CoroutineGroupContainer(this.suspendContext));
            node2.addChildren(children2, true);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineGroupContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "getSuspendContext", "()Lcom/intellij/debugger/engine/SuspendContextImpl;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "kotlin.jvm-debugger.coroutines"})
    public final class CoroutineGroupContainer
    extends RendererContainer {
        @NotNull
        private final SuspendContextImpl suspendContext;

        public CoroutineGroupContainer(SuspendContextImpl suspendContext) {
            super(CoroutineView.this.renderer.renderGroup(KotlinDebuggerCoroutinesBundle.message("coroutine.view.node.root", new Object[0])));
            this.suspendContext = suspendContext;
        }

        @NotNull
        public final SuspendContextImpl getSuspendContext() {
            return this.suspendContext;
        }

        public void computeChildren(@NotNull XCompositeNode node2) {
            if (this.suspendContext.getSuspendPolicy() != 2) {
                node2.addChildren(XValueChildrenList.singleton((XNamedValue)new ErrorNode("to.enable.information.breakpoint.suspend.policy.should.be.set.to.all.threads")), true);
                return;
            }
            CoroutineViewKt.access$invokeInSuspendContext(CoroutineView.this.debugProcess, this.suspendContext, (Function1)new Function1<SuspendContextImpl, Unit>(CoroutineView.this, node2){
                final /* synthetic */ CoroutineView this$0;
                final /* synthetic */ XCompositeNode $node;
                {
                    this.this$0 = $receiver;
                    this.$node = $node;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull SuspendContextImpl suspendContext) {
                    void $this$groupByTo$iv$iv;
                    CoroutineDebugProbesProxy debugProbesProxy = new CoroutineDebugProbesProxy(suspendContext);
                    CoroutineInfoCache coroutineCache = debugProbesProxy.dumpCoroutines();
                    if (!coroutineCache.isOk()) {
                        ErrorNode errorNode = this.this$0.new ErrorNode("coroutine.view.fetching.error");
                        this.$node.addChildren(XValueChildrenList.singleton((XNamedValue)errorNode), true);
                        return;
                    }
                    XValueChildrenList children2 = new XValueChildrenList();
                    Iterable $this$groupBy$iv = coroutineCache.getCache();
                    boolean $i$f$groupBy = false;
                    Iterable iterable = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object;
                        CoroutineInfoData it = (CoroutineInfoData)element$iv$iv;
                        boolean bl = false;
                        String key$iv$iv = it.getDescriptor().getDispatcher();
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    Map groups = destination$iv$iv;
                    for (String dispatcher : groups.keySet()) {
                        String string2 = dispatcher;
                        if (string2 == null) {
                            string2 = CoroutineView.access$getEMPTY_DISPATCHER_NAME$cp();
                        }
                        children2.add((XNamedValue)this.this$0.new CoroutineContainer(suspendContext, string2, (List)groups.get(dispatcher)));
                    }
                    if (children2.size() > 0) {
                        this.$node.addChildren(children2, true);
                    } else {
                        this.$node.addChildren(XValueChildrenList.singleton((XNamedValue)this.this$0.new InfoNode("coroutine.view.fetching.not_found")), true);
                    }
                }
            });
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "groupName", "", "coroutines", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;Ljava/lang/String;Ljava/util/List;)V", "getCoroutines", "()Ljava/util/List;", "getSuspendContext", "()Lcom/intellij/debugger/engine/SuspendContextImpl;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "kotlin.jvm-debugger.coroutines"})
    public final class CoroutineContainer
    extends RendererContainer {
        @NotNull
        private final SuspendContextImpl suspendContext;
        @NotNull
        private final String groupName;
        @Nullable
        private final List<CoroutineInfoData> coroutines;

        public CoroutineContainer(@NotNull SuspendContextImpl suspendContext, @Nullable String groupName, List<? extends CoroutineInfoData> coroutines) {
            super(CoroutineView.this.renderer.renderGroup(groupName));
            this.suspendContext = suspendContext;
            this.groupName = groupName;
            this.coroutines = coroutines;
        }

        @NotNull
        public final SuspendContextImpl getSuspendContext() {
            return this.suspendContext;
        }

        @Nullable
        public final List<CoroutineInfoData> getCoroutines() {
            return this.coroutines;
        }

        /*
         * WARNING - void declaration
         */
        public void computeChildren(@NotNull XCompositeNode node2) {
            XValueChildrenList children2 = new XValueChildrenList();
            List<CoroutineInfoData> list2 = this.coroutines;
            if (list2 != null) {
                void $this$forEach$iv;
                Iterable iterable = list2;
                CoroutineView coroutineView = CoroutineView.this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CoroutineInfoData it = (CoroutineInfoData)element$iv;
                    boolean bl = false;
                    children2.add((XNamedValue)coroutineView.new FramesContainer(it, this.suspendContext));
                }
            }
            if (children2.size() > 0) {
                node2.addChildren(children2, true);
            } else {
                node2.addChildren(XValueChildrenList.singleton((XNamedValue)new InfoNode("coroutine.view.fetching.not_found")), true);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$InfoNode;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "error", "", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "kotlin.jvm-debugger.coroutines"})
    public final class InfoNode
    extends RendererContainer {
        @NotNull
        private final String error;

        public InfoNode(String error2) {
            super(CoroutineView.this.renderer.renderInfoNode(error2));
            this.error = error2;
        }

        @NotNull
        public final String getError() {
            return this.error;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$ErrorNode;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "error", "", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "kotlin.jvm-debugger.coroutines"})
    public final class ErrorNode
    extends RendererContainer {
        @NotNull
        private final String error;

        public ErrorNode(String error2) {
            super(CoroutineView.this.renderer.renderErrorNode(error2));
            this.error = error2;
        }

        @NotNull
        public final String getError() {
            return this.error;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$FramesContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "infoData", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "kotlin.jvm-debugger.coroutines"})
    public final class FramesContainer
    extends RendererContainer {
        @NotNull
        private final CoroutineInfoData infoData;
        @NotNull
        private final SuspendContextImpl suspendContext;

        public FramesContainer(@NotNull CoroutineInfoData infoData, SuspendContextImpl suspendContext) {
            super(CoroutineView.this.renderer.render(infoData));
            this.infoData = infoData;
            this.suspendContext = suspendContext;
        }

        public void computeChildren(@NotNull XCompositeNode node2) {
            CoroutineViewKt.access$invokeInSuspendContext(CoroutineView.this.debugProcess, this.suspendContext, (Function1)new Function1<SuspendContextImpl, Unit>(this, node2, CoroutineView.this){
                final /* synthetic */ FramesContainer this$0;
                final /* synthetic */ XCompositeNode $node;
                final /* synthetic */ CoroutineView this$1;
                {
                    this.this$0 = $receiver;
                    this.$node = $node;
                    this.this$1 = $receiver2;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull SuspendContextImpl suspendContext) {
                    Object object;
                    CoroutineView coroutineView;
                    Object object2;
                    XValueChildrenList children2 = new XValueChildrenList();
                    CoroutineFrameBuilder.Companion.CoroutineFrameItemLists doubleFrameList = CoroutineFrameBuilder.Companion.build(FramesContainer.access$getInfoData$p(this.this$0), suspendContext);
                    Object object3 = doubleFrameList;
                    if (object3 != null && (object3 = ((CoroutineFrameBuilder.Companion.CoroutineFrameItemLists)object3).getFrames()) != null) {
                        void $this$forEach$iv;
                        object2 = (Iterable)object3;
                        coroutineView = this.this$1;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            CoroutineStackFrameItem it = (CoroutineStackFrameItem)((Object)element$iv);
                            boolean bl = false;
                            children2.add((XNamedValue)coroutineView.new CoroutineFrameValue(it));
                        }
                    }
                    if ((object = doubleFrameList) != null && (object = ((CoroutineFrameBuilder.Companion.CoroutineFrameItemLists)object).getCreationFrames()) != null) {
                        object2 = object;
                        coroutineView = this.this$1;
                        Object it = object2;
                        boolean bl = false;
                        children2.add((XNamedValue)coroutineView.new CreationFramesContainer((List<CreationCoroutineStackFrameItem>)it));
                    }
                    this.$node.addChildren(children2, true);
                }
            });
        }

        public static final /* synthetic */ CoroutineInfoData access$getInfoData$p(FramesContainer $this) {
            return $this.infoData;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CreationFramesContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "creationFrames", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Ljava/util/List;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "kotlin.jvm-debugger.coroutines"})
    public final class CreationFramesContainer
    extends RendererContainer {
        @NotNull
        private final List<CreationCoroutineStackFrameItem> creationFrames;

        public CreationFramesContainer(List<CreationCoroutineStackFrameItem> creationFrames) {
            super(CoroutineView.this.renderer.renderCreationNode());
            this.creationFrames = creationFrames;
        }

        /*
         * WARNING - void declaration
         */
        public void computeChildren(@NotNull XCompositeNode node2) {
            void $this$forEach$iv;
            XValueChildrenList children2 = new XValueChildrenList();
            Iterable iterable = this.creationFrames;
            CoroutineView coroutineView = CoroutineView.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CreationCoroutineStackFrameItem it = (CreationCoroutineStackFrameItem)((Object)element$iv);
                boolean bl = false;
                children2.add((XNamedValue)coroutineView.new CoroutineFrameValue(it));
            }
            node2.addChildren(children2, true);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineFrameValue;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "frameItem", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;)V", "getFrameItem", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "kotlin.jvm-debugger.coroutines"})
    public final class CoroutineFrameValue
    extends XNamedValue {
        @NotNull
        private final CoroutineStackFrameItem frameItem;

        public CoroutineFrameValue(CoroutineStackFrameItem frameItem) {
            super(frameItem.uniqueId());
            this.frameItem = frameItem;
        }

        @NotNull
        public final CoroutineStackFrameItem getFrameItem() {
            return this.frameItem;
        }

        public void computePresentation(@NotNull XValueNode node2, @NotNull XValuePlace place) {
            CoroutineView.this.applyRenderer(node2, CoroutineView.this.renderer.render(this.frameItem.getLocation()));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0096\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "presentation", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;)V", "getPresentation", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "kotlin.jvm-debugger.coroutines"})
    public class RendererContainer
    extends XNamedValue {
        @NotNull
        private final SimpleColoredTextIcon presentation;

        public RendererContainer(SimpleColoredTextIcon presentation) {
            super(presentation.simpleString());
            this.presentation = presentation;
        }

        @NotNull
        public final SimpleColoredTextIcon getPresentation() {
            return this.presentation;
        }

        public void computePresentation(@NotNull XValueNode node2, @NotNull XValuePlace place) {
            CoroutineView.this.applyRenderer(node2, this.presentation);
        }
    }
}

