/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DoubleClickListener;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsClassFinder;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.RunningCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineSelectedNodeListenerKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineView;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineSelectedNodeListener;", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "tree", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;)V", "install", "", "processSelectedNode", "", "setCurrentStackFrame", "executionStack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "stackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineSelectedNodeListener {
    @NotNull
    private final DebugProcessImpl debugProcess;
    @NotNull
    private final XDebuggerTree tree;

    public CoroutineSelectedNodeListener(@NotNull DebugProcessImpl debugProcess, @NotNull XDebuggerTree tree2) {
        this.debugProcess = debugProcess;
        this.tree = tree2;
    }

    public final void install() {
        new DoubleClickListener(this){
            final /* synthetic */ CoroutineSelectedNodeListener this$0;
            {
                this.this$0 = $receiver;
            }

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                return CoroutineSelectedNodeListener.access$processSelectedNode(this.this$0);
            }
        }.installOn((Component)this.tree);
        this.tree.addKeyListener((KeyListener)new KeyAdapter(this){
            final /* synthetic */ CoroutineSelectedNodeListener this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(@NotNull KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 10: 
                    case 32: 
                    case 39: {
                        CoroutineSelectedNodeListener.access$processSelectedNode(this.this$0);
                    }
                }
            }
        });
    }

    private final boolean processSelectedNode() {
        JavaExecutionStack executionStack;
        XValueNodeImpl[] selectedNodes = (XValueNodeImpl[])this.tree.getSelectedNodes(XValueNodeImpl.class, null);
        CoroutineView.CoroutineFrameValue coroutineFrameValue = CoroutineSelectedNodeListenerKt.access$getSingleCoroutineFrameValueContainer(selectedNodes);
        if (coroutineFrameValue == null) {
            return false;
        }
        CoroutineView.CoroutineFrameValue valueContainer = coroutineFrameValue;
        CoroutineStackFrameItem frameItem = valueContainer.getFrameItem();
        XStackFrame xStackFrame = frameItem.createFrame(this.debugProcess);
        if (xStackFrame == null) {
            return false;
        }
        XStackFrame frame = xStackFrame;
        if (frameItem instanceof RunningCoroutineStackFrameItem) {
            v2 = CoroutineSelectedNodeListenerKt.access$createExecutionStack(((RunningCoroutineStackFrameItem)frameItem).getFrame().threadProxy(), this.debugProcess);
        } else {
            ThreadReferenceProxyImpl threadReferenceProxyImpl = CoroutineSelectedNodeListenerKt.access$getSuspendContext(this.debugProcess).getThread();
            if (threadReferenceProxyImpl != null) {
                ThreadReferenceProxyImpl it = threadReferenceProxyImpl;
                boolean bl = false;
                v2 = CoroutineSelectedNodeListenerKt.access$createExecutionStack(it, this.debugProcess);
            } else {
                v2 = executionStack = null;
            }
        }
        if (executionStack != null) {
            this.setCurrentStackFrame((XExecutionStack)executionStack, frame);
        }
        return true;
    }

    private final void setCurrentStackFrame(XExecutionStack executionStack, XStackFrame stackFrame) {
        XSourcePosition xSourcePosition = stackFrame.getSourcePosition();
        if (xSourcePosition == null || (xSourcePosition = xSourcePosition.getFile()) == null) {
            return;
        }
        XSourcePosition fileToNavigate = xSourcePosition;
        XDebugSession xDebugSession = this.debugProcess.getSession().getXDebugSession();
        if (xDebugSession == null) {
            return;
        }
        XDebugSession session = xDebugSession;
        if (!ClsClassFinder.isKotlinInternalCompiledFile$default((ClsClassFinder)ClsClassFinder.INSTANCE, (VirtualFile)fileToNavigate, null, (int)2, null)) {
            ApplicationManager.getApplication().invokeLater(() -> CoroutineSelectedNodeListener.setCurrentStackFrame$lambda$1(session, executionStack, stackFrame), ModalityState.stateForComponent((Component)((Component)this.tree)));
        }
    }

    private static final void setCurrentStackFrame$lambda$1(XDebugSession $session, XExecutionStack $executionStack, XStackFrame $stackFrame) {
        $session.setCurrentStackFrame($executionStack, $stackFrame, false);
    }

    public static final /* synthetic */ boolean access$processSelectedNode(CoroutineSelectedNodeListener $this) {
        return $this.processSelectedNode();
    }
}

