/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.util;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.xdebugger.XSourcePosition;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.JdiTypeUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.SuspendExitMode;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u001a\f\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0007\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u000b\u001a\u0012\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0006*\u00020\u0010\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0010\u001a\u0012\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0006*\u00020\u0010\u001a\u0019\u0010\u0016\u001a\t\u0018\u00010\u0017\u00a2\u0006\u0002\b\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u0019\u001a\n\u0010\u001e\u001a\u00020\t*\u00020\u001f\u001a+\u0010 \u001a\u0004\u0018\u0001H!\"\b\b\u0000\u0010!*\u00020\"*\u00020\u000b2\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H!0$\u00a2\u0006\u0002\u0010%\u001a\n\u0010&\u001a\u00020\t*\u00020'\u001a\n\u0010(\u001a\u00020\t*\u00020'\u001a\n\u0010)\u001a\u00020\t*\u00020\u0012\u001a\n\u0010*\u001a\u00020\t*\u00020'\u001a\n\u0010+\u001a\u00020\t*\u00020,\u001a\u0014\u0010-\u001a\u00020\t*\u00020\u00192\b\u0010.\u001a\u0004\u0018\u00010\u0019\u001a\u0014\u0010/\u001a\u00020\t*\u00020\u00192\b\u0010.\u001a\u0004\u0018\u00010\u0019\u001a\n\u00100\u001a\u00020\t*\u00020\u0019\u001a\f\u00101\u001a\u00020\t*\u00020\u001fH\u0002\u001a\n\u00102\u001a\u00020\t*\u00020\u001f\u001a\n\u00103\u001a\u00020\t*\u00020\u0019\u001a\n\u00103\u001a\u00020\t*\u00020\u001f\u001a\n\u00104\u001a\u00020\t*\u00020\u0019\u001a\u0012\u00105\u001a\u00020\t*\u00020'2\u0006\u00106\u001a\u00020\u0001\u001a\n\u00107\u001a\u00020\t*\u00020\u001f\u001a\n\u00107\u001a\u00020\t*\u00020\u0012\u001a\n\u00108\u001a\u00020\t*\u00020\u0019\u001a\u0014\u00109\u001a\u00020\t*\u00020\u00192\b\u0010.\u001a\u0004\u0018\u00010\u0019\u001a\n\u0010:\u001a\u00020\t*\u00020\u000b\u001a\n\u0010:\u001a\u00020\t*\u00020;\u001a\f\u0010<\u001a\u0004\u0018\u00010\u000e*\u00020\u0007\u001a\u0014\u0010=\u001a\u0004\u0018\u00010\u000e*\u00020\u00072\u0006\u0010>\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"CREATION_CLASS_NAME", "", "CREATION_STACK_TRACE_SEPARATOR", "hasGetCoroutineSuspended", "", "frames", "", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "threadAndContextSupportsEvaluation", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "frameProxy", "continuationVariableValue", "Lcom/sun/jdi/ObjectReference;", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "findCancellableContinuationImplReferenceType", "Lcom/sun/jdi/ReferenceType;", "findCoroutineMetadataType", "Lcom/sun/jdi/ClassType;", "findDispatchedContinuationReferenceType", "findPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/sun/jdi/Location;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getSuspendExitMode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/SuspendExitMode;", "hasContinuationParameter", "Lcom/sun/jdi/Method;", "invokeInManagerThread", "T", "", "f", "Lkotlin/Function0;", "(Lcom/intellij/debugger/engine/SuspendContextImpl;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isAbstractCoroutine", "Lcom/sun/jdi/Type;", "isBaseContinuationImpl", "isContinuation", "isCoroutineScope", "isCreationSeparatorFrame", "Ljava/lang/StackTraceElement;", "isFilterFromBottom", "location", "isFilterFromTop", "isFilteredInvokeSuspend", "isGetCoroutineSuspended", "isInvoke", "isInvokeSuspend", "isInvokeSuspendWithNegativeLineNumber", "isSubTypeOrSame", "className", "isSuspendLambda", "safeCoroutineExitPointLineNumber", "sameLineAndMethod", "supportsEvaluation", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "thisVariableValue", "variableValue", "variableName", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineUtilsKt {
    @NotNull
    public static final String CREATION_STACK_TRACE_SEPARATOR = "\b\b\b";
    @NotNull
    public static final String CREATION_CLASS_NAME = "_COROUTINE._CREATION";

    public static final boolean isInvokeSuspend(@NotNull Method $this$isInvokeSuspend) {
        return Intrinsics.areEqual((Object)$this$isInvokeSuspend.name(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)$this$isInvokeSuspend.signature(), (Object)"(Ljava/lang/Object;)Ljava/lang/Object;");
    }

    public static final boolean isInvoke(@NotNull Method $this$isInvoke) {
        return Intrinsics.areEqual((Object)$this$isInvoke.name(), (Object)"invoke") && StringsKt.contains$default((CharSequence)$this$isInvoke.signature(), (CharSequence)"Ljava/lang/Object;)Ljava/lang/Object;", (boolean)false, (int)2, null);
    }

    public static final boolean isSuspendLambda(@NotNull Method $this$isSuspendLambda) {
        return CoroutineUtilsKt.isInvokeSuspend($this$isSuspendLambda) && CoroutineUtilsKt.isSuspendLambda($this$isSuspendLambda.declaringType());
    }

    public static final boolean hasContinuationParameter(@NotNull Method $this$hasContinuationParameter) {
        return StringsKt.contains$default((CharSequence)$this$hasContinuationParameter.signature(), (CharSequence)"Lkotlin/coroutines/Continuation;)", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final SuspendExitMode getSuspendExitMode(@NotNull Location $this$getSuspendExitMode) {
        Method method = SafeUtilKt.safeMethod($this$getSuspendExitMode);
        if (method == null) {
            return SuspendExitMode.NONE;
        }
        Method method2 = method;
        if (CoroutineUtilsKt.isSuspendLambda(method2)) {
            return SuspendExitMode.SUSPEND_LAMBDA;
        }
        if (CoroutineUtilsKt.hasContinuationParameter(method2)) {
            return SuspendExitMode.SUSPEND_METHOD_PARAMETER;
        }
        if ((CoroutineUtilsKt.isInvokeSuspend(method2) || CoroutineUtilsKt.isInvoke(method2)) && CoroutineUtilsKt.safeCoroutineExitPointLineNumber($this$getSuspendExitMode)) {
            return SuspendExitMode.SUSPEND_METHOD;
        }
        return SuspendExitMode.NONE;
    }

    public static final boolean safeCoroutineExitPointLineNumber(@NotNull Location $this$safeCoroutineExitPointLineNumber) {
        Integer n;
        boolean $i$f$wrapIllegalArgumentException = false;
        try {
            boolean bl = false;
            n = DebuggerUtilsEx.getLineNumber((Location)$this$safeCoroutineExitPointLineNumber, (boolean)false);
        }
        catch (IllegalArgumentException e$iv) {
            n = null;
        }
        Integer n2 = n;
        return (n2 != null ? n2 : -2) == -1;
    }

    public static final boolean isContinuation(@NotNull ReferenceType $this$isContinuation) {
        return CoroutineUtilsKt.isBaseContinuationImpl($this$isContinuation) || JdiTypeUtils.isSubtype((Type)$this$isContinuation, "kotlin.coroutines.Continuation");
    }

    public static final boolean isBaseContinuationImpl(@NotNull Type $this$isBaseContinuationImpl) {
        return JdiTypeUtils.isSubtype($this$isBaseContinuationImpl, "kotlin.coroutines.jvm.internal.BaseContinuationImpl");
    }

    public static final boolean isAbstractCoroutine(@NotNull Type $this$isAbstractCoroutine) {
        return JdiTypeUtils.isSubtype($this$isAbstractCoroutine, "kotlinx.coroutines.AbstractCoroutine");
    }

    public static final boolean isCoroutineScope(@NotNull Type $this$isCoroutineScope) {
        return JdiTypeUtils.isSubtype($this$isCoroutineScope, "kotlinx.coroutines.CoroutineScope");
    }

    public static final boolean isSubTypeOrSame(@NotNull Type $this$isSubTypeOrSame, @NotNull String className) {
        return Intrinsics.areEqual((Object)$this$isSubTypeOrSame.name(), (Object)className) || JdiTypeUtils.isSubtype($this$isSubTypeOrSame, className);
    }

    public static final boolean isSuspendLambda(@NotNull ReferenceType $this$isSuspendLambda) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = org.jetbrains.kotlin.idea.debugger.base.util.CoroutineUtilsKt.getSUSPEND_LAMBDA_CLASSES();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!JdiTypeUtils.isSubtype((Type)$this$isSuspendLambda, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isInvokeSuspend(@NotNull Location $this$isInvokeSuspend) {
        Method method = SafeUtilKt.safeMethod($this$isInvokeSuspend);
        return method != null ? CoroutineUtilsKt.isInvokeSuspend(method) : false;
    }

    public static final boolean isInvokeSuspendWithNegativeLineNumber(@NotNull Location $this$isInvokeSuspendWithNegativeLineNumber) {
        return CoroutineUtilsKt.isInvokeSuspend($this$isInvokeSuspendWithNegativeLineNumber) && SafeUtilKt.safeLineNumber($this$isInvokeSuspendWithNegativeLineNumber) < 0;
    }

    public static final boolean isFilteredInvokeSuspend(@NotNull Location $this$isFilteredInvokeSuspend) {
        return CoroutineUtilsKt.isInvokeSuspend($this$isFilteredInvokeSuspend) || CoroutineUtilsKt.isInvokeSuspendWithNegativeLineNumber($this$isFilteredInvokeSuspend);
    }

    @Nullable
    public static final ObjectReference variableValue(@NotNull StackFrameProxyImpl $this$variableValue, @NotNull String variableName) {
        LocalVariableProxyImpl localVariableProxyImpl = SafeUtilKt.safeVisibleVariableByName($this$variableValue, variableName);
        if (localVariableProxyImpl == null) {
            return null;
        }
        LocalVariableProxyImpl continuationVariable = localVariableProxyImpl;
        Value value2 = $this$variableValue.getValue(continuationVariable);
        ObjectReference objectReference = value2 instanceof ObjectReference ? (ObjectReference)value2 : null;
        if (objectReference == null) {
            return null;
        }
        return objectReference;
    }

    @Nullable
    public static final ObjectReference continuationVariableValue(@NotNull StackFrameProxyImpl $this$continuationVariableValue) {
        return CoroutineUtilsKt.variableValue($this$continuationVariableValue, "$continuation");
    }

    @Nullable
    public static final ObjectReference thisVariableValue(@NotNull StackFrameProxyImpl $this$thisVariableValue) {
        return $this$thisVariableValue.thisObject();
    }

    private static final boolean isGetCoroutineSuspended(Method $this$isGetCoroutineSuspended) {
        return Intrinsics.areEqual((Object)$this$isGetCoroutineSuspended.signature(), (Object)"()Ljava/lang/Object;") && Intrinsics.areEqual((Object)$this$isGetCoroutineSuspended.name(), (Object)"getCOROUTINE_SUSPENDED") && Intrinsics.areEqual((Object)$this$isGetCoroutineSuspended.declaringType().name(), (Object)"kotlin.coroutines.intrinsics.IntrinsicsKt__IntrinsicsKt");
    }

    @Nullable
    public static final ClassType findCoroutineMetadataType(@NotNull DefaultExecutionContext $this$findCoroutineMetadataType) {
        return (ClassType)DebuggerUtil.invokeInManagerThread($this$findCoroutineMetadataType.getDebugProcess(), (Function1)new Function1<DebuggerContextImpl, ClassType>($this$findCoroutineMetadataType){
            final /* synthetic */ DefaultExecutionContext $this_findCoroutineMetadataType;
            {
                this.$this_findCoroutineMetadataType = $receiver;
                super(1);
            }

            @Nullable
            public final ClassType invoke(@NotNull DebuggerContextImpl it) {
                return this.$this_findCoroutineMetadataType.findClassSafe("kotlin.coroutines.jvm.internal.DebugMetadataKt");
            }
        });
    }

    @Nullable
    public static final List<ReferenceType> findDispatchedContinuationReferenceType(@NotNull DefaultExecutionContext $this$findDispatchedContinuationReferenceType) {
        return $this$findDispatchedContinuationReferenceType.getVm().classesByName("kotlinx.coroutines.DispatchedContinuation");
    }

    @Nullable
    public static final List<ReferenceType> findCancellableContinuationImplReferenceType(@NotNull DefaultExecutionContext $this$findCancellableContinuationImplReferenceType) {
        return $this$findCancellableContinuationImplReferenceType.getVm().classesByName("kotlinx.coroutines.CancellableContinuationImpl");
    }

    public static final int hasGetCoroutineSuspended(@NotNull List<? extends StackFrameProxyImpl> frames) {
        int n;
        block2: {
            List<? extends StackFrameProxyImpl> $this$indexOfFirst$iv = frames;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<? extends StackFrameProxyImpl> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                StackFrameProxyImpl item$iv;
                StackFrameProxyImpl it = item$iv = iterator.next();
                boolean bl = false;
                Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)it);
                boolean bl2 = comparable != null && (comparable = SafeUtilKt.safeMethod(comparable)) != null ? CoroutineUtilsKt.isGetCoroutineSuspended((Method)comparable) : false;
                if (bl2) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    public static final boolean isCreationSeparatorFrame(@NotNull StackTraceElement $this$isCreationSeparatorFrame) {
        return StringsKt.startsWith$default((String)$this$isCreationSeparatorFrame.getClassName(), (String)CREATION_STACK_TRACE_SEPARATOR, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)$this$isCreationSeparatorFrame.getClassName(), (Object)CREATION_CLASS_NAME);
    }

    @Nullable
    public static final XSourcePosition findPosition(@NotNull Location $this$findPosition, @NotNull DebugProcessImpl debugProcess) {
        boolean $i$f$runReadAction = false;
        return (XSourcePosition)ApplicationManager.getApplication().runReadAction(new Computable(debugProcess, $this$findPosition){
            final /* synthetic */ DebugProcessImpl $debugProcess$inlined;
            final /* synthetic */ Location $this_findPosition$inlined;
            {
                this.$debugProcess$inlined = debugProcessImpl;
                this.$this_findPosition$inlined = location2;
            }

            public final T compute() {
                boolean bl = false;
                return (T)DebuggerUtilsEx.toXSourcePosition((SourcePosition)this.$debugProcess$inlined.getPositionManager().getSourcePosition(this.$this_findPosition$inlined));
            }
        });
    }

    @Nullable
    public static final DefaultExecutionContext executionContext(@NotNull SuspendContextImpl $this$executionContext) {
        return (DefaultExecutionContext)CoroutineUtilsKt.invokeInManagerThread($this$executionContext, (Function0)new Function0<DefaultExecutionContext>($this$executionContext){
            final /* synthetic */ SuspendContextImpl $this_executionContext;
            {
                this.$this_executionContext = $receiver;
                super(0);
            }

            @Nullable
            public final DefaultExecutionContext invoke() {
                return new DefaultExecutionContext(new EvaluationContextImpl(this.$this_executionContext, this.$this_executionContext.getFrameProxy()));
            }
        });
    }

    @Nullable
    public static final <T> T invokeInManagerThread(@NotNull SuspendContextImpl $this$invokeInManagerThread, @NotNull Function0<? extends T> f2) {
        return DebuggerUtil.invokeInManagerThread($this$invokeInManagerThread.getDebugProcess(), (Function1)new Function1<DebuggerContextImpl, T>(f2){
            final /* synthetic */ Function0<T> $f;
            {
                this.$f = $f;
                super(1);
            }

            @Nullable
            public final T invoke(@NotNull DebuggerContextImpl it) {
                return (T)this.$f.invoke();
            }
        });
    }

    public static final boolean supportsEvaluation(@NotNull ThreadReferenceProxyImpl $this$supportsEvaluation) {
        ThreadReference threadReference = $this$supportsEvaluation.getThreadReference();
        return threadReference != null ? threadReference.isSuspended() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean supportsEvaluation(@NotNull SuspendContextImpl $this$supportsEvaluation) {
        if (DebuggerUtil.getCanRunEvaluation($this$supportsEvaluation.getDebugProcess())) return true;
        boolean $i$f$isUnitTestMode = false;
        if (!ApplicationManager.getApplication().isUnitTestMode()) return false;
        return true;
    }

    public static final boolean threadAndContextSupportsEvaluation(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy) {
        Boolean bl = (Boolean)CoroutineUtilsKt.invokeInManagerThread(suspendContext, (Function0)new Function0<Boolean>(suspendContext, frameProxy){
            final /* synthetic */ SuspendContextImpl $suspendContext;
            final /* synthetic */ StackFrameProxyImpl $frameProxy;
            {
                this.$suspendContext = $suspendContext;
                this.$frameProxy = $frameProxy;
                super(0);
            }

            @Nullable
            public final Boolean invoke() {
                StackFrameProxyImpl stackFrameProxyImpl;
                return CoroutineUtilsKt.supportsEvaluation(this.$suspendContext) && ((stackFrameProxyImpl = this.$frameProxy) != null && (stackFrameProxyImpl = stackFrameProxyImpl.threadProxy()) != null ? CoroutineUtilsKt.supportsEvaluation((ThreadReferenceProxyImpl)stackFrameProxyImpl) : false);
            }
        });
        return bl != null ? bl : false;
    }

    public static final boolean sameLineAndMethod(@NotNull Location $this$sameLineAndMethod, @Nullable Location location2) {
        return location2 != null && Intrinsics.areEqual((Object)SafeUtilKt.safeMethod(location2), (Object)SafeUtilKt.safeMethod($this$sameLineAndMethod)) && SafeUtilKt.safeLineNumber(location2) == SafeUtilKt.safeLineNumber($this$sameLineAndMethod);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFilterFromTop(@NotNull Location $this$isFilterFromTop, @Nullable Location location2) {
        if (CoroutineUtilsKt.isFilteredInvokeSuspend($this$isFilterFromTop)) return true;
        if (CoroutineUtilsKt.sameLineAndMethod($this$isFilterFromTop, location2)) return true;
        Location location3 = location2;
        if (!Intrinsics.areEqual((Object)(location3 != null ? SafeUtilKt.safeMethod(location3) : null), (Object)SafeUtilKt.safeMethod($this$isFilterFromTop))) return false;
        return true;
    }

    public static final boolean isFilterFromBottom(@NotNull Location $this$isFilterFromBottom, @Nullable Location location2) {
        return CoroutineUtilsKt.sameLineAndMethod($this$isFilterFromBottom, location2);
    }
}

