/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.ContinuationVariableValueDescriptorImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineScopeExtractor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\n\u0010\u0019\u001a\u0004\u0018\u00010\u000fH\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"R\u0018\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0014\u0010\u0012R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineStackFrameProxyImpl;", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "location", "Lcom/sun/jdi/Location;", "spilledVariables", "", "Lcom/intellij/debugger/engine/JavaValue;", "threadProxy", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "stackFrame", "Lcom/sun/jdi/StackFrame;", "indexFromBottom", "", "(Lcom/sun/jdi/Location;Ljava/util/List;Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;Lcom/sun/jdi/StackFrame;I)V", "continuation", "Lcom/sun/jdi/ObjectReference;", "Lorg/jetbrains/annotations/Nullable;", "getContinuation", "()Lcom/sun/jdi/ObjectReference;", "coroutineScope", "getCoroutineScope", "coroutineScope$delegate", "Lkotlin/Lazy;", "getSpilledVariables", "()Ljava/util/List;", "extractCoroutineScope", "isCoroutineScopeAvailable", "", "thisObject", "updateSpilledVariableValue", "", "name", "", "value", "Lcom/sun/jdi/Value;", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineStackFrameProxyImpl
extends StackFrameProxyImpl {
    @Nullable
    private final Location location;
    @NotNull
    private final List<JavaValue> spilledVariables;
    @Nullable
    private final ObjectReference continuation;
    @NotNull
    private final Lazy coroutineScope$delegate;

    public CoroutineStackFrameProxyImpl(@Nullable Location location2, @NotNull List<? extends JavaValue> spilledVariables, @NotNull ThreadReferenceProxyImpl threadProxy, @NotNull StackFrame stackFrame, int indexFromBottom) {
        super(threadProxy, stackFrame, indexFromBottom);
        ObjectReference objectReference;
        this.location = location2;
        this.spilledVariables = spilledVariables;
        CoroutineStackFrameProxyImpl coroutineStackFrameProxyImpl = this;
        boolean $i$f$wrapEvaluateException = false;
        try {
            boolean bl = false;
            objectReference = super.thisObject();
        }
        catch (EvaluateException e$iv) {
            objectReference = null;
        }
        coroutineStackFrameProxyImpl.continuation = objectReference;
        this.coroutineScope$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ObjectReference>(this){
            final /* synthetic */ CoroutineStackFrameProxyImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ObjectReference invoke() {
                return CoroutineStackFrameProxyImpl.access$extractCoroutineScope(this.this$0);
            }
        }));
    }

    @NotNull
    public final List<JavaValue> getSpilledVariables() {
        return this.spilledVariables;
    }

    @Nullable
    public final ObjectReference getContinuation() {
        return this.continuation;
    }

    private final ObjectReference getCoroutineScope() {
        Lazy lazy = this.coroutineScope$delegate;
        return (ObjectReference)lazy.getValue();
    }

    public final void updateSpilledVariableValue(@NotNull String name2, @Nullable Value value2) {
        Object v0;
        block2: {
            Iterable iterable = this.spilledVariables;
            for (Object t : iterable) {
                JavaValue it = (JavaValue)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        JavaValue javaValue = v0;
        ValueDescriptorImpl valueDescriptorImpl = javaValue != null ? javaValue.getDescriptor() : null;
        ContinuationVariableValueDescriptorImpl continuationVariableValueDescriptorImpl = valueDescriptorImpl instanceof ContinuationVariableValueDescriptorImpl ? (ContinuationVariableValueDescriptorImpl)valueDescriptorImpl : null;
        if (continuationVariableValueDescriptorImpl == null) {
            return;
        }
        ContinuationVariableValueDescriptorImpl descriptor2 = continuationVariableValueDescriptorImpl;
        descriptor2.updateValue(value2);
    }

    public final boolean isCoroutineScopeAvailable() {
        return this.getCoroutineScope() != null;
    }

    @Nullable
    public Location location() {
        return this.location;
    }

    @Nullable
    public ObjectReference thisObject() {
        ObjectReference objectReference = this.getCoroutineScope();
        if (objectReference == null) {
            objectReference = this.continuation;
        }
        return objectReference;
    }

    private final ObjectReference extractCoroutineScope() {
        if (this.continuation == null) {
            return null;
        }
        DebugProcess debugProcess = this.getVirtualMachine().getDebugProcess();
        DebugProcessImpl debugProcessImpl = debugProcess instanceof DebugProcessImpl ? (DebugProcessImpl)debugProcess : null;
        if (debugProcessImpl == null) {
            return null;
        }
        DebugProcessImpl debugProcess2 = debugProcessImpl;
        SuspendContextImpl suspendContextImpl = debugProcess2.getSuspendManager().getPausedContext();
        if (suspendContextImpl == null) {
            return null;
        }
        SuspendContextImpl suspendContext = suspendContextImpl;
        EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, (StackFrameProxyImpl)this);
        return CoroutineScopeExtractor.INSTANCE.extractCoroutineScope(this.continuation, (EvaluationContext)evaluationContext);
    }

    public static final /* synthetic */ ObjectReference access$extractCoroutineScope(CoroutineStackFrameProxyImpl $this) {
        return $this.extractCoroutineScope();
    }
}

