/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.command;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.filters.ExceptionFilters;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.command.CoroutineDumpAction;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CompleteCoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoDatasKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineDebugProbesProxy;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineDumpPanel;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/command/CoroutineDumpAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "addCoroutineDump", "project", "Lcom/intellij/openapi/project/Project;", "coroutines", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CompleteCoroutineInfoData;", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineDumpAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DebuggerContextImpl context2 = DebuggerManagerEx.getInstanceEx((Project)project2).getContext();
        DebuggerSession session = context2.getDebuggerSession();
        if (session != null && session.isAttached()) {
            DebugProcessImpl debugProcessImpl = context2.getDebugProcess();
            if (debugProcessImpl == null) {
                return;
            }
            DebugProcessImpl process2 = debugProcessImpl;
            SuspendContextImpl suspendContextImpl = context2.getSuspendContext();
            process2.getManagerThread().schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(project2, session, this, suspendContextImpl){
                final /* synthetic */ Project $project;
                final /* synthetic */ DebuggerSession $session;
                final /* synthetic */ CoroutineDumpAction this$0;
                {
                    this.$project = $project;
                    this.$session = $session;
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    CoroutineInfoCache states = new CoroutineDebugProbesProxy(suspendContext).dumpCoroutines();
                    if (states.isOk()) {
                        Function0 f2 = (Function0)new Function0<Unit>(this.$session, states, this.this$0, this.$project){
                            final /* synthetic */ DebuggerSession $session;
                            final /* synthetic */ CoroutineInfoCache $states;
                            final /* synthetic */ CoroutineDumpAction this$0;
                            final /* synthetic */ Project $project;
                            {
                                this.$session = $session;
                                this.$states = $states;
                                this.this$0 = $receiver;
                                this.$project = $project;
                                super(0);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                void $this$mapTo$iv$iv;
                                XDebugSession xDebugSession = this.$session.getXDebugSession();
                                if (xDebugSession == null || (xDebugSession = xDebugSession.getUI()) == null) {
                                    return;
                                }
                                XDebugSession ui = xDebugSession;
                                Iterable $this$map$iv = this.$states.getCache();
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    CoroutineInfoData coroutineInfoData = (CoroutineInfoData)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(CoroutineInfoDatasKt.toCompleteCoroutineInfoData((CoroutineInfoData)it));
                                }
                                List coroutines = (List)destination$iv$iv;
                                this.this$0.addCoroutineDump(this.$project, coroutines, (RunnerLayoutUi)ui, this.$session.getSearchScope());
                            }
                        };
                        ApplicationManager.getApplication().invokeLater(() -> actionPerformed.1.contextAction$lambda$0(f2), ModalityState.NON_MODAL);
                    } else {
                        String message2 = KotlinDebuggerCoroutinesBundle.message("coroutine.dump.failed", new Object[0]);
                        XDebuggerManagerImpl.getNotificationGroup().createNotification(message2, MessageType.ERROR).notify(this.$project);
                    }
                }

                private static final void contextAction$lambda$0(Function0 $tmp0) {
                    $tmp0.invoke();
                }
            });
        }
    }

    public final void addCoroutineDump(@NotNull Project project, @NotNull List<CompleteCoroutineInfoData> coroutines, @NotNull RunnerLayoutUi ui, @NotNull GlobalSearchScope searchScope2) {
        Content content2;
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        consoleBuilder.filters(ExceptionFilters.getFilters((GlobalSearchScope)searchScope2));
        ConsoleView consoleView2 = consoleBuilder.getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        consoleView2.allowHeavyFilters();
        CoroutineDumpPanel panel = new CoroutineDumpPanel(project, consoleView2, toolbarActions, coroutines);
        String id = "DumpKt " + DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
        Content $this$addCoroutineDump_u24lambda_u240 = content2 = ui.createContent(id, (JComponent)panel, id, null, null);
        boolean bl = false;
        $this$addCoroutineDump_u24lambda_u240.putUserData(RunnerContentUi.LIGHTWEIGHT_CONTENT_MARKER, (Object)true);
        $this$addCoroutineDump_u24lambda_u240.setCloseable(true);
        $this$addCoroutineDump_u24lambda_u240.setDescription(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.panel.title", new Object[0]));
        Content content3 = content2;
        ui.addContent(content3);
        ui.selectAndFocus(content3, true, true);
        Disposer.register((Disposable)((Disposable)content3), (Disposable)((Disposable)consoleView2));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            CoroutineDumpAction $this$update_u24lambda_u241 = this;
            boolean bl = false;
            presentation.setEnabledAndVisible(false);
            return;
        }
        Project project2 = project;
        if (DebuggerManagerEx.getInstanceEx((Project)project2).getContext().getSuspendContext() == null) {
            presentation.setEnabled(false);
            return;
        }
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx((Project)project2).getContext().getDebuggerSession();
        presentation.setEnabled(debuggerSession != null && debuggerSession.isAttached());
        presentation.setVisible(presentation.isEnabled());
    }
}

