/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.calls.KtFunctionCall;
import org.jetbrains.kotlin.analysis.api.lifetime.KtDefaultLifetimeTokenProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.signatures.KtVariableLikeSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.AnalysisApiBasedInlineUtil;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0014\u0010\u001e\u001a\u00020\u001d*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0014\u0010\u001f\u001a\u00020\u001d*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0014\u0010 \u001a\u00020\u001d*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0014\u0010!\u001a\u00020\u001d*\u00020\"2\u0006\u0010#\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/KotlinVariableNameFinder;", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)V", "getDebugProcess", "()Lcom/intellij/debugger/engine/DebugProcessImpl;", "findEnclosingBlockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "element", "Lcom/intellij/psi/PsiElement;", "findVariableNamesInParameterList", "", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "findVisibleVariableNames", "location", "Lcom/sun/jdi/Location;", "findVisibleVariableNamesFrom", "findExpressionToStartAnalysisFrom", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "expression", "findVariableNames", "boundaryElement", "blocksToVisit", "Lkotlin/sequences/Sequence;", "isCoroutineContextAvailable", "", "isCoroutineContextAvailableFromFunction", "isCoroutineContextAvailableFromLambda", "isInlined", "shouldBeFiltered", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "elementAtBreakpointPosition", "kotlin.jvm-debugger.coroutines"})
public final class KotlinVariableNameFinder {
    @NotNull
    private final DebugProcessImpl debugProcess;

    public KotlinVariableNameFinder(@NotNull DebugProcessImpl debugProcess) {
        this.debugProcess = debugProcess;
    }

    @NotNull
    public final DebugProcessImpl getDebugProcess() {
        return this.debugProcess;
    }

    @RequiresReadLock
    @NotNull
    public final List<String> findVisibleVariableNames(@NotNull Location location2) {
        SourcePosition sourcePosition = SafeUtilKt.safeGetSourcePosition((PositionManager)new KotlinPositionManager((DebugProcess)this.debugProcess), location2);
        if (sourcePosition == null) {
            return CollectionsKt.emptyList();
        }
        SourcePosition sourcePosition2 = sourcePosition;
        ProgressManager.checkCanceled();
        return this.findVisibleVariableNamesFrom(sourcePosition2.getElementAt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<String> findVisibleVariableNamesFrom(PsiElement element3) {
        void this_$iv$iv$iv;
        void this_$iv$iv;
        KtBlockExpression ktBlockExpression = this.findEnclosingBlockExpression(element3);
        if (ktBlockExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtBlockExpression enclosingBlockExpression = ktBlockExpression;
        PsiElement $this$parentsOfType_u24default$iv = (PsiElement)enclosingBlockExpression;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType22 = false;
        Sequence blockParents = PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, KtBlockExpression.class, (boolean)withSelf$iv);
        if (SequencesKt.none((Sequence)blockParents)) {
            return CollectionsKt.emptyList();
        }
        ProgressManager.checkCanceled();
        Object nonDefaultLifetimeTokenFactory$iv = null;
        boolean $i$f$analyze = false;
        Project project = ((KtElement)enclosingBlockExpression).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"useSiteKtElement.project");
        KtAnalysisSessionProvider $i$f$parentsOfType22 = KtAnalysisSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyse = false;
        KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
        void var9_10 = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)enclosingBlockExpression, factory$iv$iv);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            KtFunction ktFunction;
            void $this$parentOfType$iv;
            KtAnalysisSession $this$findVisibleVariableNamesFrom_u24lambda_u240 = analysisSession$iv$iv$iv;
            boolean bl = false;
            KtExpression expressionToStartAnalysisFrom = this.findExpressionToStartAnalysisFrom($this$findVisibleVariableNamesFrom_u24lambda_u240, (KtExpression)enclosingBlockExpression);
            if (!this.isCoroutineContextAvailable($this$findVisibleVariableNamesFrom_u24lambda_u240, expressionToStartAnalysisFrom)) {
                List list2 = CollectionsKt.emptyList();
                return list2;
            }
            ProgressManager.checkCanceled();
            PsiElement psiElement2 = (PsiElement)expressionToStartAnalysisFrom;
            boolean withSelf$iv2 = true;
            boolean $i$f$parentOfType = false;
            if ((KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFunction.class, (boolean)false) == null) {
                List list3 = CollectionsKt.emptyList();
                return list3;
            }
            KtFunction parentFunction = ktFunction;
            List<String> namesInParameterList = this.findVariableNamesInParameterList(parentFunction);
            List<String> namesVisibleInExpression = this.findVariableNames($this$findVisibleVariableNamesFrom_u24lambda_u240, expressionToStartAnalysisFrom, element3, (Sequence<? extends KtBlockExpression>)blockParents);
            List list4 = CollectionsKt.plus((Collection)namesVisibleInExpression, (Iterable)namesInParameterList);
            return list4;
        }
        finally {
            factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
    }

    private final List<String> findVariableNames(KtAnalysisSession $this$findVariableNames, KtExpression expression2, PsiElement boundaryElement, Sequence<? extends KtBlockExpression> blocksToVisit) {
        List names2 = new ArrayList();
        expression2.accept((PsiElementVisitor)new KtTreeVisitorVoid(this, $this$findVariableNames, blocksToVisit, boundaryElement, names2){
            private boolean stopTraversal;
            final /* synthetic */ KotlinVariableNameFinder this$0;
            final /* synthetic */ KtAnalysisSession $this_findVariableNames;
            final /* synthetic */ Sequence<KtBlockExpression> $blocksToVisit;
            final /* synthetic */ PsiElement $boundaryElement;
            final /* synthetic */ List<String> $names;
            {
                this.this$0 = $receiver;
                this.$this_findVariableNames = $receiver2;
                this.$blocksToVisit = $blocksToVisit;
                this.$boundaryElement = $boundaryElement;
                this.$names = $names;
            }

            public final boolean getStopTraversal() {
                return this.stopTraversal;
            }

            public final void setStopTraversal(boolean bl) {
                this.stopTraversal = bl;
            }

            public void visitBlockExpression(@NotNull KtBlockExpression expression2) {
                if (KotlinVariableNameFinder.access$isInlined(this.this$0, this.$this_findVariableNames, expression2) || SequencesKt.contains(this.$blocksToVisit, (Object)expression2)) {
                    expression2.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitKtElement(@NotNull KtElement element3) {
                ProgressManager.checkCanceled();
                if (this.stopTraversal) {
                    return;
                }
                if (PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element3)) >= PsiUtilsKt.getStartOffset((PsiElement)this.$boundaryElement)) {
                    this.stopTraversal = true;
                    return;
                }
                if (element3 instanceof KtVariableDeclaration && !KotlinVariableNameFinder.access$shouldBeFiltered(this.this$0, (KtDeclaration)element3, this.$boundaryElement)) {
                    String string2 = ((KtVariableDeclaration)element3).getName();
                    if (string2 != null) {
                        String string3 = string2;
                        List<String> list2 = this.$names;
                        String it = string3;
                        boolean bl = false;
                        list2.add(it);
                    }
                }
                element3.acceptChildren((PsiElementVisitor)this);
            }
        });
        return names2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findVariableNamesInParameterList(KtFunction function2) {
        void $this$mapNotNullTo$iv$iv;
        PsiElement $this$getChildOfType$iv = (PsiElement)function2;
        boolean $i$f$getChildOfType22 = false;
        KtParameterList ktParameterList = (KtParameterList)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtParameterList.class);
        if (ktParameterList == null) {
            return CollectionsKt.emptyList();
        }
        KtParameterList parameterList2 = ktParameterList;
        Iterable $this$mapNotNull$iv = parameterList2.getParameters();
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$getChildOfType22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KtParameter it = (KtParameter)element$iv$iv;
            boolean bl2 = false;
            if (it.getName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final KtExpression findExpressionToStartAnalysisFrom(KtAnalysisSession $this$findExpressionToStartAnalysisFrom, KtExpression expression2) {
        KtExpression lastSeenBlockExpression = expression2;
        for (PsiElement parent2 : PsiTreeUtilKt.parents((PsiElement)((PsiElement)expression2), (boolean)true)) {
            PsiElement psiElement2 = parent2;
            if (psiElement2 instanceof KtNamedFunction) {
                return (KtExpression)parent2;
            }
            if (!(psiElement2 instanceof KtBlockExpression)) continue;
            if (!this.isInlined($this$findExpressionToStartAnalysisFrom, (KtBlockExpression)parent2) && !(((KtBlockExpression)parent2).getParent() instanceof KtWhenEntry)) {
                return (KtExpression)parent2;
            }
            lastSeenBlockExpression = (KtExpression)parent2;
        }
        return lastSeenBlockExpression;
    }

    private final boolean isCoroutineContextAvailable(KtAnalysisSession $this$isCoroutineContextAvailable, KtExpression expression2) {
        return this.isCoroutineContextAvailableFromFunction($this$isCoroutineContextAvailable, expression2) || this.isCoroutineContextAvailableFromLambda($this$isCoroutineContextAvailable, expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCoroutineContextAvailableFromFunction(KtAnalysisSession $this$isCoroutineContextAvailableFromFunction, KtExpression expression2) {
        void $this$parentOfType$iv;
        PsiElement psiElement2 = (PsiElement)expression2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFunction.class, (boolean)false);
        if (ktFunction == null) {
            return false;
        }
        KtFunction functionParent = ktFunction;
        KtDeclarationSymbol ktDeclarationSymbol = $this$isCoroutineContextAvailableFromFunction.getSymbol((KtDeclaration)functionParent);
        KtFunctionSymbol ktFunctionSymbol = ktDeclarationSymbol instanceof KtFunctionSymbol ? (KtFunctionSymbol)ktDeclarationSymbol : null;
        if (ktFunctionSymbol == null) {
            return false;
        }
        KtFunctionSymbol symbol2 = ktFunctionSymbol;
        return symbol2.isSuspend();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCoroutineContextAvailableFromLambda(KtAnalysisSession $this$isCoroutineContextAvailableFromLambda, KtExpression expression2) {
        void $this$parentOfType$iv;
        PsiElement psiElement2 = (PsiElement)expression2;
        boolean withSelf$iv22 = true;
        boolean $i$f$parentOfType = false;
        KtFunctionLiteral ktFunctionLiteral = (KtFunctionLiteral)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFunctionLiteral.class, (boolean)false);
        if (ktFunctionLiteral == null) {
            return false;
        }
        KtFunctionLiteral literalParent = ktFunctionLiteral;
        KtExpression withSelf$iv22 = KtPsiUtil.getParentCallIfPresent((KtExpression)((KtExpression)literalParent));
        KtCallExpression ktCallExpression = withSelf$iv22 instanceof KtCallExpression ? (KtCallExpression)withSelf$iv22 : null;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression parentCall2 = ktCallExpression;
        KtFunctionCall<?> ktFunctionCall = AnalysisApiBasedInlineUtil.INSTANCE.getResolvedFunctionCall($this$isCoroutineContextAvailableFromLambda, parentCall2);
        if (ktFunctionCall == null) {
            return false;
        }
        KtFunctionCall<?> call = ktFunctionCall;
        ValueArgument valueArgument = AnalysisApiBasedInlineUtil.INSTANCE.getValueArgumentForExpression(parentCall2, expression2);
        if (valueArgument == null) {
            return false;
        }
        ValueArgument valueArgument2 = valueArgument;
        KtLifetimeOwner ktLifetimeOwner = (KtVariableLikeSignature)((Map)call.getArgumentMapping()).get(valueArgument2.getArgumentExpression());
        if (ktLifetimeOwner == null || (ktLifetimeOwner = (KtValueParameterSymbol)((KtVariableLikeSignature)ktLifetimeOwner).getSymbol()) == null) {
            return false;
        }
        KtLifetimeOwner argumentSymbol = ktLifetimeOwner;
        return $this$isCoroutineContextAvailableFromLambda.isSuspendFunctionType(((KtCallableSymbol)argumentSymbol).getReturnType());
    }

    private final KtBlockExpression findEnclosingBlockExpression(PsiElement element3) {
        for (PsiElement parent2 : PsiTreeUtilKt.parents((PsiElement)element3, (boolean)false)) {
            PsiElement psiElement2 = parent2;
            if ((psiElement2 instanceof KtFunction ? true : psiElement2 instanceof KtWhenEntry) ? true : psiElement2 instanceof KtLambdaExpression) {
                PsiElement $this$getChildOfType$iv = parent2;
                boolean $i$f$getChildOfType = false;
                return (KtBlockExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtBlockExpression.class);
            }
            if (!(psiElement2 instanceof KtBlockExpression)) continue;
            return (KtBlockExpression)parent2;
        }
        return null;
    }

    private final boolean shouldBeFiltered(KtDeclaration $this$shouldBeFiltered, PsiElement elementAtBreakpointPosition) {
        return $this$shouldBeFiltered.getParent() instanceof KtWhenExpression ? !SequencesKt.contains((Sequence)PsiTreeUtilKt.parents((PsiElement)elementAtBreakpointPosition, (boolean)false), (Object)$this$shouldBeFiltered.getParent()) : false;
    }

    private final boolean isInlined(KtAnalysisSession $this$isInlined, KtBlockExpression expression2) {
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)expression2;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtFunction.class, (boolean)true);
        if (ktFunction == null) {
            return false;
        }
        KtFunction parentFunction = ktFunction;
        return AnalysisApiBasedInlineUtil.INSTANCE.isInlinedArgument($this$isInlined, parentFunction, false);
    }

    public static final /* synthetic */ boolean access$isInlined(KotlinVariableNameFinder $this, KtAnalysisSession $receiver, KtBlockExpression expression2) {
        return $this.isInlined($receiver, expression2);
    }

    public static final /* synthetic */ boolean access$shouldBeFiltered(KotlinVariableNameFinder $this, KtDeclaration $receiver, PsiElement elementAtBreakpointPosition) {
        return $this.shouldBeFiltered($receiver, elementAtBreakpointPosition);
    }
}

