/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.sun.jdi.VMDisconnectedException;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.RequestHintWithMethodFilterKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\fH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/RequestHintWithMethodFilter;", "Lcom/intellij/debugger/engine/RequestHint;", "stepThread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "depth", "", "methodFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "(Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;Lcom/intellij/debugger/engine/SuspendContextImpl;ILcom/intellij/debugger/engine/MethodFilter;)V", "targetMethodMatched", "", "findFieldWithValue", "Ljava/lang/reflect/Field;", "value", "type", "Ljava/lang/Class;", "getNextStepDepth", "context", "wasStepTargetMethodMatched", "kotlin.jvm-debugger.core"})
public final class RequestHintWithMethodFilter
extends RequestHint {
    private boolean targetMethodMatched;

    public RequestHintWithMethodFilter(@NotNull ThreadReferenceProxyImpl stepThread, @NotNull SuspendContextImpl suspendContext, int depth2, @NotNull MethodFilter methodFilter) {
        block1: {
            super(stepThread, suspendContext, methodFilter);
            if (depth2 == 1) break block1;
            Field field2 = this.findFieldWithValue(1, Integer.TYPE);
            if (field2 != null) {
                field2.setInt((Object)this, depth2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Field findFieldWithValue(int value, Class<?> type) {
        block3: {
            $this$firstOrNull$iv = RequestHint.class.getDeclaredFields();
            $i$f$firstOrNull = false;
            var6_6 = $this$firstOrNull$iv.length;
            for (var5_5 = 0; var5_5 < var6_6; ++var5_5) {
                field = element$iv = $this$firstOrNull$iv[var5_5];
                $i$a$-firstOrNull-RequestHintWithMethodFilter$findFieldWithValue$1 = false;
                if (!Intrinsics.areEqual(field.getType(), type)) ** GOTO lbl-1000
                field.setAccessible(true);
                if (field.getInt((Object)this) == value) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!v0) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    public int getNextStepDepth(@NotNull SuspendContextImpl context2) {
        try {
            StackFrameProxyImpl frameProxy = context2.getFrameProxy();
            MethodFilter filter2 = this.getMethodFilter();
            if (filter2 != null && frameProxy != null && !(filter2 instanceof BreakpointStepMethodFilter) && filter2.locationMatches(context2.getDebugProcess(), SafeUtilKt.safeLocation((StackFrameProxy)frameProxy))) {
                this.targetMethodMatched = true;
                return filter2.onReached(context2, (RequestHint)this);
            }
        }
        catch (VMDisconnectedException ignored) {
            return 0;
        }
        catch (EvaluateException e) {
            RequestHintWithMethodFilterKt.access$getLOG$p().error((Throwable)e);
            return 0;
        }
        return super.getNextStepDepth(context2);
    }

    public boolean wasStepTargetMethodMatched() {
        return super.wasStepTargetMethodMatched() || this.targetMethodMatched;
    }
}

