/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.VMDisconnectedException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineBreakpointFacility;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineBreakpointFacilityKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinMethodFilter;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOverRequestHint;", "Lcom/intellij/debugger/engine/RequestHint;", "stepThread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "filter", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinMethodFilter;", "parentHint", "(Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;Lcom/intellij/debugger/engine/SuspendContextImpl;Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinMethodFilter;Lcom/intellij/debugger/engine/RequestHint;)V", "startLocation", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOverRequestHint$LocationData;", "getNextStepDepth", "", "context", "installCoroutineResumedBreakpoint", "", "isSteppedFromDefaultParamsOriginal", "location", "Lcom/sun/jdi/Location;", "Companion", "LocationData", "kotlin.jvm-debugger.core"})
public final class KotlinStepOverRequestHint
extends RequestHint {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinMethodFilter filter;
    @Nullable
    private final LocationData startLocation;
    @Deprecated
    @NotNull
    private static final Logger LOG = Logger.getInstance(KotlinStepOverRequestHint.class);

    public KotlinStepOverRequestHint(@NotNull ThreadReferenceProxyImpl stepThread, @NotNull SuspendContextImpl suspendContext, @NotNull KotlinMethodFilter filter2, @Nullable RequestHint parentHint) {
        super(stepThread, suspendContext, -2, 2, (MethodFilter)filter2, parentHint);
        this.filter = filter2;
        this.startLocation = LocationData.Companion.create(CoroutineBreakpointFacilityKt.getLocationCompat(suspendContext));
    }

    public int getNextStepDepth(@NotNull SuspendContextImpl context2) {
        try {
            StackFrameProxyImpl stackFrameProxyImpl = context2.getFrameProxy();
            if (stackFrameProxyImpl == null) {
                return 0;
            }
            StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
            if (this.isTheSameFrame(context2)) {
                if (DebuggerUtil.isOnSuspensionPoint(frameProxy)) {
                    return !this.installCoroutineResumedBreakpoint(context2) ? 0 : -100;
                }
                Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
                boolean isAcceptable = location2 != null && this.filter.locationMatches(context2, location2);
                return isAcceptable ? 0 : 2;
            }
            if (this.isSteppedOut()) {
                Method method;
                Location location3 = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
                Integer isAcceptable = this.processSteppingFilters(context2, location3);
                if (isAcceptable != null) {
                    Integer it = isAcceptable;
                    boolean bl = false;
                    return it;
                }
                Location location4 = location3;
                Method method2 = method = location4 != null ? SafeUtilKt.safeMethod(location4) : null;
                if (method != null && KotlinSteppingCommandProviderKt.isSyntheticMethodForDefaultParameters(method) && this.isSteppedFromDefaultParamsOriginal(location3)) {
                    return 2;
                }
                Location location5 = location3;
                int lineNumber = location5 != null ? SafeUtilKt.safeLineNumber(location5, "Java") : -1;
                return lineNumber >= 0 ? 0 : 2;
            }
            return 3;
        }
        catch (VMDisconnectedException frameProxy) {
        }
        catch (EvaluateException e) {
            LOG.error((Throwable)e);
        }
        return 0;
    }

    private final boolean isSteppedFromDefaultParamsOriginal(Location location2) {
        Type[] endArgs;
        LocationData locationData = this.startLocation;
        if (locationData == null) {
            return false;
        }
        LocationData startLocation = locationData;
        LocationData locationData2 = LocationData.Companion.create(location2);
        if (locationData2 == null) {
            return false;
        }
        LocationData endLocation = locationData2;
        if (!Intrinsics.areEqual((Object)startLocation.getDeclaringType(), (Object)endLocation.getDeclaringType())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)(startLocation.getMethod() + "$default"), (Object)endLocation.getMethod())) {
            return false;
        }
        Type[] startArgs = startLocation.getSignature().getArgumentTypes();
        if (startArgs.length >= (endArgs = endLocation.getSignature().getArgumentTypes()).length) {
            return false;
        }
        int n = startArgs.length;
        for (int j = 0; j < n; ++j) {
            int index = j;
            Type type2 = startArgs[j];
            if (Intrinsics.areEqual((Object)endArgs[index], (Object)type2)) continue;
            return false;
        }
        n = endArgs.length - 1;
        for (int index = startArgs.length; index < n; ++index) {
            if (endArgs[index].getSort() == 5) continue;
            return false;
        }
        return Intrinsics.areEqual((Object)endArgs[endArgs.length - 1].getDescriptor(), (Object)"Ljava/lang/Object;");
    }

    private final boolean installCoroutineResumedBreakpoint(SuspendContextImpl context2) {
        StackFrameProxyImpl stackFrameProxyImpl = context2.getFrameProxy();
        if (stackFrameProxyImpl == null) {
            return false;
        }
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
        if (location2 == null) {
            return false;
        }
        Location location3 = location2;
        Method method = SafeUtilKt.safeMethod(location3);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        context2.getDebugProcess().cancelRunToCursorBreakpoint();
        return CoroutineBreakpointFacility.INSTANCE.installCoroutineResumedBreakpoint(context2, location3, method2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOverRequestHint$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm-debugger.core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOverRequestHint$LocationData;", "", "method", "", "signature", "Lorg/jetbrains/org/objectweb/asm/Type;", "declaringType", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;Ljava/lang/String;)V", "getDeclaringType", "()Ljava/lang/String;", "getMethod", "getSignature", "()Lorg/jetbrains/org/objectweb/asm/Type;", "Companion", "kotlin.jvm-debugger.core"})
    private static final class LocationData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String method;
        @NotNull
        private final Type signature;
        @NotNull
        private final String declaringType;

        public LocationData(@NotNull String method, @NotNull Type signature2, @NotNull String declaringType) {
            this.method = method;
            this.signature = signature2;
            this.declaringType = declaringType;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @NotNull
        public final Type getSignature() {
            return this.signature;
        }

        @NotNull
        public final String getDeclaringType() {
            return this.declaringType;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOverRequestHint$LocationData$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOverRequestHint$LocationData;", "location", "Lcom/sun/jdi/Location;", "kotlin.jvm-debugger.core"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final LocationData create(@Nullable Location location2) {
                Comparable<Location> comparable = location2;
                if (comparable == null || (comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) {
                    return null;
                }
                Comparable<Location> method = comparable;
                Type signature2 = Type.getMethodType((String)method.signature());
                return new LocationData(method.name(), signature2, location2.declaringType().name());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

