/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Location;
import com.sun.jdi.VMDisconnectedException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinRequestHint;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepIntoRequestHint;", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinRequestHint;", "stepThread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "filter", "Lcom/intellij/debugger/engine/MethodFilter;", "parentHint", "Lcom/intellij/debugger/engine/RequestHint;", "(Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;Lcom/intellij/debugger/engine/SuspendContextImpl;Lcom/intellij/debugger/engine/MethodFilter;Lcom/intellij/debugger/engine/RequestHint;)V", "lastWasKotlinFakeLineNumber", "", "getNextStepDepth", "", "context", "Companion", "kotlin.jvm-debugger.core"})
public final class KotlinStepIntoRequestHint
extends KotlinRequestHint {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private boolean lastWasKotlinFakeLineNumber;
    @Deprecated
    @NotNull
    private static final Logger LOG = Logger.getInstance(KotlinStepIntoRequestHint.class);

    public KotlinStepIntoRequestHint(@NotNull ThreadReferenceProxyImpl stepThread, @NotNull SuspendContextImpl suspendContext, @Nullable MethodFilter filter2, @Nullable RequestHint parentHint) {
        super(stepThread, suspendContext, -2, 1, filter2, parentHint);
    }

    public int getNextStepDepth(@NotNull SuspendContextImpl context2) {
        try {
            StackFrameProxyImpl stackFrameProxyImpl = context2.getFrameProxy();
            if (stackFrameProxyImpl == null) {
                return 0;
            }
            StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
            Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
            if (location2 != null && DebuggerUtil.isKotlinFakeLineNumber(location2)) {
                this.lastWasKotlinFakeLineNumber = true;
                return 1;
            }
            if (this.lastWasKotlinFakeLineNumber) {
                this.lastWasKotlinFakeLineNumber = false;
                return 0;
            }
            return super.getNextStepDepth(context2);
        }
        catch (VMDisconnectedException frameProxy) {
        }
        catch (EvaluateException e) {
            LOG.error((Throwable)e);
        }
        return 0;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepIntoRequestHint$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm-debugger.core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

