/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinMethodFilter;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinRequestHint;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinStepIntoRequestHint;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinStepOverRequestHint;

public class KotlinStepActionFactory {
    private static final Logger LOG = Logger.getInstance(KotlinStepActionFactory.class);

    @NotNull
    public static DebugProcessImpl.StepOverCommand createKotlinStepOverCommand(final DebugProcessImpl debugProcess, SuspendContextImpl suspendContext, final boolean ignoreBreakpoints, final @NotNull KotlinMethodFilter methodFilter) {
        DebugProcessImpl debugProcessImpl = debugProcess;
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.StepOverCommand(debugProcessImpl, suspendContext, ignoreBreakpoints, methodFilter, -2){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                Objects.requireNonNull(debugProcessImpl2);
                super(debugProcessImpl2, arg0, arg1, arg2, arg3);
            }

            @NotNull
            protected String getStatusText() {
                return KotlinDebuggerCoreBundle.message("stepping.over.inline", new Object[0]);
            }

            @NotNull
            public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                KotlinStepOverRequestHint hint = new KotlinStepOverRequestHint(stepThread, suspendContext, methodFilter, parentHint);
                hint.setResetIgnoreFilters(!debugProcess.getSession().shouldIgnoreSteppingFilters());
                hint.setRestoreBreakpoints(ignoreBreakpoints);
                try {
                    debugProcess.getSession().setIgnoreStepFiltersFlag(stepThread.frameCount());
                }
                catch (EvaluateException e) {
                    LOG.info((Throwable)e);
                }
                return hint;
            }
        };
    }

    @NotNull
    public static DebugProcessImpl.StepIntoCommand createKotlinStepIntoCommand(final DebugProcessImpl debugProcess, SuspendContextImpl suspendContext, boolean ignoreBreakpoints, final @Nullable MethodFilter methodFilter) {
        DebugProcessImpl debugProcessImpl = debugProcess;
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.StepIntoCommand(debugProcessImpl, suspendContext, ignoreBreakpoints, methodFilter, -2){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                Objects.requireNonNull(debugProcessImpl2);
                super(debugProcessImpl2, arg0, arg1, arg2, arg3);
            }

            @NotNull
            public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                KotlinStepIntoRequestHint hint = new KotlinStepIntoRequestHint(stepThread, suspendContext, methodFilter, parentHint);
                hint.setResetIgnoreFilters(this.myMethodFilter != null && !debugProcess.getSession().shouldIgnoreSteppingFilters());
                return hint;
            }
        };
    }

    @NotNull
    public static DebugProcessImpl.StepIntoCommand createStepIntoCommand(final DebugProcessImpl debugProcess, SuspendContextImpl suspendContext, boolean ignoreFilters, final @Nullable MethodFilter methodFilter, final int stepSize) {
        DebugProcessImpl debugProcessImpl = debugProcess;
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.StepIntoCommand(debugProcessImpl, suspendContext, ignoreFilters, methodFilter, stepSize){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                Objects.requireNonNull(debugProcessImpl2);
                super(debugProcessImpl2, arg0, arg1, arg2, arg3);
            }

            @NotNull
            public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                KotlinRequestHint hint = new KotlinRequestHint(stepThread, suspendContext, stepSize, 1, methodFilter, parentHint);
                hint.setResetIgnoreFilters(this.myMethodFilter != null && !debugProcess.getSession().shouldIgnoreSteppingFilters());
                return hint;
            }
        };
    }

    @NotNull
    public static DebugProcessImpl.StepOutCommand createStepOutCommand(final DebugProcessImpl debugProcess, SuspendContextImpl suspendContext) {
        DebugProcessImpl debugProcessImpl = debugProcess;
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.StepOutCommand(debugProcessImpl, suspendContext, -2){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                Objects.requireNonNull(debugProcessImpl2);
                super(debugProcessImpl2, arg0, arg1);
            }

            @NotNull
            public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                KotlinRequestHint hint = new KotlinRequestHint(stepThread, suspendContext, -2, 3, null, parentHint);
                hint.setIgnoreFilters(debugProcess.getSession().shouldIgnoreSteppingFilters());
                return hint;
            }
        };
    }
}

