/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stackFrame;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.VariableWithLocation;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.KotlinStackFrameInfo;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0002\u001a&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"INLINE_LAMBDA_REGEX", "Lkotlin/text/Regex;", "computeStackFrameInfos", "", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrameInfo;", "sortedVariables", "Lorg/jetbrains/kotlin/idea/debugger/core/VariableWithLocation;", "fetchCallLocations", "", "method", "Lcom/sun/jdi/Method;", "kotlinStackFrameInfos", "defaultLocation", "Lcom/sun/jdi/Location;", "computeKotlinStackFrameInfos", "Lcom/sun/jdi/StackFrame;", "kotlin.jvm-debugger.core"})
public final class InlineStackTraceCalculatorKt {
    @NotNull
    private static final Regex INLINE_LAMBDA_REGEX = new Regex(StringsKt.replace$default((String)"$i$a$", (String)"$", (String)"\\$", (boolean)false, (int)4, null) + "-(.+)-[^$]+\\$([^$]+)\\$.*");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinStackFrameInfo> computeKotlinStackFrameInfos(@NotNull StackFrame $this$computeKotlinStackFrameInfos) {
        List<KotlinStackFrameInfo> list2;
        void $this$filterTo$iv$iv;
        Location location2 = $this$computeKotlinStackFrameInfos.location();
        Method method = SafeUtilKt.safeMethod(location2);
        if (method == null) {
            return CollectionsKt.emptyList();
        }
        Method method2 = method;
        Iterable $this$filter$iv = StackFrameUtilsKt.sortedVariablesWithLocation(method2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VariableWithLocation it = (VariableWithLocation)element$iv$iv;
            boolean bl = false;
            if (!it.getVariable().isVisible($this$computeKotlinStackFrameInfos)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allVisibleVariables = (List)destination$iv$iv;
        List<KotlinStackFrameInfo> it = list2 = InlineStackTraceCalculatorKt.computeStackFrameInfos(allVisibleVariables);
        boolean bl = false;
        InlineStackTraceCalculatorKt.fetchCallLocations(method2, it, location2);
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KotlinStackFrameInfo> computeStackFrameInfos(List<VariableWithLocation> sortedVariables) {
        int depth2;
        Object[] objectArray = new KotlinStackFrameInfo[]{new KotlinStackFrameInfo(null, null, new ArrayList(), 0)};
        List stackFrameInfos = CollectionsKt.mutableListOf((Object[])objectArray);
        Map pendingVariables = new LinkedHashMap();
        Integer[] integerArray = new Integer[]{0};
        List<Integer> activeFrames = CollectionsKt.mutableListOf((Object[])integerArray);
        for (VariableWithLocation entry : sortedVariables) {
            Object object;
            void $this$getOrPut$iv;
            Object object2;
            if (StringsKt.startsWith$default((String)entry.getName(), (String)"$i$f$", (boolean)false, (int)2, null)) {
                int depth22 = activeFrames.size();
                object2 = stackFrameInfos;
                List list2 = (List)pendingVariables.get(depth22);
                if (list2 == null) {
                    list2 = new ArrayList();
                }
                object2.add(new KotlinStackFrameInfo(entry, null, list2, depth22));
                pendingVariables.remove(depth22);
                ((Collection)activeFrames).add(stackFrameInfos.size() - 1);
                continue;
            }
            depth2 = InlineUtilsKt.getInlineDepth(entry.getName());
            if (StringsKt.startsWith$default((String)entry.getName(), (String)"$i$a$", (boolean)false, (int)2, null)) {
                if (depth2 + 1 < activeFrames.size()) {
                    activeFrames = activeFrames.subList(0, depth2 + 1);
                }
                if (depth2 >= activeFrames.size()) continue;
                object2 = stackFrameInfos;
                KotlinStackFrameInfo kotlinStackFrameInfo = (KotlinStackFrameInfo)stackFrameInfos.get(((Number)activeFrames.get(depth2)).intValue());
                List list3 = (List)pendingVariables.get(depth2);
                if (list3 == null) {
                    list3 = new ArrayList();
                }
                object2.add(new KotlinStackFrameInfo(entry, kotlinStackFrameInfo, list3, depth2));
                pendingVariables.remove(depth2);
                activeFrames.set(depth2, stackFrameInfos.size() - 1);
                continue;
            }
            if (depth2 == activeFrames.size() - 1) {
                ((Collection)((KotlinStackFrameInfo)stackFrameInfos.get(((Number)activeFrames.get(depth2)).intValue())).getVisibleVariablesWithLocations()).add(entry);
                continue;
            }
            object2 = pendingVariables;
            Integer key$iv = depth2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Collection)object).add(entry);
        }
        for (Map.Entry entry : pendingVariables.entrySet()) {
            List<VariableWithLocation> list4;
            KotlinStackFrameInfo kotlinStackFrameInfo;
            Object v4;
            List variables;
            block12: {
                depth2 = ((Number)entry.getKey()).intValue();
                variables = (List)entry.getValue();
                if (depth2 < activeFrames.size()) {
                    CollectionsKt.addAll((Collection)((KotlinStackFrameInfo)stackFrameInfos.get(((Number)activeFrames.get(depth2)).intValue())).getVisibleVariablesWithLocations(), (Iterable)variables);
                    continue;
                }
                List $this$lastOrNull$iv = stackFrameInfos;
                boolean $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object element$iv = iterator$iv.previous();
                    KotlinStackFrameInfo it = (KotlinStackFrameInfo)element$iv;
                    boolean bl = false;
                    if (!(it.getDepth() == depth2)) continue;
                    v4 = element$iv;
                    break block12;
                }
                v4 = null;
            }
            if ((kotlinStackFrameInfo = (KotlinStackFrameInfo)v4) == null || (list4 = kotlinStackFrameInfo.getVisibleVariablesWithLocations()) == null) continue;
            list4.addAll(variables);
        }
        return stackFrameInfos;
    }

    private static final void fetchCallLocations(Method method, List<KotlinStackFrameInfo> kotlinStackFrameInfos, Location defaultLocation) {
        VariableWithLocation firstInlineScopeVariable;
        KotlinStackFrameInfo kotlinStackFrameInfo = (KotlinStackFrameInfo)CollectionsKt.lastOrNull(kotlinStackFrameInfos);
        if (kotlinStackFrameInfo != null) {
            kotlinStackFrameInfo.setCallLocation(defaultLocation);
        }
        if (kotlinStackFrameInfos.size() <= 1) {
            return;
        }
        List allLocations = DebuggerUtilsEx.allLineLocations((Method)method);
        if (allLocations == null) {
            Iterable $this$forEach$iv = kotlinStackFrameInfos;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinStackFrameInfo it = (KotlinStackFrameInfo)element$iv;
                boolean bl = false;
                it.setCallLocation(defaultLocation);
            }
            return;
        }
        int startIndex = 0;
        startIndex = 1;
        VariableWithLocation $i$f$forEach = kotlinStackFrameInfos.get(1).getScopeVariable();
        if ($i$f$forEach != null) {
            VariableWithLocation variableWithLocation;
            VariableWithLocation element$iv;
            VariableWithLocation it = element$iv = $i$f$forEach;
            boolean bl = false;
            VariableWithLocation variableWithLocation2 = variableWithLocation = StringsKt.startsWith$default((String)it.getName(), (String)"$i$f$", (boolean)false, (int)2, null) ? element$iv : null;
            if (variableWithLocation != null) {
                firstInlineScopeVariable = variableWithLocation;
                boolean bl2 = false;
                Location startOffset = firstInlineScopeVariable.getLocation();
                int callLineNumber = SafeUtilKt.safeLineNumber(startOffset, "KotlinDebug");
                String callSourceName = SafeUtilKt.safeSourceName(startOffset, "KotlinDebug");
                if (callLineNumber != -1 && callSourceName != null) {
                    Object v3;
                    block14: {
                        List $this$lastOrNull$iv = allLocations;
                        boolean $i$f$lastOrNull = false;
                        ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            Object element$iv2 = iterator$iv.previous();
                            Location location2 = (Location)element$iv2;
                            boolean bl3 = false;
                            boolean bl4 = location2.compareTo(startOffset) < 0 && SafeUtilKt.safeLineNumber(location2) == callLineNumber && Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName(location2), (Object)callSourceName);
                            if (!bl4) continue;
                            v3 = element$iv2;
                            break block14;
                        }
                        v3 = null;
                    }
                    Location callLocation = v3;
                    if (callLocation != null) {
                        kotlinStackFrameInfos.get(0).setCallLocation(callLocation);
                        ++startIndex;
                    }
                }
            }
        }
        int n = kotlinStackFrameInfos.size();
        for (int index = startIndex; index < n; ++index) {
            int locationIndex;
            Integer n2;
            Location bl2;
            firstInlineScopeVariable = kotlinStackFrameInfos.get(index).getScopeVariable();
            if (firstInlineScopeVariable != null && (bl2 = firstInlineScopeVariable.getLocation()) != null) {
                Location p0 = bl2;
                boolean bl = false;
                n2 = CollectionsKt.binarySearch$default((List)allLocations, (Comparable)p0, (int)0, (int)0, (int)6, null);
            } else {
                n2 = null;
            }
            Integer scopeIndex = n2;
            KotlinStackFrameInfo prev2 = kotlinStackFrameInfos.get(index - 1);
            if (scopeIndex == null || new IntRange(-1, 0).contains(scopeIndex.intValue())) {
                prev2.setCallLocation(defaultLocation);
                continue;
            }
            int n3 = locationIndex = scopeIndex > 0 ? scopeIndex - 1 : -scopeIndex.intValue() - 2;
            if (DebuggerUtil.isKotlinFakeLineNumber((Location)allLocations.get(locationIndex))) {
                locationIndex = RangesKt.coerceAtLeast((int)(locationIndex - 1), (int)0);
            }
            prev2.setCallLocation((Location)allLocations.get(locationIndex));
        }
    }

    public static final /* synthetic */ Regex access$getINLINE_LAMBDA_REGEX$p() {
        return INLINE_LAMBDA_REGEX;
    }
}

