/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.filter;

import com.intellij.debugger.engine.SyntheticTypeComponentProvider;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.name.FqNameUnsafe;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0012\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\f\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u000f\u0010\r\u001a\u00020\u0004*\u0004\u0018\u00010\u000eH\u0082\u0010J\f\u0010\u000f\u001a\u00020\u0004*\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/filter/KotlinSyntheticTypeComponentProvider;", "Lcom/intellij/debugger/engine/SyntheticTypeComponentProvider;", "()V", "hasInterfaceWithImplementation", "", "method", "Lcom/sun/jdi/Method;", "hasOnlyInvokeStatic", "m", "isNotSynthetic", "typeComponent", "Lcom/sun/jdi/TypeComponent;", "isSynthetic", "isCallableReferenceSyntheticClass", "Lcom/sun/jdi/ReferenceType;", "isDelegateToDefaultInterfaceImpl", "Companion", "kotlin.jvm-debugger.core"})
public final class KotlinSyntheticTypeComponentProvider
implements SyntheticTypeComponentProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    private static final IntRange LOAD_INSTRUCTIONS_WITH_INDEX = new IntRange(21, 25);
    @Deprecated
    @NotNull
    private static final IntRange LOAD_INSTRUCTIONS = new IntRange(26, 45);
    @Deprecated
    @NotNull
    private static final IntRange RETURN_INSTRUCTIONS = new IntRange(-84, -79);
    @Deprecated
    @NotNull
    private static final IntRange ICONST_INSTRUCTIONS = new IntRange(2, 8);

    public boolean isSynthetic(@Nullable TypeComponent typeComponent) {
        if (!(typeComponent instanceof Method)) {
            return false;
        }
        ReferenceType containingType = ((Method)typeComponent).declaringType();
        String typeName = containingType.name();
        if (!FqNameUnsafe.isValid((String)typeName)) {
            return false;
        }
        if (this.isCallableReferenceSyntheticClass(containingType)) {
            return true;
        }
        try {
            boolean bl;
            block16: {
                Location it;
                boolean bl2;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block15: {
                    if (this.isDelegateToDefaultInterfaceImpl((Method)typeComponent)) {
                        return true;
                    }
                    Location location2 = ((Method)typeComponent).location();
                    if (!(location2 != null ? location2.lineNumber() == 1 : false)) {
                        return false;
                    }
                    $this$any$iv = ((Method)typeComponent).allLineLocations();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Location)element$iv;
                            boolean bl3 = false;
                            if (!(it.lineNumber() != 1)) continue;
                            bl2 = true;
                            break block15;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return false;
                }
                $this$any$iv = SafeUtilKt.safeAllLineLocations(((Method)typeComponent).declaringType());
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Location)element$iv;
                        boolean bl4 = false;
                        if (!(it.lineNumber() != 1)) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            }
            return !bl;
        }
        catch (AbsentInformationException e) {
            return false;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    public boolean isNotSynthetic(@Nullable TypeComponent typeComponent) {
        if (typeComponent instanceof Method) {
            String name2 = ((Method)typeComponent).name();
            if (StringsKt.endsWith$default((String)name2, (String)"$suspendImpl", (boolean)false, (int)2, null)) {
                Location location2 = ((Method)typeComponent).location();
                boolean bl = location2 != null ? DebuggerUtil.isInKotlinSources(location2) : false;
                if (bl) {
                    ReferenceType containingClass = ((Method)typeComponent).declaringType();
                    if (Intrinsics.areEqual((Object)CollectionsKt.firstOrNull(((Method)typeComponent).argumentTypeNames()), (Object)containingClass.name())) {
                        return true;
                    }
                }
            } else if (StringsKt.endsWith$default((String)name2, (String)"$default", (boolean)false, (int)2, null)) {
                String originalName = StringsKt.dropLast((String)name2, (int)8);
                return !((Collection)((Method)typeComponent).declaringType().methodsByName(originalName)).isEmpty();
            }
        }
        return super.isNotSynthetic(typeComponent);
    }

    private final boolean isCallableReferenceSyntheticClass(ReferenceType $this$isCallableReferenceSyntheticClass) {
        while (true) {
            ClassType superClass;
            if (!($this$isCallableReferenceSyntheticClass instanceof ClassType)) {
                return false;
            }
            if (((ClassType)$this$isCallableReferenceSyntheticClass).superclass() == null) {
                return false;
            }
            String superClassName = superClass.name();
            if (Intrinsics.areEqual((Object)superClassName, (Object)PropertyReference.class.getName()) || Intrinsics.areEqual((Object)superClassName, (Object)FunctionReference.class.getName())) {
                return true;
            }
            if (!StringsKt.startsWith$default((String)superClassName, (String)"kotlin.jvm.internal.", (boolean)false, (int)2, null)) break;
            $this$isCallableReferenceSyntheticClass = superClass;
        }
        return false;
    }

    private final boolean isDelegateToDefaultInterfaceImpl(Method $this$isDelegateToDefaultInterfaceImpl) {
        if (SafeUtilKt.safeAllLineLocations($this$isDelegateToDefaultInterfaceImpl).size() != 1) {
            return false;
        }
        if (!$this$isDelegateToDefaultInterfaceImpl.virtualMachine().canGetBytecodes()) {
            return false;
        }
        if (!this.hasOnlyInvokeStatic($this$isDelegateToDefaultInterfaceImpl)) {
            return false;
        }
        return this.hasInterfaceWithImplementation($this$isDelegateToDefaultInterfaceImpl);
    }

    private final boolean hasOnlyInvokeStatic(Method m) {
        byte[] instructions = m.bytecodes();
        int i2 = 0;
        boolean isALoad0BeforeStaticCall = false;
        while (i2 < instructions.length) {
            boolean bl;
            int instr = instructions[i2];
            if (instr == 42) {
                ++i2;
                isALoad0BeforeStaticCall = true;
                continue;
            }
            IntRange intRange = LOAD_INSTRUCTIONS_WITH_INDEX;
            int n = intRange.getFirst();
            int n2 = intRange.getLast();
            int n3 = instr;
            boolean bl2 = n <= n3 ? n3 <= n2 : false;
            if (bl2) {
                bl = true;
            } else {
                intRange = LOAD_INSTRUCTIONS;
                n = intRange.getFirst();
                n2 = intRange.getLast();
                n3 = instr;
                bl = n <= n3 ? n3 <= n2 : false;
            }
            if (bl) {
                byte nextInstr;
                ++i2;
                intRange = LOAD_INSTRUCTIONS_WITH_INDEX;
                n = intRange.getFirst();
                n2 = intRange.getLast();
                n3 = instr;
                boolean bl3 = n <= n3 ? n3 <= n2 : false;
                if (bl3) {
                    ++i2;
                }
                if ((nextInstr = instructions[i2]) != 18) continue;
                i2 += 2;
                isALoad0BeforeStaticCall = false;
                continue;
            }
            if (instr == -72) {
                if (!isALoad0BeforeStaticCall || (i2 += 3) != instructions.length - 1) continue;
                byte nextInstr = instructions[i2];
                IntRange intRange2 = RETURN_INSTRUCTIONS;
                n2 = intRange2.getFirst();
                n3 = intRange2.getLast();
                byte by = nextInstr;
                return n2 <= by ? by <= n3 : false;
            }
            if (instr == -64) {
                if (instructions[++i2] != 0) {
                    return false;
                }
                intRange = ICONST_INSTRUCTIONS;
                n = intRange.getFirst();
                n2 = intRange.getLast();
                if (!(n <= (n3 = instructions[++i2]) ? n3 <= n2 : false)) {
                    return false;
                }
                ++i2;
                continue;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasInterfaceWithImplementation(Method method) {
        boolean bl;
        block5: {
            void $this$flatMapTo$iv$iv;
            ReferenceType referenceType = method.declaringType();
            ClassType classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
            if (classType == null) {
                return false;
            }
            ClassType declaringType = classType;
            List<InterfaceType> interfaces = declaringType.allInterfaces();
            VirtualMachine vm = declaringType.virtualMachine();
            Iterable $this$flatMap$iv = interfaces;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                InterfaceType it = (InterfaceType)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = vm.classesByName(it.name() + "$DefaultImpls");
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List traitImpls = (List)destination$iv$iv;
            Iterable $this$any$iv = traitImpls;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ReferenceType it = (ReferenceType)element$iv;
                    boolean bl3 = false;
                    boolean bl4 = !((Collection)it.methodsByName(method.name())).isEmpty();
                    if (!bl4) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/filter/KotlinSyntheticTypeComponentProvider$Companion;", "", "()V", "ICONST_INSTRUCTIONS", "Lkotlin/ranges/IntRange;", "LOAD_INSTRUCTIONS", "LOAD_INSTRUCTIONS_WITH_INDEX", "RETURN_INSTRUCTIONS", "kotlin.jvm-debugger.core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

