/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.filter;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.ExtraSteppingFilter;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.classFilter.ClassFilter;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.ClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.filter.KotlinExtraSteppingFilterKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/filter/KotlinExtraSteppingFilter;", "Lcom/intellij/debugger/engine/ExtraSteppingFilter;", "()V", "getStepRequestDepth", "", "context", "Lcom/intellij/debugger/engine/SuspendContext;", "isApplicable", "", "kotlin.jvm-debugger.core"})
public final class KotlinExtraSteppingFilter
implements ExtraSteppingFilter {
    public boolean isApplicable(@Nullable SuspendContext context2) {
        SuspendContext suspendContext = context2;
        if (suspendContext == null || (suspendContext = suspendContext.getDebugProcess()) == null) {
            return false;
        }
        SuspendContext debugProcess = suspendContext;
        Object object = context2.getFrameProxy();
        if (object == null || (object = SafeUtilKt.safeLocation((StackFrameProxy)object)) == null) {
            return false;
        }
        Object location2 = object;
        Object object2 = location2.declaringType();
        if (object2 == null || (object2 = object2.defaultStratum()) == null) {
            return false;
        }
        Object defaultStratum = object2;
        if (!Intrinsics.areEqual((Object)defaultStratum, (Object)"Kotlin")) {
            return false;
        }
        boolean $i$f$runReadAction = false;
        return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable((DebugProcess)debugProcess, (Location)location2){
            final /* synthetic */ DebugProcess $debugProcess$inlined;
            final /* synthetic */ Location $location$inlined;
            {
                this.$debugProcess$inlined = debugProcess;
                this.$location$inlined = location2;
            }

            /*
             * WARNING - void declaration
             */
            public final T compute() {
                boolean bl;
                block8: {
                    boolean bl2 = false;
                    KotlinPositionManager positionManager = new KotlinPositionManager(this.$debugProcess$inlined);
                    SourcePosition sourcePosition = SafeUtilKt.safeGetSourcePosition((PositionManager)positionManager, this.$location$inlined);
                    if (sourcePosition == null) {
                        bl = false;
                    } else {
                        SourcePosition sourcePosition2 = sourcePosition;
                        if (DebuggerUtil.isInSuspendMethod(this.$location$inlined) && DebuggerUtil.isOnSuspendReturnOrReenter(this.$location$inlined) && !KotlinExtraSteppingFilterKt.access$isOneLineMethod(this.$location$inlined)) {
                            bl = true;
                        } else {
                            DebuggerSettings settings2 = DebuggerSettings.getInstance();
                            if (settings2.TRACING_FILTERS_ENABLED) {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                ClassNameProvider classNameProvider = new ClassNameProvider(this.$debugProcess$inlined.getProject(), this.$debugProcess$inlined.getSearchScope(), ClassNameProvider.Configuration.copy$default(ClassNameProvider.Configuration.Companion.getDEFAULT(), false, false, 2, null));
                                Iterable iterable = classNameProvider.getCandidates(sourcePosition2);
                                boolean $i$f$map = false;
                                ClassFilter[] classFilterArray = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    String string2 = (String)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl3 = false;
                                    collection.add(StringsKt.replace$default((String)it, (char)'/', (char)'.', (boolean)false, (int)4, null));
                                }
                                List classNames = (List)destination$iv$iv;
                                for (String className : classNames) {
                                    for (ClassFilter filter2 : settings2.getSteppingFilters()) {
                                        if (!filter2.isEnabled() || !filter2.matches(className)) continue;
                                        bl = true;
                                        break block8;
                                    }
                                }
                            }
                            bl = false;
                        }
                    }
                }
                return (T)Boolean.valueOf(bl);
            }
        });
    }

    public int getStepRequestDepth(@Nullable SuspendContext context2) {
        return 1;
    }
}

