/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFunctionBreakpoint;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFunctionBreakpointKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.SourcePositionRefiner;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\u0012\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/MethodBreakpoint;", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/SourcePositionRefiner;", "project", "Lcom/intellij/openapi/project/Project;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/breakpoints/XBreakpoint;)V", "getPsiClass", "Lcom/intellij/psi/PsiClass;", "invalidateMethodData", "", "refineSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "sourcePosition", "reload", "updateClassPattern", "updateMethodData", "descriptor", "Lcom/intellij/debugger/ui/breakpoints/MethodBreakpoint$MethodDescriptor;", "kotlin.jvm-debugger.core"})
public final class KotlinFunctionBreakpoint
extends MethodBreakpoint
implements SourcePositionRefiner {
    public KotlinFunctionBreakpoint(@NotNull Project project, @NotNull XBreakpoint<?> breakpoint2) {
        super(project, breakpoint2);
    }

    @Nullable
    public PsiClass getPsiClass() {
        SourcePosition sourcePosition = this.getSourcePosition();
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PositionUtil.getPsiElementAt((Project)this.myProject, KtClassOrObject.class, (SourcePosition)sourcePosition);
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject declaration2 = ktClassOrObject;
        return (PsiClass)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> KotlinFunctionBreakpoint.getPsiClass$lambda$0(declaration2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SourcePosition refineSourcePosition(@NotNull SourcePosition sourcePosition) {
        void $this$parentOfType$iv;
        PsiElement psiElement2 = sourcePosition.getElementAt();
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        KtDeclaration ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtDeclaration.class, (boolean)false);
        if (ktDeclaration == null) {
            return sourcePosition;
        }
        KtDeclaration declaration2 = ktDeclaration;
        if (KotlinPsiUtils.isExpectDeclaration(declaration2)) {
            KtDeclaration ktDeclaration2 = KotlinFunctionBreakpointKt.access$getActualJvmDeclaration(declaration2);
            if (ktDeclaration2 == null) {
                return sourcePosition;
            }
            KtDeclaration actualDeclaration = ktDeclaration2;
            SourcePosition sourcePosition2 = SourcePosition.createFromElement((PsiElement)((PsiElement)actualDeclaration));
            if (sourcePosition2 == null) {
                sourcePosition2 = sourcePosition;
            }
            return sourcePosition2;
        }
        return sourcePosition;
    }

    public void reload() {
        super.reload();
        if (ApplicationManager.getApplication().isReadAccessAllowed() && DumbService.isDumb((Project)this.myProject)) {
            return;
        }
        this.invalidateMethodData();
        SourcePosition sourcePosition = this.getSourcePosition();
        MethodBreakpoint.MethodDescriptor descriptor2 = sourcePosition != null ? KotlinFunctionBreakpointKt.getMethodDescriptor(sourcePosition, this.myProject) : null;
        ProgressIndicatorProvider.checkCanceled();
        this.updateMethodData(descriptor2);
        this.updateClassPattern();
    }

    private final void invalidateMethodData() {
        this.setMethodName(null);
        this.mySignature = null;
    }

    private final void updateMethodData(MethodBreakpoint.MethodDescriptor descriptor2) {
        MethodBreakpoint.MethodDescriptor methodDescriptor = descriptor2;
        this.setMethodName(methodDescriptor != null ? methodDescriptor.methodName : null);
        MethodBreakpoint.MethodDescriptor methodDescriptor2 = descriptor2;
        this.mySignature = methodDescriptor2 != null ? methodDescriptor2.methodSignature : null;
        boolean bl = this.myIsStatic = descriptor2 != null && descriptor2.isStatic;
        if (this.myIsStatic) {
            this.setInstanceFiltersEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void updateClassPattern() {
        ProgressIndicatorProvider.checkCanceled();
        Project project = this.myProject;
        String string2 = KotlinDebuggerCoreBundle.message("function.breakpoint.initialize", new Object[0]);
        Task.Backgroundable task2 = new Task.Backgroundable(this, project, string2){
            final /* synthetic */ KotlinFunctionBreakpoint this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                PsiClass psiClass = this.this$0.getPsiClass();
                if (psiClass != null) {
                    boolean $i$f$runReadAction = false;
                    KotlinFunctionBreakpoint.access$getProperties((KotlinFunctionBreakpoint)this.this$0).myClassPattern = (String)ApplicationManager.getApplication().runReadAction(new Computable(psiClass){
                        final /* synthetic */ PsiClass $psiClass$inlined;
                        {
                            this.$psiClass$inlined = psiClass;
                        }

                        public final T compute() {
                            boolean bl = false;
                            return (T)this.$psiClass$inlined.getQualifiedName();
                        }
                    });
                }
            }
        };
        ProgressManager progressManager = ProgressManager.getInstance();
        boolean $i$f$isDispatchThread = false;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                progressManager.runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
                return;
            }
        }
        EmptyProgressIndicator progressIndicator = new EmptyProgressIndicator();
        progressManager.runProcess(() -> KotlinFunctionBreakpoint.updateClassPattern$lambda$1(task2, progressIndicator), (ProgressIndicator)progressIndicator);
    }

    private static final KtLightClass getPsiClass$lambda$0(KtClassOrObject $declaration) {
        return LightClassUtilsKt.toLightClass((KtClassOrObject)$declaration);
    }

    private static final void updateClassPattern$lambda$1(updateClassPattern.task.1 $task, EmptyProgressIndicator $progressIndicator) {
        $task.run((ProgressIndicator)$progressIndicator);
    }

    public static final /* synthetic */ JavaMethodBreakpointProperties access$getProperties(KotlinFunctionBreakpoint $this) {
        return (JavaMethodBreakpointProperties)$this.getProperties();
    }
}

