/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebuggerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.util.FindElementUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a+\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\b\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00170\u0016\u001a\n\u0010\u0018\u001a\u00020\u0011*\u00020\u0019\u00a8\u0006\u001a"}, d2={"getElementsAtLineIfAny", "", "T", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "", "getLambdasAtLineIfAny", "Lorg/jetbrains/kotlin/psi/KtFunction;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "getTopmostParentOnLineOrSelf", "element", "document", "Lcom/intellij/openapi/editor/Document;", "isBreakpointApplicable", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "checker", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "isInlineOnly", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "kotlin.jvm-debugger.core"})
public final class BreakpointTypeUtilsKt {
    public static final boolean isBreakpointApplicable(@NotNull VirtualFile file2, int line, @NotNull Project project, @NotNull Function1<? super PsiElement, ApplicabilityResult> checker) {
        block5: {
            block4: {
                PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(file2);
                if (psiFile2 == null) break block4;
                VirtualFile virtualFile = psiFile2.getVirtualFile();
                if (Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getFileType() : null), (Object)KotlinFileType.INSTANCE)) break block5;
            }
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return false;
        }
        Document document2 = document;
        boolean $i$f$runReadAction = false;
        return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable(project, document2, line, checker){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ Document $document$inlined;
            final /* synthetic */ int $line$inlined;
            final /* synthetic */ Function1 $checker$inlined;
            {
                this.$project$inlined = project;
                this.$document$inlined = document;
                this.$line$inlined = n;
                this.$checker$inlined = function1;
            }

            public final T compute() {
                boolean bl = false;
                Ref.BooleanRef isApplicable2 = new Ref.BooleanRef();
                HashSet<PsiElement> checked = new HashSet<PsiElement>();
                Function1 function1 = (Function1)new Function1<PsiElement, Boolean>(this.$document$inlined, this.$line$inlined, checked, (Function1<? super PsiElement, ApplicabilityResult>)this.$checker$inlined, isApplicable2){
                    final /* synthetic */ Document $document;
                    final /* synthetic */ int $line;
                    final /* synthetic */ HashSet<PsiElement> $checked;
                    final /* synthetic */ Function1<PsiElement, ApplicabilityResult> $checker;
                    final /* synthetic */ Ref.BooleanRef $isApplicable;
                    {
                        this.$document = $document;
                        this.$line = $line;
                        this.$checked = $checked;
                        this.$checker = $checker;
                        this.$isApplicable = $isApplicable;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull PsiElement element3) {
                        block6: {
                            block5: {
                                void $this$getParentOfType$iv;
                                if (element3 instanceof PsiWhiteSpace) break block5;
                                PsiElement psiElement2 = element3;
                                boolean strict$iv = false;
                                boolean $i$f$getParentOfType = false;
                                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, PsiComment.class, (boolean)strict$iv) == null && element3.isValid()) break block6;
                            }
                            return true;
                        }
                        PsiElement parent2 = BreakpointTypeUtilsKt.access$getTopmostParentOnLineOrSelf(element3, this.$document, this.$line);
                        if (!this.$checked.add(parent2)) {
                            return true;
                        }
                        ApplicabilityResult result2 = (ApplicabilityResult)this.$checker.invoke((Object)parent2);
                        if (result2.getShouldStop() && !result2.isApplicable()) {
                            this.$isApplicable.element = false;
                            return false;
                        }
                        this.$isApplicable.element |= result2.isApplicable();
                        return !result2.getShouldStop();
                    }
                };
                XDebuggerUtil.getInstance().iterateLine(this.$project$inlined, this.$document$inlined, this.$line$inlined, new Processor(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        this.function = function2;
                    }

                    public final /* synthetic */ boolean process(Object p0) {
                        return (Boolean)this.function.invoke(p0);
                    }
                });
                return (T)Boolean.valueOf(isApplicable2.element);
            }
        });
    }

    private static final PsiElement getTopmostParentOnLineOrSelf(PsiElement element3, Document document, int line) {
        int offset2;
        PsiElement current = element3;
        PsiElement parent2 = current.getParent();
        while (!(parent2 == null || parent2 instanceof PsiFile || (offset2 = parent2.getTextOffset()) > document.getTextLength() || offset2 >= 0 && document.getLineNumber(offset2) != line)) {
            current = parent2;
            parent2 = current.getParent();
        }
        return current;
    }

    @NotNull
    public static final List<KtFunction> getLambdasAtLineIfAny(@NotNull SourcePosition sourcePosition) {
        PsiFile psiFile2 = sourcePosition.getFile();
        KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file2 = ktFile;
        return BreakpointTypeUtilsKt.getLambdasAtLineIfAny(file2, sourcePosition.getLine());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T extends PsiElement> List<T> getElementsAtLineIfAny(KtFile file2, int line) {
        void $this$filterIsInstanceTo$iv$iv;
        boolean $i$f$getElementsAtLineIfAny = false;
        PsiElement psiElement2 = DebuggerUtil.findElementAtLine(file2, line);
        KtElement ktElement = psiElement2 instanceof KtElement ? (KtElement)psiElement2 : null;
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement lineElement = ktElement;
        int start2 = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)lineElement));
        int end = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)lineElement));
        for (PsiElement nextSibling = lineElement.getNextSibling(); nextSibling != null && line == PsiLinesUtilsKt.getLineNumber$default(nextSibling, false, 1, null); nextSibling = nextSibling.getNextSibling()) {
            end = PsiUtilsKt.getEndOffset((PsiElement)nextSibling);
        }
        PsiFile psiFile2 = (PsiFile)file2;
        Class[] classArray = new Class[1];
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        classArray[0] = PsiElement.class;
        Iterable $this$filterIsInstance$iv = FindElementUtils.findElementsOfClassInRange(psiFile2, start2, end, classArray);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element$iv$iv instanceof Object)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtFunction> getLambdasAtLineIfAny(@NotNull KtFile file2, int line) {
        void $this$filterTo$iv$iv;
        Object lineElement$iv;
        List list2;
        boolean $i$f$getElementsAtLineIfAny = false;
        PsiElement psiElement2 = DebuggerUtil.findElementAtLine(file2, line);
        KtElement ktElement = psiElement2 instanceof KtElement ? (KtElement)psiElement2 : null;
        if (ktElement == null) {
            list2 = CollectionsKt.emptyList();
        } else {
            void $this$filterIsInstanceTo$iv$iv$iv;
            lineElement$iv = ktElement;
            int start$iv = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)lineElement$iv));
            int end$iv = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)lineElement$iv));
            for (PsiElement nextSibling$iv = lineElement$iv.getNextSibling(); nextSibling$iv != null && line == PsiLinesUtilsKt.getLineNumber$default(nextSibling$iv, false, 1, null); nextSibling$iv = nextSibling$iv.getNextSibling()) {
                end$iv = PsiUtilsKt.getEndOffset((PsiElement)nextSibling$iv);
            }
            Class[] classArray = new Class[]{KtFunction.class};
            Iterable $this$filterIsInstance$iv$iv = FindElementUtils.findElementsOfClassInRange((PsiFile)file2, start$iv, end$iv, classArray);
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv instanceof KtFunction)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            list2 = (List)destination$iv$iv$iv;
        }
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        lineElement$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFunction it = (KtFunction)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof KtFunctionLiteral || it.getName() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isInlineOnly(@NotNull KtCallableDeclaration $this$isInlineOnly) {
        boolean bl;
        block4: {
            if (!$this$isInlineOnly.hasModifier(KtTokens.INLINE_KEYWORD)) {
                return false;
            }
            Iterable $this$any$iv = $this$isInlineOnly.getAnnotationEntries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getShortName(), (Object)InlineOnlyKt.getINLINE_ONLY_ANNOTATION_FQ_NAME().shortName())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ PsiElement access$getTopmostParentOnLineOrSelf(PsiElement element3, Document document, int line) {
        return BreakpointTypeUtilsKt.getTopmostParentOnLineOrSelf(element3, document, line);
    }
}

