/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.filters.impl.HyperlinkInfoFactoryImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.idea.debugger.base.util.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinSourceMapCache;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.InlineFunctionHyperLinkInfo;
import org.jetbrains.kotlin.idea.debugger.core.SmapUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.SourceLineKind;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0006H\u0002J*\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/KotlinExceptionFilter;", "Lcom/intellij/execution/filters/ExceptionFilter;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/psi/search/GlobalSearchScope;)V", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "createHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "defaultResult", "createHyperlinks", "Lorg/jetbrains/kotlin/idea/debugger/core/InlineFunctionHyperLinkInfo;", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "parseNativeStackTraceLine", "rawLine", "patchResult", "result", "Companion", "kotlin.jvm-debugger.core"})
public final class KotlinExceptionFilter
extends ExceptionFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlobalSearchScope searchScope;
    private static final Pattern STACK_TRACE_ELEMENT_PATTERN = Pattern.compile("^[\\w|\\s]*at\\s+(.+)\\.(.+)\\((.+):(\\d+)\\)\\s*$");
    private static final Pattern LINE_COLUMN_PATTERN = Pattern.compile("(\\d+):(\\d+)");

    public KotlinExceptionFilter(@NotNull GlobalSearchScope searchScope2) {
        super(searchScope2);
        this.searchScope = searchScope2;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        boolean $i$f$runReadAction = false;
        return (Filter.Result)ApplicationManager.getApplication().runReadAction(new Computable(this, line, entireLength){
            final /* synthetic */ KotlinExceptionFilter this$0;
            final /* synthetic */ String $line$inlined;
            final /* synthetic */ int $entireLength$inlined;
            {
                this.this$0 = kotlinExceptionFilter;
                this.$line$inlined = string2;
                this.$entireLength$inlined = n;
            }

            public final T compute() {
                Filter.Result result2;
                boolean bl = false;
                Filter.Result result3 = result2 = KotlinExceptionFilter.access$applyFilter$s1178634375(this.this$0, this.$line$inlined, this.$entireLength$inlined);
                return (T)(result3 == null ? KotlinExceptionFilter.access$parseNativeStackTraceLine(this.this$0, this.$line$inlined, this.$entireLength$inlined) : KotlinExceptionFilter.access$patchResult(this.this$0, result3, this.$line$inlined));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Filter.Result patchResult(Filter.Result result2, String line) {
        void $this$mapTo$iv$iv;
        HyperlinkInfo hyperlinkInfo = this.createHyperlinkInfo(line, result2);
        if (hyperlinkInfo == null) {
            return result2;
        }
        HyperlinkInfo newHyperlinkInfo = hyperlinkInfo;
        Iterable $this$map$iv = result2.getResultItems();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Filter.ResultItem resultItem = (Filter.ResultItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Filter.ResultItem(it.getHighlightStartOffset(), it.getHighlightEndOffset(), newHyperlinkInfo, it.getHighlightAttributes()));
        }
        List list2 = (List)destination$iv$iv;
        return new Filter.Result(list2);
    }

    /*
     * WARNING - void declaration
     */
    private final HyperlinkInfo createHyperlinkInfo(String line, Filter.Result defaultResult) {
        Project project = this.searchScope.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        StackTraceElement stackTraceElement = KotlinExceptionFilter.Companion.parseStackTraceLine(line);
        if (stackTraceElement == null) {
            return null;
        }
        StackTraceElement stackTraceElement2 = stackTraceElement;
        String string2 = stackTraceElement2.getFileName();
        if (string2 == null) {
            return null;
        }
        String fileName = string2;
        if (!DebuggerUtils.INSTANCE.isKotlinSourceFile(fileName)) {
            return null;
        }
        String fullyQualifiedName = stackTraceElement2.getClassName();
        int lineNumber = stackTraceElement2.getLineNumber() - 1;
        String internalName = StringsKt.replace$default((String)fullyQualifiedName, (char)'.', (char)'/', (boolean)false, (int)4, null);
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)internalName);
        KtFile file2 = DebuggerUtils.findSourceFileForClassIncludeLibrarySources$default(DebuggerUtils.INSTANCE, project2, this.searchScope, jvmClassName, fileName, null, 16, null);
        if (file2 == null) {
            void $this$mapNotNullTo$iv;
            Iterable iterable = defaultResult.getResultItems();
            PsiFile[] destination$iv = (PsiFile[])new HashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                Filter.ResultItem it = (Filter.ResultItem)element$iv;
                boolean bl2 = false;
                FileHyperlinkInfo fileHyperlinkInfo = it instanceof FileHyperlinkInfo ? (FileHyperlinkInfo)it : null;
                if ((fileHyperlinkInfo != null && (fileHyperlinkInfo = fileHyperlinkInfo.getDescriptor()) != null && (fileHyperlinkInfo = fileHyperlinkInfo.getFile()) != null ? fileHyperlinkInfo.getName() : null) == null) continue;
                it$iv = it$iv;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            HashSet defaultLinkFileNames = (HashSet)destination$iv;
            if (!defaultLinkFileNames.contains(fileName)) {
                void $this$mapNotNullTo$iv2;
                destination$iv = FilenameIndex.getFilesByName((Project)project2, (String)fileName, (GlobalSearchScope)this.searchScope);
                Collection destination$iv2 = new HashSet();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv2 = $this$mapNotNullTo$iv2;
                boolean $i$f$forEach2 = false;
                int n = ((void)$this$forEach$iv$iv2).length;
                for (int j = 0; j < n; ++j) {
                    VirtualFile it$iv;
                    void element$iv$iv;
                    void element$iv = element$iv$iv = $this$forEach$iv$iv2[j];
                    boolean bl = false;
                    void it = element$iv;
                    boolean bl4 = false;
                    if ((!it.isValid() ? null : it.getVirtualFile()) == null) continue;
                    it$iv = it$iv;
                    boolean bl5 = false;
                    destination$iv2.add(it$iv);
                }
                HashSet filesByName = (HashSet)destination$iv2;
                if (!((Collection)filesByName).isEmpty()) {
                    return filesByName.size() > 1 ? HyperlinkInfoFactoryImpl.getInstance().createMultipleFilesHyperlinkInfo(CollectionsKt.toList((Iterable)filesByName), lineNumber, project2) : (HyperlinkInfo)new OpenFileHyperlinkInfo(project2, (VirtualFile)CollectionsKt.first((Iterable)filesByName), lineNumber);
                }
            }
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        InlineFunctionHyperLinkInfo hyperlinkInfoForInline = this.createHyperlinks(jvmClassName, virtualFile2, lineNumber + 1, project2);
        if (hyperlinkInfoForInline != null) {
            return (HyperlinkInfo)hyperlinkInfoForInline;
        }
        return (HyperlinkInfo)new OpenFileHyperlinkInfo(project2, virtualFile2, lineNumber);
    }

    private final InlineFunctionHyperLinkInfo createHyperlinks(JvmClassName jvmName, VirtualFile file2, int line, Project project) {
        if (!InlineUtilsKt.isInlineFrameLineNumber(file2, line, project)) {
            return null;
        }
        SMAP sMAP = KotlinSourceMapCache.Companion.getInstance(project).getSourceMap(file2, jvmName);
        if (sMAP == null) {
            return null;
        }
        SMAP smapData = sMAP;
        ArrayList<InlineFunctionHyperLinkInfo.InlineInfo> inlineInfos = new ArrayList<InlineFunctionHyperLinkInfo.InlineInfo>();
        Pair<KtFile, Integer> pair = SmapUtilKt.mapStacktraceLineToSource(smapData, line, project, SourceLineKind.EXECUTED_LINE, this.searchScope);
        if (pair == null) {
            return null;
        }
        Pair<KtFile, Integer> pair2 = pair;
        KtFile inlineFunctionBodyFile = (KtFile)pair2.component1();
        int inlineFunctionBodyLine = ((Number)pair2.component2()).intValue();
        inlineInfos.add(new InlineFunctionHyperLinkInfo.InlineInfo.InlineFunctionBodyInfo(inlineFunctionBodyFile.getVirtualFile(), inlineFunctionBodyLine));
        Pair<KtFile, Integer> inlineFunCallInfo = SmapUtilKt.mapStacktraceLineToSource(smapData, line, project, SourceLineKind.CALL_LINE, this.searchScope);
        if (inlineFunCallInfo != null) {
            KtFile callSiteFile = (KtFile)inlineFunCallInfo.component1();
            int callSiteLine = ((Number)inlineFunCallInfo.component2()).intValue();
            inlineInfos.add(new InlineFunctionHyperLinkInfo.InlineInfo.CallSiteInfo(callSiteFile.getVirtualFile(), callSiteLine));
        }
        return new InlineFunctionHyperLinkInfo(project, (List<? extends InlineFunctionHyperLinkInfo.InlineInfo>)inlineInfos);
    }

    private final Filter.Result parseNativeStackTraceLine(String rawLine, int entireLength) {
        String atPrefix = "at ";
        String ktExtension = ".kt:";
        Project project = this.searchScope.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        String line = ((Object)StringsKt.trim((CharSequence)rawLine)).toString();
        if (!StringsKt.startsWith$default((String)line, (String)atPrefix, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((CharSequence)line, (char)')', (boolean)false, (int)2, null)) {
            return null;
        }
        int fileNameBegin = StringsKt.lastIndexOf$default((CharSequence)line, (char)'(', (int)0, (boolean)false, (int)6, null) + 1;
        if (fileNameBegin < 1) {
            return null;
        }
        int fileNameEnd = StringsKt.indexOf$default((CharSequence)line, (String)ktExtension, (int)fileNameBegin, (boolean)false, (int)4, null) + ktExtension.length() - 1;
        if (fileNameEnd < ktExtension.length() - 1) {
            return null;
        }
        String string2 = line.substring(fileNameBegin, fileNameEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        VirtualFile virtualFile = KotlinExceptionFilter.Companion.findFile(string2);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        String string3 = line.substring(fileNameEnd + 1, StringsKt.getLastIndex((CharSequence)line));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        Pair pair = KotlinExceptionFilter.Companion.parsLineColumn(string3);
        int lineNumber = ((Number)pair.component1()).intValue();
        int columnNumber = ((Number)pair.component2()).intValue();
        int offset2 = entireLength - rawLine.length() + StringsKt.indexOf$default((CharSequence)rawLine, (String)atPrefix, (int)0, (boolean)false, (int)6, null);
        int highlightEndOffset = offset2 + (lineNumber > 0 ? StringsKt.getLastIndex((CharSequence)line) : fileNameEnd);
        OpenFileHyperlinkInfo hyperLinkInfo = new OpenFileHyperlinkInfo(project2, virtualFile2, Math.max(0, lineNumber - 1), columnNumber);
        return new Filter.Result(offset2 + fileNameBegin, highlightEndOffset, (HyperlinkInfo)hyperLinkInfo);
    }

    public static final /* synthetic */ Filter.Result access$applyFilter$s1178634375(KotlinExceptionFilter $this, String p0, int p1) {
        return super.applyFilter(p0, p1);
    }

    public static final /* synthetic */ Filter.Result access$parseNativeStackTraceLine(KotlinExceptionFilter $this, String rawLine, int entireLength) {
        return $this.parseNativeStackTraceLine(rawLine, entireLength);
    }

    public static final /* synthetic */ Filter.Result access$patchResult(KotlinExceptionFilter $this, Filter.Result result2, String line) {
        return $this.patchResult(result2, line);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/KotlinExceptionFilter$Companion;", "", "()V", "LINE_COLUMN_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "STACK_TRACE_ELEMENT_PATTERN", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileName", "", "parsLineColumn", "Lkotlin/Pair;", "", "locationLine", "parseStackTraceLine", "Ljava/lang/StackTraceElement;", "line", "kotlin.jvm-debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        private final StackTraceElement parseStackTraceLine(String line) {
            Matcher matcher2 = STACK_TRACE_ELEMENT_PATTERN.matcher(line);
            if (matcher2.matches()) {
                String declaringClass = matcher2.group(1);
                String methodName2 = matcher2.group(2);
                String fileName = matcher2.group(3);
                String lineNumber = matcher2.group(4);
                return new StackTraceElement(declaringClass, methodName2, fileName, Integer.parseInt(lineNumber));
            }
            return null;
        }

        private final VirtualFile findFile(String fileName) {
            if (!DebuggerUtils.INSTANCE.isKotlinSourceFile(fileName)) {
                return null;
            }
            String vfsFileName = FileUtil.toSystemIndependentName((String)fileName);
            return LocalFileSystem.getInstance().findFileByPath(vfsFileName);
        }

        private final Pair<Integer, Integer> parsLineColumn(String locationLine) {
            Matcher matcher2 = LINE_COLUMN_PATTERN.matcher(locationLine);
            if (matcher2.matches()) {
                int line = Integer.parseInt(matcher2.group(1));
                int column = Integer.parseInt(matcher2.group(2));
                return new Pair((Object)line, (Object)column);
            }
            return new Pair((Object)0, (Object)0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

