/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"ANDROIDX_COMPOSE_PACKAGE_NAME", "", "COMPOSABLE_SINGLETONS_PREFIX", "computeComposableSingletonsClassName", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getClassPrepareRequestForComposableSingletons", "Lcom/sun/jdi/request/ClassPrepareRequest;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "requestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "getComposableSingletonsClasses", "", "Lcom/sun/jdi/ReferenceType;", "isInsideProjectWithCompose", "", "Lcom/intellij/debugger/SourcePosition;", "kotlin.jvm-debugger.core"})
public final class ComposeUtilsKt {
    @NotNull
    private static final String COMPOSABLE_SINGLETONS_PREFIX = "ComposableSingletons";
    @NotNull
    private static final String ANDROIDX_COMPOSE_PACKAGE_NAME = "androidx.compose";

    @NotNull
    public static final String computeComposableSingletonsClassName(@NotNull KtFile file2) {
        Object object = file2.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            object = file2.getName();
        }
        Object filePath = object;
        char[] cArray = new char[]{'/'};
        String fileName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)filePath), (char[])cArray, (boolean)false, (int)0, (int)6, null));
        String shortName = PackagePartClassUtils.getFilePartShortName((String)fileName);
        boolean $i$f$runReadAction = false;
        FqName fileClassFqName = ((JvmFileClassInfo)ApplicationManager.getApplication().runReadAction(new Computable(file2){
            final /* synthetic */ KtFile $file$inlined;
            {
                this.$file$inlined = ktFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)this.$file$inlined);
            }
        })).getFacadeClassFqName();
        String classNameSuffix = "ComposableSingletons$" + shortName;
        FqName filePackageName = fileClassFqName.parent();
        if (filePackageName.isRoot()) {
            return classNameSuffix;
        }
        return filePackageName.asString() + "." + classNameSuffix;
    }

    public static final boolean isInsideProjectWithCompose(@NotNull SourcePosition $this$isInsideProjectWithCompose) {
        return (Boolean)ReadAction.nonBlocking(() -> ComposeUtilsKt.isInsideProjectWithCompose$lambda$1($this$isInsideProjectWithCompose)).executeSynchronously();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ReferenceType> getComposableSingletonsClasses(@NotNull DebugProcess debugProcess, @NotNull KtFile file2) {
        void $this$flatMapTo$iv$iv;
        VirtualMachineProxy vm = debugProcess.getVirtualMachineProxy();
        String composableSingletonsClassName = ComposeUtilsKt.computeComposableSingletonsClassName(file2);
        Iterable $this$flatMap$iv = vm.classesByName(composableSingletonsClassName);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ReferenceType referenceType = (ReferenceType)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = referenceType.isPrepared() ? vm.nestedTypes(referenceType) : CollectionsKt.emptyList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ClassPrepareRequest getClassPrepareRequestForComposableSingletons(@NotNull DebugProcess debugProcess, @NotNull ClassPrepareRequestor requestor, @NotNull KtFile file2) {
        return debugProcess.getRequestsManager().createClassPrepareRequest(requestor, ComposeUtilsKt.computeComposableSingletonsClassName(file2) + "$*");
    }

    private static final Boolean isInsideProjectWithCompose$lambda$1(SourcePosition $this_isInsideProjectWithCompose) {
        return JavaPsiFacade.getInstance((Project)$this_isInsideProjectWithCompose.getFile().getProject()).findPackage(ANDROIDX_COMPOSE_PACKAGE_NAME) != null;
    }
}

