/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.debugger.core.KotlinEditorTextProvider;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a8\u0006\u0007"}, d2={"getAccurateContextElement", "Lcom/intellij/psi/PsiElement;", "elementAt", "containingFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getContextElement", "getElementSkippingWhitespaces", "kotlin.jvm-debugger.core"})
public final class CodeFragmentContextUtilsKt {
    @Nullable
    public static final PsiElement getContextElement(@Nullable PsiElement elementAt) {
        if (elementAt == null) {
            return null;
        }
        if (elementAt instanceof PsiCodeBlock) {
            PsiElement psiElement2 = ((PsiCodeBlock)elementAt).getContext();
            return CodeFragmentContextUtilsKt.getContextElement((PsiElement)(psiElement2 != null ? psiElement2.getContext() : null));
        }
        if (elementAt instanceof KtLightClass) {
            return CodeFragmentContextUtilsKt.getContextElement((PsiElement)((KtLightClass)elementAt).getKotlinOrigin());
        }
        PsiFile containingFile = elementAt.getContainingFile();
        if (containingFile instanceof PsiJavaFile) {
            return elementAt;
        }
        if (!(containingFile instanceof KtFile)) {
            return null;
        }
        PsiElement accurateElement = CodeFragmentContextUtilsKt.getAccurateContextElement(elementAt, (KtFile)containingFile);
        if (accurateElement != null) {
            return accurateElement;
        }
        return (PsiElement)containingFile;
    }

    /*
     * WARNING - void declaration
     */
    private static final PsiElement getAccurateContextElement(PsiElement elementAt, KtFile containingFile) {
        PsiElement elementAtSkippingWhitespaces = CodeFragmentContextUtilsKt.getElementSkippingWhitespaces(elementAt);
        if (elementAtSkippingWhitespaces instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)elementAtSkippingWhitespaces).getElementType(), (Object)KtTokens.RBRACE)) {
            PsiElement declarationParent;
            KtClassOrObject classOrObject;
            KtClassBody classBody;
            PsiElement psiElement2 = ((LeafPsiElement)elementAtSkippingWhitespaces).getParent();
            KtClassBody ktClassBody = classBody = psiElement2 instanceof KtClassBody ? (KtClassBody)psiElement2 : null;
            PsiElement psiElement3 = ktClassBody != null ? ktClassBody.getParent() : null;
            KtClassOrObject ktClassOrObject = classOrObject = psiElement3 instanceof KtClassOrObject ? (KtClassOrObject)psiElement3 : null;
            Object object = declarationParent = ktClassOrObject != null ? ktClassOrObject.getParent() : null;
            if (declarationParent instanceof KtObjectLiteralExpression) {
                declarationParent = ((KtObjectLiteralExpression)declarationParent).getParent();
            }
            if (declarationParent != null) {
                return CodeFragmentContextUtilsKt.getAccurateContextElement(declarationParent, containingFile);
            }
        }
        int lineStartOffset = elementAtSkippingWhitespaces.getTextOffset();
        KtExpression targetExpression = (KtExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)((PsiFile)containingFile), (int)lineStartOffset, KtExpression.class, (boolean)false);
        KotlinEditorTextProvider editorTextProvider = KotlinEditorTextProvider.Companion.getInstance();
        if (targetExpression != null) {
            Object v3;
            PsiElement psiElement4;
            block8: {
                void $this$firstOrNull$iv;
                if (editorTextProvider.isAcceptedAsCodeFragmentContext((PsiElement)targetExpression)) {
                    return (PsiElement)targetExpression;
                }
                psiElement4 = editorTextProvider.findEvaluationTarget(elementAt, true);
                if (psiElement4 != null) {
                    PsiElement it = psiElement4;
                    boolean bl = false;
                    return it;
                }
                Sequence sequence2 = PsiUtilsKt.getParents((PsiElement)((PsiElement)targetExpression));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!editorTextProvider.isAcceptedAsCodeFragmentContext(it)) continue;
                    v3 = element$iv;
                    break block8;
                }
                v3 = null;
            }
            psiElement4 = v3;
            if (psiElement4 != null) {
                PsiElement it = psiElement4;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    private static final PsiElement getElementSkippingWhitespaces(PsiElement elementAt) {
        Class[] classArray;
        PsiElement newElement;
        if ((elementAt instanceof PsiWhiteSpace || elementAt instanceof PsiComment) && (newElement = PsiTreeUtil.skipSiblingsForward((PsiElement)elementAt, (Class[])(classArray = new Class[]{PsiWhiteSpace.class, PsiComment.class}))) != null) {
            return newElement;
        }
        return elementAt;
    }
}

