/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.SourcePosition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.base.util.caching.ConcurrentFactoryCache;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculator;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0017H\u0002J(\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J\f\u0010\"\u001a\u00020\n*\u00020#H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "configuration", "Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$Configuration;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$Configuration;)V", "hasInlineAccessors", "", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getHasInlineAccessors", "(Lorg/jetbrains/kotlin/psi/KtProperty;)Z", "computeCandidatesForElement", "", "", "element", "Lcom/intellij/psi/PsiElement;", "alreadyVisited", "", "findInlinedCalls", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getCandidates", "position", "Lcom/intellij/debugger/SourcePosition;", "getCandidatesForElement", "getInlinedReferenceElement", "reference", "Lcom/intellij/psi/PsiReference;", "getScopeForInlineDeclarationUsages", "inlineDeclaration", "processInlinedReference", "isInterfaceClass", "Lcom/intellij/psi/PsiNamedElement;", "Configuration", "kotlin.jvm-debugger.core"})
public final class ClassNameProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope searchScope;
    @NotNull
    private final Configuration configuration;

    public ClassNameProvider(@NotNull Project project, @NotNull GlobalSearchScope searchScope2, @NotNull Configuration configuration2) {
        this.project = project;
        this.searchScope = searchScope2;
        this.configuration = configuration2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @NotNull
    public final List<String> getCandidates(@NotNull SourcePosition position) {
        void $this$flatMapTo$iv$iv;
        Object p0;
        Object object;
        block4: {
            block3: {
                object = position.getElementAt();
                if (object == null) break block3;
                p0 = object;
                boolean bl = false;
                List<String> list2 = this.getCandidatesForElement((PsiElement)p0);
                object = list2;
                if (list2 != null) break block4;
            }
            object = CollectionsKt.emptyList();
        }
        Object regularClassNames = object;
        Iterable $this$flatMap$iv = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(position);
        boolean $i$f$flatMap = false;
        p0 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            KtFunction it = (KtFunction)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getCandidatesForElement((PsiElement)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List lambdaClassNames = (List)destination$iv$iv;
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)((Collection)regularClassNames), (Iterable)lambdaClassNames));
    }

    @NotNull
    public final List<String> getCandidatesForElement(@NotNull PsiElement element3) {
        ConcurrentFactoryCache cache2 = (ConcurrentFactoryCache)CachedValuesManager.getCachedValue((PsiElement)element3, ClassNameProvider::getCandidatesForElement$lambda$1);
        return (List)cache2.get(this.configuration, (Function1)new Function1<Configuration, List<? extends String>>(this, element3){
            final /* synthetic */ ClassNameProvider this$0;
            final /* synthetic */ PsiElement $element;
            {
                this.this$0 = $receiver;
                this.$element = $element;
                super(1);
            }

            public final List<String> invoke(Configuration it) {
                return ClassNameProvider.access$computeCandidatesForElement(this.this$0, this.$element, SetsKt.emptySet());
            }
        });
    }

    private final List<String> computeCandidatesForElement(PsiElement element3, Set<? extends PsiElement> alreadyVisited) {
        ArrayList<String> result2 = new ArrayList<String>();
        PsiElement current = element3;
        while (true) {
            PsiElement psiElement2;
            if ((psiElement2 = current) instanceof KtScript ? true : psiElement2 instanceof KtFile) {
                PsiElement psiElement3 = current;
                Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                ClassNameProvider.computeCandidatesForElement$registerClassName(result2, (KtElement)psiElement3);
                break;
            }
            if (psiElement2 instanceof KtClassOrObject) {
                className = ClassNameProvider.computeCandidatesForElement$registerClassName(result2, (KtElement)current);
                if (className != null) {
                    if (!this.isInterfaceClass((PsiNamedElement)current)) break;
                    result2.add(className + "$DefaultImpls");
                    break;
                }
            } else if (psiElement2 instanceof KtProperty) {
                KtClassOrObject propertyOwner;
                if (this.configuration.getFindInlineUseSites() && this.getHasInlineAccessors((KtProperty)current)) {
                    CollectionsKt.addAll((Collection)result2, (Iterable)this.findInlinedCalls((KtDeclaration)current, alreadyVisited));
                }
                if ((propertyOwner = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)current))) instanceof KtObjectDeclaration && ((KtObjectDeclaration)propertyOwner).isCompanion()) {
                    KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)propertyOwner));
                    if (ktClassOrObject == null) {
                        break;
                    }
                    current = (PsiElement)ktClassOrObject;
                    continue;
                }
            } else if (psiElement2 instanceof KtNamedFunction) {
                if (this.configuration.getFindInlineUseSites() && ((KtNamedFunction)current).hasModifier(KtTokens.INLINE_KEYWORD)) {
                    CollectionsKt.addAll((Collection)result2, (Iterable)this.findInlinedCalls((KtDeclaration)current, alreadyVisited));
                }
                if (((KtNamedFunction)current).isLocal()) {
                    ClassNameProvider.computeCandidatesForElement$registerClassName(result2, (KtElement)current);
                }
            } else if (psiElement2 instanceof KtAnonymousInitializer) {
                KtDeclaration initializerOwner = ((KtAnonymousInitializer)current).getContainingDeclaration();
                if (initializerOwner instanceof KtObjectDeclaration && ((KtObjectDeclaration)initializerOwner).isCompanion()) {
                    KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)initializerOwner);
                    if (ktClassOrObject == null) {
                        break;
                    }
                    current = (PsiElement)ktClassOrObject;
                    continue;
                }
            } else if (psiElement2 instanceof KtCallableReferenceExpression ? true : psiElement2 instanceof KtLambdaExpression) {
                PsiElement psiElement4 = current;
                Intrinsics.checkNotNull((Object)psiElement4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                className = ClassNameProvider.computeCandidatesForElement$registerClassName(result2, (KtElement)psiElement4);
                if (className != null && !this.configuration.getAlwaysReturnLambdaParentClass()) {
                    break;
                }
            } else if (psiElement2 instanceof KtObjectLiteralExpression) {
                ClassNameProvider.computeCandidatesForElement$registerClassName(result2, (KtElement)current);
            }
            if (current.getParent() == null) break;
        }
        return result2;
    }

    private final boolean isInterfaceClass(PsiNamedElement $this$isInterfaceClass) {
        PsiNamedElement psiNamedElement = $this$isInterfaceClass;
        return psiNamedElement instanceof KtClass ? ((KtClass)$this$isInterfaceClass).isInterface() : (psiNamedElement instanceof PsiClass ? ((PsiClass)$this$isInterfaceClass).isInterface() : false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findInlinedCalls(KtDeclaration declaration2, Set<? extends PsiElement> alreadyVisited) {
        void $this$flatMapTo$iv$iv;
        Object[] e2;
        boolean isSuccess;
        HashSet searchResult = new HashSet();
        String string2 = declaration2.getName();
        if (string2 == null) {
            string2 = "<error>";
        }
        String declarationName = string2;
        Runnable task2 = () -> ClassNameProvider.findInlinedCalls$lambda$4(declaration2, this, alreadyVisited, searchResult);
        boolean $i$f$isDispatchThread = false;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Object[] objectArray = new Object[]{declarationName};
            String progressMessage = KotlinDebuggerCoreBundle.message("find.inline.calls.task.compute.names", objectArray);
            v1 = ProgressManager.getInstance().runProcessWithProgressSynchronously(task2, progressMessage, true, this.project);
        } else {
            boolean progressMessage;
            try {
                ProgressManager.getInstance().runProcess(task2, (ProgressIndicator)new EmptyProgressIndicator());
                progressMessage = true;
            }
            catch (InterruptedException e2) {
                progressMessage = false;
            }
            v1 = isSuccess = progressMessage;
        }
        if (!isSuccess) {
            e2 = new Object[]{declarationName};
            String notificationMessage = KotlinDebuggerCoreBundle.message("find.inline.calls.task.cancelled", e2);
            XDebuggerManagerImpl.getNotificationGroup().createNotification(notificationMessage, MessageType.WARNING).notify(this.project);
        }
        Object[] $this$findInlinedCalls_u24lambda_u245 = e2 = SetsKt.createSetBuilder();
        boolean $i$a$-buildSet-ClassNameProvider$findInlinedCalls$newAlreadyVisited$22 = false;
        $this$findInlinedCalls_u24lambda_u245.addAll((Collection)alreadyVisited);
        $this$findInlinedCalls_u24lambda_u245.addAll(searchResult);
        $this$findInlinedCalls_u24lambda_u245.add(declaration2);
        Set newAlreadyVisited = SetsKt.build((Set)e2);
        Iterable $this$flatMap$iv = searchResult;
        boolean $i$f$flatMap = false;
        Iterable $i$a$-buildSet-ClassNameProvider$findInlinedCalls$newAlreadyVisited$22 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.computeCandidatesForElement(it, newAlreadyVisited);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final PsiElement processInlinedReference(KtDeclaration declaration2, PsiReference reference2, Set<? extends PsiElement> alreadyVisited) {
        if (SearchUtilKt.isImportUsage(reference2) || !Intrinsics.areEqual((Object)reference2.getElement().getLanguage(), (Object)KotlinLanguage.INSTANCE)) {
            return null;
        }
        PsiElement element3 = this.getInlinedReferenceElement(reference2);
        return !PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)declaration2), (PsiElement)element3, (boolean)false, (int)2, null) && !alreadyVisited.contains(element3) ? element3 : null;
    }

    private final PsiElement getInlinedReferenceElement(PsiReference reference2) {
        PsiElement element3 = reference2.getElement();
        Class[] classArray = new Class[]{KtDeclaration.class, KtFile.class, KtScript.class, KtCallableReferenceExpression.class, KtLambdaExpression.class, KtObjectLiteralExpression.class};
        KtElement ktElement = (KtElement)PsiUtilsKt.getParentOfTypes((PsiElement)element3, (boolean)false, (Class[])classArray);
        return ktElement != null ? (PsiElement)ktElement : element3;
    }

    private final GlobalSearchScope getScopeForInlineDeclarationUsages(KtDeclaration inlineDeclaration) {
        VirtualFile virtualFile = inlineDeclaration.getContainingFile().getVirtualFile();
        return virtualFile != null && SourceKindFilterUtils.matches(RootKindFilter.libraryFiles, this.project, virtualFile) ? this.searchScope.uniteWith(KotlinSourceFilterScope.Companion.librarySources(GlobalSearchScope.allScope((Project)this.project), this.project)) : this.searchScope;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getHasInlineAccessors(KtProperty $this$hasInlineAccessors) {
        KtPropertyAccessor it;
        if ($this$hasInlineAccessors.hasModifier(KtTokens.INLINE_KEYWORD)) return true;
        Iterable $this$any$iv = $this$hasInlineAccessors.getAccessors();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (KtPropertyAccessor)element$iv;
            boolean bl = false;
        } while (!it.hasModifier(KtTokens.INLINE_KEYWORD));
        return true;
    }

    private static final CachedValueProvider.Result getCandidatesForElement$lambda$1() {
        ConcurrentHashMap storage = new ConcurrentHashMap();
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return new CachedValueProvider.Result(new ConcurrentFactoryCache(storage), objectArray);
    }

    private static final String computeCandidatesForElement$registerClassName(ArrayList<String> result2, KtElement element3) {
        String string2;
        String string3 = ClassNameCalculator.INSTANCE.getClassName(element3);
        if (string3 != null) {
            String string4;
            String it = string4 = string3;
            boolean bl = false;
            ((Collection)result2).add(it);
            string2 = string4;
        } else {
            string2 = null;
        }
        return string2;
    }

    private static final void findInlinedCalls$lambda$4(KtDeclaration $declaration, ClassNameProvider this$0, Set $alreadyVisited, HashSet $searchResult) {
        for (PsiReference reference2 : ReferencesSearch.search((PsiElement)((PsiElement)$declaration), (SearchScope)((SearchScope)this$0.getScopeForInlineDeclarationUsages($declaration)))) {
            PsiElement it;
            ProgressManager.checkCanceled();
            if (this$0.processInlinedReference($declaration, reference2, $alreadyVisited) == null) continue;
            boolean bl = false;
            ((Collection)$searchResult).add(it);
        }
    }

    public static final /* synthetic */ List access$computeCandidatesForElement(ClassNameProvider $this, PsiElement element3, Set alreadyVisited) {
        return $this.computeCandidatesForElement(element3, alreadyVisited);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$Configuration;", "", "findInlineUseSites", "", "alwaysReturnLambdaParentClass", "(ZZ)V", "getAlwaysReturnLambdaParentClass", "()Z", "getFindInlineUseSites", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "kotlin.jvm-debugger.core"})
    public static final class Configuration {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean findInlineUseSites;
        private final boolean alwaysReturnLambdaParentClass;
        @NotNull
        private static final Configuration DEFAULT = new Configuration(true, true);

        public Configuration(boolean findInlineUseSites, boolean alwaysReturnLambdaParentClass) {
            this.findInlineUseSites = findInlineUseSites;
            this.alwaysReturnLambdaParentClass = alwaysReturnLambdaParentClass;
        }

        public final boolean getFindInlineUseSites() {
            return this.findInlineUseSites;
        }

        public final boolean getAlwaysReturnLambdaParentClass() {
            return this.alwaysReturnLambdaParentClass;
        }

        public final boolean component1() {
            return this.findInlineUseSites;
        }

        public final boolean component2() {
            return this.alwaysReturnLambdaParentClass;
        }

        @NotNull
        public final Configuration copy(boolean findInlineUseSites, boolean alwaysReturnLambdaParentClass) {
            return new Configuration(findInlineUseSites, alwaysReturnLambdaParentClass);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = configuration2.findInlineUseSites;
            }
            if ((n & 2) != 0) {
                bl2 = configuration2.alwaysReturnLambdaParentClass;
            }
            return configuration2.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Configuration(findInlineUseSites=" + this.findInlineUseSites + ", alwaysReturnLambdaParentClass=" + this.alwaysReturnLambdaParentClass + ")";
        }

        public int hashCode() {
            int n;
            int result2;
            int n2 = this.findInlineUseSites ? 1 : 0;
            if (n2 != 0) {
                n2 = result2 = 1;
            }
            if ((n = this.alwaysReturnLambdaParentClass) != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Configuration)) {
                return false;
            }
            Configuration configuration2 = (Configuration)other;
            if (this.findInlineUseSites != configuration2.findInlineUseSites) {
                return false;
            }
            return this.alwaysReturnLambdaParentClass == configuration2.alwaysReturnLambdaParentClass;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$Configuration$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$Configuration;", "getDEFAULT", "()Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$Configuration;", "kotlin.jvm-debugger.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Configuration getDEFAULT() {
                return DEFAULT;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

