/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.calls.KtCall;
import org.jetbrains.kotlin.analysis.api.calls.KtCallInfo;
import org.jetbrains.kotlin.analysis.api.calls.KtCallKt;
import org.jetbrains.kotlin.analysis.api.calls.KtFunctionCall;
import org.jetbrains.kotlin.analysis.api.calls.KtSuccessCallInfo;
import org.jetbrains.kotlin.analysis.api.signatures.KtVariableLikeSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KtConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtNonErrorClassType;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.idea.debugger.core.AnalysisApiBasedInlineUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u0011*\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\u0011*\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0011*\u00020\u0012H\u0002J\u001a\u0010\u0019\u001a\u00020\u0011*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0011J\u0014\u0010\u001b\u001a\u00020\u0011*\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0014H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/AnalysisApiBasedInlineUtil;", "", "()V", "getInlineArgumentSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtValueParameterSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "argument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getResolvedFunctionCall", "Lorg/jetbrains/kotlin/analysis/api/calls/KtFunctionCall;", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getValueArgumentForExpression", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isArrayConstructorWithLambda", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol;", "isArrayOrPrimitiveArray", "Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "isClassTypeWithClassId", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "isInline", "isInlinedArgument", "checkNonLocalReturn", "isNotNullableFunctionType", "type", "kotlin.jvm-debugger.core"})
public final class AnalysisApiBasedInlineUtil {
    @NotNull
    public static final AnalysisApiBasedInlineUtil INSTANCE = new AnalysisApiBasedInlineUtil();

    private AnalysisApiBasedInlineUtil() {
    }

    public final boolean isInlinedArgument(@NotNull KtAnalysisSession $this$isInlinedArgument, @NotNull KtFunction argument2, boolean checkNonLocalReturn) {
        KtValueParameterSymbol ktValueParameterSymbol = this.getInlineArgumentSymbol($this$isInlinedArgument, argument2);
        if (ktValueParameterSymbol == null) {
            return false;
        }
        KtValueParameterSymbol argumentSymbol = ktValueParameterSymbol;
        KtType argumentType = argumentSymbol.getReturnType();
        return !argumentSymbol.isNoinline() && this.isNotNullableFunctionType($this$isInlinedArgument, argumentType) && (!checkNonLocalReturn || !argumentSymbol.isCrossinline());
    }

    private final KtValueParameterSymbol getInlineArgumentSymbol(KtAnalysisSession $this$getInlineArgumentSymbol, KtFunction argument2) {
        if (!(argument2 instanceof KtFunctionLiteral) && !(argument2 instanceof KtNamedFunction)) {
            return null;
        }
        KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)((KtExpression)argument2));
        KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression parentCall2 = ktCallExpression;
        KtFunctionCall<?> ktFunctionCall = this.getResolvedFunctionCall($this$getInlineArgumentSymbol, parentCall2);
        if (ktFunctionCall == null) {
            return null;
        }
        KtFunctionCall<?> call = ktFunctionCall;
        KtFunctionLikeSymbol callSymbol = (KtFunctionLikeSymbol)KtCallKt.getSymbol(call.getPartiallyAppliedSymbol());
        if (!this.isInline(callSymbol) && !this.isArrayConstructorWithLambda(callSymbol)) {
            return null;
        }
        ValueArgument valueArgument = this.getValueArgumentForExpression(parentCall2, (KtExpression)argument2);
        if (valueArgument == null) {
            return null;
        }
        ValueArgument valueArgument2 = valueArgument;
        KtVariableLikeSignature ktVariableLikeSignature = (KtVariableLikeSignature)((Map)call.getArgumentMapping()).get(valueArgument2.getArgumentExpression());
        return ktVariableLikeSignature != null ? (KtValueParameterSymbol)ktVariableLikeSignature.getSymbol() : null;
    }

    @Nullable
    public final KtFunctionCall<?> getResolvedFunctionCall(@NotNull KtAnalysisSession $this$getResolvedFunctionCall, @NotNull KtCallExpression callExpression2) {
        KtCallInfo ktCallInfo = $this$getResolvedFunctionCall.resolveCall((KtCallElement)callExpression2);
        KtSuccessCallInfo ktSuccessCallInfo = ktCallInfo instanceof KtSuccessCallInfo ? (KtSuccessCallInfo)ktCallInfo : null;
        if (ktSuccessCallInfo == null) {
            return null;
        }
        KtSuccessCallInfo callInfo = ktSuccessCallInfo;
        KtCall ktCall = callInfo.getCall();
        return ktCall instanceof KtFunctionCall ? (KtFunctionCall)ktCall : null;
    }

    private final boolean isInline(KtFunctionLikeSymbol $this$isInline) {
        return $this$isInline instanceof KtFunctionSymbol && ((KtFunctionSymbol)$this$isInline).isInline();
    }

    private final boolean isNotNullableFunctionType(KtAnalysisSession $this$isNotNullableFunctionType, KtType type2) {
        return ($this$isNotNullableFunctionType.isFunctionType(type2) || $this$isNotNullableFunctionType.isSuspendFunctionType(type2)) && !$this$isNotNullableFunctionType.isMarkedNullable(type2);
    }

    private final boolean isArrayConstructorWithLambda(KtFunctionLikeSymbol $this$isArrayConstructorWithLambda) {
        return $this$isArrayConstructorWithLambda instanceof KtConstructorSymbol && $this$isArrayConstructorWithLambda.getValueParameters().size() == 2 && this.isArrayOrPrimitiveArray($this$isArrayConstructorWithLambda.getReturnType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isArrayOrPrimitiveArray(KtType $this$isArrayOrPrimitiveArray) {
        ClassId it;
        if (this.isClassTypeWithClassId($this$isArrayOrPrimitiveArray, StandardClassIds.INSTANCE.getArray())) return true;
        Iterable $this$any$iv = StandardClassIds.INSTANCE.getElementTypeByPrimitiveArrayType().keySet();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (ClassId)element$iv;
            boolean bl = false;
        } while (!INSTANCE.isClassTypeWithClassId($this$isArrayOrPrimitiveArray, it));
        return true;
    }

    private final boolean isClassTypeWithClassId(KtType $this$isClassTypeWithClassId, ClassId classId) {
        return $this$isClassTypeWithClassId instanceof KtNonErrorClassType && Intrinsics.areEqual((Object)((KtNonErrorClassType)$this$isClassTypeWithClassId).getClassId(), (Object)classId);
    }

    @Nullable
    public final ValueArgument getValueArgumentForExpression(@NotNull KtCallExpression $this$getValueArgumentForExpression, @NotNull KtExpression expression2) {
        Object v1;
        block1: {
            Iterable $this$firstOrNull$iv = $this$getValueArgumentForExpression.getValueArguments();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtValueArgument it = (KtValueArgument)element$iv;
                boolean bl = false;
                KtValueArgument ktValueArgument = it;
                if (!(ktValueArgument != null && (ktValueArgument = ktValueArgument.getArgumentExpression()) != null ? AnalysisApiBasedInlineUtil.getValueArgumentForExpression$isParenthesizedExpression((KtElement)ktValueArgument, expression2) : false)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final KtElement getValueArgumentForExpression$deparenthesizeStructurally(KtElement $this$getValueArgumentForExpression_u24deparenthesizeStructurally) {
        KtElement deparenthesized = $this$getValueArgumentForExpression_u24deparenthesizeStructurally instanceof KtExpression ? (KtElement)KtPsiUtil.deparenthesizeOnce((KtExpression)((KtExpression)$this$getValueArgumentForExpression_u24deparenthesizeStructurally)) : $this$getValueArgumentForExpression_u24deparenthesizeStructurally;
        return !Intrinsics.areEqual((Object)deparenthesized, (Object)$this$getValueArgumentForExpression_u24deparenthesizeStructurally) ? deparenthesized : ($this$getValueArgumentForExpression_u24deparenthesizeStructurally instanceof KtLambdaExpression ? (KtElement)((KtLambdaExpression)$this$getValueArgumentForExpression_u24deparenthesizeStructurally).getFunctionLiteral() : ($this$getValueArgumentForExpression_u24deparenthesizeStructurally instanceof KtFunctionLiteral ? (KtElement)((KtFunctionLiteral)$this$getValueArgumentForExpression_u24deparenthesizeStructurally).getBodyExpression() : null));
    }

    private static final boolean getValueArgumentForExpression$isParenthesizedExpression(KtElement $this$getValueArgumentForExpression_u24isParenthesizedExpression, KtExpression $expression) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.generateSequence((Object)$this$getValueArgumentForExpression_u24isParenthesizedExpression, (Function1)getValueArgumentForExpression.isParenthesizedExpression.1.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                KtElement it = (KtElement)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)$expression)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ KtElement access$getValueArgumentForExpression$deparenthesizeStructurally(KtElement $receiver) {
        return AnalysisApiBasedInlineUtil.getValueArgumentForExpression$deparenthesizeStructurally($receiver);
    }
}

