/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinReentrantSourcePosition;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinLineBreakpointTypeKt;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinLineBreakpoint;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.LineBreakpointExpressionVisitor;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0013R\u00020\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00162\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u001cH\u0016J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u001c\u0010\u001e\u001a\u00020\n2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u0014\u001a\u00020\u001fH\u0016\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointType;", "()V", "calculateSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaLineBreakpointProperties;", "canPutAt", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "computeVariants", "", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant;", "position", "createJavaBreakpoint", "Lcom/intellij/debugger/ui/breakpoints/Breakpoint;", "getContainingMethod", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/debugger/ui/breakpoints/LineBreakpoint;", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "getSourcePosition", "matchesPosition", "Lcom/intellij/debugger/SourcePosition;", "KotlinBreakpointVariant", "LineKotlinBreakpointVariant", "kotlin.jvm-debugger.core"})
public final class KotlinLineBreakpointType
extends JavaLineBreakpointType
implements KotlinBreakpointType {
    public KotlinLineBreakpointType() {
        super("kotlin-line", KotlinDebuggerCoreBundle.message("line.breakpoint.tab.title", new Object[0]));
    }

    @NotNull
    public Breakpoint<JavaLineBreakpointProperties> createJavaBreakpoint(@NotNull Project project, @NotNull XBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        return (Breakpoint)new KotlinLineBreakpoint(project, breakpoint2);
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> breakpoint2, @NotNull SourcePosition position) {
        JavaBreakpointProperties properties2 = KotlinLineBreakpointTypeKt.access$getJavaBreakpointProperties(breakpoint2);
        if (properties2 == null || properties2 instanceof JavaLineBreakpointProperties) {
            if (position instanceof KotlinReentrantSourcePosition) {
                return false;
            }
            if (properties2 != null && ((JavaLineBreakpointProperties)properties2).getLambdaOrdinal() == null) {
                return true;
            }
            PsiElement psiElement2 = this.getContainingMethod(breakpoint2);
            if (psiElement2 == null) {
                return false;
            }
            PsiElement containingMethod = psiElement2;
            return KotlinLineBreakpointTypeKt.inTheMethod(position, containingMethod);
        }
        return true;
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> breakpoint2) {
        KtFunction lambda2;
        SourcePosition sourcePosition = breakpoint2.getSourcePosition();
        if (sourcePosition == null) {
            return null;
        }
        SourcePosition position = sourcePosition;
        JavaBreakpointProperties properties2 = KotlinLineBreakpointTypeKt.access$getJavaBreakpointProperties(breakpoint2);
        if (properties2 instanceof JavaLineBreakpointProperties && (lambda2 = KotlinLineBreakpointTypeKt.access$getLambdaByOrdinal(position, ((JavaLineBreakpointProperties)properties2).getLambdaOrdinal())) != null) {
            return (PsiElement)lambda2;
        }
        return KotlinLineBreakpointTypeKt.access$getContainingMethod(position.getElementAt());
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project) {
        return BreakpointTypeUtilsKt.isBreakpointApplicable(file2, line, project, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)new Function1<PsiElement, ApplicabilityResult>(file2, line){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ int $line;
            {
                this.$file = $file;
                this.$line = $line;
                super(1);
            }

            @NotNull
            public final ApplicabilityResult invoke(@NotNull PsiElement element3) {
                LineBreakpointExpressionVisitor visitor2;
                ApplicabilityResult applicabilityResult = element3 instanceof KtDestructuringDeclaration ? ApplicabilityResult.MAYBE_YES : (KotlinLineBreakpointTypeKt.access$isInlineOnlyDeclaration(KotlinLineBreakpointTypeKt.access$getContainingMethod(element3)) ? ApplicabilityResult.DEFINITELY_NO : (KotlinLineBreakpointTypeKt.access$isClosingBraceInMethod(element3) ? ApplicabilityResult.MAYBE_YES : (element3 instanceof KtElement ? ((visitor2 = LineBreakpointExpressionVisitor.Companion.of(this.$file, this.$line)) != null ? (ApplicabilityResult)((KtElement)element3).accept((KtVisitor)visitor2, null) : ApplicabilityResult.UNKNOWN) : ApplicabilityResult.UNKNOWN)));
                return applicabilityResult;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<JavaLineBreakpointType.JavaBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position) {
        Object element$iv2;
        LinkedList<Object> result2;
        List<KtFunction> lambdas;
        SourcePosition pos;
        block8: {
            PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(position.getFile());
            KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
            if (ktFile == null) {
                return CollectionsKt.emptyList();
            }
            KtFile file2 = ktFile;
            pos = SourcePosition.createFromLine((PsiFile)((PsiFile)file2), (int)position.getLine());
            lambdas = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(pos);
            if (lambdas.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            result2 = new LinkedList<Object>();
            Sequence $this$firstIsInstance$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)pos.getElementAt());
            boolean $i$f$firstIsInstance = false;
            for (Object element$iv2 : $this$firstIsInstance$iv) {
                if (!(element$iv2 instanceof KtElement)) continue;
                break block8;
            }
            throw new NoSuchElementException("No element of given type found");
        }
        KtElement elementAt = (KtElement)element$iv2;
        KtFunction mainMethod = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)elementAt), KtFunction.class, (boolean)false);
        boolean mainMethodAdded = false;
        if (mainMethod != null) {
            boolean isLambdaResult;
            KtExpression bodyExpression = mainMethod.getBodyExpression();
            boolean bl = isLambdaResult = bodyExpression instanceof KtLambdaExpression && lambdas.contains(((KtLambdaExpression)bodyExpression).getFunctionLiteral());
            if (!isLambdaResult) {
                PsiElement variantElement = KotlinPsiUtils.getTopmostElementAtOffset((PsiElement)elementAt, pos.getOffset());
                result2.add((Object)new LineKotlinBreakpointVariant(position, variantElement, -1));
                mainMethodAdded = true;
            }
        }
        Iterable $this$forEachIndexed$iv = lambdas;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void lambda2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KtFunction ktFunction = (KtFunction)item$iv;
            int ordinal = n;
            boolean bl = false;
            XSourcePositionImpl positionImpl = XSourcePositionImpl.createByElement((PsiElement)((PsiElement)lambda2.getBodyExpression()));
            if (positionImpl == null) continue;
            result2.add(new JavaLineBreakpointType.LambdaJavaBreakpointVariant((JavaLineBreakpointType)this, (XSourcePosition)positionImpl, (PsiElement)lambda2, Integer.valueOf(ordinal)));
        }
        if (mainMethodAdded && result2.size() > 1) {
            result2.add((Object)new KotlinBreakpointVariant(position, lambdas.size()));
        }
        return result2;
    }

    @Nullable
    public TextRange getHighlightRange(@NotNull XLineBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        JavaLineBreakpointProperties javaLineBreakpointProperties = (JavaLineBreakpointProperties)breakpoint2.getProperties();
        if (javaLineBreakpointProperties == null) {
            return null;
        }
        JavaLineBreakpointProperties properties2 = javaLineBreakpointProperties;
        Integer n = properties2.getLambdaOrdinal();
        if (n == null) {
            return null;
        }
        int ordinal = n;
        Breakpoint breakpoint3 = BreakpointManager.getJavaBreakpoint((XBreakpoint)((XBreakpoint)breakpoint2));
        LineBreakpoint lineBreakpoint = breakpoint3 instanceof LineBreakpoint ? (LineBreakpoint)breakpoint3 : null;
        if (lineBreakpoint == null) {
            return null;
        }
        LineBreakpoint javaBreakpoint = lineBreakpoint;
        SourcePosition sourcePosition = javaBreakpoint.getSourcePosition();
        if (sourcePosition == null) {
            return null;
        }
        SourcePosition position = sourcePosition;
        PsiElement $this$parentOfType_u24default$iv = position.getElementAt();
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtFunction.class, (boolean)true);
        if (ktFunction == null) {
            return null;
        }
        KtFunction function2 = ktFunction;
        SourcePosition sourcePosition2 = SourcePosition.createFromElement((PsiElement)((PsiElement)function2));
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition updatedPosition = sourcePosition2;
        KtFunction ktFunction2 = KotlinLineBreakpointTypeKt.access$getLambdaByOrdinal(updatedPosition, ordinal);
        return ktFunction2 != null ? ktFunction2.getTextRange() : null;
    }

    @Nullable
    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        XSourcePosition xSourcePosition = this.calculateSourcePosition(breakpoint2);
        if (xSourcePosition == null) {
            xSourcePosition = super.getSourcePosition(breakpoint2);
        }
        return xSourcePosition;
    }

    private final XSourcePosition calculateSourcePosition(XBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        JavaLineBreakpointProperties javaLineBreakpointProperties = (JavaLineBreakpointProperties)breakpoint2.getProperties();
        if (javaLineBreakpointProperties == null) {
            return null;
        }
        JavaLineBreakpointProperties javaBreakpointProperties = javaLineBreakpointProperties;
        Intrinsics.checkNotNull(breakpoint2, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl<*>");
        SourcePosition sourcePosition = KotlinLineBreakpointTypeKt.access$createLineSourcePosition((XLineBreakpointImpl)breakpoint2);
        if (sourcePosition == null) {
            return null;
        }
        SourcePosition sourcePosition2 = sourcePosition;
        Integer ordinal = javaBreakpointProperties.getLambdaOrdinal();
        KtFunction ktFunction = KotlinLineBreakpointTypeKt.access$getLambdaByOrdinal(sourcePosition2, ordinal);
        if (ktFunction == null) {
            return null;
        }
        KtFunction function2 = ktFunction;
        Object object = function2.getBodyBlockExpression();
        if (object == null || (object = object.getStatements()) == null || (object = (KtExpression)CollectionsKt.firstOrNull((List)object)) == null) {
            return null;
        }
        Object firstStatement = object;
        boolean $i$f$runReadAction = false;
        return (XSourcePosition)ApplicationManager.getApplication().runReadAction(new Computable((KtExpression)firstStatement, ordinal){
            final /* synthetic */ KtExpression $firstStatement$inlined;
            final /* synthetic */ Integer $ordinal$inlined;
            {
                this.$firstStatement$inlined = ktExpression;
                this.$ordinal$inlined = n;
            }

            public final T compute() {
                XSourcePosition xSourcePosition;
                boolean bl = false;
                SourcePosition sourcePosition = SourcePosition.createFromElement((PsiElement)((PsiElement)this.$firstStatement$inlined));
                if (sourcePosition == null) {
                    xSourcePosition = null;
                } else {
                    SourcePosition linePosition = sourcePosition;
                    xSourcePosition = DebuggerUtilsEx.toXSourcePosition((SourcePosition)((SourcePosition)new PositionManagerImpl.JavaSourcePosition(linePosition, this.$ordinal$inlined.intValue())));
                }
                return (T)xSourcePosition;
            }
        });
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType$LineKotlinBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LineJavaBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "element", "Lcom/intellij/psi/PsiElement;", "lambdaOrdinal", "", "(Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType;Lcom/intellij/xdebugger/XSourcePosition;Lcom/intellij/psi/PsiElement;Ljava/lang/Integer;)V", "getText", "", "kotlin.jvm-debugger.core"})
    public final class LineKotlinBreakpointVariant
    extends JavaLineBreakpointType.LineJavaBreakpointVariant {
        public LineKotlinBreakpointVariant(@Nullable XSourcePosition position, @Nullable PsiElement element3, Integer lambdaOrdinal) {
            super((JavaLineBreakpointType)KotlinLineBreakpointType.this, position, element3, lambdaOrdinal);
        }

        @NotNull
        public String getText() {
            return KotlinDebuggerCoreBundle.message("line.breakpoint", new Object[0]);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType$KotlinBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "lambdaCount", "", "(Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType;Lcom/intellij/xdebugger/XSourcePosition;I)V", "getText", "", "kotlin.jvm-debugger.core"})
    public final class KotlinBreakpointVariant
    extends JavaLineBreakpointType.JavaBreakpointVariant {
        private final int lambdaCount;

        public KotlinBreakpointVariant(XSourcePosition position, int lambdaCount) {
            super((JavaLineBreakpointType)KotlinLineBreakpointType.this, position);
            this.lambdaCount = lambdaCount;
        }

        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.lambdaCount};
            return KotlinDebuggerCoreBundle.message("line.and.lambda.breakpoint", objectArray);
        }
    }
}

