/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpointType;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinBreakpointFiltersPanel;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFieldBreakpoint;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFieldBreakpointPropertiesPanel;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinPropertyBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.dialog.AddFieldBreakpointDialog;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016J0\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u001c2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u001c2\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010\b\u001a\u00020\t2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0002H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u0004\u0018\u00010\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J \u0010&\u001a\u0004\u0018\u00010'2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010(\u001a\u00020$H\u0016J\b\u0010)\u001a\u00020$H\u0016J\b\u0010*\u001a\u00020$H\u0016J\b\u0010+\u001a\u00020\u0012H\u0016J\u0016\u0010,\u001a\u00020\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\b\u0010-\u001a\u00020\rH\u0016J\b\u0010.\u001a\u00020\rH\u0016J\u001a\u0010/\u001a\u0002002\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u00101\u001a\u00020\u0018H\u0002\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpointType;", "Lcom/intellij/debugger/ui/breakpoints/JavaBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinPropertyBreakpointProperties;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointType;", "()V", "addBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljavax/swing/JComponent;", "canBeHitInOtherPlaces", "", "canPutAt", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "createBreakpointIfPropertyExists", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "Lorg/jetbrains/kotlin/psi/KtFile;", "className", "", "fieldName", "createBreakpointProperties", "createCustomPropertiesPanel", "Lcom/intellij/xdebugger/breakpoints/ui/XBreakpointCustomPropertiesPanel;", "createCustomRightPropertiesPanel", "createJavaBreakpoint", "Lcom/intellij/debugger/ui/breakpoints/Breakpoint;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "createProperties", "getDisabledIcon", "Ljavax/swing/Icon;", "getDisplayText", "getEditorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "getEnabledIcon", "getMutedDisabledIcon", "getMutedEnabledIcon", "getPriority", "getShortText", "isAddBreakpointButtonVisible", "isSuspendThreadSupported", "reportError", "", "message", "kotlin.jvm-debugger.core"})
public final class KotlinFieldBreakpointType
extends XLineBreakpointType<KotlinPropertyBreakpointProperties>
implements JavaBreakpointType<KotlinPropertyBreakpointProperties>,
KotlinBreakpointType {
    public KotlinFieldBreakpointType() {
        super("kotlin-field", KotlinDebuggerCoreBundle.message("property.watchpoint.tab.title", new Object[0]));
    }

    @NotNull
    public Breakpoint<KotlinPropertyBreakpointProperties> createJavaBreakpoint(@NotNull Project project, @NotNull XBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        return (Breakpoint)new KotlinFieldBreakpoint(project, breakpoint2);
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project) {
        return BreakpointTypeUtilsKt.isBreakpointApplicable(file2, line, project, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)canPutAt.1.INSTANCE));
    }

    public int getPriority() {
        return 120;
    }

    @NotNull
    public KotlinPropertyBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file2, int line) {
        return new KotlinPropertyBreakpointProperties(null, null, 3, null);
    }

    @Nullable
    public XLineBreakpoint<KotlinPropertyBreakpointProperties> addBreakpoint(@NotNull Project project, @Nullable JComponent parentComponent) {
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        AddFieldBreakpointDialog dialog2 = new AddFieldBreakpointDialog(project, this, (Ref.ObjectRef<XLineBreakpoint<KotlinPropertyBreakpointProperties>>)result2){
            final /* synthetic */ Project $project;
            final /* synthetic */ KotlinFieldBreakpointType this$0;
            final /* synthetic */ Ref.ObjectRef<XLineBreakpoint<KotlinPropertyBreakpointProperties>> $result;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$result = $result;
                super($project);
            }

            protected boolean validateData() {
                String className = this.getClassName();
                if (((CharSequence)className).length() == 0) {
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, JavaDebuggerBundle.message((String)"error.field.breakpoint.class.name.not.specified", (Object[])new Object[0]));
                    return false;
                }
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.$project).findClass(className, GlobalSearchScope.allScope((Project)this.$project));
                if (!(psiClass instanceof KtLightClass)) {
                    Object[] objectArray = new Object[]{className};
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, KotlinDebuggerCoreBundle.message("property.watchpoint.error.couldnt.find.0.class", objectArray));
                    return false;
                }
                String fieldName = this.getFieldName();
                if (((CharSequence)fieldName).length() == 0) {
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, JavaDebuggerBundle.message((String)"error.field.breakpoint.field.name.not.specified", (Object[])new Object[0]));
                    return false;
                }
                Object[] objectArray = (Object[])psiClass;
                if (objectArray instanceof KtLightClassForFacade) {
                    v0 = (XLineBreakpoint)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((KtLightClassForFacade)psiClass).getFiles()), (Function1)((Function1)new Function1<KtFile, XLineBreakpoint<KotlinPropertyBreakpointProperties>>(this.this$0, className, fieldName){
                        final /* synthetic */ KotlinFieldBreakpointType this$0;
                        final /* synthetic */ String $className;
                        final /* synthetic */ String $fieldName;
                        {
                            this.this$0 = $receiver;
                            this.$className = $className;
                            this.$fieldName = $fieldName;
                            super(1);
                        }

                        @Nullable
                        public final XLineBreakpoint<KotlinPropertyBreakpointProperties> invoke(@NotNull KtFile it) {
                            return KotlinFieldBreakpointType.access$createBreakpointIfPropertyExists(this.this$0, (KtDeclarationContainer)it, it, this.$className, this.$fieldName);
                        }
                    })));
                } else if (objectArray instanceof KtLightClassForSourceDeclaration) {
                    KtClassOrObject ktClassOrObject = ((KtLightClassForSourceDeclaration)psiClass).getKotlinOrigin();
                    v0 = KotlinFieldBreakpointType.access$createBreakpointIfPropertyExists(this.this$0, (KtDeclarationContainer)ktClassOrObject, ktClassOrObject.getContainingKtFile(), className, fieldName);
                } else {
                    v0 = this.$result.element = null;
                }
                if (this.$result.element == null) {
                    objectArray = new Object[]{className, fieldName, fieldName};
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, JavaDebuggerBundle.message((String)"error.field.breakpoint.field.not.found", (Object[])objectArray));
                }
                return this.$result.element != null;
            }
        };
        dialog2.show();
        return (XLineBreakpoint)result2.element;
    }

    private final XLineBreakpoint<KotlinPropertyBreakpointProperties> createBreakpointIfPropertyExists(KtDeclarationContainer declaration2, KtFile file2, String className, String fieldName) {
        Object v0;
        Project project;
        block3: {
            project = file2.getProject();
            Iterable $this$firstOrNull$iv = declaration2.getDeclarations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof KtProperty && Intrinsics.areEqual((Object)((KtProperty)it).getName(), (Object)fieldName))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        KtDeclaration ktDeclaration = v0;
        if (ktDeclaration == null) {
            return null;
        }
        KtDeclaration property2 = ktDeclaration;
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        int line = document2.getLineNumber(property2.getTextOffset());
        boolean $i$f$runWriteAction = false;
        return (XLineBreakpoint)ApplicationManager.getApplication().runWriteAction(new Computable(project, this, file2, line, fieldName, className){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ KotlinFieldBreakpointType this$0;
            final /* synthetic */ KtFile $file$inlined;
            final /* synthetic */ int $line$inlined;
            final /* synthetic */ String $fieldName$inlined;
            final /* synthetic */ String $className$inlined;
            {
                this.$project$inlined = project;
                this.this$0 = kotlinFieldBreakpointType;
                this.$file$inlined = ktFile;
                this.$line$inlined = n;
                this.$fieldName$inlined = string2;
                this.$className$inlined = string3;
            }

            public final T compute() {
                boolean bl = false;
                return (T)XDebuggerManager.getInstance((Project)this.$project$inlined).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)this.this$0, this.$file$inlined.getVirtualFile().getUrl(), this.$line$inlined, (XBreakpointProperties)new KotlinPropertyBreakpointProperties(this.$fieldName$inlined, this.$className$inlined));
            }
        });
    }

    private final void reportError(Project project, @NlsContexts.DialogMessage String message2) {
        Messages.showMessageDialog((Project)project, (String)message2, (String)JavaDebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        return AllIcons.Debugger.Db_muted_field_breakpoint;
    }

    @NotNull
    public Icon getDisabledIcon() {
        return AllIcons.Debugger.Db_disabled_field_breakpoint;
    }

    @NotNull
    public Icon getEnabledIcon() {
        return AllIcons.Debugger.Db_field_breakpoint;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        return AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    @NotNull
    public String getShortText(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        KotlinPropertyBreakpointProperties properties2 = (KotlinPropertyBreakpointProperties)breakpoint2.getProperties();
        String className = properties2.getMyClassName();
        return ((CharSequence)className).length() > 0 ? className + "." + properties2.getMyFieldName() : properties2.getMyFieldName();
    }

    @NotNull
    public KotlinPropertyBreakpointProperties createProperties() {
        return new KotlinPropertyBreakpointProperties(null, null, 3, null);
    }

    @NotNull
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<KotlinPropertyBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project) {
        return new KotlinFieldBreakpointPropertiesPanel();
    }

    @Nullable
    public String getDisplayText(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        Breakpoint breakpoint3 = BreakpointManager.getJavaBreakpoint((XBreakpoint)((XBreakpoint)breakpoint2));
        BreakpointWithHighlighter kotlinBreakpoint = breakpoint3 instanceof BreakpointWithHighlighter ? (BreakpointWithHighlighter)breakpoint3 : null;
        Object object = kotlinBreakpoint;
        if (object == null || (object = object.getDescription()) == null) {
            object = super.getDisplayText(breakpoint2);
        }
        return object;
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2, @NotNull Project project) {
        return null;
    }

    @NotNull
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<KotlinPropertyBreakpointProperties>> createCustomRightPropertiesPanel(@NotNull Project project) {
        return new KotlinBreakpointFiltersPanel(project);
    }

    public boolean isSuspendThreadSupported() {
        return true;
    }

    public static final /* synthetic */ void access$reportError(KotlinFieldBreakpointType $this, Project project, String message2) {
        $this.reportError(project, message2);
    }

    public static final /* synthetic */ XLineBreakpoint access$createBreakpointIfPropertyExists(KotlinFieldBreakpointType $this, KtDeclarationContainer declaration2, KtFile file2, String className, String fieldName) {
        return $this.createBreakpointIfPropertyExists(declaration2, file2, className, fieldName);
    }
}

