/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.base.util;

import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005\u001a\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u001a\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0014"}, d2={"INLINED_THIS_REGEX", "Lkotlin/text/Regex;", "getINLINED_THIS_REGEX", "()Lkotlin/text/Regex;", "dropInlineSuffix", "", "name", "getInlineDepth", "", "variableName", "variables", "", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "isInlineFrameLineNumber", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "lineNumber", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.jvm-debugger.base.util"})
public final class InlineUtilsKt {
    @NotNull
    private static final Regex INLINED_THIS_REGEX;

    @NotNull
    public static final Regex getINLINED_THIS_REGEX() {
        return INLINED_THIS_REGEX;
    }

    public static final int getInlineDepth(@NotNull List<? extends LocalVariableProxyImpl> variables) {
        int n;
        Iterable $this$count$iv = variables;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                LocalVariableProxyImpl it = (LocalVariableProxyImpl)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it.name(), (String)"$i$f$", (boolean)false, (int)2, null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int rawInlineFunDepth = n;
        Iterable $this$sortedByDescending$iv = variables;
        boolean $i$f$sortedByDescending = false;
        for (LocalVariableProxyImpl variable2 : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LocalVariableProxyImpl it = (LocalVariableProxyImpl)b;
                boolean bl = false;
                Comparable comparable = it.getVariable();
                it = (LocalVariableProxyImpl)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getVariable());
            }
        })) {
            String name2 = variable2.name();
            int depth2 = InlineUtilsKt.getInlineDepth(name2);
            if (depth2 > 0) {
                return depth2;
            }
            if (!StringsKt.startsWith$default((String)name2, (String)"$i$a$", (boolean)false, (int)2, null)) continue;
            return 0;
        }
        return rawInlineFunDepth;
    }

    public static final int getInlineDepth(@NotNull String variableName) {
        int depth2 = 0;
        int suffixLen = 3;
        for (int endIndex = variableName.length(); endIndex >= suffixLen; endIndex -= suffixLen) {
            String string2 = variableName.substring(endIndex - suffixLen, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            if (!Intrinsics.areEqual((Object)string2, (Object)"$iv")) break;
            ++depth2;
        }
        return depth2;
    }

    @NotNull
    public static final String dropInlineSuffix(@NotNull String name2) {
        int depth2 = InlineUtilsKt.getInlineDepth(name2);
        if (depth2 == 0) {
            return name2;
        }
        return StringsKt.dropLast((String)name2, (int)(depth2 * 3));
    }

    public static final boolean isInlineFrameLineNumber(@NotNull VirtualFile file2, int lineNumber, @NotNull Project project) {
        if (SourceKindFilterUtils.matches(RootKindFilter.projectSources, project, file2)) {
            PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile(file2, project);
            if (psiFile2 == null) {
                return false;
            }
            int linesInFile = PsiLinesUtilsKt.getLineCount((PsiElement)psiFile2);
            return lineNumber > linesInFile;
        }
        return true;
    }

    static {
        boolean bl = false;
        String escapedName = Regex.Companion.escape("this_");
        String escapedSuffix = Regex.Companion.escape("$iv");
        INLINED_THIS_REGEX = new Regex("^" + escapedName + "(?:" + escapedSuffix + ")*$");
    }
}

