/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.base.util;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.CallableNameCalculator;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculator;
import org.jetbrains.kotlin.idea.debugger.base.util.FileApplicabilityChecker;
import org.jetbrains.kotlin.idea.debugger.base.util.JdiTypeUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmDebuggerBasePsiUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinFileSelector;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010\u0016\u001a\u00020\u000e*\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u001cH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/FileApplicabilityChecker;", "Lorg/jetbrains/kotlin/idea/debugger/base/util/KotlinFileSelector;", "()V", "chooseMostApplicableFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "", "location", "Lcom/sun/jdi/Location;", "findClassParent", "Lorg/jetbrains/kotlin/psi/KtElement;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getApplicability", "Lorg/jetbrains/kotlin/idea/debugger/base/util/FileApplicabilityChecker$Applicability;", "file", "isCallableReferenceClass", "", "type", "Lcom/sun/jdi/ClassType;", "isFunctionLiteralClass", "Lorg/jetbrains/kotlin/idea/debugger/base/util/FileApplicabilityChecker$ApplicabilityContext;", "getApplicabilityByClassName", "rangeOfLine", "Lcom/intellij/openapi/util/TextRange;", "declaringType", "Lcom/sun/jdi/ReferenceType;", "clazz", "Ljava/lang/Class;", "Applicability", "ApplicabilityContext", "kotlin.jvm-debugger.base.util"})
public final class FileApplicabilityChecker
implements KotlinFileSelector {
    @NotNull
    public static final FileApplicabilityChecker INSTANCE = new FileApplicabilityChecker();

    private FileApplicabilityChecker() {
    }

    @Override
    @NotNull
    public KtFile chooseMostApplicableFile(@NotNull List<? extends KtFile> files2, @NotNull Location location2) {
        Object v0;
        if (files2.size() == 1) {
            return (KtFile)CollectionsKt.first(files2);
        }
        Iterable $this$maxByOrNull$iv = files2;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                KtFile it = (KtFile)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)((Object)INSTANCE.getApplicability(it, location2));
                do {
                    Object e$iv = iterator$iv.next();
                    KtFile it2 = (KtFile)e$iv;
                    $i$a$-maxByOrNull-FileApplicabilityChecker$chooseMostApplicableFile$1 = false;
                    Comparable v$iv = (Comparable)((Object)INSTANCE.getApplicability(it2, location2));
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        KtFile ktFile = v0;
        if (ktFile == null) {
            throw new IllegalStateException("One or more source files expected".toString());
        }
        return ktFile;
    }

    private final Applicability getApplicability(KtFile file2, Location location2) {
        try {
            ApplicabilityContext context2 = new ApplicabilityContext(file2, ClassNameCalculator.INSTANCE.getClassNames(file2));
            return this.getApplicability(context2, location2);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (ClassNotLoadedException e) {
            return Applicability.UNCERTAIN;
        }
        catch (AbsentInformationException e) {
            return Applicability.UNCERTAIN;
        }
        catch (InternalException e) {
            return Applicability.UNCERTAIN;
        }
    }

    private final Applicability getApplicability(ApplicabilityContext $this$getApplicability, Location location2) {
        String methodName2;
        int sourceLineNumber = location2.lineNumber() - 1;
        if (sourceLineNumber < 0) {
            return Applicability.NO;
        }
        TextRange textRange = JvmDebuggerBasePsiUtils.getRangeOfLine((PsiFile)$this$getApplicability.getFile(), sourceLineNumber);
        if (textRange == null) {
            return Applicability.NO;
        }
        TextRange rangeOfLine = textRange;
        ReferenceType declaringType = location2.declaringType();
        if (declaringType instanceof ClassType) {
            if (this.isCallableReferenceClass((ClassType)declaringType)) {
                return this.getApplicabilityByClassName($this$getApplicability, rangeOfLine, declaringType, KtCallableReferenceExpression.class);
            }
            if (this.isFunctionLiteralClass((ClassType)declaringType)) {
                return this.getApplicabilityByClassName($this$getApplicability, rangeOfLine, declaringType, KtLambdaExpression.class);
            }
        }
        if (Intrinsics.areEqual((Object)(methodName2 = location2.method().name()), (Object)"<init>") || Intrinsics.areEqual((Object)methodName2, (Object)"<clinit>")) {
            return this.getApplicabilityByClassName($this$getApplicability, rangeOfLine, declaringType, KtClassOrObject.class);
        }
        Integer n = PsiLinesUtilsKt.getLineStartOffset((PsiFile)$this$getApplicability.getFile(), sourceLineNumber);
        if (n == null) {
            return Applicability.NO;
        }
        int lineStartOffset = n;
        PsiElement psiElement2 = $this$getApplicability.getFile().findElementAt(lineStartOffset);
        if (psiElement2 == null) {
            return Applicability.NO;
        }
        PsiElement elementAt = psiElement2;
        Sequence callableParents2 = SequencesKt.filter((Sequence)PsiTreeUtilKt.parents((PsiElement)elementAt, (boolean)true), (Function1)getApplicability.callableParents.1.INSTANCE);
        for (PsiElement declaration2 : callableParents2) {
            KtElement classParent;
            if (!(declaration2 instanceof KtDeclaration)) continue;
            KtElement ktElement = this.findClassParent((KtDeclaration)declaration2);
            if (ktElement == null) {
                ktElement = classParent = (KtElement)$this$getApplicability.getFile();
            }
            if (!Intrinsics.areEqual((Object)$this$getApplicability.getClassNames().get(classParent), (Object)declaringType.name())) {
                return Applicability.NO;
            }
            PsiElement psiElement3 = declaration2;
            CallableNameCalculator.CallableName name2 = psiElement3 instanceof KtPropertyAccessor ? CallableNameCalculator.INSTANCE.getAccessorName(((KtPropertyAccessor)declaration2).getProperty(), ((KtPropertyAccessor)declaration2).isSetter()) : (psiElement3 instanceof KtProperty ? CallableNameCalculator.INSTANCE.getAccessorName((KtProperty)declaration2, JvmAbi.isSetterName((String)methodName2)) : (psiElement3 instanceof KtNamedFunction ? CallableNameCalculator.INSTANCE.getFunctionName((KtNamedFunction)declaration2) : null));
            if (name2 == null || !name2.matches(methodName2)) continue;
            return Applicability.YES;
        }
        return Applicability.UNCERTAIN;
    }

    /*
     * WARNING - void declaration
     */
    private final KtElement findClassParent(KtDeclaration declaration2) {
        void $this$getParentOfType$iv;
        PsiElement psiElement2 = (PsiElement)declaration2;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClassOrObject.class, (boolean)strict$iv);
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject parent2 = ktClassOrObject;
        if (parent2 instanceof KtObjectDeclaration && ((KtObjectDeclaration)parent2).getName() == null) {
            psiElement2 = ((KtObjectDeclaration)parent2).getParent();
            KtObjectLiteralExpression ktObjectLiteralExpression = psiElement2 instanceof KtObjectLiteralExpression ? (KtObjectLiteralExpression)psiElement2 : null;
            return ktObjectLiteralExpression != null ? (KtElement)ktObjectLiteralExpression : (KtElement)parent2;
        }
        return (KtElement)parent2;
    }

    private final Applicability getApplicabilityByClassName(ApplicabilityContext $this$getApplicabilityByClassName, TextRange rangeOfLine, ReferenceType declaringType, Class<? extends KtElement> clazz) {
        Class[] classArray = new Class[]{clazz};
        for (KtElement declaration2 : JvmDebuggerBasePsiUtils.findElementsOfTypeInRange((PsiFile)$this$getApplicabilityByClassName.getFile(), rangeOfLine, classArray)) {
            String expectedClassName;
            if ($this$getApplicabilityByClassName.getClassNames().get(declaration2) == null || !Intrinsics.areEqual((Object)expectedClassName, (Object)declaringType.name())) continue;
            return Applicability.YES;
        }
        return Applicability.NO;
    }

    private final boolean isFunctionLiteralClass(ClassType type2) {
        return JdiTypeUtils.hasInterface(type2, "kotlin.jvm.internal.FunctionBase");
    }

    private final boolean isCallableReferenceClass(ClassType type2) {
        return JdiTypeUtils.hasSuperClass(type2, "kotlin.jvm.internal.FunctionReference");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/FileApplicabilityChecker$Applicability;", "", "(Ljava/lang/String;I)V", "NO", "UNCERTAIN", "YES", "kotlin.jvm-debugger.base.util"})
    public static final class Applicability
    extends Enum<Applicability> {
        public static final /* enum */ Applicability NO = new Applicability();
        public static final /* enum */ Applicability UNCERTAIN = new Applicability();
        public static final /* enum */ Applicability YES = new Applicability();
        private static final /* synthetic */ Applicability[] $VALUES;

        public static Applicability[] values() {
            return (Applicability[])$VALUES.clone();
        }

        public static Applicability valueOf(String value2) {
            return Enum.valueOf(Applicability.class, value2);
        }

        static {
            $VALUES = applicabilityArray = new Applicability[]{Applicability.NO, Applicability.UNCERTAIN, Applicability.YES};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/FileApplicabilityChecker$ApplicabilityContext;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "classNames", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/util/Map;)V", "getClassNames", "()Ljava/util/Map;", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.jvm-debugger.base.util"})
    private static final class ApplicabilityContext {
        @NotNull
        private final KtFile file;
        @NotNull
        private final Map<KtElement, String> classNames;

        public ApplicabilityContext(@NotNull KtFile file2, @NotNull Map<KtElement, String> classNames) {
            this.file = file2;
            this.classNames = classNames;
        }

        @NotNull
        public final KtFile getFile() {
            return this.file;
        }

        @NotNull
        public final Map<KtElement, String> getClassNames() {
            return this.classNames;
        }
    }
}

