/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.jdi.LocalVariableImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.calls.KtFunctionCall;
import org.jetbrains.kotlin.analysis.api.lifetime.KtDefaultLifetimeTokenProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.signatures.KtVariableLikeSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtUsualClassType;
import org.jetbrains.kotlin.idea.debugger.KotlinSourcePositionWithEntireLineHighlighted;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.AnalysisApiBasedInlineUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\b2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\f\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u0003\u001a\f\u0010\u000e\u001a\u00020\u000b*\u00020\u0003H\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0010*\u00020\u0014H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0010*\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0017"}, d2={"decorateSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "location", "Lcom/sun/jdi/Location;", "sourcePosition", "findTargetClasses", "", "Lcom/sun/jdi/ReferenceType;", "Lcom/intellij/debugger/engine/DebugProcess;", "outerClass", "lineAt", "", "getClassName", "", "getZeroBasedLineNumber", "hasVisibleInlineLambdasOnLines", "", "lines", "Lkotlin/ranges/IntRange;", "isSamLambda", "Lorg/jetbrains/kotlin/psi/KtFunction;", "isVisible", "Lcom/jetbrains/jdi/LocalVariableImpl;", "kotlin.jvm-debugger.core"})
public final class KotlinPositionManagerKt {
    private static final SourcePosition decorateSourcePosition(Location location2, SourcePosition sourcePosition) {
        PsiElement psiElement2 = sourcePosition.getElementAt();
        PsiElement psiElement3 = psiElement2 != null ? psiElement2.getParent() : null;
        KtFunctionLiteral ktFunctionLiteral = psiElement3 instanceof KtFunctionLiteral ? (KtFunctionLiteral)psiElement3 : null;
        if (ktFunctionLiteral == null) {
            return sourcePosition;
        }
        KtFunctionLiteral lambda2 = ktFunctionLiteral;
        IntRange intRange = KotlinSteppingCommandProviderKt.getLineRange((PsiElement)lambda2);
        if (intRange == null) {
            return sourcePosition;
        }
        IntRange lines = intRange;
        if (!KotlinPositionManagerKt.hasVisibleInlineLambdasOnLines(location2, lines)) {
            return new KotlinSourcePositionWithEntireLineHighlighted(sourcePosition);
        }
        return sourcePosition;
    }

    private static final int getZeroBasedLineNumber(Location $this$getZeroBasedLineNumber) {
        return DebuggerUtilsEx.getLineNumber((Location)$this$getZeroBasedLineNumber, (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasVisibleInlineLambdasOnLines(Location $this$hasVisibleInlineLambdasOnLines, IntRange lines) {
        boolean bl;
        Method method = SafeUtilKt.safeMethod($this$hasVisibleInlineLambdasOnLines);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        Sequence $this$any$iv = SequencesKt.filter((Sequence)MapsKt.asSequence(DebuggerUtil.getInlineFunctionAndArgumentVariablesToBordersMap(method2)), (Function1)((Function1)new Function1<Map.Entry<? extends LocalVariable, ? extends ClosedRange<Location>>, Boolean>($this$hasVisibleInlineLambdasOnLines){
            final /* synthetic */ Location $this_hasVisibleInlineLambdasOnLines;
            {
                this.$this_hasVisibleInlineLambdasOnLines = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<? extends LocalVariable, ? extends ClosedRange<Location>> entry) {
                LocalVariable variable2 = entry.getKey();
                return variable2 instanceof LocalVariableImpl && KotlinPositionManagerKt.access$isVisible((LocalVariableImpl)variable2, this.$this_hasVisibleInlineLambdasOnLines) && StringsKt.startsWith$default((String)variable2.name(), (String)"$i$a$", (boolean)false, (int)2, null);
            }
        }));
        boolean $i$f$any = false;
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            ClosedRange borders = (ClosedRange)entry.getValue();
            int n = lines.getFirst();
            int n2 = lines.getLast();
            int n3 = KotlinPositionManagerKt.getZeroBasedLineNumber((Location)borders.getStart());
            boolean bl3 = n <= n3 ? n3 <= n2 : false;
            if (bl3) {
                boolean bl4;
                n = lines.getFirst();
                n2 = lines.getLast();
                n3 = KotlinPositionManagerKt.getZeroBasedLineNumber((Location)borders.getEndInclusive());
                if (n <= n3) {
                    if (n3 <= n2) {
                        return true;
                    }
                    bl4 = false;
                } else {
                    bl4 = false;
                }
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final boolean isVisible(LocalVariableImpl $this$isVisible, Location location2) {
        return $this$isVisible.getScopeStart().compareTo(location2) <= 0 && $this$isVisible.getScopeEnd().compareTo(location2) >= 0;
    }

    @Nullable
    public static final String getClassName(@NotNull Location $this$getClassName) {
        String string2 = $this$getClassName.declaringType().name();
        if (string2 == null) {
            return null;
        }
        String currentLocationFqName = string2;
        return StringsKt.replace$default((String)JvmClassName.byFqNameWithoutInnerClasses((FqName)new FqName(currentLocationFqName)).getInternalName(), (char)'/', (char)'.', (boolean)false, (int)4, null);
    }

    private static final List<ReferenceType> findTargetClasses(DebugProcess $this$findTargetClasses, ReferenceType outerClass, int lineAt) {
        VirtualMachineProxy vmProxy = $this$findTargetClasses.getVirtualMachineProxy();
        try {
            if (!outerClass.isPrepared()) {
                return CollectionsKt.emptyList();
            }
        }
        catch (ObjectCollectedException e) {
            return CollectionsKt.emptyList();
        }
        ArrayList targetClasses = new ArrayList(1);
        try {
            for (Location location2 : SafeUtilKt.safeAllLineLocations(outerClass)) {
                Method method;
                int locationLine = location2.lineNumber() - 1;
                if (locationLine < 0 || lineAt != locationLine || (method = location2.method()) == null || DebuggerUtils.isSynthetic((TypeComponent)method) || method.isBridge()) continue;
                ((Collection)targetClasses).add(outerClass);
                break;
            }
            List nestedTypes = vmProxy.nestedTypes(outerClass);
            for (ReferenceType nested : nestedTypes) {
                CollectionsKt.addAll((Collection)targetClasses, (Iterable)KotlinPositionManagerKt.findTargetClasses($this$findTargetClasses, nested, lineAt));
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return targetClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final boolean isSamLambda(KtFunction $this$isSamLambda) {
        void this_$iv$iv$iv;
        if (!($this$isSamLambda instanceof KtFunctionLiteral) && !($this$isSamLambda instanceof KtNamedFunction)) {
            return false;
        }
        Object nonDefaultLifetimeTokenFactory$iv = null;
        boolean $i$f$analyze = false;
        Project project = ((KtElement)$this$isSamLambda).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"useSiteKtElement.project");
        KtAnalysisSessionProvider this_$iv$iv = KtAnalysisSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyse = false;
        KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
        KtAnalysisSessionProvider ktAnalysisSessionProvider = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)$this$isSamLambda, factory$iv$iv);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            ValueArgument valueArgument;
            KtFunctionCall<?> ktFunctionCall;
            KtCallExpression ktCallExpression;
            KtAnalysisSession $this$isSamLambda_u24lambda_u241 = analysisSession$iv$iv$iv;
            boolean bl = false;
            KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)((KtExpression)$this$isSamLambda));
            if ((ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null) == null) {
                boolean bl2 = false;
                return bl2;
            }
            KtCallExpression parentCall2 = ktCallExpression;
            if (AnalysisApiBasedInlineUtil.INSTANCE.getResolvedFunctionCall($this$isSamLambda_u24lambda_u241, parentCall2) == null) {
                boolean bl3 = false;
                return bl3;
            }
            KtFunctionCall<?> call = ktFunctionCall;
            if (AnalysisApiBasedInlineUtil.INSTANCE.getValueArgumentForExpression(parentCall2, (KtExpression)$this$isSamLambda) == null) {
                boolean bl4 = false;
                return bl4;
            }
            ValueArgument valueArgument2 = valueArgument;
            KtLifetimeOwner ktLifetimeOwner = (KtVariableLikeSignature)((Map)call.getArgumentMapping()).get(valueArgument2.getArgumentExpression());
            if (ktLifetimeOwner == null || (ktLifetimeOwner = (KtValueParameterSymbol)((KtVariableLikeSignature)ktLifetimeOwner).getSymbol()) == null) {
                boolean bl5 = false;
                return bl5;
            }
            KtLifetimeOwner argument2 = ktLifetimeOwner;
            boolean bl6 = ((KtCallableSymbol)argument2).getReturnType() instanceof KtUsualClassType;
            return bl6;
        }
        finally {
            factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
    }

    public static final /* synthetic */ SourcePosition access$decorateSourcePosition(Location location2, SourcePosition sourcePosition) {
        return KotlinPositionManagerKt.decorateSourcePosition(location2, sourcePosition);
    }

    public static final /* synthetic */ boolean access$isSamLambda(KtFunction $receiver) {
        return KotlinPositionManagerKt.isSamLambda($receiver);
    }

    public static final /* synthetic */ List access$findTargetClasses(DebugProcess $receiver, ReferenceType outerClass, int lineAt) {
        return KotlinPositionManagerKt.findTargetClasses($receiver, outerClass, lineAt);
    }

    public static final /* synthetic */ boolean access$isVisible(LocalVariableImpl $receiver, Location location2) {
        return KotlinPositionManagerKt.isVisible($receiver, location2);
    }
}

