/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerWithMultipleStackFrames;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KtDefaultLifetimeTokenProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposableUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.KotlinReentrantSourcePosition;
import org.jetbrains.kotlin.idea.debugger.base.util.DexDebugFacility;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinAllFilesScopeProvider;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.AnalysisApiBasedInlineUtil;
import org.jetbrains.kotlin.idea.debugger.core.ClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.core.CodeFragmentContextUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.ComposeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.SourcePositionRefiner;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackTraceCalculator;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.KotlinStackFrame;
import org.jetbrains.kotlin.idea.util.FindElementUtils;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0017J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001dH\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00072\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\"\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\"\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0012\u00105\u001a\u0004\u0018\u00010*2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020(0\u00072\u0006\u0010\u0013\u001a\u00020\u0010H\u0003J\u0014\u00107\u001a\u0004\u0018\u00010\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u001e\u00108\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00072\u0006\u00109\u001a\u00020(2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0014\u0010;\u001a\u00020<*\u00020=2\u0006\u0010>\u001a\u00020\u001dH\u0002J0\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0007*\u00020\u001b2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00072\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u001dH\u0002J$\u0010D\u001a\u0004\u0018\u000104*\b\u0012\u0004\u0012\u0002040\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020\u001dH\u0002J$\u0010E\u001a\u0004\u0018\u000104*\b\u0012\u0004\u0012\u0002040\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010/\u001a\u000200H\u0002J \u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0G0\u0007*\u00020B2\u0006\u0010C\u001a\u00020\u001dH\u0002J(\u0010H\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010G*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0G0\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010I\u001a\u0004\u0018\u000104*\b\u0012\u0004\u0012\u0002040\u00072\u0006\u0010J\u001a\u000200H\u0002J\u0014\u0010K\u001a\u00020<*\u00020\u001b2\u0006\u0010L\u001a\u00020*H\u0002J\u001c\u0010M\u001a\u00020<*\u00020\u001b2\u0006\u0010L\u001a\u00020*2\u0006\u0010C\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager;", "Lcom/intellij/debugger/MultiRequestPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerWithMultipleStackFrames;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "(Lcom/intellij/debugger/engine/DebugProcess;)V", "sourceSearchScopes", "", "Lcom/intellij/psi/search/GlobalSearchScope;", "stackFrameInterceptor", "Lorg/jetbrains/kotlin/idea/debugger/core/StackFrameInterceptor;", "createKotlinClassPrepareRequests", "Lcom/sun/jdi/request/ClassPrepareRequest;", "requestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "position", "Lcom/intellij/debugger/SourcePosition;", "createPrepareRequest", "classPrepareRequestor", "sourcePosition", "createPrepareRequests", "createStackFrames", "Lcom/intellij/xdebugger/frame/XStackFrame;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "defaultInternalName", "", "evaluateCondition", "Lcom/intellij/util/ThreeState;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "frame", "expression", "getAcceptedFileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "getAllClasses", "Lcom/sun/jdi/ReferenceType;", "getAlternativeSource", "Lcom/intellij/psi/PsiFile;", "getCallableReferenceIfInside", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "lineNumber", "", "getElementForDeclarationLine", "Lorg/jetbrains/kotlin/psi/KtElement;", "getLambdaOrFunIfInside", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getPsiFileByLocation", "getReferenceTypesForPositionInKotlinFile", "getSourcePosition", "locationsOfLine", "type", "originalClassNamesForPosition", "calculatedClassNameMatches", "", "Lcom/intellij/psi/PsiElement;", "currentLocationClassName", "findLocationsInSameInlinedFunction", "locations", "method", "Lcom/sun/jdi/Method;", "sourceFileName", "getAppropriateLiteralBasedOnDeclaringClassName", "getAppropriateLiteralBasedOnLambdaName", "getInlineFunctionBorders", "Lkotlin/ranges/ClosedRange;", "getLeastEnclosingBorders", "getSamLambdaWithIndex", "index", "hasFinallyBlockInParent", "psiFile", "shouldBeTreatedAsReentrantSourcePosition", "kotlin.jvm-debugger.core"})
public final class KotlinPositionManager
implements MultiRequestPositionManager,
PositionManagerWithMultipleStackFrames {
    @NotNull
    private final DebugProcess debugProcess;
    @Nullable
    private final StackFrameInterceptor stackFrameInterceptor;
    @NotNull
    private final List<GlobalSearchScope> sourceSearchScopes;

    public KotlinPositionManager(@NotNull DebugProcess debugProcess) {
        this.debugProcess = debugProcess;
        ComponentManager $this$serviceOrNull$iv = (ComponentManager)this.debugProcess.getProject();
        boolean $i$f$serviceOrNull = false;
        this.stackFrameInterceptor = (StackFrameInterceptor)$this$serviceOrNull$iv.getService(StackFrameInterceptor.class);
        Object[] objectArray = new GlobalSearchScope[]{this.debugProcess.getSearchScope(), KotlinAllFilesScopeProvider.Companion.getInstance(this.debugProcess.getProject()).getAllKotlinFilesScope()};
        this.sourceSearchScopes = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Set<FileType> getAcceptedFileTypes() {
        return ProjectStructureUtils.getKOTLIN_FILE_TYPES();
    }

    @NotNull
    public ThreeState evaluateCondition(@NotNull EvaluationContext context2, @NotNull StackFrameProxyImpl frame, @NotNull Location location2, @NotNull String expression2) {
        return ThreeState.UNSURE;
    }

    @NotNull
    public List<XStackFrame> createStackFrames(@NotNull StackFrameProxyImpl frameProxy, @NotNull DebugProcessImpl debugProcess, @NotNull Location location2) {
        List<XStackFrame> inlineStackTrace;
        XStackFrame coroutineFrame;
        if (!DebuggerUtil.isInKotlinSources(location2)) {
            return CollectionsKt.emptyList();
        }
        StackFrameInterceptor stackFrameInterceptor = this.stackFrameInterceptor;
        XStackFrame xStackFrame = coroutineFrame = stackFrameInterceptor != null ? stackFrameInterceptor.createStackFrame(frameProxy, debugProcess, location2) : null;
        if (coroutineFrame != null) {
            return CollectionsKt.listOf((Object)coroutineFrame);
        }
        if (Registry.get((String)"debugger.kotlin.inline.stack.trace.enabled").asBoolean() && !((Collection)(inlineStackTrace = InlineStackTraceCalculator.INSTANCE.calculateInlineStackTrace(frameProxy))).isEmpty()) {
            return inlineStackTrace;
        }
        List<LocalVariableProxyImpl> visibleVariables = InlineStackTraceCalculator.INSTANCE.calculateVisibleVariables(frameProxy);
        return CollectionsKt.listOf((Object)((Object)new KotlinStackFrame(frameProxy, visibleVariables)));
    }

    @Nullable
    public SourcePosition getSourcePosition(@Nullable Location location2) {
        SourcePosition sourcePosition;
        PsiFile psiFile2;
        if (location2 == null) {
            throw NoDataException.INSTANCE;
        }
        String string2 = SafeUtilKt.safeSourceName(location2);
        if (string2 == null) {
            throw NoDataException.INSTANCE;
        }
        String fileName = string2;
        int lineNumber = SafeUtilKt.safeLineNumber(location2);
        if (lineNumber < 0) {
            throw NoDataException.INSTANCE;
        }
        if (!DebuggerUtils.INSTANCE.isKotlinSourceFile(fileName)) {
            throw NoDataException.INSTANCE;
        }
        PsiFile psiFile3 = this.getAlternativeSource(location2);
        if (psiFile3 == null) {
            psiFile3 = this.getPsiFileByLocation(location2);
        }
        if ((psiFile2 = psiFile3) == null) {
            boolean isKotlinStrataAvailable = DebuggerUtil.containsKotlinStrata(location2.declaringType());
            if (isKotlinStrataAvailable) {
                try {
                    String javaSourceFileName = location2.sourceName("Java");
                    JvmClassName javaClassName = JvmClassName.byInternalName((String)this.defaultInternalName(location2));
                    Project project = this.debugProcess.getProject();
                    KtFile defaultPsiFile = DebuggerUtils.INSTANCE.findSourceFileForClass(project, this.sourceSearchScopes, javaClassName, javaSourceFileName, location2);
                    if (defaultPsiFile != null) {
                        return SourcePosition.createFromLine((PsiFile)((PsiFile)defaultPsiFile), (int)0);
                    }
                }
                catch (AbsentInformationException javaSourceFileName) {
                    // empty catch block
                }
            }
            throw NoDataException.INSTANCE;
        }
        if (!(psiFile2 instanceof KtFile)) {
            throw NoDataException.INSTANCE;
        }
        int sourceLineNumber = SafeUtilKt.safeLineNumber(location2) - 1;
        if (sourceLineNumber < 0) {
            throw NoDataException.INSTANCE;
        }
        KtFunction lambdaOrFunIfInside = this.getLambdaOrFunIfInside(location2, (KtFile)psiFile2, sourceLineNumber);
        if (lambdaOrFunIfInside != null) {
            KtExpression ktExpression = lambdaOrFunIfInside.getBodyExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            return SourcePosition.createFromElement((PsiElement)((PsiElement)ktExpression));
        }
        KtCallableReferenceExpression callableReferenceIfInside = this.getCallableReferenceIfInside(location2, (KtFile)psiFile2, sourceLineNumber);
        if (callableReferenceIfInside != null && (sourcePosition = SourcePosition.createFromElement((PsiElement)((PsiElement)callableReferenceIfInside))) != null) {
            return new KotlinReentrantSourcePosition(sourcePosition);
        }
        KtElement elementInDeclaration = this.getElementForDeclarationLine(location2, (KtFile)psiFile2, sourceLineNumber);
        if (elementInDeclaration != null) {
            return SourcePosition.createFromElement((PsiElement)((PsiElement)elementInDeclaration));
        }
        if (this.shouldBeTreatedAsReentrantSourcePosition(location2, psiFile2, fileName)) {
            return new KotlinReentrantSourcePosition(SourcePosition.createFromLine((PsiFile)psiFile2, (int)sourceLineNumber));
        }
        SourcePosition sourcePosition2 = SourcePosition.createFromLine((PsiFile)psiFile2, (int)sourceLineNumber);
        return KotlinPositionManagerKt.access$decorateSourcePosition(location2, sourcePosition2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldBeTreatedAsReentrantSourcePosition(Location $this$shouldBeTreatedAsReentrantSourcePosition, PsiFile psiFile2, String sourceFileName) {
        Collection collection;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Method method = SafeUtilKt.safeMethod($this$shouldBeTreatedAsReentrantSourcePosition);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        Iterable iterable = SafeUtilKt.safeAllLineLocations(method2);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location it = (Location)element$iv$iv;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName(it), (Object)sourceFileName) && it.lineNumber() == $this$shouldBeTreatedAsReentrantSourcePosition.lineNumber();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sameLineLocations = (List)destination$iv$iv;
        if (sameLineLocations.size() < 2 || this.hasFinallyBlockInParent($this$shouldBeTreatedAsReentrantSourcePosition, psiFile2)) {
            return false;
        }
        List<Location> locationsInSameInlinedFunction = this.findLocationsInSameInlinedFunction($this$shouldBeTreatedAsReentrantSourcePosition, sameLineLocations, method2, sourceFileName);
        Collection collection2 = locationsInSameInlinedFunction;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = sameLineLocations;
        } else {
            collection = collection2;
        }
        return ((List)collection).indexOf($this$shouldBeTreatedAsReentrantSourcePosition) > 0;
    }

    private final boolean hasFinallyBlockInParent(Location $this$hasFinallyBlockInParent, PsiFile psiFile2) {
        KtFinallySection ktFinallySection;
        PsiElement elementAt;
        PsiElement psiElement2;
        Integer n = PsiLinesUtilsKt.getLineStartOffset(psiFile2, $this$hasFinallyBlockInParent.lineNumber());
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            psiElement2 = psiFile2.findElementAt(it);
        } else {
            psiElement2 = null;
        }
        PsiElement psiElement3 = elementAt = psiElement2;
        if (psiElement3 != null) {
            PsiElement $this$parentOfType_u24default$iv = psiElement3;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            ktFinallySection = (KtFinallySection)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtFinallySection.class, (boolean)true);
        } else {
            ktFinallySection = null;
        }
        return ktFinallySection != null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Location> findLocationsInSameInlinedFunction(Location $this$findLocationsInSameInlinedFunction, List<? extends Location> locations, Method method, String sourceFileName) {
        void $this$filterTo$iv$iv;
        ClosedRange<Location> closedRange = this.getLeastEnclosingBorders(this.getInlineFunctionBorders(method, sourceFileName), $this$findLocationsInSameInlinedFunction);
        if (closedRange == null) {
            return CollectionsKt.emptyList();
        }
        ClosedRange<Location> leastEnclosingBorders = closedRange;
        Iterable $this$filter$iv = locations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location it = (Location)element$iv$iv;
            boolean bl = false;
            if (!leastEnclosingBorders.contains((Comparable)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ClosedRange<Location> getLeastEnclosingBorders(List<? extends ClosedRange<Location>> $this$getLeastEnclosingBorders, Location location2) {
        ClosedRange<Location> result2 = null;
        for (ClosedRange<Location> closedRange : $this$getLeastEnclosingBorders) {
            if (!closedRange.contains((Comparable)location2) || result2 != null && ((Location)closedRange.getStart()).compareTo(result2.getStart()) <= 0) continue;
            result2 = closedRange;
        }
        return result2;
    }

    private final List<ClosedRange<Location>> getInlineFunctionBorders(Method $this$getInlineFunctionBorders, String sourceFileName) {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull(DebuggerUtil.getInlineFunctionOrArgumentVariables($this$getInlineFunctionBorders), (Function1)getInlineFunctionBorders.1.INSTANCE), (Function1)((Function1)new Function1<ClosedRange<Location>, Boolean>(sourceFileName){
            final /* synthetic */ String $sourceFileName;
            {
                this.$sourceFileName = $sourceFileName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ClosedRange<Location> it) {
                return Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName((Location)it.getStart()), (Object)this.$sourceFileName);
            }
        })));
    }

    private final PsiFile getAlternativeSource(Location location2) {
        PsiManager manager = PsiManager.getInstance((Project)this.debugProcess.getProject());
        String qName = location2.declaringType().name();
        String string2 = DebuggerUtilsEx.getAlternativeSourceUrl((String)qName, (Project)this.debugProcess.getProject());
        if (string2 == null) {
            return null;
        }
        String alternativeFileUrl = string2;
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(alternativeFileUrl);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile alternativePsiFile = virtualFile;
        return manager.findFile(alternativePsiFile);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final KtElement getElementForDeclarationLine(Location location, KtFile file, int lineNumber) {
        block8: {
            block7: {
                block6: {
                    v0 = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file, lineNumber);
                    if (v0 == null) {
                        return null;
                    }
                    lineStartOffset = v0;
                    elementAt = file.findElementAt(lineStartOffset);
                    contextElement = CodeFragmentContextUtilsKt.getContextElement(elementAt);
                    if (!(contextElement instanceof KtClass)) {
                        return null;
                    }
                    methodName = location.method().name();
                    if (!JvmAbi.isGetterName((String)methodName)) break block7;
                    v1 /* !! */  = ((KtClass)contextElement).getPrimaryConstructor();
                    if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getValueParameters()) == null) {
                        v1 /* !! */  = CollectionsKt.emptyList();
                    }
                    valueParameters /* !! */  = v1 /* !! */ ;
                    var9_9 = (Iterable)valueParameters /* !! */ ;
                    for (T var11_11 : var9_9) {
                        it = (KtParameter)var11_11;
                        $i$a$-find-KotlinPositionManager$getElementForDeclarationLine$1 = false;
                        if (!it.hasValOrVar() || it.getName() == null) ** GOTO lbl-1000
                        v2 = it.getName();
                        Intrinsics.checkNotNull((Object)v2);
                        if (Intrinsics.areEqual((Object)JvmAbi.getterName((String)v2), (Object)methodName)) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        if (!v3) continue;
                        v4 = var11_11;
                        break block6;
                    }
                    v4 = null;
                }
                v5 = v4;
                break block8;
            }
            v5 = Intrinsics.areEqual((Object)methodName, (Object)"<init>") != false ? (KtElement)((KtClass)contextElement).getPrimaryConstructor() : null;
        }
        return v5;
    }

    /*
     * WARNING - void declaration
     */
    private final KtCallableReferenceExpression getCallableReferenceIfInside(Location location2, KtFile file2, int lineNumber) {
        Object v3;
        block6: {
            List list2;
            String string2 = KotlinPositionManagerKt.getClassName(location2);
            if (string2 == null) {
                return null;
            }
            String currentLocationClassName = string2;
            boolean $i$f$getElementsAtLineIfAny = false;
            PsiElement psiElement2 = DebuggerUtil.findElementAtLine(file2, lineNumber);
            KtElement ktElement = psiElement2 instanceof KtElement ? (KtElement)psiElement2 : null;
            if (ktElement == null) {
                list2 = CollectionsKt.emptyList();
            } else {
                void $this$filterIsInstanceTo$iv$iv$iv;
                KtElement lineElement$iv = ktElement;
                int start$iv = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)lineElement$iv));
                int end$iv = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)lineElement$iv));
                for (PsiElement nextSibling$iv = lineElement$iv.getNextSibling(); nextSibling$iv != null && lineNumber == PsiLinesUtilsKt.getLineNumber$default(nextSibling$iv, false, 1, null); nextSibling$iv = nextSibling$iv.getNextSibling()) {
                    end$iv = PsiUtilsKt.getEndOffset((PsiElement)nextSibling$iv);
                }
                Class[] classArray = new Class[]{KtCallableReferenceExpression.class};
                Iterable $this$filterIsInstance$iv$iv = FindElementUtils.findElementsOfClassInRange((PsiFile)file2, start$iv, end$iv, classArray);
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                    if (!(element$iv$iv$iv instanceof KtCallableReferenceExpression)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                list2 = (List)destination$iv$iv$iv;
            }
            List allReferenceExpressions = list2;
            Iterable $this$firstOrNull$iv = allReferenceExpressions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtCallableReferenceExpression it = (KtCallableReferenceExpression)element$iv;
                boolean bl = false;
                if (!this.calculatedClassNameMatches((PsiElement)it, currentLocationClassName)) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        return v3;
    }

    private final KtFunction getLambdaOrFunIfInside(Location location2, KtFile file2, int lineNumber) {
        String string2 = KotlinPositionManagerKt.getClassName(location2);
        if (string2 == null) {
            return null;
        }
        String currentLocationClassName = string2;
        Integer start2 = KotlinPsiUtils.getStartLineOffset((PsiFile)file2, lineNumber);
        Integer end = KotlinPsiUtils.getEndLineOffset((PsiFile)file2, lineNumber);
        if (start2 == null || end == null) {
            return null;
        }
        List<KtFunction> literalsOrFunctions = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(file2, lineNumber);
        if (literalsOrFunctions.isEmpty()) {
            return null;
        }
        KtFunction ktFunction = this.getAppropriateLiteralBasedOnDeclaringClassName(literalsOrFunctions, location2, currentLocationClassName);
        if (ktFunction == null) {
            ktFunction = this.getAppropriateLiteralBasedOnLambdaName(literalsOrFunctions, location2, lineNumber);
        }
        return ktFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final KtFunction getAppropriateLiteralBasedOnDeclaringClassName(List<? extends KtFunction> $this$getAppropriateLiteralBasedOnDeclaringClassName, Location location2, String currentLocationClassName) {
        void this_$iv$iv$iv;
        void this_$iv$iv;
        KtFunction ktFunction = (KtFunction)CollectionsKt.firstOrNull($this$getAppropriateLiteralBasedOnDeclaringClassName);
        if (ktFunction == null) {
            return null;
        }
        KtFunction firstLiteral = ktFunction;
        Object nonDefaultLifetimeTokenFactory$iv = null;
        boolean $i$f$analyze = false;
        Project project = ((KtElement)firstLiteral).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"useSiteKtElement.project");
        KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyse = false;
        KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
        void var10_10 = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)firstLiteral, factory$iv$iv);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            KtAnalysisSession $this$getAppropriateLiteralBasedOnDeclaringClassName_u24lambda_u247 = analysisSession$iv$iv$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = $this$getAppropriateLiteralBasedOnDeclaringClassName;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtFunction literal = (KtFunction)element$iv;
                boolean bl2 = false;
                if (AnalysisApiBasedInlineUtil.INSTANCE.isInlinedArgument($this$getAppropriateLiteralBasedOnDeclaringClassName_u24lambda_u247, literal, true)) {
                    DebugProcess debugProcess = this.debugProcess;
                    Intrinsics.checkNotNull((Object)debugProcess, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
                    if (!DebuggerUtil.isInsideInlineArgument(literal, location2, (DebugProcessImpl)debugProcess)) continue;
                    KtFunction ktFunction2 = literal;
                    return ktFunction2;
                }
                if (!this.calculatedClassNameMatches(literal.getFirstChild(), currentLocationClassName)) continue;
                KtFunction ktFunction3 = literal;
                return ktFunction3;
            }
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
        return null;
    }

    private final boolean calculatedClassNameMatches(PsiElement $this$calculatedClassNameMatches, String currentLocationClassName) {
        boolean bl;
        block3: {
            ClassNameProvider classNameProvider = new ClassNameProvider(this.debugProcess.getProject(), this.debugProcess.getSearchScope(), ClassNameProvider.Configuration.copy$default(ClassNameProvider.Configuration.Companion.getDEFAULT(), false, false, 1, null));
            Iterable $this$any$iv = classNameProvider.getCandidatesForElement($this$calculatedClassNameMatches);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)currentLocationClassName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final KtFunction getAppropriateLiteralBasedOnLambdaName(List<? extends KtFunction> $this$getAppropriateLiteralBasedOnLambdaName, Location location2, int lineNumber) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Method method = SafeUtilKt.safeMethod(location2);
        if (method == null) {
            return null;
        }
        Method method2 = method;
        if (!DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(method2.name())) {
            return null;
        }
        Iterable iterable = location2.declaringType().methods();
        boolean $i$f$filter = false;
        void var8_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Method it = (Method)element$iv$iv;
            boolean bl = false;
            boolean bl2 = DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(it.name()) && !((Collection)DebuggerUtilsEx.locationsOfLine((Method)it, (int)(lineNumber + 1))).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lambdas = (List)destination$iv$iv;
        return this.getSamLambdaWithIndex($this$getAppropriateLiteralBasedOnLambdaName, lambdas.indexOf(method2));
    }

    private final KtFunction getSamLambdaWithIndex(List<? extends KtFunction> $this$getSamLambdaWithIndex, int index) {
        int samLambdaCounter = 0;
        for (KtFunction ktFunction : $this$getSamLambdaWithIndex) {
            if (!KotlinPositionManagerKt.access$isSamLambda(ktFunction)) continue;
            if (samLambdaCounter == index) {
                return ktFunction;
            }
            ++samLambdaCounter;
        }
        return null;
    }

    private final PsiFile getPsiFileByLocation(Location location2) {
        String string2;
        String string3 = SafeUtilKt.safeSourceName(location2);
        if (string3 == null) {
            return null;
        }
        String sourceName2 = string3;
        try {
            string2 = DebuggerUtil.containsKotlinStrata(location2.declaringType()) ? StringsKt.replace$default((String)location2.sourcePath(), (char)'\\', (char)'/', (boolean)false, (int)4, null) : this.defaultInternalName(location2);
        }
        catch (AbsentInformationException e) {
            string2 = this.defaultInternalName(location2);
        }
        String referenceInternalName = string2;
        JvmClassName className = JvmClassName.byInternalName((String)referenceInternalName);
        Project project = this.debugProcess.getProject();
        return (PsiFile)DebuggerUtils.INSTANCE.findSourceFileForClass(project, this.sourceSearchScopes, className, sourceName2, location2);
    }

    private final String defaultInternalName(Location location2) {
        String referenceFqName = location2.declaringType().name();
        return StringsKt.replace$default((String)referenceFqName, (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition sourcePosition) {
        PsiFile psiFile2 = sourcePosition.getFile();
        if (psiFile2 instanceof KtFile) {
            List list2 = (List)KotlinPluginDisposableUtils.syncNonBlockingReadAction(((KtFile)psiFile2).getProject(), (Function0)new Function0<List<? extends ReferenceType>>(psiFile2, this, sourcePosition){
                final /* synthetic */ PsiFile $psiFile;
                final /* synthetic */ KotlinPositionManager this$0;
                final /* synthetic */ SourcePosition $sourcePosition;
                {
                    this.$psiFile = $psiFile;
                    this.this$0 = $receiver;
                    this.$sourcePosition = $sourcePosition;
                    super(0);
                }

                @Nullable
                public final List<ReferenceType> invoke() {
                    if (!SourceKindFilterUtils.matches(RootKindFilter.projectAndLibrarySources, (PsiElement)this.$psiFile)) {
                        return null;
                    }
                    return KotlinPositionManager.access$getReferenceTypesForPositionInKotlinFile(this.this$0, this.$sourcePosition);
                }
            });
            if (list2 == null) {
                return CollectionsKt.emptyList();
            }
            List referenceTypesInKtFile2 = list2;
            if (ComposeUtilsKt.isInsideProjectWithCompose(sourcePosition)) {
                return CollectionsKt.plus((Collection)referenceTypesInKtFile2, (Iterable)ComposeUtilsKt.getComposableSingletonsClasses(this.debugProcess, (KtFile)psiFile2));
            }
            return referenceTypesInKtFile2;
        }
        if (psiFile2 instanceof ClsFileImpl) {
            boolean $i$f$runReadAction = false;
            PsiFile decompiledPsiFile = (PsiFile)ApplicationManager.getApplication().runReadAction(new Computable(psiFile2){
                final /* synthetic */ PsiFile $psiFile$inlined;
                {
                    this.$psiFile$inlined = psiFile2;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)((ClsFileImpl)this.$psiFile$inlined).getDecompiledPsiFile();
                }
            });
            if (decompiledPsiFile instanceof KtClsFile) {
                $i$f$runReadAction = false;
                if (((Number)ApplicationManager.getApplication().runReadAction(new Computable(sourcePosition){
                    final /* synthetic */ SourcePosition $sourcePosition$inlined;
                    {
                        this.$sourcePosition$inlined = sourcePosition;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)Integer.valueOf(this.$sourcePosition$inlined.getLine());
                    }
                })).intValue() == -1) {
                    String className = JvmFileClassUtil.getFileClassInternalName((KtFile)((KtFile)decompiledPsiFile));
                    return this.debugProcess.getVirtualMachineProxy().classesByName(className);
                }
            }
        }
        throw NoDataException.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    private final List<ReferenceType> getReferenceTypesForPositionInKotlinFile(SourcePosition sourcePosition) {
        ClassNameProvider classNameProvider = new ClassNameProvider(this.debugProcess.getProject(), this.debugProcess.getSearchScope(), ClassNameProvider.Configuration.Companion.getDEFAULT());
        int lineNumber = sourcePosition.getLine();
        try {
            Collection collection;
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            Iterable iterable = classNameProvider.getCandidates(sourcePosition);
            boolean $i$f$flatMap22 = false;
            void var7_7 = $this$flatMap$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                String className = (String)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.debugProcess.getVirtualMachineProxy().classesByName(className);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List allCandidates = (List)destination$iv$iv;
            Iterable $i$f$flatMap22 = allCandidates;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ReferenceType referenceType = (ReferenceType)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = KotlinPositionManagerKt.access$findTargetClasses(this.debugProcess, referenceType, lineNumber);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List matchingCandidates = (List)destination$iv$iv2;
            Collection collection2 = matchingCandidates;
            if (collection2.isEmpty()) {
                boolean bl = false;
                collection = allCandidates;
            } else {
                collection = collection2;
            }
            return (List)collection;
        }
        catch (IncompatibleThreadStateException e) {
            return CollectionsKt.emptyList();
        }
        catch (VMDisconnectedException e) {
            return CollectionsKt.emptyList();
        }
    }

    @Deprecated(message="Use 'ClassNameProvider' directly")
    @NotNull
    public final List<String> originalClassNamesForPosition(@NotNull SourcePosition position) {
        boolean $i$f$runReadAction = false;
        return (List)ApplicationManager.getApplication().runReadAction(new Computable(this, position){
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ SourcePosition $position$inlined;
            {
                this.this$0 = kotlinPositionManager;
                this.$position$inlined = sourcePosition;
            }

            public final T compute() {
                boolean bl = false;
                ClassNameProvider classNameProvider = new ClassNameProvider(KotlinPositionManager.access$getDebugProcess$p(this.this$0).getProject(), KotlinPositionManager.access$getDebugProcess$p(this.this$0).getSearchScope(), ClassNameProvider.Configuration.copy$default(ClassNameProvider.Configuration.Companion.getDEFAULT(), false, false, 2, null));
                return (T)classNameProvider.getCandidates(this.$position$inlined);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type2, @NotNull SourcePosition position) {
        if (!(position.getFile() instanceof KtFile)) {
            throw NoDataException.INSTANCE;
        }
        try {
            void $this$filterTo$iv$iv;
            int line;
            List locations;
            Collection collection;
            if (DexDebugFacility.INSTANCE.isDex(this.debugProcess)) {
                boolean $i$f$runReadAction = false;
                List inlineLocations = (List)ApplicationManager.getApplication().runReadAction(new Computable(type2, position, this){
                    final /* synthetic */ ReferenceType $type$inlined;
                    final /* synthetic */ SourcePosition $position$inlined;
                    final /* synthetic */ KotlinPositionManager this$0;
                    {
                        this.$type$inlined = referenceType;
                        this.$position$inlined = sourcePosition;
                        this.this$0 = kotlinPositionManager;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)DebuggerUtils.INSTANCE.getLocationsOfInlinedLine(this.$type$inlined, this.$position$inlined, KotlinPositionManager.access$getDebugProcess$p(this.this$0).getSearchScope());
                    }
                });
                if (!((Collection)inlineLocations).isEmpty()) {
                    return inlineLocations;
                }
            }
            if ((collection = (Collection)(locations = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type2, (String)"Kotlin", null, (int)(line = position.getLine() + 1)))) == null || collection.isEmpty()) {
                throw NoDataException.INSTANCE;
            }
            Iterable $this$filter$iv = locations;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Location it = (Location)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.sourceName("Kotlin"), (Object)position.getFile().getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        catch (AbsentInformationException e) {
            throw NoDataException.INSTANCE;
        }
    }

    @Deprecated(message="Since Idea 14.0.3 use createPrepareRequests fun", replaceWith=@ReplaceWith(expression="createPrepareRequests(classPrepareRequestor, sourcePosition).firstOrNull()", imports={}))
    @Nullable
    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor classPrepareRequestor, @NotNull SourcePosition sourcePosition) {
        return (ClassPrepareRequest)CollectionsKt.firstOrNull(this.createPrepareRequests(classPrepareRequestor, sourcePosition));
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        PsiFile file2 = position.getFile();
        if (!(file2 instanceof KtFile)) {
            throw NoDataException.INSTANCE;
        }
        boolean isInsideProjectWithCompose = ComposeUtilsKt.isInsideProjectWithCompose(position);
        return (List)DumbService.getInstance((Project)this.debugProcess.getProject()).runReadActionInSmartMode(() -> KotlinPositionManager.createPrepareRequests$lambda$18(this, requestor, position, isInsideProjectWithCompose, file2));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    private final List<ClassPrepareRequest> createKotlinClassPrepareRequests(ClassPrepareRequestor requestor, SourcePosition position) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        SourcePosition refinedPosition = requestor instanceof SourcePositionRefiner ? ((SourcePositionRefiner)requestor).refineSourcePosition(position) : position;
        Iterable iterable = new ClassNameProvider(this.debugProcess.getProject(), this.debugProcess.getSearchScope(), ClassNameProvider.Configuration.Companion.getDEFAULT()).getCandidates(refinedPosition);
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String name2 = (String)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new ClassPrepareRequest[]{this.debugProcess.getRequestsManager().createClassPrepareRequest(requestor, name2), this.debugProcess.getRequestsManager().createClassPrepareRequest(requestor, name2 + "$*")};
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List createPrepareRequests$lambda$18(KotlinPositionManager this$0, ClassPrepareRequestor $requestor, SourcePosition $position, boolean $isInsideProjectWithCompose, PsiFile $file) {
        ClassPrepareRequest singletonRequest;
        List kotlinRequests = this$0.createKotlinClassPrepareRequests($requestor, $position);
        return $isInsideProjectWithCompose ? ((singletonRequest = ComposeUtilsKt.getClassPrepareRequestForComposableSingletons(this$0.debugProcess, $requestor, (KtFile)$file)) == null ? kotlinRequests : CollectionsKt.plus((Collection)kotlinRequests, (Object)singletonRequest)) : kotlinRequests;
    }

    public static final /* synthetic */ List access$getReferenceTypesForPositionInKotlinFile(KotlinPositionManager $this, SourcePosition sourcePosition) {
        return $this.getReferenceTypesForPositionInKotlinFile(sourcePosition);
    }

    public static final /* synthetic */ DebugProcess access$getDebugProcess$p(KotlinPositionManager $this) {
        return $this.debugProcess;
    }
}

