/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Accessible;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionBase;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.FileRankingCalculatorKt;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinFileSelector;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 F2\u00020\u0001:\u0002FGB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J!\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0007\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0007\u001a\u00020\u001aH\u0002J\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0007\u001a\u00020\u001aH\u0082\u0010J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0006H\u0002J(\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020'0&2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0(2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J \u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u0002002\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u000205H\u0002J \u00106\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u001f2\u0006\u00107\u001a\u0002082\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0018\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020;2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010<\u001a\u00020\u00102\u0006\u0010=\u001a\u00020>2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010?\u001a\u00020\u00102\u0006\u00107\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u001a\u0010C\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f\u0018\u00010D*\u00020-H\u0002J\f\u0010E\u001a\u00020\u0003*\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator;", "Lorg/jetbrains/kotlin/idea/debugger/base/util/KotlinFileSelector;", "checkClassFqName", "", "(Z)V", "analyze", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "chooseMostApplicableFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "", "location", "Lcom/sun/jdi/Location;", "collect", "Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "conditions", "", "", "([Ljava/lang/Object;)Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "fileRanking", "file", "fileRankingSafe", "findAnonymousFunctionInParent", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lcom/intellij/psi/PsiElement;", "findFunctionLiteralOnLine", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "findNonLocalCallableParent", "getPropertyName", "", "accessorMethodName", "isSetter", "makeTypeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "bindingContext", "rankFiles", "", "", "", "rankingForAccessor", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "method", "Lcom/sun/jdi/Method;", "rankingForClass", "clazz", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "type", "Lcom/sun/jdi/ReferenceType;", "fqName", "virtualMachine", "Lcom/sun/jdi/VirtualMachine;", "rankingForClassName", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "rankingForMethod", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "rankingForProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "rankingForVisibility", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "accessible", "Lcom/sun/jdi/Accessible;", "getContainingClassAndMethodNameForLambda", "Lkotlin/Pair;", "isLambda", "Companion", "Ranking", "kotlin.jvm-debugger.util"})
public abstract class FileRankingCalculator
implements KotlinFileSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean checkClassFqName;
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)"FileRankingCalculator");

    public FileRankingCalculator(boolean checkClassFqName) {
        this.checkClassFqName = checkClassFqName;
    }

    public /* synthetic */ FileRankingCalculator(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @NotNull
    public abstract BindingContext analyze(@NotNull KtElement var1);

    @Override
    @NotNull
    public KtFile chooseMostApplicableFile(@NotNull List<? extends KtFile> files2, @NotNull Location location2) {
        Object v0;
        Map<KtFile, Integer> fileWithRankings = this.rankFiles((Collection<? extends KtFile>)files2, location2);
        Iterable iterable = fileWithRankings.entrySet();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator.next();
            if (!iterator.hasNext()) {
                v0 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                int n = ((Number)it.getValue()).intValue();
                do {
                    Object t2 = iterator.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-FileRankingCalculator$chooseMostApplicableFile$fileWithMaxScore$1 = false;
                    int n2 = ((Number)it2.getValue()).intValue();
                    if (n >= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator.hasNext());
                v0 = t;
            }
        }
        Map.Entry entry = v0;
        Intrinsics.checkNotNull((Object)entry);
        Map.Entry fileWithMaxScore = entry;
        return (KtFile)fileWithMaxScore.getKey();
    }

    @NotNull
    public final Map<KtFile, Integer> rankFiles(@NotNull Collection<? extends KtFile> files2, @NotNull Location location2) {
        boolean bl;
        boolean bl2 = bl = !files2.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return CollectionsKt.keysToMap((Iterable)files2, (Function1)((Function1)new Function1<KtFile, Integer>(this, location2){
            final /* synthetic */ FileRankingCalculator this$0;
            final /* synthetic */ Location $location;
            {
                this.this$0 = $receiver;
                this.$location = $location;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull KtFile it) {
                return FileRankingCalculator.access$fileRankingSafe(this.this$0, it, this.$location).getValue();
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Ranking collect(Object ... conditions) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Object $this$map$iv = conditions;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            Ranking ranking;
            void condition2;
            void item$iv$iv;
            void var10_15 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_18 = condition2;
            if (var12_18 instanceof Boolean) {
                ranking = Ranking.Companion.minor((Boolean)condition2);
            } else if (var12_18 instanceof Integer) {
                ranking = new Ranking(((Number)condition2).intValue());
            } else if (var12_18 instanceof Ranking) {
                ranking = (Ranking)condition2;
            } else {
                throw new IllegalStateException(("Invalid condition type " + condition2.getClass().getName()).toString());
            }
            collection.add(ranking);
        }
        $this$map$iv = (List)destination$iv$iv;
        Ranking initial$iv = Ranking.Companion.getZERO();
        boolean $i$f$fold = false;
        Ranking accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void r;
            Ranking ranking = (Ranking)element$iv;
            Ranking sum = accumulator$iv;
            boolean bl = false;
            accumulator$iv = sum.plus((Ranking)r);
        }
        return accumulator$iv;
    }

    private final Ranking rankingForClass(KtClassOrObject clazz, String fqName2, VirtualMachine virtualMachine) {
        BindingContext bindingContext2 = this.analyze((KtElement)clazz);
        ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.CLASS, (Object)clazz);
        if (classDescriptor == null) {
            return Ranking.Companion.getZERO();
        }
        ClassDescriptor descriptor2 = classDescriptor;
        ReferenceType referenceType = (ReferenceType)kotlin.collections.CollectionsKt.firstOrNull(virtualMachine.classesByName(fqName2));
        if (referenceType == null) {
            FileRankingCalculator $this$rankingForClass_u24lambda_u243 = this;
            boolean bl = false;
            return $this$rankingForClass_u24lambda_u243.rankingForClassName(fqName2, descriptor2, bindingContext2);
        }
        ReferenceType jdiType = referenceType;
        return this.rankingForClass(clazz, jdiType);
    }

    private final Ranking rankingForClass(KtClassOrObject clazz, ReferenceType type2) {
        BindingContext bindingContext2 = this.analyze((KtElement)clazz);
        ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.CLASS, (Object)clazz);
        if (classDescriptor == null) {
            return Ranking.Companion.getZERO();
        }
        ClassDescriptor descriptor2 = classDescriptor;
        Object[] objectArray = new Object[]{this.rankingForClassName(type2.name(), descriptor2, bindingContext2), Ranking.Companion.minor(type2.isAbstract() && descriptor2.getModality() == Modality.ABSTRACT), Ranking.Companion.minor(type2.isFinal() && descriptor2.getModality() == Modality.FINAL), Ranking.Companion.minor(type2.isStatic() && !descriptor2.isInner()), this.rankingForVisibility((DeclarationDescriptorWithVisibility)descriptor2, type2)};
        return this.collect(objectArray);
    }

    private final Ranking rankingForClassName(String fqName2, ClassDescriptor descriptor2, BindingContext bindingContext2) {
        if (DescriptorUtils.isLocal((DeclarationDescriptor)((DeclarationDescriptor)descriptor2))) {
            return Ranking.Companion.getZERO();
        }
        String expectedFqName = this.makeTypeMapper(bindingContext2).mapType((ClassifierDescriptor)descriptor2).getClassName();
        return this.checkClassFqName ? (Intrinsics.areEqual((Object)expectedFqName, (Object)fqName2) ? Ranking.Companion.getMAJOR() : Ranking.Companion.getLOW()) : (Intrinsics.areEqual((Object)FileRankingCalculatorKt.access$simpleName(expectedFqName), (Object)FileRankingCalculatorKt.access$simpleName(fqName2)) ? Ranking.Companion.getMAJOR() : Ranking.Companion.getLOW());
    }

    private final Ranking rankingForMethod(KtFunction function2, Method method) {
        BindingContext bindingContext2 = this.analyze((KtElement)function2);
        Object object = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)function2);
        CallableMemberDescriptor callableMemberDescriptor = object instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)object : null;
        if (callableMemberDescriptor == null) {
            return Ranking.Companion.getZERO();
        }
        CallableMemberDescriptor descriptor2 = callableMemberDescriptor;
        if (!(function2 instanceof KtConstructor) && !Intrinsics.areEqual((Object)method.name(), (Object)descriptor2.getName().asString())) {
            return Ranking.Companion.getLOW();
        }
        Object[] objectArray = new Object[6];
        objectArray[0] = method.isConstructor() && function2 instanceof KtConstructor;
        objectArray[1] = method.isAbstract() && descriptor2.getModality() == Modality.ABSTRACT;
        objectArray[2] = method.isFinal() && descriptor2.getModality() == Modality.FINAL;
        objectArray[3] = method.isVarArgs() && DescriptorUtilsKt.varargParameterPosition((CallableDescriptor)((CallableDescriptor)descriptor2)) >= 0;
        objectArray[4] = this.rankingForVisibility((DeclarationDescriptorWithVisibility)descriptor2, method);
        List<LocalVariable> list2 = SafeUtilKt.safeArguments(method);
        objectArray[5] = descriptor2.getValueParameters().size() == (list2 != null ? list2.size() : 0);
        return this.collect(objectArray);
    }

    private final Ranking rankingForAccessor(KtPropertyAccessor accessor, Method method) {
        String actualPropertyName;
        String methodName2 = method.name();
        String string2 = accessor.getProperty().getName();
        if (string2 == null) {
            return Ranking.Companion.getZERO();
        }
        String expectedPropertyName = string2;
        if (!(!accessor.isSetter() || StringsKt.startsWith$default((String)methodName2, (String)"set", (boolean)false, (int)2, null) && method.returnType() instanceof VoidType && method.argumentTypes().size() == 1)) {
            return Ranking.Companion.getMAJOR().unaryMinus();
        }
        if (accessor.isGetter()) {
            if (!StringsKt.startsWith$default((String)methodName2, (String)"get", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)methodName2, (String)"is", (boolean)false, (int)2, null)) {
                return Ranking.Companion.getMAJOR().unaryMinus();
            }
            if (method.returnType() instanceof VoidType || !((Collection)method.argumentTypes()).isEmpty()) {
                return Ranking.Companion.getNORMAL().unaryMinus();
            }
        }
        return Intrinsics.areEqual((Object)expectedPropertyName, (Object)(actualPropertyName = this.getPropertyName(methodName2, accessor.isSetter()))) ? Ranking.Companion.getNORMAL() : Ranking.Companion.getNORMAL().unaryMinus();
    }

    private final String getPropertyName(String accessorMethodName, boolean isSetter) {
        if (isSetter) {
            return StringsKt.drop((String)accessorMethodName, (int)3);
        }
        return StringsKt.drop((String)accessorMethodName, (int)(StringsKt.startsWith$default((String)accessorMethodName, (String)"is", (boolean)false, (int)2, null) ? 2 : 3));
    }

    private final Ranking rankingForProperty(KtProperty property2, Method method) {
        String methodName2 = method.name();
        String string2 = property2.getName();
        if (string2 == null) {
            return Ranking.Companion.getZERO();
        }
        String propertyName = string2;
        if (property2.isTopLevel() && Intrinsics.areEqual((Object)method.name(), (Object)"<clinit>")) {
            return Ranking.Companion.getMINOR();
        }
        if (!StringsKt.startsWith$default((String)methodName2, (String)"get", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)methodName2, (String)"set", (boolean)false, (int)2, null)) {
            return Ranking.Companion.getMAJOR().unaryMinus();
        }
        return Intrinsics.areEqual((Object)StringsKt.drop((String)methodName2, (int)3), (Object)CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)propertyName)) ? Ranking.Companion.getMAJOR() : Ranking.Companion.getNORMAL().unaryMinus();
    }

    private final Ranking rankingForVisibility(DeclarationDescriptorWithVisibility descriptor2, Accessible accessible) {
        Object[] objectArray = new Object[]{accessible.isPublic() && Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.PUBLIC), accessible.isProtected() && Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.PROTECTED), accessible.isPrivate() && Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.PRIVATE)};
        return this.collect(objectArray);
    }

    private final Ranking fileRankingSafe(KtFile file2, Location location2) {
        Ranking ranking;
        try {
            ranking = this.fileRanking(file2, location2);
        }
        catch (ClassNotLoadedException e) {
            LOG.error("ClassNotLoadedException should never happen in FileRankingCalculator", (Throwable)e);
            ranking = Ranking.Companion.getZERO();
        }
        catch (AbsentInformationException e) {
            ranking = Ranking.Companion.getZERO();
        }
        catch (InternalException e) {
            ranking = Ranking.Companion.getZERO();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error("Exception during Kotlin sources ranking", (Throwable)e);
            ranking = Ranking.Companion.getZERO();
        }
        return ranking;
    }

    /*
     * WARNING - void declaration
     */
    private final Ranking fileRanking(KtFile file2, Location location2) {
        Ranking overallRanking;
        block39: {
            Ranking ranking;
            Method method;
            PsiElement elementAt;
            block36: {
                PsiElement constructorOrInitializer;
                Object object;
                KtClassOrObject containingClass;
                int locationLineNumber;
                block38: {
                    Object object2;
                    block37: {
                        void $this$getParentOfType$iv;
                        locationLineNumber = location2.lineNumber() - 1;
                        Integer n = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file2, locationLineNumber);
                        if (n == null) {
                            return Ranking.Companion.getLOW();
                        }
                        int lineStartOffset = n;
                        PsiElement psiElement2 = file2.findElementAt(lineStartOffset);
                        if (psiElement2 == null) {
                            return Ranking.Companion.getZERO();
                        }
                        elementAt = psiElement2;
                        overallRanking = Ranking.Companion.getZERO();
                        method = location2.method();
                        if (this.isLambda(method)) {
                            void $this$getParentOfType$iv2;
                            NavigatablePsiElement navigatablePsiElement;
                            Pair<String, String> pair = this.getContainingClassAndMethodNameForLambda(method);
                            if (pair == null) {
                                return Ranking.Companion.getZERO();
                            }
                            Pair<String, String> pair2 = pair;
                            String className = (String)pair2.component1();
                            String methodName2 = (String)pair2.component2();
                            if (method.isBridge() && method.isSynthetic()) {
                                void $this$getParentOfType$iv3;
                                PsiElement psiElement3 = elementAt;
                                boolean strict$iv = false;
                                boolean $i$f$getParentOfType = false;
                                KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv3, KtClassOrObject.class, (boolean)strict$iv);
                                if (ktClassOrObject == null) {
                                    return Ranking.Companion.getLOW();
                                }
                                KtClassOrObject containingClass2 = ktClassOrObject;
                                return this.rankingForClass(containingClass2, className, location2.virtualMachine());
                            }
                            KtFunctionLiteral ktFunctionLiteral = this.findFunctionLiteralOnLine(elementAt);
                            if (ktFunctionLiteral != null) {
                                navigatablePsiElement = (NavigatablePsiElement)ktFunctionLiteral;
                            } else {
                                KtNamedFunction ktNamedFunction = this.findAnonymousFunctionInParent(elementAt);
                                if (ktNamedFunction != null) {
                                    navigatablePsiElement = (NavigatablePsiElement)ktNamedFunction;
                                } else {
                                    return Ranking.Companion.getLOW();
                                }
                            }
                            NavigatablePsiElement containingFunctionLiteral = navigatablePsiElement;
                            PsiElement psiElement4 = this.findNonLocalCallableParent((PsiElement)containingFunctionLiteral);
                            if (psiElement4 == null) {
                                return Ranking.Companion.getLOW();
                            }
                            PsiElement containingCallable = psiElement4;
                            PsiElement $this$getParentOfType$iv3 = containingCallable;
                            if ($this$getParentOfType$iv3 instanceof KtFunction) {
                                if (Intrinsics.areEqual((Object)((KtFunction)containingCallable).getName(), (Object)methodName2)) {
                                    overallRanking = overallRanking.plus(Ranking.Companion.getMAJOR());
                                }
                            } else if ($this$getParentOfType$iv3 instanceof KtProperty) {
                                if (Intrinsics.areEqual((Object)((KtProperty)containingCallable).getName(), (Object)methodName2)) {
                                    overallRanking = overallRanking.plus(Ranking.Companion.getMAJOR());
                                }
                            } else if ($this$getParentOfType$iv3 instanceof KtPropertyAccessor && Intrinsics.areEqual((Object)((KtPropertyAccessor)containingCallable).getProperty().getName(), (Object)methodName2)) {
                                overallRanking = overallRanking.plus(Ranking.Companion.getMAJOR());
                            }
                            PsiElement strict$iv = containingCallable;
                            boolean strict$iv2 = false;
                            boolean $i$f$getParentOfType = false;
                            KtClassOrObject containingClass3 = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv2, KtClassOrObject.class, (boolean)strict$iv2);
                            if (containingClass3 != null) {
                                overallRanking = overallRanking.plus(this.rankingForClass(containingClass3, className, location2.virtualMachine()));
                            }
                            return overallRanking;
                        }
                        if (!Intrinsics.areEqual((Object)method.name(), (Object)"<init>")) break block36;
                        PsiElement methodName2 = elementAt;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfType = false;
                        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClassOrObject.class, (boolean)strict$iv);
                        if (ktClassOrObject == null) {
                            return Ranking.Companion.getLOW();
                        }
                        containingClass = ktClassOrObject;
                        PsiElement $this$getParentOfTypes2$iv = elementAt;
                        boolean $i$f$getParentOfTypes2 = false;
                        Class[] containingClass3 = new Class[]{KtConstructor.class, KtClassInitializer.class};
                        object = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfTypes2$iv, (Class[])containingClass3);
                        if (object == null) break block37;
                        PsiElement it = $i$f$getParentOfTypes2 = object;
                        boolean bl = false;
                        object = PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)containingClass), (PsiElement)it, (boolean)false, (int)2, null) ? $i$f$getParentOfTypes2 : null;
                        if (object != null) break block38;
                    }
                    KtPrimaryConstructor ktPrimaryConstructor = containingClass.getPrimaryConstructor();
                    if (ktPrimaryConstructor != null) {
                        KtPrimaryConstructor ktPrimaryConstructor2;
                        KtPrimaryConstructor it = ktPrimaryConstructor2 = ktPrimaryConstructor;
                        boolean bl = false;
                        object2 = FileRankingCalculatorKt.access$getLine((PsiElement)it) == FileRankingCalculatorKt.access$getLine((PsiElement)containingClass) ? ktPrimaryConstructor2 : null;
                    } else {
                        object2 = null;
                    }
                    object = (PsiElement)object2;
                }
                if ((constructorOrInitializer = object) == null && locationLineNumber < FileRankingCalculatorKt.access$getLine((PsiElement)containingClass) && locationLineNumber > FileRankingCalculatorKt.access$getLine(containingClass.getLastChild())) {
                    return Ranking.Companion.getLOW();
                }
                overallRanking = overallRanking.plus(this.rankingForClass(containingClass, location2.declaringType()));
                if (constructorOrInitializer instanceof KtConstructor) {
                    overallRanking = overallRanking.plus(this.rankingForMethod((KtFunction)constructorOrInitializer, method));
                }
                break block39;
            }
            PsiElement psiElement5 = this.findNonLocalCallableParent(elementAt);
            if (psiElement5 == null) {
                return Ranking.Companion.getLOW();
            }
            PsiElement callable2 = psiElement5;
            PsiElement constructorOrInitializer = callable2;
            if (constructorOrInitializer instanceof KtFunction) {
                ranking = this.rankingForMethod((KtFunction)callable2, method);
            } else if (constructorOrInitializer instanceof KtPropertyAccessor) {
                ranking = this.rankingForAccessor((KtPropertyAccessor)callable2, method);
            } else if (constructorOrInitializer instanceof KtProperty) {
                ranking = this.rankingForProperty((KtProperty)callable2, method);
            } else {
                return Ranking.Companion.getLOW();
            }
            overallRanking = overallRanking.plus(ranking);
            PsiElement $this$getParentOfType$iv = elementAt;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            KtClassOrObject containingClass = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClassOrObject.class, (boolean)strict$iv);
            if (containingClass != null) {
                overallRanking = overallRanking.plus(this.rankingForClass(containingClass, location2.declaringType()));
            }
        }
        return overallRanking;
    }

    /*
     * WARNING - void declaration
     */
    private final KtFunctionLiteral findFunctionLiteralOnLine(PsiElement element3) {
        void $this$getParentOfType$iv;
        void $this$getParentOfType$iv2;
        PsiElement psiElement2 = element3;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType22 = false;
        KtFunctionLiteral literal = (KtFunctionLiteral)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv2, KtFunctionLiteral.class, (boolean)strict$iv);
        if (literal != null) {
            return literal;
        }
        PsiElement $i$f$getParentOfType22 = element3;
        boolean strict$iv2 = false;
        boolean $i$f$getParentOfType = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtCallExpression.class, (boolean)strict$iv2);
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        for (KtLambdaArgument lambdaArgument : callExpression2.getLambdaArguments()) {
            if (FileRankingCalculatorKt.access$getLine(element3) != FileRankingCalculatorKt.access$getLine((PsiElement)lambdaArgument)) continue;
            KtLambdaExpression ktLambdaExpression2 = lambdaArgument.getLambdaExpression();
            Object functionLiteral = ktLambdaExpression2 != null ? ktLambdaExpression2.getFunctionLiteral() : null;
            if (functionLiteral == null) continue;
            return functionLiteral;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final KtNamedFunction findAnonymousFunctionInParent(PsiElement element3) {
        void $this$getParentOfType$iv;
        PsiElement psiElement2 = element3;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        KtNamedFunction parentFun = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtNamedFunction.class, (boolean)strict$iv);
        if (parentFun != null && KtPsiUtilKt.isFunctionalExpression((PsiElement)((PsiElement)parentFun))) {
            return parentFun;
        }
        return null;
    }

    private final PsiElement findNonLocalCallableParent(PsiElement element3) {
        PsiElement containingCallable;
        while (true) {
            if (FileRankingCalculator.findNonLocalCallableParent$isCallableDeclaration(element3) && !FileRankingCalculator.findNonLocalCallableParent$isLocalDeclaration(element3)) {
                return element3;
            }
            PsiElement $this$getParentOfTypes3$iv = element3;
            boolean $i$f$getParentOfTypes3 = false;
            Class[] classArray = new Class[]{KtProperty.class, KtFunction.class, KtAnonymousInitializer.class};
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfTypes3$iv, (Class[])classArray) == null) {
                return null;
            }
            if (!FileRankingCalculator.findNonLocalCallableParent$isLocalDeclaration(containingCallable)) break;
            element3 = containingCallable;
        }
        return containingCallable;
    }

    private final Pair<String, String> getContainingClassAndMethodNameForLambda(Method $this$getContainingClassAndMethodNameForLambda) {
        ReferenceType referenceType = $this$getContainingClassAndMethodNameForLambda.declaringType();
        Intrinsics.checkNotNull((Object)referenceType, (String)"null cannot be cast to non-null type com.sun.jdi.ClassType");
        ClassType declaringClass = (ClassType)referenceType;
        Object object = new char[]{'$'};
        char[] it = object = (Object)StringsKt.split$default((CharSequence)declaringClass.name(), (char[])object, (boolean)false, (int)3, (int)2, null);
        boolean bl = false;
        Object object2 = it.size() == 3 ? object : null;
        if (object2 == null) {
            return null;
        }
        Object object3 = object2;
        String className = (String)object3.get(0);
        String methodName2 = (String)object3.get(1);
        return new Pair((Object)className, (Object)methodName2);
    }

    private final boolean isLambda(Method $this$isLambda) {
        ReferenceType referenceType = $this$isLambda.declaringType();
        ClassType classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
        if (classType == null) {
            return false;
        }
        ClassType declaringClass = classType;
        ClassType classType2 = declaringClass.superclass();
        return classType2 != null ? FileRankingCalculator.isLambda$isLambdaClass(classType2) : false;
    }

    private final KotlinTypeMapper makeTypeMapper(BindingContext bindingContext2) {
        return new KotlinTypeMapper(bindingContext2, ClassBuilderMode.LIGHT_CLASSES, "debugger", KotlinTypeMapper.Companion.getLANGUAGE_VERSION_SETTINGS_DEFAULT(), false, null, false, null, null, 480, null);
    }

    private static final boolean findNonLocalCallableParent$isCallableDeclaration(PsiElement $this$findNonLocalCallableParent_u24isCallableDeclaration) {
        return $this$findNonLocalCallableParent_u24isCallableDeclaration instanceof KtProperty || $this$findNonLocalCallableParent_u24isCallableDeclaration instanceof KtFunction || $this$findNonLocalCallableParent_u24isCallableDeclaration instanceof KtAnonymousInitializer;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean findNonLocalCallableParent$isLocalDeclaration(PsiElement $this$findNonLocalCallableParent_u24isLocalDeclaration) {
        void $this$getParentOfType$iv;
        PsiElement psiElement2 = $this$findNonLocalCallableParent_u24isLocalDeclaration;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        KtDeclaration containingDeclaration2 = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDeclaration.class, (boolean)strict$iv);
        return containingDeclaration2 instanceof KtCallableDeclaration || containingDeclaration2 instanceof KtPropertyAccessor;
    }

    private static final boolean isLambda$isLambdaClass(ClassType $this$isLambda_u24isLambdaClass) {
        while (true) {
            ClassType superClass;
            boolean bl;
            block6: {
                Iterable $this$any$iv = $this$isLambda_u24isLambdaClass.interfaces();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        InterfaceType it = (InterfaceType)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)FunctionBase.class.getName())) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
            if ($this$isLambda_u24isLambdaClass.superclass() == null) {
                return false;
            }
            $this$isLambda_u24isLambdaClass = superClass;
        }
    }

    public FileRankingCalculator() {
        this(false, 1, null);
    }

    public static final /* synthetic */ Ranking access$fileRankingSafe(FileRankingCalculator $this, KtFile file2, Location location2) {
        return $this.fileRankingSafe(file2, location2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\t\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000H\u0086\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "", "value", "", "(I)V", "getValue", "()I", "compareTo", "other", "plus", "toString", "", "unaryMinus", "Companion", "kotlin.jvm-debugger.util"})
    private static final class Ranking
    implements Comparable<Ranking> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int value;
        @NotNull
        private static final Ranking LOW = new Ranking(-1000);
        @NotNull
        private static final Ranking ZERO = new Ranking(0);
        @NotNull
        private static final Ranking MINOR = new Ranking(1);
        @NotNull
        private static final Ranking NORMAL = new Ranking(5);
        @NotNull
        private static final Ranking MAJOR = new Ranking(10);

        public Ranking(int value2) {
            this.value = value2;
        }

        public final int getValue() {
            return this.value;
        }

        @NotNull
        public final Ranking unaryMinus() {
            return new Ranking(-this.value);
        }

        @NotNull
        public final Ranking plus(@NotNull Ranking other) {
            return new Ranking(this.value + other.value);
        }

        @Override
        public int compareTo(@NotNull Ranking other) {
            return this.value - other.value;
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.value);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking$Companion;", "", "()V", "LOW", "Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "getLOW", "()Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "MAJOR", "getMAJOR", "MINOR", "getMINOR", "NORMAL", "getNORMAL", "ZERO", "getZERO", "minor", "condition", "", "kotlin.jvm-debugger.util"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Ranking getLOW() {
                return LOW;
            }

            @NotNull
            public final Ranking getZERO() {
                return ZERO;
            }

            @NotNull
            public final Ranking getMINOR() {
                return MINOR;
            }

            @NotNull
            public final Ranking getNORMAL() {
                return NORMAL;
            }

            @NotNull
            public final Ranking getMAJOR() {
                return MAJOR;
            }

            @NotNull
            public final Ranking minor(boolean condition2) {
                return condition2 ? this.getMINOR() : this.getZERO();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.jvm-debugger.util"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

