/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.surroundWith;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.util.KotlinIdeaCoreBundle;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

public class KotlinSurrounderUtils {
    @NlsContexts.DialogTitle
    public static String SURROUND_WITH() {
        return KotlinIdeaCoreBundle.message("surround.with.title", new Object[0]);
    }

    @NlsContexts.DialogMessage
    public static String SURROUND_WITH_ERROR() {
        return KotlinIdeaCoreBundle.message("surround.with.error.cannot.perform.action", new Object[0]);
    }

    private KotlinSurrounderUtils() {
    }

    public static void addStatementsInBlock(@NotNull KtBlockExpression block2, @NotNull PsiElement[] statements2) {
        PsiElement lBrace = block2.getFirstChild();
        block2.addRangeAfter(statements2[0], statements2[statements2.length - 1], lBrace);
    }

    public static void showErrorHint(@NotNull Project project, @NotNull Editor editor2, @NlsContexts.DialogMessage @NotNull String message2) {
        KotlinSurrounderUtils.showErrorHint(project, editor2, message2, KotlinSurrounderUtils.SURROUND_WITH(), null);
    }

    public static void showErrorHint(@NotNull Project project, @NotNull Editor editor2, @NlsContexts.DialogMessage @NotNull String message2, @NlsContexts.DialogTitle @NotNull String title, @Nullable String helpId) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new CommonRefactoringUtil.RefactoringErrorHintException(message2);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message2, (String)title, (String)helpId);
    }

    public static boolean isUsedAsStatement(@NotNull KtExpression expression2) {
        BindingContext context2 = ResolutionUtils.analyze((KtElement)expression2, BodyResolveMode.PARTIAL_WITH_CFA);
        return BindingContextUtilsKt.isUsedAsStatement((KtExpression)expression2, (BindingContext)context2);
    }

    public static boolean isUsedAsExpression(@NotNull KtExpression expression2) {
        BindingContext context2 = ResolutionUtils.analyze((KtElement)expression2, BodyResolveMode.PARTIAL_WITH_CFA);
        return BindingContextUtilsKt.isUsedAsExpression((KtElement)expression2, (BindingContext)context2);
    }
}

