/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.surroundWith;

import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.surroundWith.KotlinSurrounderUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

public abstract class KotlinExpressionSurrounder
implements Surrounder {
    public boolean isApplicable(@NotNull PsiElement[] elements2) {
        if (elements2.length != 1 || !(elements2[0] instanceof KtExpression)) {
            return false;
        }
        KtExpression expression2 = (KtExpression)elements2[0];
        if (expression2 instanceof KtCallExpression && expression2.getParent() instanceof KtQualifiedExpression) {
            return false;
        }
        return this.isApplicable(expression2);
    }

    protected boolean isApplicable(@NotNull KtExpression expression2) {
        BindingContext context2 = ResolutionUtils.analyze((KtElement)expression2, BodyResolveMode.PARTIAL);
        KotlinType type2 = context2.getType(expression2);
        if (type2 == null || KotlinBuiltIns.isUnit((KotlinType)type2) && this.isApplicableToStatements()) {
            return false;
        }
        return this.isApplicableToStatements() || !KotlinSurrounderUtils.isUsedAsStatement(expression2);
    }

    protected boolean isApplicableToStatements() {
        return true;
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement[] elements2) {
        assert (elements2.length == 1) : "KotlinExpressionSurrounder should be applicable only for 1 expression: " + elements2.length;
        return this.surroundExpression(project, editor2, (KtExpression)elements2[0]);
    }

    @Nullable
    protected abstract TextRange surroundExpression(@NotNull Project var1, @NotNull Editor var2, @NotNull KtExpression var3);
}

