/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.ucache;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ClasspathToVfsConverter;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptImplementationSwitcherKt;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsBuilder;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptSdks;
import org.jetbrains.kotlin.idea.core.script.ucache.SdkId;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 B2\u00020\u0001:\bBCDEFGHIB]\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u0005H\u0002J\u000e\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u000fJ\u0018\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020(2\b\u00100\u001a\u0004\u0018\u00010\u0000J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u00100\u001a\u00020\u0000H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010*2\u0006\u0010-\u001a\u00020\u0004H\u0002J\u0010\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u0010-\u001a\u00020\u0004J\u0010\u00104\u001a\u0004\u0018\u0001052\u0006\u0010-\u001a\u00020\u000fJ\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020\u000f072\u0006\u0010-\u001a\u00020\u000fJ\u000e\u00108\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u000fJ\u001c\u00109\u001a\b\u0012\u0004\u0012\u00020\u000f072\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020;J\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000f072\u0006\u0010-\u001a\u00020\u000fJ\u0010\u0010=\u001a\u0004\u0018\u00010 2\u0006\u0010-\u001a\u00020\u000fJ\u0010\u0010>\u001a\u00020\n2\u0006\u00100\u001a\u00020\u0000H\u0002J\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\fR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u0016\u0010\u001b\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "", "scripts", "", "", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$LightScriptInfo;", "classes", "", "sources", "customDefinitionsUsed", "", "sdks", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdks;", "classpathVfsHint", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;ZLorg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdks;Ljava/util/Map;)V", "allDependenciesClassFiles", "getAllDependenciesClassFiles", "()Ljava/util/Set;", "allDependenciesClassFilesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "getAllDependenciesClassFilesScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "allDependenciesSources", "getAllDependenciesSources", "allDependenciesSourcesScope", "getAllDependenciesSourcesScope", "getCustomDefinitionsUsed", "()Z", "firstScriptSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getFirstScriptSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getSdks", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdks;", "builder", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "computeHeavy", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$HeavyScriptInfo;", "lightScriptInfo", "contains", "file", "diff", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$Updates;", "old", "getChangedScripts", "getHeavyScriptInfo", "getLightScriptInfo", "getScriptConfiguration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "getScriptDependenciesClassFiles", "", "getScriptDependenciesClassFilesScope", "getScriptDependenciesSdkFiles", "rootType", "Lcom/intellij/openapi/roots/OrderRootType;", "getScriptDependenciesSourceFiles", "getScriptSdk", "hasNewRoots", "scriptsPaths", "withUpdatedSdks", "newSdks", "Companion", "DirectScriptInfo", "FullUpdate", "HeavyScriptInfo", "IncrementalUpdates", "LightScriptInfo", "NotChanged", "Updates", "kotlin.base.scripting"})
public final class ScriptClassRootsCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, LightScriptInfo> scripts;
    @NotNull
    private final Set<String> classes;
    @NotNull
    private final Set<String> sources;
    private final boolean customDefinitionsUsed;
    @NotNull
    private final ScriptSdks sdks;
    @Nullable
    private final Map<String, VirtualFile> classpathVfsHint;
    @NotNull
    private final Set<VirtualFile> allDependenciesClassFiles;
    @NotNull
    private final Set<VirtualFile> allDependenciesSources;
    @NotNull
    private final GlobalSearchScope allDependenciesClassFilesScope;
    @NotNull
    private final GlobalSearchScope allDependenciesSourcesScope;
    @NotNull
    private static final ScriptClassRootsCache EMPTY = new ScriptClassRootsCache(MapsKt.emptyMap(), SetsKt.emptySet(), SetsKt.emptySet(), true, new ScriptSdks(MapsKt.emptyMap(), SetsKt.emptySet(), SetsKt.emptySet()), null);

    public ScriptClassRootsCache(@NotNull Map<String, ? extends LightScriptInfo> scripts, @NotNull Set<String> classes2, @NotNull Set<String> sources, boolean customDefinitionsUsed, @NotNull ScriptSdks sdks, @Nullable Map<String, VirtualFile> classpathVfsHint) {
        VirtualFile it$iv;
        Set result2;
        boolean bl;
        String it;
        boolean bl2;
        Object element$iv;
        Object element$iv$iv;
        Set set2;
        this.scripts = scripts;
        this.classes = classes2;
        this.sources = sources;
        this.customDefinitionsUsed = customDefinitionsUsed;
        this.sdks = sdks;
        this.classpathVfsHint = classpathVfsHint;
        Set set3 = set2 = (Set)new LinkedHashSet();
        ScriptClassRootsCache scriptClassRootsCache = this;
        boolean bl3 = false;
        Iterable $this$mapNotNullTo$iv = this.classes;
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = element$iv$iv = iterator.next();
            bl2 = false;
            it = (String)element$iv;
            boolean bl4 = false;
            if (ScriptClassRootsCache._init_$toVFile(it, this) == null) continue;
            bl = false;
            ((Collection)result2).add(it$iv);
        }
        scriptClassRootsCache.allDependenciesClassFiles = set2;
        result2 = set2 = (Set)new LinkedHashSet();
        scriptClassRootsCache = this;
        boolean bl5 = false;
        $this$mapNotNullTo$iv = this.sources;
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = element$iv$iv = iterator.next();
            bl2 = false;
            it = (String)element$iv;
            boolean bl6 = false;
            if (ScriptClassRootsCache._init_$toVFile(it, this) == null) continue;
            bl = false;
            ((Collection)result2).add(it$iv);
        }
        scriptClassRootsCache.allDependenciesSources = set2;
        this.allDependenciesClassFilesScope = NonClasspathDirectoriesScope.compose((List)CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)this.allDependenciesClassFiles), (Iterable)this.sdks.getNonIndexedClassRoots()));
        this.allDependenciesSourcesScope = NonClasspathDirectoriesScope.compose((List)CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)this.allDependenciesSources), (Iterable)this.sdks.getNonIndexedSourceRoots()));
    }

    public final boolean getCustomDefinitionsUsed() {
        return this.customDefinitionsUsed;
    }

    @NotNull
    public final ScriptSdks getSdks() {
        return this.sdks;
    }

    @NotNull
    public final ScriptClassRootsCache withUpdatedSdks(@NotNull ScriptSdks newSdks) {
        return new ScriptClassRootsCache(this.scripts, this.classes, this.sources, this.customDefinitionsUsed, newSdks, this.classpathVfsHint);
    }

    @NotNull
    public final ScriptClassRootsBuilder builder(@NotNull Project project) {
        ScriptClassRootsBuilder scriptClassRootsBuilder;
        ScriptClassRootsBuilder builder2 = scriptClassRootsBuilder = new ScriptClassRootsBuilder(project, CollectionsKt.toMutableSet((Iterable)this.classes), CollectionsKt.toMutableSet((Iterable)this.sources), MapsKt.toMutableMap(this.scripts));
        boolean bl = false;
        if (this.customDefinitionsUsed) {
            builder2.useCustomScriptDefinition();
        }
        builder2.getSdks().addAll(this.sdks);
        Map map2 = this.classpathVfsHint;
        if (map2 == null) {
            map2 = new LinkedHashMap();
        }
        builder2.withClasspathVfsHint(map2);
        return scriptClassRootsBuilder;
    }

    @NotNull
    public final Set<String> scriptsPaths() {
        return this.scripts.keySet();
    }

    @Nullable
    public final LightScriptInfo getLightScriptInfo(@NotNull String file2) {
        return this.scripts.get(file2);
    }

    public final boolean contains(@NotNull VirtualFile file2) {
        return this.scripts.containsKey(file2.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HeavyScriptInfo getHeavyScriptInfo(String file2) {
        HeavyScriptInfo heavy0;
        LightScriptInfo lightScriptInfo = this.getLightScriptInfo(file2);
        if (lightScriptInfo == null) {
            return null;
        }
        LightScriptInfo lightScriptInfo2 = lightScriptInfo;
        Reference<HeavyScriptInfo> reference2 = lightScriptInfo2.getHeavyCache();
        HeavyScriptInfo heavyScriptInfo = heavy0 = reference2 != null ? reference2.get() : null;
        if (heavy0 != null) {
            return heavy0;
        }
        LightScriptInfo lightScriptInfo3 = lightScriptInfo2;
        synchronized (lightScriptInfo3) {
            block6: {
                HeavyScriptInfo heavy1;
                boolean bl = false;
                Reference<HeavyScriptInfo> reference3 = lightScriptInfo2.getHeavyCache();
                HeavyScriptInfo heavyScriptInfo2 = heavy1 = reference3 != null ? reference3.get() : null;
                if (heavyScriptInfo2 == null) break block6;
                HeavyScriptInfo heavyScriptInfo3 = heavyScriptInfo2;
                return heavyScriptInfo3;
            }
            HeavyScriptInfo heavy2 = this.computeHeavy(lightScriptInfo2);
            lightScriptInfo2.setHeavyCache((Reference<HeavyScriptInfo>)new SoftReference<HeavyScriptInfo>(heavy2));
            HeavyScriptInfo heavyScriptInfo4 = heavy2;
            return heavyScriptInfo4;
        }
    }

    private final HeavyScriptInfo computeHeavy(LightScriptInfo lightScriptInfo) {
        HeavyScriptInfo heavyScriptInfo;
        ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = lightScriptInfo.buildConfiguration();
        if (scriptCompilationConfigurationWrapper == null) {
            return null;
        }
        ScriptCompilationConfigurationWrapper configuration2 = scriptCompilationConfigurationWrapper;
        List<File> roots2 = configuration2.getDependenciesClassPath();
        List<VirtualFile> vfsRoots = ScriptConfigurationManager.Companion.toVfsRoots((Iterable<? extends File>)roots2);
        File file2 = configuration2.getJavaHome();
        Sdk sdk2 = this.sdks.get(SdkId.Companion.invoke(file2 != null ? file2.toPath() : null));
        if (sdk2 == null || KotlinScriptImplementationSwitcherKt.getScriptsAsEntities()) {
            heavyScriptInfo = ScriptClassRootsCache.computeHeavy$heavyInfoForRoots(configuration2, sdk2, vfsRoots);
        } else {
            List sdkClasses = ArraysKt.toList((Object[])sdk2.getRootProvider().getFiles(OrderRootType.CLASSES));
            heavyScriptInfo = ScriptClassRootsCache.computeHeavy$heavyInfoForRoots(configuration2, sdk2, CollectionsKt.plus((Collection)sdkClasses, (Iterable)vfsRoots));
        }
        return heavyScriptInfo;
    }

    @Nullable
    public final Sdk getFirstScriptSdk() {
        return this.sdks.getFirst();
    }

    @NotNull
    public final Set<VirtualFile> getAllDependenciesClassFiles() {
        return this.allDependenciesClassFiles;
    }

    @NotNull
    public final Set<VirtualFile> getAllDependenciesSources() {
        return this.allDependenciesSources;
    }

    @NotNull
    public final GlobalSearchScope getAllDependenciesClassFilesScope() {
        return this.allDependenciesClassFilesScope;
    }

    @NotNull
    public final GlobalSearchScope getAllDependenciesSourcesScope() {
        return this.allDependenciesSourcesScope;
    }

    @Nullable
    public final ScriptCompilationConfigurationWrapper getScriptConfiguration(@NotNull VirtualFile file2) {
        HeavyScriptInfo heavyScriptInfo = this.getHeavyScriptInfo(file2.getPath());
        return heavyScriptInfo != null ? heavyScriptInfo.getScriptConfiguration() : null;
    }

    @Nullable
    public final Sdk getScriptSdk(@NotNull VirtualFile file2) {
        HeavyScriptInfo heavyScriptInfo = this.getHeavyScriptInfo(file2.getPath());
        return heavyScriptInfo != null ? heavyScriptInfo.getSdk() : null;
    }

    @NotNull
    public final GlobalSearchScope getScriptDependenciesClassFilesScope(@NotNull VirtualFile file2) {
        HeavyScriptInfo heavyScriptInfo = this.getHeavyScriptInfo(file2.getPath());
        if (heavyScriptInfo == null || (heavyScriptInfo = heavyScriptInfo.getClassFilesScope()) == null) {
            heavyScriptInfo = GlobalSearchScope.EMPTY_SCOPE;
        }
        return heavyScriptInfo;
    }

    @NotNull
    public final List<VirtualFile> getScriptDependenciesClassFiles(@NotNull VirtualFile file2) {
        Object object = this.getHeavyScriptInfo(file2.getPath());
        if (object == null || (object = ((HeavyScriptInfo)object).getClassFiles()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualFile> getScriptDependenciesSourceFiles(@NotNull VirtualFile file2) {
        void $this$mapNotNullTo$iv$iv;
        LightScriptInfo lightScriptInfo = this.getLightScriptInfo(file2.getPath());
        if (lightScriptInfo == null) {
            return CollectionsKt.emptyList();
        }
        LightScriptInfo scriptInfo = lightScriptInfo;
        ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = scriptInfo.buildConfiguration();
        if (scriptCompilationConfigurationWrapper == null) {
            return CollectionsKt.emptyList();
        }
        ScriptCompilationConfigurationWrapper configuration2 = scriptCompilationConfigurationWrapper;
        Iterable $this$mapNotNull$iv = configuration2.getDependenciesSources();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (ClasspathToVfsConverter.INSTANCE.classpathEntryToVfs(it.toPath()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<VirtualFile> getScriptDependenciesSdkFiles(@NotNull VirtualFile file2, @NotNull OrderRootType rootType) {
        HeavyScriptInfo heavyScriptInfo = this.getHeavyScriptInfo(file2.getPath());
        if (heavyScriptInfo == null) {
            return CollectionsKt.emptyList();
        }
        HeavyScriptInfo scriptInfo = heavyScriptInfo;
        Sdk sdk2 = scriptInfo.getSdk();
        if (sdk2 == null) {
            return CollectionsKt.emptyList();
        }
        Sdk sdk3 = sdk2;
        return ArraysKt.toList((Object[])sdk3.getRootProvider().getFiles(rootType));
    }

    @NotNull
    public final Updates diff(@NotNull Project project, @Nullable ScriptClassRootsCache old) {
        Updates updates;
        ScriptClassRootsCache scriptClassRootsCache = old;
        if (scriptClassRootsCache == null) {
            updates = new FullUpdate(project, this);
        } else if (Intrinsics.areEqual((Object)scriptClassRootsCache, (Object)this)) {
            updates = new NotChanged(this);
        } else {
            boolean bl = this.hasNewRoots(old);
            boolean bl2 = old.hasNewRoots(this);
            Set<String> set2 = this.getChangedScripts(old);
            Set set3 = SetsKt.plus(old.allDependenciesClassFiles, (Iterable)old.allDependenciesSources);
            Set set4 = SetsKt.plus(this.allDependenciesClassFiles, (Iterable)this.allDependenciesSources);
            Set set5 = SetsKt.plus(old.sdks.getNonIndexedClassRoots(), (Iterable)old.sdks.getNonIndexedSourceRoots());
            Set set6 = SetsKt.plus(this.sdks.getNonIndexedClassRoots(), (Iterable)this.sdks.getNonIndexedSourceRoots());
            updates = new IncrementalUpdates(this, bl, set3, set4, set5, set6, bl2, set2);
        }
        return updates;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasNewRoots(ScriptClassRootsCache old) {
        boolean bl;
        VirtualFile it;
        boolean bl2;
        Set oldClassRoots = CollectionsKt.toSet((Iterable)old.allDependenciesClassFiles);
        Set oldSourceRoots = CollectionsKt.toSet((Iterable)old.allDependenciesSources);
        Iterable $this$any$iv = this.allDependenciesClassFiles;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (VirtualFile)element$iv;
                boolean bl3 = false;
                if (!oldClassRoots.contains(it)) {
                    return true;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        $this$any$iv = this.allDependenciesSources;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (VirtualFile)element$iv;
                boolean bl5 = false;
                if (!oldSourceRoots.contains(it)) {
                    return true;
                }
                boolean bl6 = false;
                if (!bl6) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        if (Intrinsics.areEqual((Object)old.sdks, (Object)this.sdks)) return false;
        return true;
    }

    private final Set<String> getChangedScripts(ScriptClassRootsCache old) {
        Map.Entry<String, LightScriptInfo> it;
        Map.Entry<String, LightScriptInfo> element$iv;
        Set changed2 = new LinkedHashSet();
        Map<String, LightScriptInfo> $this$forEach$iv = this.scripts;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, LightScriptInfo>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            if (Intrinsics.areEqual((Object)old.scripts.get(it.getKey()), (Object)it.getValue())) continue;
            changed2.add(it.getKey());
        }
        $this$forEach$iv = old.scripts;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            if (this.scripts.containsKey(it.getKey())) continue;
            changed2.add(it.getKey());
        }
        return changed2;
    }

    private static final HeavyScriptInfo computeHeavy$heavyInfoForRoots(ScriptCompilationConfigurationWrapper configuration2, Sdk sdk2, List<? extends VirtualFile> roots2) {
        return new HeavyScriptInfo(configuration2, roots2, NonClasspathDirectoriesScope.compose(roots2), sdk2);
    }

    private static final VirtualFile _init_$toVFile(String $this$_init__u24toVFile, ScriptClassRootsCache this$0) {
        VirtualFile virtualFile;
        Map<String, VirtualFile> map2 = this$0.classpathVfsHint;
        boolean bl = map2 != null ? map2.containsKey($this$_init__u24toVFile) : false;
        if (bl) {
            virtualFile = this$0.classpathVfsHint.get($this$_init__u24toVFile);
        } else {
            VirtualFile virtualFile2;
            Path path2 = Paths.get($this$_init__u24toVFile, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
            VirtualFile vFile = virtualFile2 = ClasspathToVfsConverter.INSTANCE.classpathEntryToVfs(path2);
            boolean bl2 = false;
            Map<String, VirtualFile> map3 = this$0.classpathVfsHint;
            if (map3 != null) {
                map3.put($this$_init__u24toVFile, vFile);
            }
            virtualFile = virtualFile2;
        }
        return virtualFile;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "getEMPTY", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "kotlin.base.scripting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScriptClassRootsCache getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH&R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$LightScriptInfo;", "", "definition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "(Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;)V", "getDefinition", "()Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "heavyCache", "Ljava/lang/ref/Reference;", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$HeavyScriptInfo;", "getHeavyCache", "()Ljava/lang/ref/Reference;", "setHeavyCache", "(Ljava/lang/ref/Reference;)V", "buildConfiguration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "kotlin.base.scripting"})
    public static abstract class LightScriptInfo {
        @Nullable
        private final ScriptDefinition definition;
        @Nullable
        private volatile Reference<HeavyScriptInfo> heavyCache;

        public LightScriptInfo(@Nullable ScriptDefinition definition2) {
            this.definition = definition2;
        }

        @Nullable
        public final ScriptDefinition getDefinition() {
            return this.definition;
        }

        @Nullable
        public final Reference<HeavyScriptInfo> getHeavyCache() {
            return this.heavyCache;
        }

        public final void setHeavyCache(@Nullable Reference<HeavyScriptInfo> reference2) {
            this.heavyCache = reference2;
        }

        @Nullable
        public abstract ScriptCompilationConfigurationWrapper buildConfiguration();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$DirectScriptInfo;", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$LightScriptInfo;", "result", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "(Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;)V", "getResult", "()Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "buildConfiguration", "kotlin.base.scripting"})
    public static final class DirectScriptInfo
    extends LightScriptInfo {
        @NotNull
        private final ScriptCompilationConfigurationWrapper result;

        public DirectScriptInfo(@NotNull ScriptCompilationConfigurationWrapper result2) {
            super(null);
            this.result = result2;
        }

        @NotNull
        public final ScriptCompilationConfigurationWrapper getResult() {
            return this.result;
        }

        @Override
        @NotNull
        public ScriptCompilationConfigurationWrapper buildConfiguration() {
            return this.result;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$HeavyScriptInfo;", "", "scriptConfiguration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "classFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "classFilesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;Ljava/util/List;Lcom/intellij/psi/search/GlobalSearchScope;Lcom/intellij/openapi/projectRoots/Sdk;)V", "getClassFiles", "()Ljava/util/List;", "getClassFilesScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "getScriptConfiguration", "()Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "kotlin.base.scripting"})
    public static final class HeavyScriptInfo {
        @NotNull
        private final ScriptCompilationConfigurationWrapper scriptConfiguration;
        @NotNull
        private final List<VirtualFile> classFiles;
        @NotNull
        private final GlobalSearchScope classFilesScope;
        @Nullable
        private final Sdk sdk;

        public HeavyScriptInfo(@NotNull ScriptCompilationConfigurationWrapper scriptConfiguration, @NotNull List<? extends VirtualFile> classFiles, @NotNull GlobalSearchScope classFilesScope, @Nullable Sdk sdk2) {
            this.scriptConfiguration = scriptConfiguration;
            this.classFiles = classFiles;
            this.classFilesScope = classFilesScope;
            this.sdk = sdk2;
        }

        @NotNull
        public final ScriptCompilationConfigurationWrapper getScriptConfiguration() {
            return this.scriptConfiguration;
        }

        @NotNull
        public final List<VirtualFile> getClassFiles() {
            return this.classFiles;
        }

        @NotNull
        public final GlobalSearchScope getClassFilesScope() {
            return this.classFilesScope;
        }

        @Nullable
        public final Sdk getSdk() {
            return this.sdk;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001c\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$Updates;", "", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "getCache", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "changed", "", "getChanged", "()Z", "hasNewRoots", "getHasNewRoots", "hasUpdatedScripts", "getHasUpdatedScripts", "newRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getNewRoots", "()Ljava/util/Collection;", "newSdkRoots", "getNewSdkRoots", "oldRoots", "getOldRoots", "oldSdkRoots", "getOldSdkRoots", "isScriptChanged", "scriptPath", "", "kotlin.base.scripting"})
    public static interface Updates {
        @NotNull
        public ScriptClassRootsCache getCache();

        public boolean getChanged();

        public boolean getHasNewRoots();

        @NotNull
        public Collection<VirtualFile> getOldRoots();

        @NotNull
        public Collection<VirtualFile> getNewRoots();

        @NotNull
        public Collection<VirtualFile> getOldSdkRoots();

        @NotNull
        public Collection<VirtualFile> getNewSdkRoots();

        public boolean getHasUpdatedScripts();

        public boolean isScriptChanged(@NotNull String var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0011\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$IncrementalUpdates;", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$Updates;", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "hasNewRoots", "", "oldRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "newRoots", "oldSdkRoots", "newSdkRoots", "hasOldRoots", "updatedScripts", "", "", "(Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;ZLjava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;ZLjava/util/Set;)V", "getCache", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "changed", "getChanged", "()Z", "getHasNewRoots", "hasUpdatedScripts", "getHasUpdatedScripts", "getNewRoots", "()Ljava/util/Collection;", "getNewSdkRoots", "getOldRoots", "getOldSdkRoots", "isScriptChanged", "scriptPath", "kotlin.base.scripting"})
    public static final class IncrementalUpdates
    implements Updates {
        @NotNull
        private final ScriptClassRootsCache cache;
        private final boolean hasNewRoots;
        @NotNull
        private final Collection<VirtualFile> oldRoots;
        @NotNull
        private final Collection<VirtualFile> newRoots;
        @NotNull
        private final Collection<VirtualFile> oldSdkRoots;
        @NotNull
        private final Collection<VirtualFile> newSdkRoots;
        private final boolean hasOldRoots;
        @NotNull
        private final Set<String> updatedScripts;

        public IncrementalUpdates(@NotNull ScriptClassRootsCache cache2, boolean hasNewRoots, @NotNull Collection<? extends VirtualFile> oldRoots, @NotNull Collection<? extends VirtualFile> newRoots, @NotNull Collection<? extends VirtualFile> oldSdkRoots, @NotNull Collection<? extends VirtualFile> newSdkRoots, boolean hasOldRoots, @NotNull Set<String> updatedScripts) {
            this.cache = cache2;
            this.hasNewRoots = hasNewRoots;
            this.oldRoots = oldRoots;
            this.newRoots = newRoots;
            this.oldSdkRoots = oldSdkRoots;
            this.newSdkRoots = newSdkRoots;
            this.hasOldRoots = hasOldRoots;
            this.updatedScripts = updatedScripts;
        }

        @Override
        @NotNull
        public ScriptClassRootsCache getCache() {
            return this.cache;
        }

        @Override
        public boolean getHasNewRoots() {
            return this.hasNewRoots;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getOldRoots() {
            return this.oldRoots;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getNewRoots() {
            return this.newRoots;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getOldSdkRoots() {
            return this.oldSdkRoots;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getNewSdkRoots() {
            return this.newSdkRoots;
        }

        @Override
        public boolean getHasUpdatedScripts() {
            return !((Collection)this.updatedScripts).isEmpty();
        }

        @Override
        public boolean isScriptChanged(@NotNull String scriptPath) {
            return this.updatedScripts.contains(scriptPath);
        }

        @Override
        public boolean getChanged() {
            return this.getHasNewRoots() || !((Collection)this.updatedScripts).isEmpty() || this.hasOldRoots;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$FullUpdate;", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$Updates;", "project", "Lcom/intellij/openapi/project/Project;", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;)V", "getCache", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "changed", "", "getChanged", "()Z", "hasNewRoots", "getHasNewRoots", "hasUpdatedScripts", "getHasUpdatedScripts", "newRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getNewRoots", "()Ljava/util/Collection;", "newSdkRoots", "getNewSdkRoots", "oldRoots", "getOldRoots", "oldSdkRoots", "getOldSdkRoots", "isScriptChanged", "scriptPath", "", "kotlin.base.scripting"})
    public static final class FullUpdate
    implements Updates {
        @NotNull
        private final Project project;
        @NotNull
        private final ScriptClassRootsCache cache;
        @NotNull
        private final Collection<VirtualFile> oldRoots;
        @NotNull
        private final Collection<VirtualFile> oldSdkRoots;

        public FullUpdate(@NotNull Project project, @NotNull ScriptClassRootsCache cache2) {
            this.project = project;
            this.cache = cache2;
            this.oldRoots = CollectionsKt.emptyList();
            this.oldSdkRoots = CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public ScriptClassRootsCache getCache() {
            return this.cache;
        }

        @Override
        public boolean getChanged() {
            return true;
        }

        @Override
        public boolean getHasUpdatedScripts() {
            return true;
        }

        @Override
        public boolean isScriptChanged(@NotNull String scriptPath) {
            return true;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getOldRoots() {
            return this.oldRoots;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getOldSdkRoots() {
            return this.oldSdkRoots;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getNewRoots() {
            return SetsKt.plus(this.getCache().getAllDependenciesClassFiles(), (Iterable)this.getCache().getAllDependenciesSources());
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getNewSdkRoots() {
            return SetsKt.plus(this.getCache().getSdks().getNonIndexedClassRoots(), (Iterable)this.getCache().getSdks().getNonIndexedSourceRoots());
        }

        @Override
        public boolean getHasNewRoots() {
            return !((Collection)this.getCache().getAllDependenciesClassFiles()).isEmpty() || !((Collection)this.getCache().getAllDependenciesSources()).isEmpty() || !((Collection)this.getCache().getSdks().getNonIndexedClassRoots()).isEmpty() || !((Collection)this.getCache().getSdks().getNonIndexedSourceRoots()).isEmpty();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$NotChanged;", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$Updates;", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "(Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;)V", "getCache", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "changed", "", "getChanged", "()Z", "hasNewRoots", "getHasNewRoots", "hasUpdatedScripts", "getHasUpdatedScripts", "newRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getNewRoots", "()Ljava/util/Collection;", "newSdkRoots", "getNewSdkRoots", "oldRoots", "getOldRoots", "oldSdkRoots", "getOldSdkRoots", "isScriptChanged", "scriptPath", "", "kotlin.base.scripting"})
    public static final class NotChanged
    implements Updates {
        @NotNull
        private final ScriptClassRootsCache cache;
        @NotNull
        private final Collection<VirtualFile> oldRoots;
        @NotNull
        private final Collection<VirtualFile> newRoots;
        @NotNull
        private final Collection<VirtualFile> oldSdkRoots;
        @NotNull
        private final Collection<VirtualFile> newSdkRoots;

        public NotChanged(@NotNull ScriptClassRootsCache cache2) {
            this.cache = cache2;
            this.oldRoots = CollectionsKt.emptyList();
            this.newRoots = CollectionsKt.emptyList();
            this.oldSdkRoots = CollectionsKt.emptyList();
            this.newSdkRoots = CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public ScriptClassRootsCache getCache() {
            return this.cache;
        }

        @Override
        public boolean getChanged() {
            return false;
        }

        @Override
        public boolean getHasNewRoots() {
            return false;
        }

        @Override
        public boolean getHasUpdatedScripts() {
            return false;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getOldRoots() {
            return this.oldRoots;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getNewRoots() {
            return this.newRoots;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getOldSdkRoots() {
            return this.oldSdkRoots;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getNewSdkRoots() {
            return this.newSdkRoots;
        }

        @Override
        public boolean isScriptChanged(@NotNull String scriptPath) {
            return false;
        }
    }
}

