/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.ucache;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.ScriptClassRootsStorage;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsCache;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptSdksBuilder;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 22\u00020\u0001:\u00012B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003BC\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0000H\u0007J2\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\"2\u0006\u0010$\u001a\u00020\fJ\u0014\u0010%\u001a\u00020\u001a2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\"J\u0014\u0010'\u001a\u00020\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\"J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u001aJ\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020\u001aJ\u001e\u00100\u001a\u00020\u001a2\u0016\u00101\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000bR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsBuilder;", "", "builder", "(Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsBuilder;)V", "project", "Lcom/intellij/openapi/project/Project;", "classes", "", "", "sources", "scripts", "", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$LightScriptInfo;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;)V", "classpathVfsHint", "Lcom/intellij/openapi/vfs/VirtualFile;", "customDefinitionsUsed", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "sdks", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdksBuilder;", "getSdks", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdksBuilder;", "shouldWarnAboutDependenciesExistence", "add", "", "vFile", "configuration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "other", "addCustom", "path", "scriptClassesRoots", "", "sourceSourcesRoots", "info", "addSources", "sourcesRoots", "addTemplateClassesRoots", "classesRoots", "build", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "dontWarnAboutDependenciesExistence", "toStorage", "storage", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsStorage;", "useCustomScriptDefinition", "withClasspathVfsHint", "hint", "Companion", "kotlin.base.scripting"})
public final class ScriptClassRootsBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<String> classes;
    @NotNull
    private final Set<String> sources;
    @NotNull
    private final Map<String, ScriptClassRootsCache.LightScriptInfo> scripts;
    @NotNull
    private final ScriptSdksBuilder sdks;
    private boolean customDefinitionsUsed;
    private boolean shouldWarnAboutDependenciesExistence;
    @Nullable
    private Map<String, VirtualFile> classpathVfsHint;

    public ScriptClassRootsBuilder(@NotNull Project project, @NotNull Set<String> classes2, @NotNull Set<String> sources, @NotNull Map<String, ScriptClassRootsCache.LightScriptInfo> scripts) {
        this.project = project;
        this.classes = classes2;
        this.sources = sources;
        this.scripts = scripts;
        this.sdks = new ScriptSdksBuilder(this.project, null, null, 6, null);
        this.shouldWarnAboutDependenciesExistence = true;
    }

    public /* synthetic */ ScriptClassRootsBuilder(Project project, Set set2, Set set3, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set2 = new LinkedHashSet();
        }
        if ((n & 4) != 0) {
            set3 = new LinkedHashSet();
        }
        if ((n & 8) != 0) {
            map2 = new LinkedHashMap();
        }
        this(project, set2, set3, map2);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ScriptSdksBuilder getSdks() {
        return this.sdks;
    }

    public ScriptClassRootsBuilder(@NotNull ScriptClassRootsBuilder builder2) {
        this(builder2.project, CollectionsKt.toMutableSet((Iterable)builder2.classes), CollectionsKt.toMutableSet((Iterable)builder2.sources), MapsKt.toMutableMap(builder2.scripts));
        this.sdks.getSdks$kotlin_base_scripting().putAll(builder2.sdks.getSdks$kotlin_base_scripting());
    }

    @NotNull
    public final ScriptClassRootsCache build() {
        return new ScriptClassRootsCache(this.scripts, this.classes, this.sources, this.customDefinitionsUsed, this.sdks.build(), this.classpathVfsHint);
    }

    public final void useCustomScriptDefinition() {
        this.customDefinitionsUsed = true;
    }

    public final void dontWarnAboutDependenciesExistence() {
        this.shouldWarnAboutDependenciesExistence = false;
    }

    public final void withClasspathVfsHint(@Nullable Map<String, VirtualFile> hint) {
        this.classpathVfsHint = hint;
    }

    public final void add(@NotNull VirtualFile vFile, @NotNull ScriptCompilationConfigurationWrapper configuration2) {
        String absolutePath;
        Path path2;
        File file2;
        File file3 = configuration2.getJavaHome();
        this.sdks.addSdk(file3 != null ? file3.toPath() : null);
        Iterable $this$forEach$iv = configuration2.getDependenciesClassPath();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            file2 = (File)element$iv;
            boolean bl = false;
            path2 = file2.toPath();
            absolutePath = ((Object)path2.toAbsolutePath()).toString();
            if (this.shouldWarnAboutDependenciesExistence) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    ScriptUtilsKt.getLogger().warn("configuration dependency classpath " + absolutePath + " does not exist");
                }
            }
            this.classes.add(absolutePath);
        }
        $this$forEach$iv = configuration2.getDependenciesSources();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            file2 = (File)element$iv;
            boolean bl = false;
            path2 = file2.toPath();
            absolutePath = ((Object)path2.toAbsolutePath()).toString();
            if (this.shouldWarnAboutDependenciesExistence) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    ScriptUtilsKt.getLogger().warn("configuration dependency sources " + absolutePath + " does not exist");
                }
            }
            this.sources.add(absolutePath);
        }
        this.scripts.put(vFile.getPath(), new ScriptClassRootsCache.DirectScriptInfo(configuration2));
        this.useCustomScriptDefinition();
    }

    public final void addCustom(@NotNull String path2, @NotNull Collection<String> scriptClassesRoots, @NotNull Collection<String> sourceSourcesRoots, @NotNull ScriptClassRootsCache.LightScriptInfo info2) {
        this.classes.addAll(scriptClassesRoots);
        this.sources.addAll(sourceSourcesRoots);
        this.scripts.put(path2, info2);
    }

    public final void addTemplateClassesRoots(@NotNull Collection<String> classesRoots) {
        this.classes.addAll(classesRoots);
    }

    public final void addSources(@NotNull Collection<String> sourcesRoots) {
        this.sources.addAll(sourcesRoots);
    }

    @Deprecated(message="Don't use, used only from DefaultScriptingSupport for saving to storage")
    public final void add(@NotNull ScriptClassRootsBuilder other) {
        this.classes.addAll((Collection<String>)other.classes);
        this.sources.addAll((Collection<String>)other.sources);
        this.sdks.addAll(other.sdks);
        this.scripts.putAll(other.scripts);
    }

    public final void toStorage(@NotNull ScriptClassRootsStorage storage) {
        storage.setClasspath(this.classes);
        storage.setSources(this.sources);
        this.sdks.toStorage(storage);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsBuilder$Companion;", "", "()V", "fromStorage", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsStorage;", "kotlin.base.scripting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScriptClassRootsBuilder fromStorage(@NotNull Project project, @NotNull ScriptClassRootsStorage storage) {
            ScriptClassRootsBuilder scriptClassRootsBuilder;
            ScriptClassRootsBuilder it = scriptClassRootsBuilder = new ScriptClassRootsBuilder(project, CollectionsKt.toMutableSet((Iterable)storage.getClasspath()), CollectionsKt.toMutableSet((Iterable)storage.getSources()), null, 8, null);
            boolean bl = false;
            it.getSdks().fromStorage(storage);
            return scriptClassRootsBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

