/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.ucache;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.SymbolicEntityId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryRoot;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryRootTypeId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptEntitiesKt;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptEntity;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptId;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0018H\u0000\u001a\u001a\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u001a\u001a\u00020\u0001H\u0000\u001a\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\n*\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001d"}, d2={"scriptsAsEntities", "", "getScriptsAsEntities", "()Z", "computeClassRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getAllScriptDependenciesSources", "", "getAllScriptDependenciesSourcesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getAllScriptsDependenciesClassFiles", "getAllScriptsDependenciesClassFilesScope", "getScriptDependenciesClassFilesScope", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "listAllScriptDependenciesScope", "rootTypeId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryRootTypeId;", "managerScriptsDebugInfo", "", "scriptFiles", "Lkotlin/sequences/Sequence;", "scriptEntitiesDebugInfo", "listRoots", "listDependenciesOfAllScriptEntities", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "kotlin.base.scripting"})
public final class KotlinScriptImplementationSwitcherKt {
    private static final boolean scriptsAsEntities = Registry.is((String)"kotlin.scripts.as.entities", (boolean)false);

    public static final boolean getScriptsAsEntities() {
        return scriptsAsEntities;
    }

    @NotNull
    public static final GlobalSearchScope getScriptDependenciesClassFilesScope(@NotNull Project project, @NotNull KtFile ktFile) {
        EntityStorage entityStorage;
        KotlinScriptEntity scriptEntity;
        VirtualFile vFile;
        if (!ktFile.isScript()) {
            boolean $i$a$-require-KotlinScriptImplementationSwitcherKt$getScriptDependenciesClassFilesScope$22 = false;
            String $i$a$-require-KotlinScriptImplementationSwitcherKt$getScriptDependenciesClassFilesScope$22 = "argument must be a script: " + ktFile.getVirtualFilePath();
            throw new IllegalArgumentException($i$a$-require-KotlinScriptImplementationSwitcherKt$getScriptDependenciesClassFilesScope$22.toString());
        }
        VirtualFile virtualFile = ktFile.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = vFile = ktFile.getViewProvider().getVirtualFile();
        }
        return scriptsAsEntities ? ((scriptEntity = (KotlinScriptEntity)(entityStorage = WorkspaceModel.Companion.getInstance(project).getEntityStorage().getCurrent()).resolve((SymbolicEntityId)new ScriptId(ktFile.getVirtualFilePath()))) == null ? ScriptConfigurationManager.Companion.getInstance(project).getScriptDependenciesClassFilesScope(vFile) : NonClasspathDirectoriesScope.compose(KotlinScriptEntitiesKt.listDependencies(scriptEntity, LibraryRootTypeId.Companion.getCOMPILED()))) : ScriptConfigurationManager.Companion.getInstance(project).getScriptDependenciesClassFilesScope(vFile);
    }

    @NotNull
    public static final GlobalSearchScope getAllScriptsDependenciesClassFilesScope(@NotNull Project project) {
        return scriptsAsEntities ? KotlinScriptImplementationSwitcherKt.listAllScriptDependenciesScope(project, LibraryRootTypeId.Companion.getCOMPILED()) : ScriptConfigurationManager.Companion.getInstance(project).getAllScriptsDependenciesClassFilesScope();
    }

    @NotNull
    public static final GlobalSearchScope getAllScriptDependenciesSourcesScope(@NotNull Project project) {
        return scriptsAsEntities ? KotlinScriptImplementationSwitcherKt.listAllScriptDependenciesScope(project, LibraryRootTypeId.Companion.getSOURCES()) : ScriptConfigurationManager.Companion.getInstance(project).getAllScriptDependenciesSourcesScope();
    }

    @NotNull
    public static final Collection<VirtualFile> getAllScriptsDependenciesClassFiles(@NotNull Project project) {
        Collection<VirtualFile> collection;
        if (scriptsAsEntities) {
            EntityStorage entityStorage = WorkspaceModel.Companion.getInstance(project).getEntityStorage().getCurrent();
            collection = KotlinScriptImplementationSwitcherKt.listDependenciesOfAllScriptEntities(entityStorage, LibraryRootTypeId.Companion.getCOMPILED());
        } else {
            collection = ScriptConfigurationManager.Companion.getInstance(project).getAllScriptsDependenciesClassFiles();
        }
        return collection;
    }

    @NotNull
    public static final Collection<VirtualFile> getAllScriptDependenciesSources(@NotNull Project project) {
        Collection<VirtualFile> collection;
        if (scriptsAsEntities) {
            EntityStorage entityStorage = WorkspaceModel.Companion.getInstance(project).getEntityStorage().getCurrent();
            collection = KotlinScriptImplementationSwitcherKt.listDependenciesOfAllScriptEntities(entityStorage, LibraryRootTypeId.Companion.getSOURCES());
        } else {
            collection = ScriptConfigurationManager.Companion.getInstance(project).getAllScriptDependenciesSources();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VirtualFile> computeClassRoots(@NotNull Project project) {
        List list2;
        if (scriptsAsEntities) {
            EntityStorage entityStorage = WorkspaceModel.Companion.getInstance(project).getEntityStorage().getCurrent();
            list2 = CollectionsKt.toList((Iterable)KotlinScriptImplementationSwitcherKt.listDependenciesOfAllScriptEntities(entityStorage, LibraryRootTypeId.Companion.getCOMPILED()));
        } else {
            void $this$filterTo$iv$iv;
            ScriptConfigurationManager manager = ScriptConfigurationManager.Companion.getInstance(project);
            Iterable $this$filter$iv = CollectionsKt.plus(manager.getAllScriptsDependenciesClassFiles(), (Iterable)manager.getAllScriptsSdkDependenciesClassFiles());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!it.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    private static final GlobalSearchScope listAllScriptDependenciesScope(Project project, LibraryRootTypeId rootTypeId) {
        EntityStorage entityStorage = WorkspaceModel.Companion.getInstance(project).getEntityStorage().getCurrent();
        List files2 = CollectionsKt.toList((Iterable)KotlinScriptImplementationSwitcherKt.listDependenciesOfAllScriptEntities(entityStorage, rootTypeId));
        return NonClasspathDirectoriesScope.compose((List)files2);
    }

    private static final Collection<VirtualFile> listDependenciesOfAllScriptEntities(EntityStorage $this$listDependenciesOfAllScriptEntities, LibraryRootTypeId rootTypeId) {
        return SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)$this$listDependenciesOfAllScriptEntities.entities(KotlinScriptEntity.class), (Function1)((Function1)new Function1<KotlinScriptEntity, List<? extends VirtualFile>>(rootTypeId){
            final /* synthetic */ LibraryRootTypeId $rootTypeId;
            {
                this.$rootTypeId = $rootTypeId;
                super(1);
            }

            @NotNull
            public final List<VirtualFile> invoke(@NotNull KotlinScriptEntity it) {
                return KotlinScriptEntitiesKt.listDependencies(it, this.$rootTypeId);
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String scriptEntitiesDebugInfo(@NotNull Project project, boolean listRoots) {
        StringBuilder stringBuilder;
        StringBuilder $this$scriptEntitiesDebugInfo_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        EntityStorage entityStorage = WorkspaceModel.Companion.getInstance(project).getEntityStorage().getCurrent();
        HashSet allClasses = new HashSet();
        HashSet allSources = new HashSet();
        Sequence $this$forEachIndexed$iv = entityStorage.entities(KotlinScriptEntity.class);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void scriptEntity;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KotlinScriptEntity kotlinScriptEntity = (KotlinScriptEntity)item$iv;
            int scriptIndex = n;
            boolean bl2 = false;
            $this$scriptEntitiesDebugInfo_u24lambda_u246.append("#" + (scriptIndex + 1) + ": [" + scriptEntity.getPath() + "]\n");
            Iterable $this$forEachIndexed$iv2 = scriptEntity.getDependencies();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void lib;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                LibraryEntity libraryEntity = (LibraryEntity)item$iv2;
                int libIndex = n2;
                boolean bl3 = false;
                Iterable $this$partition$iv = lib.getRoots();
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    LibraryRoot it = (LibraryRoot)element$iv;
                    boolean bl4 = false;
                    if (Intrinsics.areEqual((Object)it.getType(), (Object)LibraryRootTypeId.Companion.getCOMPILED())) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                Pair pair = new Pair(first$iv, second$iv);
                List classes2 = (List)pair.component1();
                List sources = (List)pair.component2();
                allClasses.addAll(classes2);
                allSources.addAll(sources);
                $this$scriptEntitiesDebugInfo_u24lambda_u246.append("      Lib #" + (libIndex + 1) + ": \"" + lib.getName() + "\", classes: " + classes2.size() + ", sources: " + sources.size() + " \n");
                StringBuilder $this$applyIf$iv = $this$scriptEntitiesDebugInfo_u24lambda_u246;
                boolean $i$f$applyIf = false;
                if (!listRoots) continue;
                StringBuilder $this$scriptEntitiesDebugInfo_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243 = $this$applyIf$iv;
                boolean bl5 = false;
                $this$scriptEntitiesDebugInfo_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243.append("        Classes:\n " + KotlinScriptImplementationSwitcherKt.scriptEntitiesDebugInfo$print$default(classes2, null, 1, null) + "\n");
                $this$scriptEntitiesDebugInfo_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243.append("        Sources:\n " + KotlinScriptImplementationSwitcherKt.scriptEntitiesDebugInfo$print$default(sources, null, 1, null) + "\n");
            }
        }
        $this$scriptEntitiesDebugInfo_u24lambda_u246.insert(0, "==> WorkspaceModel (unique classes: " + allClasses.size() + ", sources: " + allSources.size() + ")\n");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static /* synthetic */ String scriptEntitiesDebugInfo$default(Project project, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KotlinScriptImplementationSwitcherKt.scriptEntitiesDebugInfo(project, bl);
    }

    @NotNull
    public static final String managerScriptsDebugInfo(@NotNull Project project, @Nullable Sequence<? extends VirtualFile> scriptFiles2) {
        StringBuilder stringBuilder;
        StringBuilder $this$managerScriptsDebugInfo_u24lambda_u248 = stringBuilder = new StringBuilder();
        boolean bl = false;
        ScriptConfigurationManager configurationManager = ScriptConfigurationManager.Companion.getInstance(project);
        int allSourcesSize = configurationManager.getAllScriptDependenciesSources().size();
        int allSdkSourcesSize = configurationManager.getAllScriptSdkDependenciesSources().size();
        int allClassesSize = configurationManager.getAllScriptsDependenciesClassFiles().size();
        int allSdkClassesSize = configurationManager.getAllScriptsSdkDependenciesClassFiles().size();
        Sequence<? extends VirtualFile> sequence2 = scriptFiles2;
        if (sequence2 != null) {
            Sequence<? extends VirtualFile> $this$forEach$iv = sequence2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                int classDepSize = configurationManager.getScriptDependenciesClassFiles(it).size();
                int sourceDepSize = configurationManager.getScriptDependenciesSourceFiles(it).size();
                $this$managerScriptsDebugInfo_u24lambda_u248.append("[" + it.getPath() + "]: classes: " + classDepSize + ", sources: " + sourceDepSize + "\n");
            }
        }
        $this$managerScriptsDebugInfo_u24lambda_u248.insert(0, "==> ScriptConfigurationManager (classes: " + allClassesSize + ", sdkClasses: " + allSdkClassesSize + ", sources: " + allSourcesSize + ", sdkSources: " + allSdkSourcesSize + ")\n");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static /* synthetic */ String managerScriptsDebugInfo$default(Project project, Sequence sequence2, int n, Object object) {
        if ((n & 2) != 0) {
            sequence2 = null;
        }
        return KotlinScriptImplementationSwitcherKt.managerScriptsDebugInfo(project, (Sequence<? extends VirtualFile>)sequence2);
    }

    private static final String scriptEntitiesDebugInfo$print(List<LibraryRoot> $this$scriptEntitiesDebugInfo_u24print, CharSequence indent) {
        return SequencesKt.joinToString$default((Sequence)SequencesKt.mapIndexed((Sequence)CollectionsKt.asSequence((Iterable)$this$scriptEntitiesDebugInfo_u24print), (Function2)((Function2)new Function2<Integer, LibraryRoot, String>(indent){
            final /* synthetic */ CharSequence $indent;
            {
                this.$indent = $indent;
                super(2);
            }

            @NotNull
            public final String invoke(int i2, @NotNull LibraryRoot root) {
                return this.$indent + (i2 + 1) + ": " + root.getUrl().getPresentableUrl();
            }
        })), (CharSequence)"\n", (CharSequence)indent, null, (int)0, null, null, (int)60, null);
    }

    static /* synthetic */ String scriptEntitiesDebugInfo$print$default(List list2, CharSequence charSequence2, int n, Object object) {
        if ((n & 1) != 0) {
            charSequence2 = "          ";
        }
        return KotlinScriptImplementationSwitcherKt.scriptEntitiesDebugInfo$print(list2, charSequence2);
    }
}

