/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.ucache;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.workspaceModel.ide.BuilderSnapshot;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.UtilsKt;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import com.intellij.workspaceModel.storage.SymbolicEntityId;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryRoot;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryRootTypeId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.dependencies.ScriptAdditionalIdeaDependenciesProvider;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptEntitiesKt;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptEntity;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptEntityKt;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptEntitySource;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptId;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002\u001a\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a:\u0010\r\u001a\u00020\u000b*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\n*\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001a\u0012\u0010\u0019\u001a\u00020\u000f*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u001e\u001a\u00020\u0001*\u00020\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 H\u0000\u001a\"\u0010\u001e\u001a\u00020\u0001*\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\""}, d2={"addIdeSpecificDependencies", "", "project", "Lcom/intellij/openapi/project/Project;", "scriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "classDependencies", "", "sourceDependencies", "addOrUpdateScriptDependencies", "", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryEntity;", "Lcom/intellij/workspaceModel/storage/MutableEntityStorage;", "createLibrary", "name", "", "classFiles", "", "sources", "entitySource", "Lorg/jetbrains/kotlin/idea/core/script/ucache/KotlinScriptEntitySource;", "listDependencies", "Lorg/jetbrains/kotlin/idea/core/script/ucache/KotlinScriptEntity;", "rootTypeId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryRootTypeId;", "relativeName", "replaceModelWithSelf", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/intellij/workspaceModel/ide/BuilderSnapshot;", "syncScriptEntities", "actualScriptFiles", "Lkotlin/sequences/Sequence;", "filesToAddOrUpdate", "kotlin.base.scripting"})
public final class KotlinScriptEntitiesKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VirtualFile> listDependencies(@NotNull KotlinScriptEntity $this$listDependencies, @Nullable LibraryRootTypeId rootTypeId) {
        Sequence sequence2;
        Sequence sequence3 = SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)$this$listDependencies.getDependencies()), (Function1)listDependencies.1.INSTANCE);
        boolean condition$iv = rootTypeId != null;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$applyIf$iv;
            void $this$listDependencies_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            sequence2 = SequencesKt.filter((Sequence)$this$listDependencies_u24lambda_u240, (Function1)((Function1)new Function1<LibraryRoot, Boolean>(rootTypeId){
                final /* synthetic */ LibraryRootTypeId $rootTypeId;
                {
                    this.$rootTypeId = $rootTypeId;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull LibraryRoot it) {
                    return Intrinsics.areEqual((Object)it.getType(), (Object)this.$rootTypeId);
                }
            }));
        } else {
            sequence2 = sequence3;
        }
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)sequence2, (Function1)listDependencies.3.INSTANCE), (Function1)listDependencies.4.INSTANCE));
    }

    public static /* synthetic */ List listDependencies$default(KotlinScriptEntity kotlinScriptEntity, LibraryRootTypeId libraryRootTypeId, int n, Object object) {
        if ((n & 1) != 0) {
            libraryRootTypeId = null;
        }
        return KotlinScriptEntitiesKt.listDependencies(kotlinScriptEntity, libraryRootTypeId);
    }

    public static final void syncScriptEntities(@NotNull Project $this$syncScriptEntities, @NotNull Sequence<? extends VirtualFile> actualScriptFiles) {
        BuilderSnapshot snapshot;
        CompletableFuture<Boolean> replaced2 = null;
        do {
            snapshot = WorkspaceModel.Companion.getInstance($this$syncScriptEntities).getBuilderSnapshot();
            KotlinScriptEntitiesKt.syncScriptEntities(snapshot, actualScriptFiles, $this$syncScriptEntities);
        } while (!(replaced2 = KotlinScriptEntitiesKt.replaceModelWithSelf(snapshot, $this$syncScriptEntities)).get().booleanValue());
    }

    private static final void syncScriptEntities(BuilderSnapshot $this$syncScriptEntities, Sequence<? extends VirtualFile> filesToAddOrUpdate, Project project) {
        Sequence<? extends VirtualFile> $this$forEach$iv;
        VirtualFileUrlManager fileUrlManager = VirtualFileUrlManagerUtil.getInstance((VirtualFileUrlManager.Companion)VirtualFileUrlManager.Companion, (Project)project);
        Set actualPaths2 = SequencesKt.toSet((Sequence)SequencesKt.map(filesToAddOrUpdate, (Function1)syncScriptEntities.actualPaths.1.INSTANCE));
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$syncScriptEntities.getBuilder().entities(KotlinScriptEntity.class), (Function1)((Function1)new Function1<KotlinScriptEntity, Boolean>((Set<String>)actualPaths2){
            final /* synthetic */ Set<String> $actualPaths;
            {
                this.$actualPaths = $actualPaths;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KotlinScriptEntity it) {
                return !this.$actualPaths.contains(it.getPath());
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinScriptEntity it = (KotlinScriptEntity)element$iv;
            boolean bl = false;
            $this$syncScriptEntities.getBuilder().removeEntity((WorkspaceEntity)it);
        }
        $this$forEach$iv = filesToAddOrUpdate;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Set outdatedDependencies2;
            Set set2;
            List list2;
            VirtualFile scriptFile = (VirtualFile)element$iv;
            boolean bl = false;
            List<LibraryEntity> scriptDependencies = KotlinScriptEntitiesKt.addOrUpdateScriptDependencies($this$syncScriptEntities.getBuilder(), scriptFile, project);
            KotlinScriptEntity scriptEntity = (KotlinScriptEntity)$this$syncScriptEntities.getBuilder().resolve((SymbolicEntityId)new ScriptId(scriptFile.getPath()));
            if (scriptEntity == null) {
                KotlinScriptEntitySource scriptSource = new KotlinScriptEntitySource(UtilsKt.toVirtualFileUrl((VirtualFile)scriptFile, (VirtualFileUrlManager)fileUrlManager));
                $this$syncScriptEntities.getBuilder().addEntity((WorkspaceEntity)KotlinScriptEntity.Companion.invoke(scriptFile.getPath(), scriptSource, (Function1<? super KotlinScriptEntity.Builder, Unit>)((Function1)new Function1<KotlinScriptEntity.Builder, Unit>(scriptDependencies){
                    final /* synthetic */ List<LibraryEntity> $scriptDependencies;
                    {
                        this.$scriptDependencies = $scriptDependencies;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinScriptEntity.Builder $this$invoke) {
                        $this$invoke.setDependencies(this.$scriptDependencies);
                    }
                })));
                continue;
            }
            Map map2 = (Map)$this$syncScriptEntities.getBuilder().entitiesBySource((Function1)new Function1<EntitySource, Boolean>(scriptEntity){
                final /* synthetic */ KotlinScriptEntity $scriptEntity;
                {
                    this.$scriptEntity = $scriptEntity;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull EntitySource it) {
                    return Intrinsics.areEqual((Object)it, (Object)this.$scriptEntity.getEntitySource());
                }
            }).get(scriptEntity.getEntitySource());
            if (map2 != null && (list2 = (List)map2.get(LibraryEntity.class)) != null) {
                List it = list2;
                boolean bl2 = false;
                set2 = SetsKt.minus((Set)CollectionsKt.toSet((Iterable)it), (Iterable)CollectionsKt.toSet((Iterable)scriptDependencies));
            } else {
                set2 = null;
            }
            Set set3 = outdatedDependencies2 = set2;
            if (set3 != null) {
                Iterable $this$forEach$iv2 = set3;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    WorkspaceEntity it = (WorkspaceEntity)element$iv2;
                    boolean bl3 = false;
                    $this$syncScriptEntities.getBuilder().removeEntity(it);
                }
            }
            KotlinScriptEntityKt.modifyEntity($this$syncScriptEntities.getBuilder(), scriptEntity, (Function1<? super KotlinScriptEntity.Builder, Unit>)((Function1)new Function1<KotlinScriptEntity.Builder, Unit>(scriptDependencies){
                final /* synthetic */ List<LibraryEntity> $scriptDependencies;
                {
                    this.$scriptDependencies = $scriptDependencies;
                    super(1);
                }

                public final void invoke(@NotNull KotlinScriptEntity.Builder $this$modifyEntity) {
                    $this$modifyEntity.setDependencies(this.$scriptDependencies);
                }
            }));
        }
    }

    private static final CompletableFuture<Boolean> replaceModelWithSelf(BuilderSnapshot $this$replaceModelWithSelf, Project project) {
        return CompletableFuture.supplyAsync(() -> KotlinScriptEntitiesKt.replaceModelWithSelf$lambda$6(project, $this$replaceModelWithSelf), CompletableFutureUtil.INSTANCE.getEDTExecutor(ModalityState.NON_MODAL));
    }

    private static final List<LibraryEntity> addOrUpdateScriptDependencies(MutableEntityStorage $this$addOrUpdateScriptDependencies, VirtualFile scriptFile, Project project) {
        ScriptConfigurationManager configurationManager = ScriptConfigurationManager.Companion.getInstance(project);
        Set dependenciesClassFiles = CollectionsKt.toMutableSet((Iterable)configurationManager.getScriptDependenciesClassFiles(scriptFile));
        Set dependenciesSourceFiles = CollectionsKt.toMutableSet((Iterable)configurationManager.getScriptDependenciesSourceFiles(scriptFile));
        KotlinScriptEntitiesKt.addIdeSpecificDependencies(project, scriptFile, dependenciesClassFiles, dependenciesSourceFiles);
        VirtualFileUrlManager fileUrlManager = VirtualFileUrlManagerUtil.getInstance((VirtualFileUrlManager.Companion)VirtualFileUrlManager.Companion, (Project)project);
        KotlinScriptEntitySource entitySource = new KotlinScriptEntitySource(UtilsKt.toVirtualFileUrl((VirtualFile)scriptFile, (VirtualFileUrlManager)fileUrlManager));
        List scriptDependencies = new ArrayList();
        if (!((Collection)dependenciesClassFiles).isEmpty() || !((Collection)dependenciesSourceFiles).isEmpty()) {
            scriptDependencies.add(KotlinScriptEntitiesKt.createLibrary(project, "Script: " + KotlinScriptEntitiesKt.relativeName(scriptFile, project), dependenciesClassFiles, dependenciesSourceFiles, entitySource));
        }
        Sdk scriptSdk = configurationManager.getScriptSdk(scriptFile);
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Sdk sdk2 = scriptSdk;
        Sdk sdk3 = projectSdk;
        if (!Intrinsics.areEqual((Object)(sdk2 != null ? sdk2.getHomePath() : null), (Object)(sdk3 != null ? sdk3.getHomePath() : null))) {
            Collection<VirtualFile> sdkClassFiles = configurationManager.getScriptSdkDependenciesClassFiles(scriptFile);
            Collection<VirtualFile> sdkSourceFiles = configurationManager.getScriptSdkDependenciesSourceFiles(scriptFile);
            if (!sdkClassFiles.isEmpty() || !sdkSourceFiles.isEmpty()) {
                Sdk sdk4 = scriptSdk;
                scriptDependencies.add(KotlinScriptEntitiesKt.createLibrary(project, "Script: " + KotlinScriptEntitiesKt.relativeName(scriptFile, project) + ": sdk<" + (sdk4 != null ? sdk4.getName() : null) + ">", sdkClassFiles, sdkSourceFiles, entitySource));
            }
        }
        Iterable $this$forEach$iv = scriptDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v3;
            LibraryEntity dependency;
            block6: {
                dependency = (LibraryEntity)element$iv;
                boolean bl = false;
                Sequence sequence2 = $this$addOrUpdateScriptDependencies.entities(LibraryEntity.class);
                for (Object e : sequence2) {
                    LibraryEntity it = (LibraryEntity)e;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)dependency.getName())) continue;
                    v3 = e;
                    break block6;
                }
                v3 = null;
            }
            LibraryEntity libraryEntity = v3;
            if (libraryEntity != null) {
                LibraryEntity it = libraryEntity;
                boolean bl = false;
                $this$addOrUpdateScriptDependencies.removeEntity((WorkspaceEntity)it);
            }
            $this$addOrUpdateScriptDependencies.addEntity((WorkspaceEntity)dependency);
        }
        return scriptDependencies;
    }

    @NotNull
    public static final String relativeName(@NotNull VirtualFile $this$relativeName, @NotNull Project project) {
        String string2;
        if (ScratchUtil.isScratch((VirtualFile)$this$relativeName)) {
            string2 = $this$relativeName.getPresentableName();
        } else {
            Path path2 = $this$relativeName.toNioPath();
            String string3 = project.getBasePath();
            Intrinsics.checkNotNull((Object)string3);
            string2 = ((Object)PathsKt.relativeTo((Path)path2, (Path)Path.of(string3, new String[0]))).toString();
        }
        return string2;
    }

    private static final void addIdeSpecificDependencies(Project project, VirtualFile scriptFile, Set<VirtualFile> classDependencies, Set<VirtualFile> sourceDependencies) {
        Iterable $this$forEach$iv = ScriptAdditionalIdeaDependenciesProvider.Companion.getRelatedLibraries(scriptFile, project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it;
            VirtualFile element$iv2;
            int n;
            Library lib = (Library)element$iv;
            boolean bl = false;
            RootProvider provider2 = lib.getRootProvider();
            VirtualFile[] $this$forEach$iv2 = provider2.getFiles(OrderRootType.CLASSES);
            boolean $i$f$forEach2 = false;
            int n2 = $this$forEach$iv2.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv2 = $this$forEach$iv2[n];
                boolean bl2 = false;
                classDependencies.add(it);
            }
            $this$forEach$iv2 = provider2.getFiles(OrderRootType.SOURCES);
            $i$f$forEach2 = false;
            n2 = $this$forEach$iv2.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv2 = $this$forEach$iv2[n];
                boolean bl3 = false;
                sourceDependencies.add(it);
            }
        }
    }

    private static final LibraryEntity createLibrary(Project $this$createLibrary, String name2, Collection<? extends VirtualFile> classFiles, Collection<? extends VirtualFile> sources, KotlinScriptEntitySource entitySource) {
        VirtualFileUrl fileUrl;
        VirtualFile it;
        VirtualFileUrlManager fileUrlManager = VirtualFileUrlManagerUtil.getInstance((VirtualFileUrlManager.Companion)VirtualFileUrlManager.Companion, (Project)$this$createLibrary);
        List libraryRoots = new ArrayList();
        Iterable $this$forEach$iv = classFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VirtualFile)element$iv;
            boolean bl = false;
            fileUrl = UtilsKt.toVirtualFileUrl((VirtualFile)it, (VirtualFileUrlManager)fileUrlManager);
            libraryRoots.add(new LibraryRoot(fileUrl, LibraryRootTypeId.Companion.getCOMPILED(), null, 4, null));
        }
        $this$forEach$iv = sources;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VirtualFile)element$iv;
            boolean bl = false;
            fileUrl = UtilsKt.toVirtualFileUrl((VirtualFile)it, (VirtualFileUrlManager)fileUrlManager);
            libraryRoots.add(new LibraryRoot(fileUrl, LibraryRootTypeId.Companion.getSOURCES(), null, 4, null));
        }
        return LibraryEntity.Companion.invoke$default((LibraryEntity.Companion)LibraryEntity.Companion, (String)name2, (LibraryTableId)((LibraryTableId)LibraryTableId.ProjectLibraryTableId.INSTANCE), (List)libraryRoots, (EntitySource)entitySource, null, (int)16, null);
    }

    static /* synthetic */ LibraryEntity createLibrary$default(Project project, String string2, Collection collection, Collection collection2, KotlinScriptEntitySource kotlinScriptEntitySource, int n, Object object) {
        if ((n & 4) != 0) {
            collection2 = CollectionsKt.emptyList();
        }
        return KotlinScriptEntitiesKt.createLibrary(project, string2, collection, collection2, kotlinScriptEntitySource);
    }

    private static final Boolean replaceModelWithSelf$lambda$6(Project $project, BuilderSnapshot $this_replaceModelWithSelf) {
        boolean $i$f$runWriteAction = false;
        return (Boolean)ApplicationManager.getApplication().runWriteAction(new Computable($project, $this_replaceModelWithSelf){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ BuilderSnapshot $this_replaceModelWithSelf$inlined;
            {
                this.$project$inlined = project;
                this.$this_replaceModelWithSelf$inlined = builderSnapshot;
            }

            public final T compute() {
                boolean bl = false;
                return (T)Boolean.valueOf(WorkspaceModel.Companion.getInstance(this.$project$inlined).replaceProjectModel(this.$this_replaceModelWithSelf$inlined.getStorageReplacement()));
            }
        });
    }
}

