/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.dependencies;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsFieldImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.util.MethodSignatureUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptImplementationSwitcherKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependencySourceNavigationPolicyForJavaClasses;", "Lcom/intellij/psi/impl/compiled/ClsCustomNavigationPolicy;", "()V", "getNavigationElement", "Lcom/intellij/psi/PsiClass;", "clsClass", "Lcom/intellij/psi/impl/compiled/ClsClassImpl;", "Lcom/intellij/psi/PsiElement;", "clsField", "Lcom/intellij/psi/impl/compiled/ClsFieldImpl;", "file", "Lcom/intellij/psi/impl/compiled/ClsFileImpl;", "clsMethod", "Lcom/intellij/psi/impl/compiled/ClsMethodImpl;", "kotlin.base.scripting"})
public final class ScriptDependencySourceNavigationPolicyForJavaClasses
implements ClsCustomNavigationPolicy {
    @Nullable
    public PsiClass getNavigationElement(@NotNull ClsClassImpl clsClass) {
        ClsClassImpl containingClass;
        PsiClass psiClass = clsClass.getContainingClass();
        ClsClassImpl clsClassImpl = containingClass = psiClass instanceof ClsClassImpl ? (ClsClassImpl)psiClass : null;
        if (containingClass != null) {
            PsiClass psiClass2 = this.getNavigationElement(containingClass);
            return psiClass2 != null ? psiClass2.findInnerClassByName(clsClass.getName(), false) : null;
        }
        PsiFile psiFile2 = clsClass.getContainingFile();
        ClsFileImpl clsFileImpl = psiFile2 instanceof ClsFileImpl ? (ClsFileImpl)psiFile2 : null;
        if (clsFileImpl == null) {
            return null;
        }
        ClsFileImpl clsFileImpl2 = clsFileImpl;
        psiFile2 = this.getNavigationElement(clsFileImpl2);
        Object[] objectArray = psiFile2 instanceof PsiClassOwner ? (Object[])psiFile2 : null;
        return objectArray != null && (objectArray = objectArray.getClasses()) != null ? (PsiClass)ArraysKt.singleOrNull((Object[])objectArray) : null;
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsMethodImpl clsMethod) {
        PsiMethod psiMethod;
        block2: {
            PsiClass psiClass = clsMethod.getContainingClass();
            Intrinsics.checkNotNull((Object)psiClass, (String)"null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
            PsiClass psiClass2 = this.getNavigationElement((ClsClassImpl)psiClass);
            if (psiClass2 == null) {
                return null;
            }
            PsiClass clsClass = psiClass2;
            PsiMethod[] $this$firstOrNull$iv = clsClass.findMethodsByName(clsMethod.getName(), false);
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int j = 0; j < n; ++j) {
                PsiMethod element$iv;
                PsiMethod it = element$iv = $this$firstOrNull$iv[j];
                boolean bl = false;
                if (!MethodSignatureUtil.areParametersErasureEqual((PsiMethod)it, (PsiMethod)((PsiMethod)clsMethod))) continue;
                psiMethod = element$iv;
                break block2;
            }
            psiMethod = null;
        }
        return (PsiElement)psiMethod;
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsFieldImpl clsField) {
        PsiClass psiClass = clsField.getContainingClass();
        Intrinsics.checkNotNull((Object)psiClass, (String)"null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
        PsiClass psiClass2 = this.getNavigationElement((ClsClassImpl)psiClass);
        if (psiClass2 == null) {
            return null;
        }
        PsiClass srcClass = psiClass2;
        return (PsiElement)srcClass.findFieldByName(clsField.getName(), false);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsFileImpl file2) {
        void $this$filterTo$iv$iv;
        Object object;
        Project project;
        VirtualFile virtualFile;
        block8: {
            block7: {
                virtualFile = file2.getVirtualFile();
                project = file2.getProject();
                object = (PsiClass)ArraysKt.firstOrNull((Object[])file2.getClasses());
                if (object == null) break block7;
                PsiClass $this$safeAs$iv = object;
                boolean $i$f$safeAs = false;
                PsiClass psiClass = $this$safeAs$iv;
                if (!(psiClass instanceof ClsClassImpl)) {
                    psiClass = null;
                }
                if ((object = (ClsClassImpl)psiClass) != null && (object = object.getSourceFileName()) != null) break block8;
            }
            return null;
        }
        Object sourceFileName = object;
        if (!KotlinScriptImplementationSwitcherKt.getAllScriptsDependenciesClassFilesScope(project).contains(virtualFile)) {
            return null;
        }
        String packageName2 = file2.getPackageName();
        Object relativePath = ((CharSequence)packageName2).length() == 0 ? sourceFileName : StringsKt.replace$default((String)packageName2, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + (String)sourceFileName;
        Iterable $this$filter$iv = KotlinScriptImplementationSwitcherKt.getAllScriptDependenciesSources(project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!it.isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (VirtualFile root : (List)destination$iv$iv) {
            PsiFile sourcePsi;
            VirtualFile sourceFile = root.findFileByRelativePath((String)relativePath);
            if (sourceFile == null || !sourceFile.isValid() || !((sourcePsi = file2.getManager().findFile(sourceFile)) instanceof PsiClassOwner)) continue;
            return (PsiElement)sourcePsi;
        }
        return null;
    }
}

